/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.items;

import de.qfs.apps.qftest.client.win.WinHelper;
import de.qfs.apps.qftest.client.win.toolkit.WinControl;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.Arrays;

public class TabItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.win.items.TabItemResolver");
    protected WinHelper helper;
    protected String[] tabClasses;
    protected String[] itemClasses;
    protected TabItemValueResolver itemValueResolver = new TabItemValueResolver();

    public TabItemResolver(WinHelper winHelper, String[] stringArray, String[] stringArray2) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TabItemResolver(WinHelper,String[],String[])", 55).addDetail("helper", (Object)winHelper)).addDetail("tabClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        this.helper = winHelper;
        this.tabClasses = stringArray;
        this.itemClasses = stringArray2;
    }

    public static TabItemResolver createAndRegister(WinHelper winHelper) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WinHelper)", 65).addDetail("helper", (Object)winHelper)).log();
        }
        return TabItemResolver.createAndRegister(winHelper, new String[]{"TabPanel"}, new String[]{"TabPanelItem"});
    }

    public static TabItemResolver createAndRegister(WinHelper winHelper, String[] stringArray, String[] stringArray2) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WinHelper,String[],String[])", 74).addDetail("helper", (Object)winHelper)).addDetail("tabClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        TabItemResolver tabItemResolver = new TabItemResolver(winHelper, stringArray, stringArray2);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tabItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, tabItemResolver.getItemValueResolver());
        }
        for (String string : stringArray2) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tabItemResolver);
        }
        return tabItemResolver;
    }

    public void unregister() {
        if (TabItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 91).log();
        }
        for (String string : this.tabClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, this.getItemValueResolver());
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        WinControl winControl;
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 118).addDetail("element", object)).log();
        }
        if (!(winControl = (WinControl)object).isMatchingClass(this.itemClasses)) {
            return null;
        }
        int n2 = -1;
        WinControl winControl2 = this.helper.getAncestorOfClass(winControl, this.tabClasses);
        WinControl[] winControlArray = winControl2.getElementsByClassName(this.itemClasses, this.tabClasses);
        for (int i2 = 0; i2 < winControlArray.length; ++i2) {
            if (!winControlArray[i2].equals(object)) continue;
            n2 = i2;
            break;
        }
        Object[] objectArray = new Object[]{winControl2, n2};
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 134).add("res", (Object)objectArray)).log();
        }
        return objectArray;
    }

    @Override
    public Object getElement(Object object, Object object2) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 141).addDetail("element", object)).addDetail("item", object2)).log();
        }
        WinControl winControl = (WinControl)object;
        int n2 = (Integer)object2;
        WinControl[] winControlArray = winControl.getElementsByClassName(this.itemClasses, this.tabClasses);
        int n3 = winControlArray.length;
        if (n2 < 0) {
            n2 = n3 + n2;
        }
        WinControl winControl2 = null;
        if (0 <= n2 && n2 < n3) {
            winControl2 = winControlArray[n2];
        }
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 155).add("res", (Object)winControl2)).log();
        }
        return winControl2;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        int n2;
        int n3;
        SubItemIndex subItemIndex;
        block7: {
            WinControl winControl;
            block6: {
                if (TabItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 162).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                if (!this.helper.isMatchingClass(object, this.tabClasses)) {
                    throw new BadItemException("Not a " + Arrays.deepToString(this.tabClasses) + ": " + String.valueOf(object));
                }
                winControl = (WinControl)object;
                if (winControl.isChildrenInvalid()) {
                    this.helper.rescanHierarchy(winControl, null);
                }
                subItemIndex = subItemIndexArray[0];
                n3 = -1;
                n2 = this.a(winControl);
                if (subItemIndex.getType() != 1) break block6;
                n3 = subItemIndex.asNumber();
                if (n3 >= 0) break block7;
                n3 = n2 + n3;
                break block7;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!subItemIndex.matches(this.getResolvedName(winControl, i2))) continue;
                n3 = i2;
                break;
            }
        }
        if (n3 < 0 || n3 >= n2) {
            throw new IndexNotFoundException(subItemIndex);
        }
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 193).add("index", n3)).log();
        }
        return n3;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 200).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        WinControl winControl = (WinControl)object;
        int n3 = (Integer)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        switch (n2) {
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n3);
                break;
            }
            case 1: {
                boolean bl2;
                int n4 = this.a(winControl);
                String string = this.getResolvedName(winControl, n3);
                boolean bl3 = bl2 = string != null && string.length() > 0;
                if (TabItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 213).add("unique", bl2)).log();
                }
                if (bl2) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        if (i2 == n3) continue;
                        String string2 = this.getResolvedName(winControl, i2);
                        if (TabItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 218).add("iname", string2)).log();
                        }
                        if (!Misc.equalOrNull((Object)string, (Object)string2)) continue;
                        bl2 = false;
                        break;
                    }
                }
                subItemIndexArray[0] = bl2 ? new SubItemIndex(string, "\\#@&%") : new SubItemIndex(n3);
                break;
            }
            default: {
                subItemIndexArray[0] = new SubItemIndex(this.getResolvedName(winControl, n3), "\\#@&%");
            }
        }
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 233).add("result", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    private int a(WinControl winControl) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(WinControl)", 244).addDetail("tab", (Object)winControl)).log();
        }
        WinControl[] winControlArray = winControl.getElementsByClassName(this.itemClasses, this.tabClasses);
        int n2 = winControlArray.length;
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemCount(WinControl)", 248).add("count", n2)).log();
        }
        return n2;
    }

    public String getDefaultName(WinControl winControl, int n2) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultName(WinControl,int)", 255).addDetail("tab", (Object)winControl)).addDetail("index", n2)).log();
        }
        WinControl[] winControlArray = winControl.getElementsByClassName(this.itemClasses, this.tabClasses);
        WinControl winControl2 = winControlArray[n2];
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getDefaultName(WinControl,int)", 259).add("ctrl", (Object)winControl2)).log();
        }
        String string = null;
        string = "WPF.TabItem".equals(winControl2.getUiaClassName()) ? winControl2.getUiaName() : this.helper.getWholeText(winControl2);
        if (TabItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getDefaultName(WinControl,int)", 267).add("name", string)).log();
        }
        return string;
    }

    public String getResolvedName(WinControl winControl, int n2) {
        if (TabItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedName(WinControl,int)", 274).addDetail("tab", (Object)winControl)).addDetail("index", n2)).log();
        }
        String string = this.getDefaultName(winControl, n2);
        return ItemRegistry.instance().getItemName(winControl, this.helper.getClassNames(winControl), n2, string);
    }

    public class TabItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        @Override
        public String getItemValue(Object object, Object object2) {
            if (TabItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TabItemValueResolver.getItemValue(Object,Object)", 293).addDetail("element", object)).addDetail("item", object2)).log();
            }
            return TabItemResolver.this.getDefaultName((WinControl)object, (Integer)object2);
        }
    }
}

