/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.items;

import de.qfs.apps.qftest.client.win.WinHelper;
import de.qfs.apps.qftest.client.win.toolkit.WinControl;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Arrays;

public class TreeItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.win.items.TreeItemResolver");
    protected WinHelper helper;
    protected String[] treeClasses;
    protected String[] itemClasses;
    protected TreeItemValueResolver itemValueResolver = new TreeItemValueResolver();

    public TreeItemResolver(WinHelper winHelper, String[] stringArray, String[] stringArray2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TreeItemResolver(WinHelper,String[],String[])", 50).addDetail("helper", (Object)winHelper)).addDetail("treeClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        this.helper = winHelper;
        this.treeClasses = stringArray;
        this.itemClasses = stringArray2;
    }

    public static TreeItemResolver createAndRegister(WinHelper winHelper) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WinHelper)", 60).addDetail("helper", (Object)winHelper)).log();
        }
        return TreeItemResolver.createAndRegister(winHelper, new String[]{"Tree"}, new String[]{"TreeItem"});
    }

    public static TreeItemResolver createAndRegister(WinHelper winHelper, String[] stringArray, String[] stringArray2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WinHelper,String[],String[])", 68).addDetail("helper", (Object)winHelper)).addDetail("treeClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        TreeItemResolver treeItemResolver = new TreeItemResolver(winHelper, stringArray, stringArray2);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)treeItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, treeItemResolver.getItemValueResolver());
        }
        for (String string : stringArray2) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)treeItemResolver);
        }
        return treeItemResolver;
    }

    public void unregister() {
        if (TreeItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 85).log();
        }
        for (String string : this.treeClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, this.getItemValueResolver());
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        WinControl winControl;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 112).addDetail("element", object)).log();
        }
        if (!(winControl = (WinControl)object).isMatchingClass(this.itemClasses)) {
            return null;
        }
        WinControl winControl2 = this.helper.getAncestorOfClass(winControl, this.treeClasses);
        Object[] objectArray = new Object[]{winControl2, winControl};
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 120).add("res", (Object)objectArray)).log();
        }
        return objectArray;
    }

    @Override
    public Object getElement(Object object, Object object2) {
        WinControl winControl;
        WinControl winControl2;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 127).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if ((winControl2 = WinControl.getWinControl((winControl = (WinControl)object2).getHandle())) == null) {
            if (TreeItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getElement(Object,Object)", 133).add("Control is missing!")).log();
            }
        } else if (winControl != winControl2) {
            if (TreeItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getElement(Object,Object)", 135).add("Control was updated")).log();
            }
            winControl = winControl2;
        }
        return winControl;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 144).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
        }
        ItemRegistry.instance().checkSubItemIndexForTree(subItemIndexArray, true);
        if (!this.helper.isMatchingClass(object, this.treeClasses)) {
            throw new BadItemException("Not a " + Arrays.deepToString(this.treeClasses) + ": " + String.valueOf(object));
        }
        WinControl winControl = (WinControl)object;
        ArrayList<SubItemIndex> arrayList = new ArrayList<SubItemIndex>();
        int n2 = 0;
        SubItemIndex subItemIndex = subItemIndexArray[n2];
        String string = subItemIndex.getIndex();
        int n3 = 0;
        while (n3 >= 0) {
            int n4 = Misc.unquotedIndexOf((String)string, (String)"/", (int)(n3 + 1));
            String string2 = n4 > n3 ? Misc.unquote((String)string.substring(n3 + 1, n4), (String)"\\#@&%/") : Misc.unquote((String)string.substring(n3 + 1, string.length()), (String)"\\#@&%/");
            arrayList.add(new SubItemIndex(string2, subItemIndex.getType()));
            if (n4 < 0 && n2 < subItemIndexArray.length - 1 && (subItemIndex = subItemIndexArray[n2 + 1]).getIndex().charAt(0) == '/') {
                if (TreeItemResolver.a.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "getItemForIndex(Object,SubItemIndex[])", 170).add("multi-level-item, continue path with next index")).add("primary", (Object)subItemIndex)).log();
                }
                ++n2;
                string = subItemIndex.getIndex();
                n4 = 0;
            }
            n3 = n4;
        }
        WinControl winControl2 = null;
        boolean bl2 = false;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            winControl2 = this.getSubItem(winControl, winControl2, (SubItemIndex)arrayList.get(i2));
            winControl2.getDriver().scrollIntoView(winControl2.getHandle());
            if (i2 >= arrayList.size() - 1 || !winControl2.getDriver().expand(winControl2.getHandle(), true)) continue;
            this.helper.rescanHierarchy(winControl2, null);
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 189).add("item", (Object)winControl2)).log();
        }
        ItemRegistry.instance().setIndexesResolved(n2 + 1);
        return winControl2;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) {
        int n3;
        int n4;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 197).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        WinControl winControl = (WinControl)object;
        ArrayList arrayList = this.getItemPath(winControl, (WinControl)object2, n2);
        if (n2 == 1) {
            boolean bl2 = false;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                if (((SubItemIndex)arrayList.get(n4)).getType() != 1) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                n2 = 3;
                arrayList = this.getItemPath(winControl, (WinControl)object2, n2);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        n4 = ((SubItemIndex)arrayList.get(0)).getType() == 0 ? 1 : 0;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            stringBuilder.append('/');
            if (n4 != 0) {
                stringBuilder.append(Misc.quote((String)((SubItemIndex)arrayList.get(n3)).getIndex(), (String)"\\#@&%/"));
                continue;
            }
            stringBuilder.append(((SubItemIndex)arrayList.get(n3)).getIndex());
        }
        n3 = ((SubItemIndex)arrayList.get(0)).getType();
        SubItemIndex[] subItemIndexArray = new SubItemIndex[]{new SubItemIndex(stringBuilder.toString(), n3)};
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 228).add("result[0]", (Object)subItemIndexArray[0])).log();
        }
        return subItemIndexArray;
    }

    protected WinControl getItemParent(WinControl winControl, WinControl winControl2) {
        WinControl winControl3;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemParent(WinControl,WinControl)", 239).addDetail("tree", (Object)winControl)).addDetail("item", (Object)winControl2)).log();
        }
        if ((winControl3 = winControl2.getParent()) != null && !winControl.equals(winControl3) && !winControl3.isMatchingClass(this.itemClasses)) {
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemParent(WinControl,WinControl)", 245).add("Intermediate container: ")).add((Object)winControl3)).log();
            }
            winControl3 = winControl3.getParent();
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemParent(WinControl,WinControl)", 248).add("parent", (Object)winControl3)).log();
        }
        return winControl3;
    }

    protected WinControl[] getItemChildren(WinControl winControl, WinControl winControl2) {
        WinControl[] winControlArray;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemChildren(WinControl,WinControl)", 255).addDetail("tree", (Object)winControl)).addDetail("parent", (Object)winControl2)).log();
        }
        if (winControl2 == null) {
            winControl2 = winControl;
        }
        if ((winControlArray = this.helper.getChildrenOfClass(winControl2, this.itemClasses)).length == 0) {
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemChildren(WinControl,WinControl)", 262).add("Retrieve grand children")).log();
            }
            winControlArray = this.helper.getChildrenOfClass(winControl2.getChildren(), this.itemClasses);
        }
        if (TreeItemResolver.a.level >= 10) {
            ((LevelAwareLogBuilder)a.lvlBuild(10, "getItemChildren(WinControl,WinControl)", 265).add("items", (Object)winControlArray)).log();
        }
        return winControlArray;
    }

    protected ArrayList getItemPath(WinControl winControl, WinControl winControl2, int n2) {
        int n3;
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemPath(WinControl,WinControl,int)", 272).addDetail("tree", (Object)winControl)).addDetail("item", (Object)winControl2)).addDetail("type", n2)).log();
        }
        SubItemIndex[] subItemIndexArray = null;
        WinControl winControl3 = this.getItemParent(winControl, winControl2);
        WinControl[] winControlArray = this.getItemChildren(winControl, winControl3);
        if (!winControl.equals(winControl3)) {
            subItemIndexArray = this.getItemPath(winControl, winControl3, n2).toArray(new SubItemIndex[0]);
        }
        String string = this.getResolvedName(winControl, winControl2);
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemPath(WinControl,WinControl,int)", 281).add("name", string)).log();
        }
        boolean bl2 = false;
        if (n2 == 1) {
            bl2 = true;
        }
        int n4 = -1;
        for (n3 = 0; n3 < winControlArray.length; ++n3) {
            if (winControlArray[n3] == winControl2) {
                n4 = n3;
                if (bl2) continue;
                break;
            }
            if (Misc.emptyOrNull((String)string) || !string.equals(this.getResolvedName(winControl, winControlArray[n3]))) continue;
            bl2 = false;
            if (TreeItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemPath(WinControl,WinControl,int)", 296).add("The name is not unique")).log();
            }
            if (n4 >= 0) break;
        }
        n3 = n2;
        if (n2 == 1) {
            n3 = bl2 ? 2 : 3;
        }
        SubItemIndex subItemIndex = n3 == 2 ? new SubItemIndex(string) : new SubItemIndex(n4);
        ArrayList<SubItemIndex> arrayList = new ArrayList<SubItemIndex>();
        if (subItemIndexArray != null) {
            arrayList.addAll(Arrays.asList(subItemIndexArray));
        }
        arrayList.add(subItemIndex);
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemPath(WinControl,WinControl,int)", 321).add("ret", arrayList)).log();
        }
        return arrayList;
    }

    protected WinControl getSubItem(WinControl winControl, WinControl winControl2, SubItemIndex subItemIndex) throws TestException {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSubItem(WinControl,WinControl,SubItemIndex)", 328).addDetail("tree", (Object)winControl)).addDetail("parent", (Object)winControl2)).addDetail("idx", (Object)subItemIndex)).log();
        }
        int n2 = -1;
        WinControl[] winControlArray = this.getItemChildren(winControl, winControl2);
        if (subItemIndex.getType() == 1) {
            n2 = subItemIndex.asNumber();
        } else {
            for (int i2 = 0; i2 < winControlArray.length; ++i2) {
                String string = Misc.unquote((String)subItemIndex.getIndex(), (String)"\\#@&%/");
                if (!(subItemIndex = new SubItemIndex(string, subItemIndex.getType())).matches(this.getResolvedName(winControl, winControlArray[i2]))) continue;
                n2 = i2;
                break;
            }
        }
        if (n2 < 0 || n2 >= winControlArray.length) {
            throw new IndexNotFoundException(subItemIndex);
        }
        if (TreeItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getSubItem(WinControl,WinControl,SubItemIndex)", 348).add("items[num]", (Object)winControlArray[n2])).log();
        }
        return winControlArray[n2];
    }

    public String getDefaultName(WinControl winControl, WinControl winControl2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultName(WinControl,WinControl)", 355).addDetail("tree", (Object)winControl)).addDetail("item", (Object)winControl2)).log();
        }
        String string = winControl2.getUiaName();
        return string;
    }

    public String getResolvedName(WinControl winControl, WinControl winControl2) {
        if (TreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedName(WinControl,WinControl)", 366).addDetail("tree", (Object)winControl)).addDetail("item", (Object)winControl2)).log();
        }
        String string = this.getDefaultName(winControl, winControl2);
        return ItemRegistry.instance().getItemName(winControl, this.helper.getClassNames(winControl), winControl2, string);
    }

    public class TreeItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        @Override
        public String getItemValue(Object object, Object object2) {
            if (TreeItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TreeItemValueResolver.getItemValue(Object,Object)", 385).addDetail("element", object)).addDetail("item", object2)).log();
            }
            return TreeItemResolver.this.getDefaultName((WinControl)object, (WinControl)object2);
        }
    }
}

