/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.extensions.web;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.web.AttributeChangedHook;
import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.WebTracker;
import de.qfs.apps.qftest.client.web.check.TableChecker;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.client.web.i;
import de.qfs.apps.qftest.client.web.items.TableItemResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TableHelper
implements AttributeChangedHook,
i {
    private static final Logger a = new Logger("de.qfs.apps.qftest.extensions.web.TableHelper");
    protected String QFS_ROWS = "qfs:rows";
    protected String QFS_CELLS = "qfs:cells";
    protected String QFS_ROW = "qfs:row";
    protected String QFS_COLUMN = "qfs:column";
    protected String QFS_HEADERLESS = "qfs:headerless";
    public boolean searchHeader = false;
    protected WebHelper helper;
    protected String[] tableClasses;
    protected String[] rowClasses;
    protected String[] cellClasses;
    protected String[] headerClasses;
    protected String[] headerCellClasses;
    protected String[] footerClasses;
    protected String[] footerCellClasses;
    protected static Map classMap = new HashMap();
    protected boolean excludeHiddenItems = false;

    public TableHelper(WebHelper webHelper) {
        this(webHelper, new String[]{"TABLE"}, new String[]{"TR"}, new String[]{"TD", "TH"}, null, new String[]{"TH"}, null, null);
    }

    public TableHelper(WebHelper webHelper, String string, String string2, String string3, String string4, String string5) {
        this(webHelper, new String[]{string}, new String[]{string2}, new String[]{string3}, new String[]{string4}, new String[]{string5}, null, null);
    }

    public TableHelper(WebHelper webHelper, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) {
        if (TableHelper.a.level >= 7) {
            Logger.Builder builder = a.build("TableHelper(WebHelper,String[],String[],String[])");
            (TableHelper.a.level < 8 ? builder : builder.add("helper: ").add((Object)webHelper).add(", tableClasses: ").addAll((Object[])stringArray).add(", rowClasses: ").addAll((Object[])stringArray2).add(", cellClasses: ").addAll((Object[])stringArray3).add(", headerClasses: ").addAll((Object[])stringArray4).add(", headerCellClasses: ").addAll((Object[])stringArray5).add(", footerClasses: ").addAll((Object[])stringArray6).add(", footerCellClasses: ").addAll((Object[])stringArray7)).dumpStack(7);
        }
        this.helper = webHelper;
        this.tableClasses = stringArray;
        this.rowClasses = stringArray2;
        this.cellClasses = stringArray3;
        this.headerClasses = stringArray4;
        this.headerCellClasses = stringArray5;
        this.footerClasses = stringArray6;
        this.footerCellClasses = stringArray7;
        if (this.getClass() == TableHelper.class) {
            this.QFS_ROWS = "qfs:rows:basic";
            this.QFS_CELLS = "qfs:cells:basic";
            this.QFS_ROW = "qfs:row:basic";
            this.QFS_COLUMN = "qfs:column:basic";
            this.QFS_HEADERLESS = "qfs:headerless:basic";
        }
    }

    public static HelperContext createAndRegister(WebHelper webHelper, String string, String string2, String string3, String string4, String string5, String[] stringArray) {
        return TableHelper.createAndRegister(webHelper, new String[]{string}, new String[]{string2}, new String[]{string3}, new String[]{string4}, new String[]{string5}, null, null, stringArray);
    }

    public static HelperContext createAndRegister(WebHelper webHelper, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String[] stringArray8) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("createAndRegister(WebHelper,String[],String[],String[],String[],String[],String[],String[],String[])");
            (TableHelper.a.level < 8 ? object : object.add("helper: ").add((Object)webHelper).add(", tableClasses: ").addAll((Object[])stringArray).add(", rowClasses: ").addAll((Object[])stringArray2).add(", cellClasses: ").addAll((Object[])stringArray3).add(", headerClasses: ").addAll((Object[])stringArray4).add(", headerCellClasses: ").addAll((Object[])stringArray5).add(", footerClasses: ").addAll((Object[])stringArray6).add(", footerCellClasses: ").addAll((Object[])stringArray7).add(", otherClasses: ").addAll((Object[])stringArray8)).log(7);
        }
        object = new TableHelper(webHelper, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7);
        TableItemResolver tableItemResolver = new TableItemResolver((TableHelper)object);
        TableChecker tableChecker = new TableChecker((TableHelper)object);
        HelperContext helperContext = new HelperContext((TableHelper)object, tableItemResolver, tableChecker);
        helperContext.register(stringArray8);
        return helperContext;
    }

    public void register(String[] stringArray) {
        String[] stringArray2;
        if (TableHelper.a.level >= 7) {
            stringArray2 = a.build("register(String[])");
            (TableHelper.a.level < 8 ? stringArray2 : stringArray2.add("otherClasses: ").addAll((Object[])stringArray)).log(7);
        }
        stringArray2 = new String[this.rowClasses.length + this.cellClasses.length + (stringArray == null ? 0 : stringArray.length)];
        System.arraycopy(this.rowClasses, 0, stringArray2, 0, this.rowClasses.length);
        System.arraycopy(this.cellClasses, 0, stringArray2, this.rowClasses.length, this.cellClasses.length);
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, this.rowClasses.length + this.cellClasses.length, stringArray.length);
        }
        this.addTableClasses(this.tableClasses, stringArray2);
        ((WebTracker)this.helper.getEngine().getTracker()).a(this);
        ((WebTracker)this.helper.getEngine().getTracker()).addAttributeChangedHook(null, this);
    }

    public void unregister() {
        if (TableHelper.a.level >= 7) {
            a.log(7, "unregister()", "");
        }
        ((WebTracker)this.helper.getEngine().getTracker()).b(this);
        this.removeTableClasses(this.tableClasses);
        ((WebTracker)this.helper.getEngine().getTracker()).removeAttributeChangedHook(null, this);
    }

    public WebHelper getHelper() {
        return this.helper;
    }

    public final String[] getTableClasses() {
        return this.tableClasses;
    }

    public final String[] getRowClasses() {
        return this.rowClasses;
    }

    public final String[] getCellClasses() {
        return this.cellClasses;
    }

    public final String[] getHeaderClasses() {
        return this.headerClasses;
    }

    public final String[] getHeaderCellClasses() {
        return this.headerCellClasses;
    }

    public final String[] getFooterClasses() {
        return this.footerClasses;
    }

    public final String[] getFooterCellClasses() {
        return this.footerCellClasses;
    }

    public boolean checkTable(DomNode domNode) {
        return this.checkElement(domNode, this.tableClasses);
    }

    public boolean checkCell(DomNode domNode) {
        return this.checkElement(domNode, this.cellClasses);
    }

    public boolean checkHeaderCell(DomNode domNode) {
        return this.headerCellClasses != null && this.checkElement(domNode, this.headerCellClasses);
    }

    public DomNode getTable(DomNode domNode) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getTable(DomNode)");
            (TableHelper.a.level < 8 ? object : object.add("cell: ").add((Object)domNode)).log(7);
        }
        object = domNode.getAncestorOfClass(this.tableClasses);
        if (TableHelper.a.level >= 9) {
            a.build("getTable(DomNode)").add("parent: ").add(object).log(9);
        }
        if (object instanceof DomNode) {
            return (DomNode)object;
        }
        return null;
    }

    public int[] getRowAndColumn(DomNode domNode, DomNode domNode2) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getRowAndColumn(DomNode,DomNode)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode).add(", cell: ").add((Object)domNode2)).log(7);
        }
        if (this.checkHeaderCell(domNode2)) {
            this.getHeader(domNode);
        } else {
            this.getRows(domNode);
        }
        object = domNode2.getProperty(this.QFS_ROW);
        Object object2 = domNode2.getProperty(this.QFS_COLUMN);
        return new int[]{object instanceof Integer ? (Integer)object : -1, object2 instanceof Integer ? (Integer)object2 : -1};
    }

    public int getColumnCount(DomNode domNode) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getColumnCount(DomNode)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode)).log(7);
        }
        try {
            object = this.getHeader(domNode);
            if (TableHelper.a.level >= 9) {
                a.build("getColumnCount(DomNode)").add("header: ").add(object).log(9);
            }
            ArrayList arrayList = this.getCells((DomNode)object, this.headerCellClasses);
            if (TableHelper.a.level >= 9) {
                a.build("getColumnCount(DomNode)").add("count: ").add(arrayList.size()).log(9);
            }
            return arrayList.size();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public int getRowCount(DomNode domNode) {
        ArrayList arrayList = this.getRows(domNode);
        return arrayList.size();
    }

    public DomNode getRow(DomNode domNode, int n2) {
        return this.getRow(domNode, n2, true);
    }

    public DomNode getRow(DomNode domNode, int n2, boolean bl2) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getRow(DomNode,int,boolean)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode).add(", row: ").add(n2).add(", checkHeader: ").add(bl2)).log(7);
        }
        object = this.getRows(domNode, bl2);
        if (n2 < 0 || n2 >= ((ArrayList)object).size()) {
            throw new ArrayIndexOutOfBoundsException("Illegal row " + n2 + " not in [0," + ((ArrayList)object).size() + "[");
        }
        return (DomNode)((ArrayList)object).get(n2);
    }

    public DomNode getCell(DomNode domNode, int n2, int n3) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getCell(DomNode,int,int)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode).add(", row: ").add(n2).add(", column: ").add(n3)).log(7);
        }
        object = this.getRows(domNode);
        if (n2 < 0 || n2 >= ((ArrayList)object).size()) {
            throw new ArrayIndexOutOfBoundsException("Illegal row " + n2 + " not in [0," + ((ArrayList)object).size() + "[");
        }
        ArrayList arrayList = this.getCells((DomNode)((ArrayList)object).get(n2));
        if (n3 < 0 || n3 >= arrayList.size()) {
            boolean bl2 = Client.instance().getOptions().getBoolean("WebAssertTableColumnIndex", false);
            if (bl2) {
                throw new ArrayIndexOutOfBoundsException("Illegal column " + n3 + " not in [0," + arrayList.size() + "[");
            }
            return null;
        }
        return (DomNode)arrayList.get(n3);
    }

    public String getValue(DomNode domNode, DomNode domNode2) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getValue(DomNode,DomNode)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode).add(", cell: ").add((Object)domNode2)).log(7);
        }
        object = this.helper.getWholeText(domNode2);
        if (TableHelper.a.level >= 9) {
            a.build("getValue(DomNode,DomNode)").add("text: ").add((String)object).log(9);
        }
        object = ItemRegistry.instance().resolveItemValue(domNode, domNode.getClassNames(), domNode2, (String)object);
        if (TableHelper.a.level >= 9) {
            a.build("getValue(DomNode,DomNode)").add("resolved text: ").add((String)object).log(9);
        }
        return object;
    }

    public DomNode getHeader(DomNode domNode) {
        return this.getHeader(domNode, true);
    }

    public DomNode getHeaderCell(DomNode domNode, int n2) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("getHeaderCell(DomNode,int)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode).add(", column: ").add(n2)).log(7);
        }
        if ((object = this.getHeader(domNode)) == null) {
            throw new ArrayIndexOutOfBoundsException("No table header");
        }
        ArrayList arrayList = this.getCells((DomNode)object, this.headerCellClasses == null ? this.cellClasses : this.headerCellClasses);
        if (n2 < 0 || n2 >= arrayList.size()) {
            throw new ArrayIndexOutOfBoundsException("Illegal column " + n2 + " not in [0," + arrayList.size() + "[");
        }
        return (DomNode)arrayList.get(n2);
    }

    public int isHeaderless(DomNode domNode) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("isHeaderless(DomNode)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode)).log(7);
        }
        object = domNode.getProperty(this.QFS_HEADERLESS);
        if (TableHelper.a.level >= 9) {
            a.build("isHeaderless(DomNode)").add("prop: ").add(object).log(9);
        }
        if (object instanceof String) {
            if ("intelligent".equalsIgnoreCase((String)object)) {
                return 1;
            }
            if ("maybe".equalsIgnoreCase((String)object) || "maybe:intelligent".equalsIgnoreCase((String)object)) {
                return this.getHeader(domNode, false) == null ? 1 : 0;
            }
            if ("maybe:true".equalsIgnoreCase((String)object)) {
                return this.getHeader(domNode, false) == null ? 2 : 0;
            }
        }
        if (object != null) {
            return Misc.toBoolean((Object)object) ? 2 : 0;
        }
        return 0;
    }

    public boolean isValidCellIndex(DomNode domNode, int n2, int n3) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("isValidCellIndex(DomNode,int,int)");
            (TableHelper.a.level < 8 ? object : object.add("table: ").add((Object)domNode).add(", row: ").add(n2).add(", column: ").add(n3)).log(7);
        }
        object = this.getRows(domNode);
        if (n2 < 0 || n2 >= ((ArrayList)object).size()) {
            if (TableHelper.a.level >= 9) {
                a.build("isValidCellIndex(DomNode,int,int)").add("wrong row index: ").add(n2).log(9);
            }
            return false;
        }
        ArrayList arrayList = this.getCells((DomNode)((ArrayList)object).get(n2));
        if (n3 < 0 || n3 >= arrayList.size()) {
            if (TableHelper.a.level >= 9) {
                a.build("isValidCellIndex(DomNode,int,int)").add("wrong column index: ").add(n3).log(9);
            }
            return false;
        }
        return true;
    }

    protected void addTableClasses(String[] stringArray, String[] stringArray2) {
        if (TableHelper.a.level >= 7) {
            Logger.Builder builder = a.build("addTableClasses(String[],String[])");
            (TableHelper.a.level < 8 ? builder : builder.add("tableClasses: ").addAll((Object[])stringArray).add(", itemClasses: ").addAll((Object[])stringArray2)).log(7);
        }
        classMap.put(stringArray, stringArray2);
    }

    protected void removeTableClasses(String[] stringArray) {
        if (TableHelper.a.level >= 7) {
            Logger.Builder builder = a.build("removeTableClasses(String[])");
            (TableHelper.a.level < 8 ? builder : builder.add("tableClasses: ").addAll((Object[])stringArray)).log(7);
        }
        classMap.remove(stringArray);
    }

    @Override
    public void nodeAdded(Node node, int n2) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("nodeAdded(Node,int)");
            (TableHelper.a.level < 8 ? object : object.add("this: ").add((Object)this).add(", node: ").add((Object)node).add(", index: ").add(n2)).dumpStack(7);
        }
        if ((object = node.getAncestorOfClass(this.tableClasses)) != null) {
            if (TableHelper.a.level >= 9) {
                a.build("nodeAdded(Node,int)").add("clearing cache for ").add(object).log(9);
            }
            ((Node)object).setProperty(this.QFS_ROWS, null);
        }
    }

    @Override
    public void nodeRemoved(Node node, String string, String string2) {
        Object object;
        if (TableHelper.a.level >= 7) {
            object = a.build("nodeRemoved(Node,String,String)");
            (TableHelper.a.level < 8 ? object : object.add("parent: ").add((Object)node).add(", tagName: ").add(string).add(", className: ").add(string2)).log(7);
        }
        if (node.isMatchingClass(this.tableClasses)) {
            if (TableHelper.a.level >= 9) {
                a.build("nodeRemoved(Node,String,String)").add("clearing cache for ").add((Object)node).log(9);
            }
            node.setProperty(this.QFS_ROWS, null);
        } else {
            object = node.getAncestorOfClass(this.tableClasses);
            if (object != null) {
                if (TableHelper.a.level >= 9) {
                    a.build("nodeRemoved(Node,String,String)").add("clearing cache for ").add(object).log(9);
                }
                ((Node)object).setProperty(this.QFS_ROWS, null);
            }
        }
    }

    @Override
    public void domChanged(DocumentNode documentNode, Node node, Node node2, int n2, String string, String string2) {
        if (TableHelper.a.level >= 7) {
            Logger.Builder builder = a.build("domChanged(DocumentNode,Node,Node,int,String,String)");
            (TableHelper.a.level < 8 ? builder : builder.add("doc: ").add((Object)documentNode).add(", parent: ").add((Object)node).add(", node: ").add((Object)node2).add(", index: ").add(n2).add(", tagName: ").add(string).add(", className: ").add(string2)).log(7);
        }
        for (String[] stringArray : classMap.keySet()) {
            Node[] nodeArray;
            if (node == null) {
                nodeArray = documentNode.getElementsByClassName(stringArray);
                for (Node node3 : nodeArray) {
                    if (TableHelper.a.level >= 9) {
                        a.build("domChanged(DocumentNode,Node,Node,int,String,String)").add("clearing cache for ").add((Object)node3).log(9);
                    }
                    node3.setProperty(this.QFS_ROWS, null);
                }
                continue;
            }
            if (node.isMatchingClass(stringArray)) {
                if (TableHelper.a.level >= 9) {
                    a.build("domChanged(DocumentNode,Node,Node,int,String,String)").add("clearing cache for ").add((Object)node).log(9);
                }
                node.setProperty(this.QFS_ROWS, null);
            }
            nodeArray = node.getElementsByClassName(stringArray);
            for (Node node3 : nodeArray) {
                if (TableHelper.a.level >= 9) {
                    a.build("domChanged(DocumentNode,Node,Node,int,String,String)").add("clearing cache for ").add((Object)node3).log(9);
                }
                node3.setProperty(this.QFS_ROWS, null);
            }
            Node node4 = node.getAncestorOfClass(stringArray);
            if (node4 == null) continue;
            if (TableHelper.a.level >= 9) {
                a.build("domChanged(DocumentNode,Node,Node,int,String,String)").add("clearing cache for ").add((Object)node4).log(9);
            }
            node4.setProperty(this.QFS_ROWS, null);
        }
    }

    protected boolean checkElement(DomNode domNode, String[] stringArray) {
        if (domNode == null) {
            return false;
        }
        return domNode.isMatchingClass(stringArray);
    }

    protected ArrayList getRows(DomNode domNode) {
        return this.getRows(domNode, true);
    }

    protected ArrayList getRows(DomNode domNode, boolean bl2) {
        int n2;
        DomNode domNode2;
        Object object;
        Object object2;
        if (TableHelper.a.level >= 7) {
            object2 = a.build("getRows(DomNode,boolean)");
            (TableHelper.a.level < 8 ? object2 : object2.add("table: ").add((Object)domNode).add(", checkHeader: ").add(bl2)).log(7);
        }
        if ((object2 = domNode.getProperty(this.QFS_ROWS)) instanceof ArrayList) {
            if (TableHelper.a.level >= 9) {
                a.build("getRows(DomNode,boolean)").add("cached size: ").add(((ArrayList)object2).size()).log(9);
            }
            return (ArrayList)object2;
        }
        if (TableHelper.a.level >= 9) {
            a.build("getRows(DomNode,boolean)").add("Rebuilding row cache for ").add(this.QFS_ROWS).add(", this: ").add((Object)this).log(9);
        }
        ArrayList<DomNode> arrayList = new ArrayList<DomNode>();
        if (this.headerClasses != null && bl2 && (object = this.getHeader(domNode)) != null) {
            ((Node)object).setProperty(this.QFS_CELLS, null);
            this.getCells((DomNode)object, this.headerCellClasses);
        }
        object = this.getDefaultVisibleTableRows(domNode);
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            domNode2 = (DomNode)iterator.next();
            if (TableHelper.a.level >= 9) {
                a.build("getRows(DomNode,boolean)").add("row: ").add((Object)domNode2).log(9);
            }
            if (!domNode2.isShowing()) {
                if (TableHelper.a.level < 9) continue;
                a.log(9, "getRows(DomNode,boolean)", "Invisible");
                continue;
            }
            if (domNode2.getInterestingParent().isMatchingClass(this.headerClasses)) {
                if (TableHelper.a.level < 9) continue;
                a.log(9, "getRows(DomNode,boolean)", "Row is effectively a header row");
                continue;
            }
            arrayList.add(domNode2);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            domNode2 = (DomNode)arrayList.get(n2);
            domNode2.setProperty(this.QFS_CELLS, null);
            this.getCells(domNode2);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            DomNode domNode3;
            int n3;
            domNode2 = (DomNode)arrayList.get(n2);
            ArrayList arrayList2 = (ArrayList)domNode2.getProperty(this.QFS_CELLS);
            if (arrayList2 == null) {
                if (TableHelper.a.level < 1) break;
                a.log(1, "getRows(DomNode,boolean)", "Internal error: No cached cells for row " + n2);
                break;
            }
            block5: for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                int n4;
                block21: {
                    String string;
                    domNode3 = (DomNode)arrayList2.get(n3);
                    if (domNode3 == null || domNode3.getProperty(this.QFS_ROW) != null) continue;
                    n4 = 1;
                    String string2 = domNode3.getName();
                    if (("TD".equals(string2) || "TH".equals(string2)) && !Misc.emptyOrNull((String)(string = domNode3.getAttribute("rowspan")))) {
                        try {
                            n4 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (TableHelper.a.level < 3) break block21;
                            a.log(3, "getRows(DomNode,boolean)", (Throwable)numberFormatException);
                        }
                    }
                }
                if (n4 <= true) continue;
                for (int i2 = 1; i2 < n4; ++i2) {
                    if (n2 + i2 >= arrayList.size()) continue;
                    DomNode domNode4 = (DomNode)arrayList.get(n2 + i2);
                    ArrayList arrayList3 = (ArrayList)domNode4.getProperty(this.QFS_CELLS);
                    if (arrayList3 == null) {
                        if (TableHelper.a.level < 1) continue block5;
                        a.log(1, "getRows(DomNode,boolean)", "Internal error: No cached cells for row " + (n2 + i2));
                        continue block5;
                    }
                    if (n3 > arrayList3.size()) continue;
                    arrayList3.add(n3, domNode3);
                }
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                domNode3 = (DomNode)arrayList2.get(n3);
                if (domNode3 == null) continue;
                if (domNode3.getProperty(this.QFS_ROW) == null) {
                    domNode3.setProperty(this.QFS_ROW, n2);
                }
                if (domNode3.getProperty(this.QFS_COLUMN) != null) continue;
                domNode3.setProperty(this.QFS_COLUMN, n3);
            }
        }
        domNode.setProperty(this.QFS_ROWS, arrayList);
        if (TableHelper.a.level >= 9) {
            a.log(9, "getRows(DomNode,boolean)", "Number of rows: " + arrayList.size());
        }
        return arrayList;
    }

    protected ArrayList getCells(DomNode domNode) {
        return this.getCells(domNode, this.cellClasses);
    }

    protected ArrayList getCells(DomNode domNode, String[] stringArray) {
        Object object = domNode.getProperty(this.QFS_CELLS);
        if (object instanceof ArrayList) {
            return (ArrayList)object;
        }
        ArrayList<Object> arrayList = new ArrayList<DomNode>();
        arrayList = stringArray != null && Arrays.equals(stringArray, this.getHeaderCellClasses()) ? this.getDefaultVisibleTableHeaderCells(domNode) : (stringArray != null && Arrays.equals(stringArray, this.getCellClasses()) ? this.getDefaultVisibleTableCells(domNode) : (stringArray != null && Arrays.equals(stringArray, this.getFooterCellClasses()) ? this.getDefaultVisibleTableFooterCells(domNode) : new ArrayList<DomNode>(Arrays.asList(domNode.getElementsByClassName(stringArray, false, false, this.excludeHiddenItems)))));
        ArrayList<DomNode> arrayList2 = new ArrayList<DomNode>();
        for (DomNode domNode2 : arrayList) {
            if (domNode2 == null) {
                arrayList2.add(null);
                continue;
            }
            int n2 = 1;
            if ("TD".equals(domNode2.getName()) || "TH".equals(domNode2.getName())) {
                Node node;
                block14: {
                    String string = domNode2.getAttribute("colspan");
                    if (!Misc.emptyOrNull((String)string)) {
                        try {
                            n2 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (TableHelper.a.level < 3) break block14;
                            a.log(3, "getCells(DomNode,String[])", (Throwable)numberFormatException);
                        }
                    }
                }
                if ((node = domNode2.getAncestorOfClass(new String[]{"Table", "TABLE"})) != null) {
                    DomNode domNode3 = (DomNode)node;
                    Object object2 = domNode3.getProperty("qfs:tablehasitems");
                    if ("TABLE".equals(domNode3.getTagName()) && Misc.toBoolean((Object)object2)) {
                        if (TableHelper.a.level >= 9) {
                            a.log(9, "getCells(DomNode,String[])", "Set redirect to maybe.");
                        }
                        if (Options.cached_OPT_WEB_RETARGET_MOUSE_EVENT) {
                            domNode2.setProperty("qfs:redirectmouse", "maybe");
                        }
                    }
                }
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList2.add(domNode2);
            }
            domNode2.setProperty(this.QFS_ROW, null);
            domNode2.setProperty(this.QFS_COLUMN, null);
        }
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            DomNode domNode2;
            domNode2 = (DomNode)arrayList2.get(i3);
            if (domNode2 == null || domNode2.getProperty(this.QFS_COLUMN) != null) continue;
            domNode2.setProperty(this.QFS_COLUMN, i3);
        }
        if (TableHelper.a.level >= 9) {
            a.build("getCells(DomNode,String[])").add("ret: ").add(arrayList2).log(9);
        }
        domNode.setProperty(this.QFS_CELLS, arrayList2);
        return arrayList2;
    }

    public DomNode getHeader(DomNode domNode, boolean bl2) {
        Object[] objectArray;
        if (TableHelper.a.level >= 7) {
            objectArray = a.build("getHeader(DomNode,boolean)");
            (TableHelper.a.level < 8 ? objectArray : objectArray.add("table: ").add((Object)domNode).add(", fallback: ").add(bl2)).log(7);
        }
        objectArray = null;
        if (this.searchHeader) {
            Node node;
            DomNode[] object = domNode.getElementsByClassName(this.headerCellClasses);
            if (object.length == 1) {
                this.headerClasses = new String[]{((Node)object[0]).getParent().getClassName()};
            } else if (object.length > 1 && (node = Node.findCommonAncestor(object[0], object[object.length - 1], domNode)) != null) {
                this.headerClasses = new String[]{node.getClassName()};
                objectArray = new Node[]{node};
            }
            if (TableHelper.a.level >= 9) {
                a.build("getHeader(DomNode,boolean)").add("headerClasses: ").addAll((Object[])this.headerClasses).log(9);
            }
        }
        if (this.headerClasses != null) {
            if (objectArray == null) {
                objectArray = domNode.getElementsByClassName(this.headerClasses, false, false);
            }
            if (TableHelper.a.level >= 9) {
                a.build("getHeader(DomNode,boolean)").add("headers: ").addAll(objectArray).log(9);
            }
            for (Object object : objectArray) {
                if (!((DomNode)object).isShowing()) continue;
                if (domNode.getProperty(this.QFS_ROWS) == null) {
                    ((Node)object).setProperty(this.QFS_CELLS, null);
                    this.getCells((DomNode)object, this.headerCellClasses);
                }
                return (DomNode)object;
            }
        }
        if (!bl2) {
            return null;
        }
        ArrayList arrayList = this.getRows(domNode, false);
        if (arrayList.size() == 0) {
            return null;
        }
        return (DomNode)arrayList.get(0);
    }

    public void setExcludeHiddenItems(boolean bl2) {
        if (TableHelper.a.level >= 7) {
            a.log(7, "setExcludeHiddenItems(boolean)", TableHelper.a.level < 8 ? "" : "excludeHiddenItems: " + bl2);
        }
        this.excludeHiddenItems = bl2;
    }

    public boolean getExcludeHiddenItems() {
        if (TableHelper.a.level >= 7) {
            Logger.Builder builder = a.build("getExcludeHiddenItems()");
            (TableHelper.a.level < 8 ? builder : builder).log(7);
        }
        return this.excludeHiddenItems;
    }

    public ArrayList getDefaultVisibleTableHeaderCells(DomNode domNode) {
        return new ArrayList<DomNode>(Arrays.asList(domNode.getElementsByClassName(this.getHeaderCellClasses(), false, false, this.getExcludeHiddenItems())));
    }

    public ArrayList getDefaultVisibleTableRows(DomNode domNode) {
        return new ArrayList<DomNode>(Arrays.asList(domNode.getElementsByClassName(this.getRowClasses(), false, false, this.getExcludeHiddenItems())));
    }

    public ArrayList getDefaultVisibleTableCells(DomNode domNode) {
        return new ArrayList<DomNode>(Arrays.asList(domNode.getElementsByClassName(this.getCellClasses(), false, false, this.getExcludeHiddenItems())));
    }

    public ArrayList getDefaultVisibleTableFooterCells(DomNode domNode) {
        return new ArrayList<DomNode>(Arrays.asList(domNode.getElementsByClassName(this.getFooterCellClasses(), false, false, this.getExcludeHiddenItems())));
    }

    @Override
    public void attributeChanged(DomNode domNode, String string, String string2, String string3) {
        block10: {
            block9: {
                boolean bl2;
                boolean bl3;
                Node node;
                block11: {
                    Object object;
                    if (!this.checkForAttributeChangeRequired(string)) {
                        return;
                    }
                    if (TableHelper.a.level >= 7) {
                        Logger.Builder object2 = a.build("attributeChanged(DomNode,String,String)");
                        (TableHelper.a.level < 8 ? object2 : object2.add("node: ").add((Object)domNode).add(", attribute: ").add(string).add(", oldValue: ").add(string2).add(", newValue: ").add(string3)).log(7);
                    }
                    if (!domNode.isMatchingClass(this.rowClasses)) break block9;
                    node = domNode.getAncestorOfClass(this.tableClasses);
                    if (node == null || !((object = node.getProperty(this.QFS_ROWS)) instanceof ArrayList)) break block10;
                    bl3 = ((ArrayList)object).contains(domNode);
                    bl2 = domNode.isShowing();
                    if (bl3 || !bl2) break block11;
                    if (TableHelper.a.level >= 9) {
                        a.build("attributeChanged(DomNode,String,String)").add("new table row inserted, reset cache.").add((Object)node).log(9);
                    }
                    node.setProperty(this.QFS_ROWS, null);
                    break block10;
                }
                if (!bl3 || bl2) break block10;
                if (TableHelper.a.level >= 9) {
                    a.build("attributeChanged(DomNode,String,String)").add("table row deleted, reset cache.").add((Object)node).log(9);
                }
                node.setProperty(this.QFS_ROWS, null);
                break block10;
            }
            if (domNode.isMatchingClass(this.cellClasses)) {
                for (String string4 : this.rowClasses) {
                    Object object;
                    Node node;
                    if (!domNode.isMatchingClass(string4) || (node = domNode.getAncestorOfClass(string4)) == null || !((object = node.getProperty(this.QFS_CELLS)) instanceof ArrayList)) continue;
                    boolean bl4 = ((ArrayList)object).contains(domNode);
                    boolean bl5 = domNode.isShowing();
                    if (!bl4 && bl5) {
                        if (TableHelper.a.level >= 9) {
                            a.build("attributeChanged(DomNode,String,String)").add("new table cell inserted, reset cache.").add((Object)node).log(9);
                        }
                        node.setProperty(this.QFS_CELLS, null);
                        continue;
                    }
                    if (!bl4 || bl5) continue;
                    if (TableHelper.a.level >= 9) {
                        a.build("attributeChanged(DomNode,String,String)").add("table cell deleted, reset cache.").add((Object)node).log(9);
                    }
                    node.setProperty(this.QFS_CELLS, null);
                }
            }
        }
    }

    protected boolean checkForAttributeChangeRequired(String string) {
        return "style".equalsIgnoreCase(string) || "class".equalsIgnoreCase(string);
    }

    public static class HelperContext {
        public TableHelper helper;
        public TableItemResolver resolver;
        public TableChecker checker;

        public HelperContext(TableHelper tableHelper, TableItemResolver tableItemResolver, TableChecker tableChecker) {
            this.helper = tableHelper;
            this.resolver = tableItemResolver;
            this.checker = tableChecker;
        }

        public void register(String[] stringArray) {
            this.helper.register(stringArray);
            this.resolver.register();
            this.checker.register();
        }

        public void unregister() {
            this.helper.unregister();
            this.resolver.unregister();
            this.checker.unregister();
        }
    }
}

