/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.BucketsApi;
import com.influxdb.client.BucketsQuery;
import com.influxdb.client.FindOptions;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.BucketRetentionRules;
import com.influxdb.client.domain.Buckets;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.PatchBucketRequest;
import com.influxdb.client.domain.PatchRetentionRule;
import com.influxdb.client.domain.PostBucketRequest;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.BucketsService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class BucketsApiImpl
extends AbstractRestClient
implements BucketsApi {
    private static final Logger LOG = Logger.getLogger(BucketsApiImpl.class.getName());
    private final BucketsService service;

    BucketsApiImpl(@Nonnull BucketsService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Bucket findBucketByID(@Nonnull String bucketID) {
        Arguments.checkNonEmpty(bucketID, "Bucket ID");
        Call<Bucket> bucket = this.service.getBucketsID(bucketID, null);
        return this.execute(bucket);
    }

    @Override
    @Nullable
    public Bucket findBucketByName(@Nonnull String bucketName) {
        Arguments.checkNonEmpty(bucketName, "Bucket Name");
        Call<Buckets> bucket = this.service.getBuckets(null, null, null, null, null, null, bucketName, null);
        return this.execute(bucket).getBuckets().stream().findFirst().orElse(null);
    }

    @Override
    @Nonnull
    public List<Bucket> findBuckets() {
        return this.findBucketsByOrgName(null);
    }

    @Override
    @Nonnull
    public Buckets findBuckets(@Nonnull FindOptions findOptions) {
        Arguments.checkNotNull(findOptions, "findOptions");
        return this.findBuckets(null, findOptions);
    }

    @Override
    @Nonnull
    public List<Bucket> findBucketsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization is required");
        return this.findBucketsByOrgName(organization.getName());
    }

    @Override
    @Nonnull
    public List<Bucket> findBucketsByOrgName(@Nullable String orgName) {
        Buckets buckets = this.findBuckets(orgName, new FindOptions());
        LOG.log(Level.FINEST, "findBucketsByOrgName found: {0}", buckets);
        return buckets.getBuckets();
    }

    @Override
    @Nonnull
    public List<Bucket> findBuckets(@Nonnull BucketsQuery query) {
        Call<Buckets> bucketsCall = this.service.getBuckets(null, query.getOffset(), query.getLimit(), query.getAfter(), query.getOrg(), query.getOrgID(), query.getName(), query.getId());
        Buckets buckets = this.execute(bucketsCall);
        LOG.log(Level.FINEST, "findBuckets found: {0}", buckets);
        return buckets.getBuckets();
    }

    @Override
    @Nonnull
    public Bucket createBucket(@Nonnull String name, @Nonnull Organization organization) {
        return this.createBucket(name, null, organization);
    }

    @Override
    @Nonnull
    public Bucket createBucket(@Nonnull String name, @Nullable BucketRetentionRules bucketRetentionRules, @Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "Organization is required");
        return this.createBucket(name, bucketRetentionRules, organization.getId());
    }

    @Override
    @Nonnull
    public Bucket createBucket(@Nonnull String name, @Nonnull String orgID) {
        return this.createBucket(name, null, orgID);
    }

    @Override
    @Nonnull
    public Bucket createBucket(@Nonnull String name, @Nullable BucketRetentionRules bucketRetentionRules, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "Bucket name");
        Arguments.checkNonEmpty(orgID, "Organization Id");
        Bucket bucket = new Bucket();
        bucket.setName(name);
        bucket.setOrgID(orgID);
        if (bucketRetentionRules != null) {
            bucket.getRetentionRules().add(bucketRetentionRules);
        }
        return this.createBucket(bucket);
    }

    @Override
    @Nonnull
    public Bucket createBucket(@Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "Bucket is required");
        Arguments.checkNonEmpty(bucket.getName(), "Bucket name");
        PostBucketRequest postBucket = new PostBucketRequest().name(bucket.getName()).orgID(bucket.getOrgID()).description(bucket.getDescription()).rp(bucket.getRp()).retentionRules(bucket.getRetentionRules());
        return this.createBucket(postBucket);
    }

    @Override
    @Nonnull
    public Bucket createBucket(@Nonnull PostBucketRequest bucket) {
        Arguments.checkNotNull(bucket, "Bucket is required");
        Arguments.checkNonEmpty(bucket.getName(), "Bucket name");
        Call<Bucket> call = this.service.postBuckets(bucket, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Bucket updateBucket(@Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "Bucket is required");
        PatchBucketRequest request = new PatchBucketRequest();
        List<PatchRetentionRule> retentionRules = bucket.getRetentionRules().stream().map(bucketRetentionRules -> new PatchRetentionRule().everySeconds(bucketRetentionRules.getEverySeconds()).shardGroupDurationSeconds(bucketRetentionRules.getShardGroupDurationSeconds())).collect(Collectors.toList());
        request.name(bucket.getName()).description(bucket.getDescription()).retentionRules(retentionRules);
        Call<Bucket> bucketCall = this.service.patchBucketsID(bucket.getId(), request, null);
        return this.execute(bucketCall);
    }

    @Override
    public void deleteBucket(@Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "Bucket");
        this.deleteBucket(bucket.getId());
    }

    @Override
    public void deleteBucket(@Nonnull String bucketID) {
        Arguments.checkNonEmpty(bucketID, "bucketID");
        Call<Void> call = this.service.deleteBucketsID(bucketID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Bucket cloneBucket(@Nonnull String clonedName, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(bucketID, "bucketID");
        Bucket bucket = this.findBucketByID(bucketID);
        return this.cloneBucket(clonedName, bucket);
    }

    @Override
    @Nonnull
    public Bucket cloneBucket(@Nonnull String clonedName, @Nonnull Bucket bucket) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(bucket, "Bucket");
        Bucket cloned = new Bucket();
        cloned.setName(clonedName);
        cloned.setOrgID(bucket.getOrgID());
        cloned.setRp(bucket.getRp());
        cloned.setDescription(bucket.getDescription());
        cloned.getRetentionRules().addAll(bucket.getRetentionRules());
        Bucket created = this.createBucket(cloned);
        this.getLabels(bucket).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "Bucket");
        return this.getMembers(bucket.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String bucketID) {
        Arguments.checkNonEmpty(bucketID, "Bucket.ID");
        Call<ResourceMembers> call = this.service.getBucketsIDMembers(bucketID, null);
        ResourceMembers resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findBucketMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "bucket");
        Arguments.checkNotNull(member, "member");
        return this.addMember(member.getId(), bucket.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(bucketID, "Bucket.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postBucketsIDMembers(bucketID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "bucket");
        Arguments.checkNotNull(member, "member");
        this.deleteMember(member.getId(), bucket.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(bucketID, "Bucket.ID");
        Call<Void> call = this.service.deleteBucketsIDMembersID(memberID, bucketID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "bucket");
        return this.getOwners(bucket.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String bucketID) {
        Arguments.checkNonEmpty(bucketID, "Bucket.ID");
        Call<ResourceOwners> call = this.service.getBucketsIDOwners(bucketID, null);
        ResourceOwners resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findBucketOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "bucket");
        Arguments.checkNotNull(owner, "owner");
        return this.addOwner(owner.getId(), bucket.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(bucketID, "Bucket.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postBucketsIDOwners(bucketID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "bucket");
        Arguments.checkNotNull(owner, "owner");
        this.deleteOwner(owner.getId(), bucket.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(bucketID, "Bucket.ID");
        Call<Void> call = this.service.deleteBucketsIDOwnersID(ownerID, bucketID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Bucket bucket) {
        Arguments.checkNotNull(bucket, "bucket");
        return this.getLabels(bucket.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String bucketID) {
        Arguments.checkNonEmpty(bucketID, "bucketID");
        Call<LabelsResponse> call = this.service.getBucketsIDLabels(bucketID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Bucket bucket) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(bucket, "bucket");
        return this.addLabel(label.getId(), bucket.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(bucketID, "bucketID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postBucketsIDLabels(bucketID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Bucket bucket) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(bucket, "bucket");
        this.deleteLabel(label.getId(), bucket.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String bucketID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(bucketID, "bucketID");
        Call<Void> call = this.service.deleteBucketsIDLabelsID(bucketID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private Buckets findBuckets(@Nullable String orgName, @Nonnull FindOptions findOptions) {
        Call<Buckets> bucketsCall = this.service.getBuckets(null, findOptions.getOffset(), findOptions.getLimit(), findOptions.getAfter(), orgName, null, null, null);
        return this.execute(bucketsCall);
    }
}

