/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.TasksApi;
import com.influxdb.client.TasksQuery;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.LogEvent;
import com.influxdb.client.domain.Logs;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.Run;
import com.influxdb.client.domain.RunManually;
import com.influxdb.client.domain.Runs;
import com.influxdb.client.domain.Task;
import com.influxdb.client.domain.TaskCreateRequest;
import com.influxdb.client.domain.TaskStatusType;
import com.influxdb.client.domain.TaskUpdateRequest;
import com.influxdb.client.domain.Tasks;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.TasksService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class TasksApiImpl
extends AbstractRestClient
implements TasksApi {
    private static final Logger LOG = Logger.getLogger(TasksApiImpl.class.getName());
    private final TasksService service;

    TasksApiImpl(@Nonnull TasksService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Task findTaskByID(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "taskID");
        Call<Task> call = this.service.getTasksID(taskID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Task> findTasks() {
        return this.findTasks(null, null, null);
    }

    @Override
    @Nonnull
    public List<Task> findTasksByUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "user");
        return this.findTasksByUserID(user.getId());
    }

    @Override
    @Nonnull
    public List<Task> findTasksByUserID(@Nullable String userID) {
        return this.findTasks(null, userID, null);
    }

    @Override
    @Nonnull
    public List<Task> findTasksByOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.findTasksByOrganizationID(organization.getId());
    }

    @Override
    @Nonnull
    public List<Task> findTasksByOrganizationID(@Nullable String orgID) {
        return this.findTasks(null, null, orgID);
    }

    @Override
    @Nonnull
    public List<Task> findTasks(@Nullable String afterID, @Nullable String userID, @Nullable String orgID) {
        TasksQuery tasksQuery = new TasksQuery();
        tasksQuery.setAfter(afterID);
        tasksQuery.setUser(userID);
        tasksQuery.setOrgID(orgID);
        return this.findTasks(tasksQuery);
    }

    @Override
    @Nonnull
    public List<Task> findTasks(@Nonnull TasksQuery query) {
        Call<Tasks> call = this.service.getTasks(null, query.getName(), query.getAfter(), query.getUser(), query.getOrg(), query.getOrgID(), query.getStatus(), query.getLimit(), query.getType());
        Tasks tasks = this.execute(call);
        LOG.log(Level.FINEST, "findTasks found: {0}", tasks);
        return tasks.getTasks();
    }

    @Override
    @Nonnull
    public Stream<Task> findTasksStream(final @Nonnull TasksQuery query) {
        Iterator<Task> iterator2 = new Iterator<Task>(){
            private boolean hasNext = true;
            @Nonnull
            private Iterator<Task> tasksIterator = Collections.emptyIterator();
            @Nullable
            private String after = query.getAfter();

            @Override
            public boolean hasNext() {
                if (this.tasksIterator.hasNext()) {
                    return true;
                }
                if (this.hasNext) {
                    this.doQueryNext();
                    return this.tasksIterator.hasNext();
                }
                return false;
            }

            private void doQueryNext() {
                String nextUrl;
                Call<Tasks> call = TasksApiImpl.this.service.getTasks(null, query.getName(), this.after, query.getUser(), query.getOrg(), query.getOrgID(), query.getStatus(), query.getLimit(), query.getType());
                Tasks tasks = (Tasks)TasksApiImpl.this.execute(call);
                List<Task> tasksList = tasks.getTasks();
                this.tasksIterator = tasksList.iterator();
                if (!tasksList.isEmpty()) {
                    Task lastTask = tasksList.get(tasksList.size() - 1);
                    this.after = lastTask.getId();
                }
                this.hasNext = (nextUrl = tasks.getLinks().getNext()) != null && !nextUrl.isEmpty();
                String logMsg = "findTasksStream found: {0} has next page: {1} next after {2}: ";
                LOG.log(Level.FINEST, logMsg, new Object[]{tasks, this.hasNext, this.after});
            }

            @Override
            public Task next() throws IndexOutOfBoundsException {
                if (!this.tasksIterator.hasNext() && this.hasNext) {
                    this.doQueryNext();
                }
                if (this.tasksIterator.hasNext()) {
                    return this.tasksIterator.next();
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
        Stream<Task> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 16), false);
        return stream;
    }

    @Override
    @Nonnull
    public Task createTask(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        TaskCreateRequest request = new TaskCreateRequest();
        request.setFlux(task.getFlux());
        request.setOrgID(task.getOrgID());
        request.setOrg(task.getOrg());
        request.setDescription(task.getDescription());
        if (task.getStatus() != null) {
            request.setStatus(TaskStatusType.fromValue(task.getStatus().getValue()));
        }
        return this.createTask(request);
    }

    @Override
    @Nonnull
    public Task createTask(@Nonnull TaskCreateRequest taskCreateRequest) {
        Arguments.checkNotNull(taskCreateRequest, "taskCreateRequest");
        Call<Task> call = this.service.postTasks(taskCreateRequest, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Task createTaskCron(@Nonnull String name, @Nonnull String flux, @Nonnull String cron, @Nonnull Organization organization) {
        Arguments.checkNonEmpty(name, "name of the task");
        Arguments.checkNonEmpty(flux, "Flux script to run");
        Arguments.checkNonEmpty(cron, "cron expression");
        Arguments.checkNotNull(organization, "organization");
        Task task = this.createTask(name, flux, null, cron, organization.getId());
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task createTaskCron(@Nonnull String name, @Nonnull String flux, @Nonnull String cron, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name of the task");
        Arguments.checkNonEmpty(flux, "Flux script to run");
        Arguments.checkNonEmpty(cron, "cron expression");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Task task = this.createTask(name, flux, null, cron, orgID);
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task createTaskEvery(@Nonnull String name, @Nonnull String flux, @Nonnull String every, @Nonnull Organization organization) {
        Arguments.checkNonEmpty(name, "name of the task");
        Arguments.checkNonEmpty(flux, "Flux script to run");
        Arguments.checkNonEmpty(every, "every");
        Arguments.checkNotNull(organization, "organization");
        Task task = this.createTask(name, flux, every, null, organization.getId());
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task createTaskEvery(@Nonnull String name, @Nonnull String flux, @Nonnull String every, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name of the task");
        Arguments.checkNonEmpty(flux, "Flux script to run");
        Arguments.checkNonEmpty(every, "every expression");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Task task = this.createTask(name, flux, every, null, orgID);
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task updateTask(@Nonnull Task task) {
        Arguments.checkNotNull(task, "Task is required");
        Arguments.checkDurationNotRequired(task.getEvery(), "Task.every");
        TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
        taskUpdateRequest.setStatus(TaskStatusType.fromValue(task.getStatus().getValue()));
        taskUpdateRequest.setFlux(task.getFlux());
        taskUpdateRequest.setName(task.getName());
        taskUpdateRequest.setEvery(task.getEvery());
        taskUpdateRequest.setCron(task.getCron());
        taskUpdateRequest.setOffset(task.getOffset());
        taskUpdateRequest.setDescription(task.getDescription());
        return this.updateTask(task.getId(), taskUpdateRequest);
    }

    @Override
    @Nonnull
    public Task updateTask(@Nonnull String taskID, @Nonnull TaskUpdateRequest request) {
        Arguments.checkNotNull(request, "request");
        Arguments.checkNonEmpty(taskID, "taskID");
        Call<Task> call = this.service.patchTasksID(taskID, request, null);
        return this.execute(call);
    }

    @Override
    public void deleteTask(@Nonnull Task task) {
        Arguments.checkNotNull(task, "Task is required");
        this.deleteTask(task.getId());
    }

    @Override
    public void deleteTask(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "taskID");
        Call<Void> call = this.service.deleteTasksID(taskID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Task cloneTask(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "taskID");
        Task task = this.findTaskByID(taskID);
        return this.cloneTask(task);
    }

    @Override
    @Nonnull
    public Task cloneTask(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        Task cloned = new Task();
        cloned.setName(task.getName());
        cloned.setOrgID(task.getOrgID());
        cloned.setFlux(task.getFlux());
        cloned.setStatus(TaskStatusType.ACTIVE);
        Task created = this.createTask(cloned);
        this.getLabels(task).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Call<ResourceMembers> call = this.service.getTasksIDMembers(taskID, null);
        ResourceMembers resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findTaskMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Task task) {
        Arguments.checkNotNull(task, "Task");
        return this.getMembers(task.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        Arguments.checkNotNull(member, "member");
        return this.addMember(member.getId(), task.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String taskID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(taskID, "Task.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postTasksIDMembers(taskID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        Arguments.checkNotNull(member, "member");
        this.deleteMember(member.getId(), task.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String taskID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Call<Void> call = this.service.deleteTasksIDMembersID(memberID, taskID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Call<ResourceOwners> call = this.service.getTasksIDOwners(taskID, null);
        ResourceOwners resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findTaskMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        return this.getOwners(task.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        Arguments.checkNotNull(owner, "owner");
        return this.addOwner(owner.getId(), task.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String taskID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(taskID, "Task.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postTasksIDOwners(taskID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        Arguments.checkNotNull(owner, "owner");
        this.deleteOwner(owner.getId(), task.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String taskID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Call<Void> call = this.service.deleteTasksIDOwnersID(ownerID, taskID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        return this.getRuns(task, null, null, null);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull Task task, @Nullable OffsetDateTime afterTime, @Nullable OffsetDateTime beforeTime, @Nullable Integer limit) {
        Arguments.checkNotNull(task, "task");
        return this.getRuns(task.getId(), afterTime, beforeTime, limit);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        return this.getRuns(taskID, null, null, null);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull String taskID, @Nullable OffsetDateTime afterTime, @Nullable OffsetDateTime beforeTime, @Nullable Integer limit) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Call<Runs> runs = this.service.getTasksIDRuns(taskID, null, null, limit, afterTime, beforeTime);
        Runs execute2 = this.execute(runs);
        return execute2.getRuns();
    }

    @Override
    @Nonnull
    public Run getRun(@Nonnull Run run) {
        Arguments.checkNotNull(run, "run");
        return this.getRun(run.getTaskID(), run.getId());
    }

    @Override
    @Nonnull
    public Run getRun(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Arguments.checkNonEmpty(runID, "Run.ID");
        Call<Run> run = this.service.getTasksIDRunsID(taskID, runID, null);
        return this.execute(run);
    }

    @Override
    @Nonnull
    public List<LogEvent> getRunLogs(@Nonnull Run run) {
        Arguments.checkNotNull(run, "run");
        return this.getRunLogs(run.getTaskID(), run.getId());
    }

    @Override
    @Nonnull
    public List<LogEvent> getRunLogs(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Arguments.checkNonEmpty(runID, "Run.ID");
        Call<Logs> call = this.service.getTasksIDRunsIDLogs(taskID, runID, null);
        Logs logs = this.execute(call);
        return logs.getEvents();
    }

    @Override
    @Nonnull
    public Run runManually(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        return this.runManually(task.getId(), new RunManually());
    }

    @Override
    @Nonnull
    public Run runManually(@Nonnull String taskId, @Nonnull RunManually runManually) {
        Arguments.checkNonEmpty(taskId, "taskId");
        Arguments.checkNotNull(runManually, "runManually");
        Call<Run> call = this.service.postTasksIDRuns(taskId, null, runManually);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Run retryRun(@Nonnull Run run) {
        Arguments.checkNotNull(run, "run");
        return this.retryRun(run.getTaskID(), run.getId());
    }

    @Override
    @Nonnull
    public Run retryRun(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Arguments.checkNonEmpty(runID, "Run.ID");
        Call<Run> run = this.service.postTasksIDRunsIDRetry(taskID, runID, null, "");
        return this.execute(run);
    }

    @Override
    public void cancelRun(@Nonnull Run run) {
        Arguments.checkNotNull(run, "run");
        this.cancelRun(run.getTaskID(), run.getId());
    }

    @Override
    public void cancelRun(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Arguments.checkNonEmpty(runID, "Run.ID");
        Call<Void> run = this.service.deleteTasksIDRunsID(taskID, runID, null);
        this.execute(run);
    }

    @Override
    @Nonnull
    public List<LogEvent> getLogs(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        return this.getLogs(task.getId());
    }

    @Override
    @Nonnull
    public List<LogEvent> getLogs(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "Task.ID");
        Call<Logs> execute2 = this.service.getTasksIDLogs(taskID, null);
        Logs logs = this.execute(execute2);
        return logs.getEvents();
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Task task) {
        Arguments.checkNotNull(task, "task");
        return this.getLabels(task.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String taskID) {
        Arguments.checkNonEmpty(taskID, "taskID");
        Call<LabelsResponse> call = this.service.getTasksIDLabels(taskID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Task task) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(task, "task");
        return this.addLabel(label.getId(), task.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String taskID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(taskID, "taskID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postTasksIDLabels(taskID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Task task) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(task, "task");
        this.deleteLabel(label.getId(), task.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String taskID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(taskID, "taskID");
        Call<Void> call = this.service.deleteTasksIDLabelsID(taskID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private Task createTask(@Nonnull String name, @Nonnull String flux, @Nullable String every, @Nullable String cron, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name of the task");
        Arguments.checkNotNull(flux, "Flux script to run");
        Arguments.checkNonEmpty(orgID, "Organization ID");
        Arguments.checkDurationNotRequired(every, "Task.every");
        Task task = new Task();
        task.setName(name);
        task.setOrgID(orgID);
        task.setStatus(TaskStatusType.ACTIVE);
        task.setFlux(flux);
        Object repetition = "";
        if (every != null) {
            repetition = (String)repetition + "every: ";
            repetition = (String)repetition + every;
        }
        if (cron != null) {
            repetition = (String)repetition + "cron: ";
            repetition = (String)repetition + "\"" + cron + "\"";
        }
        String fluxWithOptions = String.format("%s\n\noption task = {name: \"%s\", %s}", flux, name, repetition);
        task.setFlux(fluxWithOptions);
        return task;
    }
}

