/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write;

import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.PointSettings;
import com.influxdb.client.write.WriteParameters;
import com.influxdb.client.write.internal.NanosecondConverter;
import com.influxdb.utils.Arguments;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Point {
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat;
    });
    private final String name;
    private final Map<String, String> tags = new TreeMap<String, String>();
    private final Map<String, Object> fields = new TreeMap<String, Object>();
    private Number time;
    private WritePrecision precision = WriteParameters.DEFAULT_WRITE_PRECISION;

    public Point(@Nonnull String measurementName) {
        Arguments.checkNotNull(measurementName, "measurement");
        this.name = measurementName;
    }

    @Nonnull
    public static Point measurement(@Nonnull String measurementName) {
        Arguments.checkNotNull(measurementName, "measurement");
        return new Point(measurementName);
    }

    @Nonnull
    public Point addTag(@Nonnull String key, @Nullable String value) {
        Arguments.checkNotNull(key, "tagName");
        this.tags.put(key, value);
        return this;
    }

    @Nonnull
    public Point addTags(@Nonnull Map<String, String> tagsToAdd) {
        Arguments.checkNotNull(tagsToAdd, "tagsToAdd");
        tagsToAdd.forEach(this::addTag);
        return this;
    }

    @Nonnull
    public Point addField(@Nonnull String field, boolean value) {
        return this.putField(field, value);
    }

    public Point addField(@Nonnull String field, long value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, double value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, @Nullable Number value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, @Nullable String value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addFields(@Nonnull Map<String, Object> fieldsToAdd) {
        Arguments.checkNotNull(fieldsToAdd, "fieldsToAdd");
        fieldsToAdd.forEach(this::putField);
        return this;
    }

    @Nonnull
    public Point time(@Nullable Instant time, @Nonnull WritePrecision precision) {
        if (time == null) {
            return this.time((Long)null, precision);
        }
        BigInteger convertedTime = NanosecondConverter.convert(time, precision);
        return this.time(convertedTime, precision);
    }

    @Nonnull
    public Point time(@Nullable Number time, @Nonnull WritePrecision precision) {
        Arguments.checkNotNull((Object)precision, "precision");
        this.time = time;
        this.precision = precision;
        return this;
    }

    @Nonnull
    public Point time(@Nullable Long time, @Nonnull WritePrecision precision) {
        return this.time((Number)time, precision);
    }

    @Nullable
    public Number getTime() {
        return this.time;
    }

    @Nonnull
    public WritePrecision getPrecision() {
        return this.precision;
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Nonnull
    public String toLineProtocol() {
        return this.toLineProtocol(null);
    }

    @Nonnull
    public String toLineProtocol(@Nullable PointSettings pointSettings) {
        return this.toLineProtocol(pointSettings, this.precision);
    }

    @Nonnull
    public String toLineProtocol(@Nullable PointSettings pointSettings, @Nonnull WritePrecision precision) {
        StringBuilder sb = new StringBuilder();
        this.escapeKey(sb, this.name, false);
        this.appendTags(sb, pointSettings);
        boolean appendedFields = this.appendFields(sb);
        if (!appendedFields) {
            return "";
        }
        this.appendTime(sb, precision);
        return sb.toString();
    }

    @Nonnull
    private Point putField(@Nonnull String field, @Nullable Object value) {
        Arguments.checkNonEmpty(field, "fieldName");
        this.fields.put(field, value);
        return this;
    }

    private void appendTags(@Nonnull StringBuilder sb, @Nullable PointSettings pointSettings) {
        Map<String, String> defaultTags;
        Set<Map.Entry<String, String>> entries = this.tags.entrySet();
        if (pointSettings != null && !(defaultTags = pointSettings.getDefaultTags()).isEmpty()) {
            entries = Stream.of(this.tags, defaultTags).map(Map::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                if (v1.isEmpty()) {
                    return v2;
                }
                return v1;
            }, TreeMap::new)).entrySet();
        }
        for (Map.Entry<String, String> tag : entries) {
            String key = tag.getKey();
            String value = tag.getValue();
            if (key.isEmpty() || value == null || value.isEmpty()) continue;
            sb.append(',');
            this.escapeKey(sb, key);
            sb.append('=');
            this.escapeKey(sb, value);
        }
        sb.append(' ');
    }

    private boolean appendFields(@Nonnull StringBuilder sb) {
        boolean appended = false;
        for (Map.Entry<String, Object> field : this.fields.entrySet()) {
            Object value = field.getValue();
            if (this.isNotDefined(value)) continue;
            this.escapeKey(sb, field.getKey());
            sb.append('=');
            if (value instanceof Number) {
                if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                    sb.append(NUMBER_FORMATTER.get().format(value));
                } else {
                    sb.append(value).append('i');
                }
            } else if (value instanceof String) {
                String stringValue = (String)value;
                sb.append('\"');
                this.escapeValue(sb, stringValue);
                sb.append('\"');
            } else {
                sb.append(value);
            }
            sb.append(',');
            appended = true;
        }
        int lengthMinusOne = sb.length() - 1;
        if (sb.charAt(lengthMinusOne) == ',') {
            sb.setLength(lengthMinusOne);
        }
        return appended;
    }

    private void appendTime(@Nonnull StringBuilder sb, WritePrecision precision) {
        if (this.time == null) {
            return;
        }
        sb.append(" ");
        if (this.precision == precision) {
            if (this.time instanceof BigDecimal) {
                sb.append(((BigDecimal)this.time).toBigInteger());
            } else if (this.time instanceof BigInteger) {
                sb.append(this.time);
            } else {
                sb.append(this.time.longValue());
            }
        } else {
            long time = this.time instanceof BigDecimal ? ((BigDecimal)this.time).longValueExact() : (this.time instanceof BigInteger ? ((BigInteger)this.time).longValueExact() : this.time.longValue());
            sb.append(this.toTimeUnit(precision).convert(time, this.toTimeUnit(this.precision)));
        }
    }

    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key) {
        this.escapeKey(sb, key, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key, boolean escapeEqual) {
        int i = 0;
        while (true) {
            block9: {
                if (i >= key.length()) {
                    return;
                }
                switch (key.charAt(i)) {
                    case '\n': {
                        sb.append("\\n");
                        break block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break block9;
                    }
                    case ' ': 
                    case ',': {
                        sb.append('\\');
                        break;
                    }
                    case '=': {
                        if (!escapeEqual) break;
                        sb.append('\\');
                    }
                }
                sb.append(key.charAt(i));
            }
            ++i;
        }
    }

    private void escapeValue(@Nonnull StringBuilder sb, @Nonnull String value) {
        for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(value.charAt(i));
        }
    }

    private boolean isNotDefined(Object value) {
        return value == null || value instanceof Double && !Double.isFinite((Double)value) || value instanceof Float && !Float.isFinite(((Float)value).floatValue());
    }

    @Nonnull
    private TimeUnit toTimeUnit(@Nonnull WritePrecision precision) {
        switch (precision) {
            case MS: {
                return TimeUnit.MILLISECONDS;
            }
            case S: {
                return TimeUnit.SECONDS;
            }
            case US: {
                return TimeUnit.MICROSECONDS;
            }
            case NS: {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)precision));
    }
}

