/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query;

import com.influxdb.utils.Arguments;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FluxRecord
implements Serializable {
    private final Integer table;
    private LinkedHashMap<String, Object> values = new LinkedHashMap();
    private List<Object> row = new ArrayList<Object>();

    public FluxRecord(@Nonnull Integer table) {
        Arguments.checkNotNull(table, "Table index");
        this.table = table;
    }

    @Nullable
    public Instant getStart() {
        return (Instant)this.getValueByKey("_start");
    }

    @Nullable
    public Instant getStop() {
        return (Instant)this.getValueByKey("_stop");
    }

    @Nullable
    public Instant getTime() {
        return (Instant)this.getValueByKey("_time");
    }

    @Nullable
    public Object getValue() {
        return this.getValueByKey("_value");
    }

    @Nullable
    public String getField() {
        return (String)this.getValueByKey("_field");
    }

    @Nullable
    public String getMeasurement() {
        return (String)this.getValueByKey("_measurement");
    }

    @Nonnull
    public Integer getTable() {
        return this.table;
    }

    @Nonnull
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Nonnull
    public List<Object> getRow() {
        return this.row;
    }

    @Nullable
    public Object getValueByIndex(int index) {
        return this.values.values().toArray()[index];
    }

    @Nullable
    public Object getValueByKey(@Nonnull String key) {
        Arguments.checkNonEmpty(key, "key");
        return this.values.get(key);
    }

    public String toString() {
        return new StringJoiner(", ", FluxRecord.class.getSimpleName() + "[", "]").add("table=" + this.table).add("values=" + this.values.size()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluxRecord that = (FluxRecord)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.values);
    }
}

