/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.QueueSubscription;
import org.reactivestreams.Subscriber;

public final class FlowableFilter<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public FlowableFilter(Flowable<T> source2, Predicate<? super T> predicate) {
        super(source2);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new FilterConditionalSubscriber<T>((ConditionalSubscriber)s, this.predicate));
        } else {
            this.source.subscribe(new FilterSubscriber<T>(s, this.predicate));
        }
    }

    static final class FilterConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Predicate<? super T> filter;

        FilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.downstream.tryOnNext(null);
            }
            try {
                b = this.filter.test(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return true;
            }
            return b && this.downstream.tryOnNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            QueueSubscription qs = this.qs;
            Predicate f = this.filter;
            Object t;
            while ((t = qs.poll()) != null) {
                if (f.test(t)) {
                    return t;
                }
                if (this.sourceMode != 2) continue;
                qs.request(1L);
            }
            return null;
        }
    }

    static final class FilterSubscriber<T>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final Predicate<? super T> filter;

        FilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return true;
            }
            try {
                b = this.filter.test(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return true;
            }
            if (b) {
                this.downstream.onNext(t);
            }
            return b;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            QueueSubscription qs = this.qs;
            Predicate f = this.filter;
            Object t;
            while ((t = qs.poll()) != null) {
                if (f.test(t)) {
                    return t;
                }
                if (this.sourceMode != 2) continue;
                qs.request(1L);
            }
            return null;
        }
    }
}

