/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LogEntry;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

class FlushBuffer {
    private int size;
    private int[] levels;
    private long[] times;
    private Thread[] threads;
    private String[] classes;
    private String[] methods;
    private String[] messages;
    private int head = 0;
    private int tail = 0;

    FlushBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal size " + n + ". Must be >= 0");
        }
        this.size = n + 1;
        this.levels = new int[this.size];
        this.times = new long[this.size];
        this.threads = new Thread[this.size];
        this.classes = new String[this.size];
        this.methods = new String[this.size];
        this.messages = new String[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buffer(int n, long l, String string, String string2, String string3) {
        Thread thread = Thread.currentThread();
        FlushBuffer flushBuffer = this;
        synchronized (flushBuffer) {
            int n2 = this.head++;
            if (this.head == this.size) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                ++this.tail;
                if (this.tail == this.size) {
                    this.tail = 0;
                }
            }
        }
        this.levels[n2] = n;
        this.times[n2] = l;
        this.threads[n2] = thread;
        this.classes[n2] = string;
        this.methods[n2] = string2;
        this.messages[n2] = string3;
    }

    synchronized LogEntry[] flush() {
        int n = this.count();
        LogEntry[] logEntryArray = new LogEntry[n];
        int n2 = 0;
        while (n2 < n) {
            if (this.tail == this.size) {
                this.tail = 0;
            }
            logEntryArray[n2] = new LogEntry(this.levels[this.tail], this.times[this.tail], this.threads[this.tail].getName(), this.classes[this.tail], this.methods[this.tail], this.messages[this.tail]);
            ++n2;
            ++this.tail;
        }
        return logEntryArray;
    }

    public int getSize() {
        return this.size - 1;
    }

    void resize(int n) {
        if (n == this.size - 1) {
            return;
        }
        int[] nArray = new int[n + 1];
        long[] lArray = new long[n + 1];
        Thread[] threadArray = new Thread[n + 1];
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        String[] stringArray3 = new String[n + 1];
        int n2 = this.count();
        if (n2 > n) {
            if (this.head > this.tail) {
                System.arraycopy(this.levels, this.tail + (n2 - n), nArray, 0, n);
                System.arraycopy(this.times, this.tail + (n2 - n), lArray, 0, n);
                System.arraycopy(this.threads, this.tail + (n2 - n), threadArray, 0, n);
                System.arraycopy(this.classes, this.tail + (n2 - n), stringArray, 0, n);
                System.arraycopy(this.methods, this.tail + (n2 - n), stringArray2, 0, n);
                System.arraycopy(this.messages, this.tail + (n2 - n), stringArray3, 0, n);
            } else if (this.head >= n) {
                System.arraycopy(this.levels, this.head - n, nArray, 0, n);
                System.arraycopy(this.times, this.head - n, lArray, 0, n);
                System.arraycopy(this.threads, this.head - n, threadArray, 0, n);
                System.arraycopy(this.classes, this.head - n, stringArray, 0, n);
                System.arraycopy(this.methods, this.head - n, stringArray2, 0, n);
                System.arraycopy(this.messages, this.head - n, stringArray3, 0, n);
            } else {
                int n3 = n - this.head;
                System.arraycopy(this.levels, this.size - n3, nArray, 0, n3);
                System.arraycopy(this.times, this.size - n3, lArray, 0, n3);
                System.arraycopy(this.threads, this.size - n3, threadArray, 0, n3);
                System.arraycopy(this.classes, this.size - n3, stringArray, 0, n3);
                System.arraycopy(this.methods, this.size - n3, stringArray2, 0, n3);
                System.arraycopy(this.messages, this.size - n3, stringArray3, 0, n3);
                if (this.head > 0) {
                    System.arraycopy(this.levels, 0, nArray, n3, this.head);
                    System.arraycopy(this.times, 0, lArray, n3, this.head);
                    System.arraycopy(this.threads, 0, threadArray, n3, this.head);
                    System.arraycopy(this.classes, 0, stringArray, n3, this.head);
                    System.arraycopy(this.methods, 0, stringArray2, n3, this.head);
                    System.arraycopy(this.messages, 0, stringArray3, n3, this.head);
                }
            }
        } else if (n2 > 0) {
            if (this.head > this.tail) {
                System.arraycopy(this.levels, this.tail, nArray, 0, n2);
                System.arraycopy(this.times, this.tail, lArray, 0, n2);
                System.arraycopy(this.threads, this.tail, threadArray, 0, n2);
                System.arraycopy(this.classes, this.tail, stringArray, 0, n2);
                System.arraycopy(this.methods, this.tail, stringArray2, 0, n2);
                System.arraycopy(this.messages, this.tail, stringArray3, 0, n2);
            } else {
                System.arraycopy(this.levels, this.tail, nArray, 0, this.size - this.tail);
                System.arraycopy(this.times, this.tail, lArray, 0, this.size - this.tail);
                System.arraycopy(this.threads, this.tail, threadArray, 0, this.size - this.tail);
                System.arraycopy(this.classes, this.tail, stringArray, 0, this.size - this.tail);
                System.arraycopy(this.methods, this.tail, stringArray2, 0, this.size - this.tail);
                System.arraycopy(this.messages, this.tail, stringArray3, 0, this.size - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.levels, 0, nArray, this.size - this.tail, this.head);
                    System.arraycopy(this.times, 0, lArray, this.size - this.tail, this.head);
                    System.arraycopy(this.threads, 0, threadArray, this.size - this.tail, this.head);
                    System.arraycopy(this.classes, 0, stringArray, this.size - this.tail, this.head);
                    System.arraycopy(this.methods, 0, stringArray2, this.size - this.tail, this.head);
                    System.arraycopy(this.messages, 0, stringArray3, this.size - this.tail, this.head);
                }
            }
        }
        this.levels = nArray;
        this.times = lArray;
        this.threads = threadArray;
        this.classes = stringArray;
        this.methods = stringArray2;
        this.messages = stringArray3;
        this.size = n + 1;
        this.tail = 0;
        this.head = Math.min(n2, n);
    }

    private int count() {
        return this.head >= this.tail ? this.head - this.tail : this.head - this.tail + this.size;
    }

    public static class UnitTest
    extends TestCase {
        private FlushBuffer buffer;

        public UnitTest(String string) {
            super(string);
        }

        protected void setUp() {
            this.buffer = new FlushBuffer(5);
            this.fill();
        }

        public static Test suite() {
            return new TestSuite(UnitTest.class);
        }

        public void testFlush() {
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 4 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 0 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[2].getMessage().equals("message2"));
        }

        public void testOverrun() {
            this.fill();
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 5 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 3 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[2].getMessage().equals("message1"));
        }

        public void testResizeSmall() {
            this.buffer.resize(2);
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 2 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 2 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[1].getMethod().equals("method3"));
        }

        public void testOverrunResizeSmall() {
            this.fill();
            this.buffer.resize(2);
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 2 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 2 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[1].getClazz().equals("class3"));
        }

        public void testOverrunAfterResizeSmall() {
            this.buffer.resize(2);
            this.fill();
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 2 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 2 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[1].getTimestamp() == 3L ? 1 : 0) != 0);
        }

        public void testResizeLarge() {
            this.buffer.resize(8);
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 4 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 0 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[3].getMessage().equals("message3"));
        }

        public void testOverrunResizeLarge() {
            this.fill();
            this.buffer.resize(8);
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 5 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 3 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[3].getMessage().equals("message2"));
            UnitTest.assertTrue((logEntryArray[4].getLevel() == 3 ? 1 : 0) != 0);
        }

        public void testOverrunAfterResizeLarge() {
            this.fill();
            this.buffer.resize(8);
            this.fill();
            LogEntry[] logEntryArray = this.buffer.flush();
            UnitTest.assertTrue((logEntryArray.length == 8 ? 1 : 0) != 0);
            UnitTest.assertTrue((logEntryArray[0].getLevel() == 0 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)logEntryArray[3].getMessage().equals("message3"));
            UnitTest.assertTrue((boolean)logEntryArray[7].getMessage().equals("message3"));
        }

        private void fill() {
            this.buffer.buffer(0, 0L, "class0", "method0", "message0");
            this.buffer.buffer(1, 1L, "class1", "method1", "message1");
            this.buffer.buffer(2, 2L, "class2", "method2", "message2");
            this.buffer.buffer(3, 3L, "class3", "method3", "message3");
        }
    }
}

