/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    boolean borderVisible = false;
    CTabFolderRenderer renderer;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    boolean ignoreTraverse;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 0;
    boolean showChevron = false;
    Menu showMenu;
    boolean showMin = false;
    Rectangle minRect = new Rectangle(0, 0, 0, 0);
    boolean minimized = false;
    int minImageState = 0;
    boolean showMax = false;
    Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    boolean maximized = false;
    int maxImageState = 0;
    Control topRight;
    Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    int topRightAlignment = 131072;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int CHEVRON_CHILD_ID = 0;
    static final int MINIMIZE_CHILD_ID = 1;
    static final int MAXIMIZE_CHILD_ID = 2;
    static final int EXTRA_CHILD_ID_COUNT = 3;

    public CTabFolder(Composite composite, int n) {
        super(composite, CTabFolder.checkStyle(composite, n));
        this.init(n);
    }

    void init(int n) {
        super.setLayout(new CTabFolderLayout());
        int n2 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (n2 & 0x400) != 0;
        this.showClose = (n2 & 0x40) != 0;
        this.single = (n2 & 4) != 0;
        this.borderVisible = (n & 0x800) != 0;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        this.renderer = new CTabFolderRenderer(this);
        this.updateTabHeight(false);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose(event);
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 6: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 29, 15, 16, 1, 8, 3, 6, 7, 5, 4, 9, 11, 31};
        for (int i = 0; i < nArray.length; ++i) {
            this.addListener(nArray[i], this.listener);
        }
        this.initAccessible();
    }

    static int checkStyle(Composite composite, int n) {
        int n2 = 109053126;
        if (((n &= n2) & 0x80) != 0) {
            n &= 0xFFFFFBFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        if (((n |= 0x100000) & 0x4000000) != 0) {
            return n;
        }
        if ((composite.getStyle() & 0x8000000) != 0 && (n & 0x2000000) == 0) {
            return n;
        }
        return n | 0x20000000;
    }

    public void addCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, this.folderListeners.length);
        this.folderListeners = cTabFolder2ListenerArray;
        this.folderListeners[this.folderListeners.length - 1] = cTabFolder2Listener;
    }

    public void addCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, this.tabListeners.length);
        this.tabListeners = cTabFolderListenerArray;
        this.tabListeners[this.tabListeners.length - 1] = cTabFolderListener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        return this.renderer.computeTrim(-1, 0, n, n2, n3, n4);
    }

    void createItem(CTabItem cTabItem, int n) {
        if (0 > n || n > this.getItemCount()) {
            SWT.error(6);
        }
        cTabItem.parent = this;
        CTabItem[] cTabItemArray = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n);
        cTabItemArray[n] = cTabItem;
        System.arraycopy(this.items, n, cTabItemArray, n + 1, this.items.length - n);
        this.items = cTabItemArray;
        if (this.selectedIndex >= n) {
            ++this.selectedIndex;
        }
        int[] nArray = new int[this.priority.length + 1];
        int n2 = 0;
        int n3 = this.priority.length;
        for (int i = 0; i < this.priority.length; ++i) {
            if (!this.mru && this.priority[i] == n) {
                n3 = n2++;
            }
            nArray[n2++] = this.priority[i] >= n ? this.priority[i] + 1 : this.priority[i];
        }
        nArray[n3] = n;
        this.priority = nArray;
        if (this.items.length == 1) {
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redrawTabs();
        }
    }

    void destroyItem(CTabItem cTabItem) {
        if (this.inDispose) {
            return;
        }
        int n = this.indexOf(cTabItem);
        if (n == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = cTabItem.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            GC gC = new GC(this);
            this.setButtonBounds(gC);
            gC.dispose();
            this.redraw();
            return;
        }
        CTabItem[] cTabItemArray = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n);
        System.arraycopy(this.items, n + 1, cTabItemArray, n, this.items.length - n - 1);
        this.items = cTabItemArray;
        int[] nArray = new int[this.priority.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.priority.length; ++i) {
            if (this.priority[i] == n) continue;
            nArray[n2++] = this.priority[i] > n ? this.priority[i] - 1 : this.priority[i];
        }
        this.priority = nArray;
        if (this.selectedIndex == n) {
            Control control = cTabItem.getControl();
            this.selectedIndex = -1;
            int n3 = this.mru ? this.priority[0] : Math.max(0, n - 1);
            this.setSelection(n3, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > n) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redrawTabs();
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderVisible;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        if (this.minimized) {
            return new Rectangle(-rectangle.x, -rectangle.y, 0, 0);
        }
        Point point = this.getSize();
        int n = point.x - rectangle.width;
        int n2 = point.y - rectangle.height;
        return new Rectangle(-rectangle.x, -rectangle.y, n, n2);
    }

    public CTabItem getItem(int n) {
        if (n < 0 || n >= this.items.length) {
            SWT.error(6);
        }
        return this.items[n];
    }

    public CTabItem getItem(Point point) {
        if (this.items.length == 0) {
            return null;
        }
        Point point2 = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        if (point2.x <= rectangle.width) {
            return null;
        }
        if (this.showChevron && this.chevronRect.contains(point)) {
            return null;
        }
        for (int i = 0; i < this.priority.length; ++i) {
            CTabItem cTabItem = this.items[this.priority[i]];
            Rectangle rectangle2 = cTabItem.getBounds();
            if (!rectangle2.contains(point)) continue;
            return cTabItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, cTabItemArray, 0, this.items.length);
        return cTabItemArray;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return string.substring(0, n - 1) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    public CTabFolderRenderer getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    int getRightItemEdge(GC gC) {
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n = this.getSize().x - (rectangle.width + rectangle.x) - 3;
        if (this.showMin) {
            n -= this.renderer.computeSize((int)-6, (int)0, (GC)gC, (int)-1, (int)-1).x;
        }
        if (this.showMax) {
            n -= this.renderer.computeSize((int)-5, (int)0, (GC)gC, (int)-1, (int)-1).x;
        }
        if (this.showChevron) {
            n -= this.renderer.computeSize((int)-7, (int)0, (GC)gC, (int)-1, (int)-1).x;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            Point point = this.topRight.computeSize(-1, -1);
            n -= point.x + 3;
        }
        return Math.max(0, n);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xFFFFFB7F;
        n |= this.onBottom ? 1024 : 128;
        n &= 0xFFFFFFF9;
        n |= this.single ? 4 : 2;
        if (this.borderVisible) {
            n |= 0x800;
        }
        n &= 0xFFFFFFBF;
        if (this.showClose) {
            n |= 0x40;
        }
        return n;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public int getTopRightAlignment() {
        this.checkWidget();
        return this.topRightAlignment;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != cTabItem) continue;
            return i;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                int n = accessibleEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = CTabFolder.this.stripMnemonic(CTabFolder.this.items[n].getText());
                } else if (n == CTabFolder.this.items.length + 0) {
                    string = SWT.getMessage("SWT_ShowList");
                } else if (n == CTabFolder.this.items.length + 1) {
                    string = CTabFolder.this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
                } else if (n == CTabFolder.this.items.length + 2) {
                    string = CTabFolder.this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
                }
                accessibleEvent.result = string;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                String string = null;
                int n = accessibleEvent.childID;
                if (n == -1) {
                    string = CTabFolder.this.getToolTipText();
                } else if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = CTabFolder.this.items[n].getToolTipText();
                }
                accessibleEvent.result = string;
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                int n = accessibleEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length && (string = CTabFolder.this.items[n].getText()) != null && (c = CTabFolder.this._findMnemonic(string)) != '\u0000') {
                    string2 = SWT.getMessage("SWT_Page_Mnemonic", new Object[]{new Character(c)});
                }
                if (n == -1) {
                    string2 = SWT.getMessage("SWT_SwitchPage_Shortcut");
                }
                accessibleEvent.result = string2;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = CTabFolder.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                int n = -2;
                for (int i = 0; i < CTabFolder.this.items.length; ++i) {
                    if (!CTabFolder.this.items[i].getBounds().contains(point)) continue;
                    n = i;
                    break;
                }
                if (n == -2) {
                    if (CTabFolder.this.showChevron && CTabFolder.this.chevronRect.contains(point)) {
                        n = CTabFolder.this.items.length + 0;
                    } else if (CTabFolder.this.showMin && CTabFolder.this.minRect.contains(point)) {
                        n = CTabFolder.this.items.length + 1;
                    } else if (CTabFolder.this.showMax && CTabFolder.this.maxRect.contains(point)) {
                        n = CTabFolder.this.items.length + 2;
                    } else {
                        Rectangle rectangle = CTabFolder.this.getBounds();
                        rectangle.y = 0;
                        rectangle.x = 0;
                        rectangle.height -= CTabFolder.this.getClientArea().height;
                        if (rectangle.contains(point)) {
                            n = -1;
                        }
                    }
                }
                accessibleControlEvent.childID = n;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = null;
                Point point = null;
                int n = accessibleControlEvent.childID;
                if (n == -1) {
                    rectangle = CTabFolder.this.getBounds();
                    point = CTabFolder.this.getParent().toDisplay(rectangle.x, rectangle.y);
                } else {
                    if (n >= 0 && n < CTabFolder.this.items.length && CTabFolder.this.items[n].isShowing()) {
                        rectangle = CTabFolder.this.items[n].getBounds();
                    } else if (CTabFolder.this.showChevron && n == CTabFolder.this.items.length + 0) {
                        rectangle = CTabFolder.this.chevronRect;
                    } else if (CTabFolder.this.showMin && n == CTabFolder.this.items.length + 1) {
                        rectangle = CTabFolder.this.minRect;
                    } else if (CTabFolder.this.showMax && n == CTabFolder.this.items.length + 2) {
                        rectangle = CTabFolder.this.maxRect;
                    }
                    if (rectangle != null) {
                        point = CTabFolder.this.toDisplay(rectangle.x, rectangle.y);
                    }
                }
                if (rectangle != null && point != null) {
                    accessibleControlEvent.x = point.x;
                    accessibleControlEvent.y = point.y;
                    accessibleControlEvent.width = rectangle.width;
                    accessibleControlEvent.height = rectangle.height;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = CTabFolder.this.items.length + 3;
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                String string = null;
                int n = accessibleControlEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = SWT.getMessage("SWT_Switch");
                }
                if (n >= CTabFolder.this.items.length && n < CTabFolder.this.items.length + 3) {
                    string = SWT.getMessage("SWT_Press");
                }
                accessibleControlEvent.result = string;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                int n = -2;
                if (CTabFolder.this.isFocusControl()) {
                    n = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                accessibleControlEvent.childID = n;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    n = 60;
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    n = 37;
                } else if (n2 >= CTabFolder.this.items.length && n2 < CTabFolder.this.items.length + 3) {
                    n = 43;
                }
                accessibleControlEvent.detail = n;
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    n = 0;
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    n = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        n |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == n2) {
                        n |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            n |= 4;
                        }
                    }
                } else if (n2 == CTabFolder.this.items.length + 0) {
                    n = CTabFolder.this.showChevron ? 0 : 32768;
                } else if (n2 == CTabFolder.this.items.length + 1) {
                    n = CTabFolder.this.showMin ? 0 : 32768;
                } else if (n2 == CTabFolder.this.items.length + 2) {
                    n = CTabFolder.this.showMax ? 0 : 32768;
                }
                accessibleControlEvent.detail = n;
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n = CTabFolder.this.items.length + 3;
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = new Integer(i);
                }
                accessibleControlEvent.children = objectArray;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int n;
                int n2;
                int n3 = this.items.length;
                if (n3 == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int n4 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n5 = n2 = event.keyCode == n4 ? -1 : 1;
                if (!this.mru) {
                    n = this.selectedIndex + n2;
                } else {
                    int[] nArray = new int[this.items.length];
                    int n6 = 0;
                    int n7 = -1;
                    for (int i = 0; i < this.items.length; ++i) {
                        if (!this.items[i].showing) continue;
                        if (i == this.selectedIndex) {
                            n7 = n6;
                        }
                        nArray[n6++] = i;
                    }
                    if (n7 + n2 >= 0 && n7 + n2 < n6) {
                        n = nArray[n7 + n2];
                    } else {
                        if (this.showChevron) {
                            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                            cTabFolderEvent.widget = this;
                            cTabFolderEvent.time = event.time;
                            cTabFolderEvent.x = this.chevronRect.x;
                            cTabFolderEvent.y = this.chevronRect.y;
                            cTabFolderEvent.width = this.chevronRect.width;
                            cTabFolderEvent.height = this.chevronRect.height;
                            cTabFolderEvent.doit = true;
                            for (int i = 0; i < this.folderListeners.length; ++i) {
                                this.folderListeners[i].showList(cTabFolderEvent);
                            }
                            if (cTabFolderEvent.doit && !this.isDisposed()) {
                                this.showList(this.chevronRect);
                            }
                        }
                        return;
                    }
                }
                if (n < 0 || n >= n3) {
                    return;
                }
                this.setSelection(n, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int n = this.items.length;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].dispose();
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = null;
    }

    void onDragDetect(Event event) {
        boolean bl = false;
        if (this.chevronRect.contains(event.x, event.y) || this.minRect.contains(event.x, event.y) || this.maxRect.contains(event.x, event.y)) {
            bl = true;
        } else {
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].closeRect.contains(event.x, event.y)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event, boolean bl) {
        char c = event.character;
        for (int i = 0; i < this.items.length; ++i) {
            char c2;
            if (this.items[i] == null || (c2 = this._findMnemonic(this.items[i].getText())) == '\u0000' || Character.toLowerCase(c) != c2) continue;
            if (bl) {
                this.setSelection(i, true);
                this.forceFocus();
            }
            return true;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = this.getItem(new Point(event.x, event.y));
        if (event2.item != null) {
            this.notifyListeners(14, event2);
        }
    }

    void onMouse(Event event) {
        int n = event.x;
        int n2 = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                if (this.minImageState != 0) {
                    this.minImageState = 0;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 0) {
                    this.maxImageState = 0;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 0) {
                    this.chevronImageState = 0;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                for (int i = 0; i < this.items.length; ++i) {
                    CTabItem cTabItem = this.items[i];
                    if (i != this.selectedIndex && cTabItem.closeImageState != 8) {
                        cTabItem.closeImageState = 8;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if ((cTabItem.state & 0x20) != 0) {
                        cTabItem.state &= 0xFFFFFFDF;
                        this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                    }
                    if (i != this.selectedIndex || cTabItem.closeImageState == 0) continue;
                    cTabItem.closeImageState = 0;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                }
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.minRect.contains(n, n2)) {
                    this.minImageState = 2;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    this.update();
                    return;
                }
                if (this.maxRect.contains(n, n2)) {
                    this.maxImageState = 2;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(n, n2)) {
                    this.chevronImageState = this.chevronImageState != 32 ? 32 : 2;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n, n2)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i = 0; i < this.items.length; ++i) {
                        Rectangle rectangle = this.items[i].getBounds();
                        if (!rectangle.contains(n, n2)) continue;
                        cTabItem = this.items[i];
                    }
                }
                if (cTabItem == null) break;
                if (cTabItem.closeRect.contains(n, n2)) {
                    cTabItem.closeImageState = 2;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    this.update();
                    return;
                }
                int n3 = this.indexOf(cTabItem);
                if (cTabItem.showing) {
                    int n4 = this.selectedIndex;
                    this.setSelection(n3, true);
                    if (n4 == this.selectedIndex) {
                        this.forceFocus();
                    }
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if (this.minRect.contains(n, n2)) {
                    bl2 = true;
                    if (this.minImageState != 2 && this.minImageState != 32) {
                        this.minImageState = 32;
                        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    }
                }
                if (this.maxRect.contains(n, n2)) {
                    bl3 = true;
                    if (this.maxImageState != 2 && this.maxImageState != 32) {
                        this.maxImageState = 32;
                        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    }
                }
                if (this.chevronRect.contains(n, n2)) {
                    bl4 = true;
                    if (this.chevronImageState != 2 && this.chevronImageState != 32) {
                        this.chevronImageState = 32;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.minImageState != 0 && !bl2) {
                    this.minImageState = 0;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 0 && !bl3) {
                    this.maxImageState = 0;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 0 && !bl4) {
                    this.chevronImageState = 0;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                for (int i = 0; i < this.items.length; ++i) {
                    CTabItem cTabItem = this.items[i];
                    bl = false;
                    if (cTabItem.getBounds().contains(n, n2)) {
                        bl = true;
                        if (cTabItem.closeRect.contains(n, n2)) {
                            if (cTabItem.closeImageState != 2 && cTabItem.closeImageState != 32) {
                                cTabItem.closeImageState = 32;
                                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                            }
                        } else if (cTabItem.closeImageState != 0) {
                            cTabItem.closeImageState = 0;
                            this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                        }
                        if ((cTabItem.state & 0x20) == 0) {
                            cTabItem.state |= 0x20;
                            this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                        }
                    }
                    if (i != this.selectedIndex && cTabItem.closeImageState != 8 && !bl) {
                        cTabItem.closeImageState = 8;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if ((cTabItem.state & 0x20) != 0 && !bl) {
                        cTabItem.state &= 0xFFFFFFDF;
                        this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                    }
                    if (i != this.selectedIndex || cTabItem.closeImageState == 0 || bl) continue;
                    cTabItem.closeImageState = 0;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                }
                break;
            }
            case 4: {
                Object object;
                int n5;
                Serializable serializable;
                if (event.button != 1) {
                    return;
                }
                if (this.chevronRect.contains(n, n2)) {
                    boolean bl;
                    boolean bl5 = bl = this.chevronImageState == 2;
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = this.chevronRect.x;
                    cTabFolderEvent.y = this.chevronRect.y;
                    cTabFolderEvent.width = this.chevronRect.width;
                    cTabFolderEvent.height = this.chevronRect.height;
                    cTabFolderEvent.doit = true;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        this.folderListeners[i].showList(cTabFolderEvent);
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                    return;
                }
                if (this.minRect.contains(n, n2)) {
                    boolean bl = this.minImageState == 2;
                    this.minImageState = 32;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        if (this.minimized) {
                            this.folderListeners[i].restore(cTabFolderEvent);
                            continue;
                        }
                        this.folderListeners[i].minimize(cTabFolderEvent);
                    }
                    return;
                }
                if (this.maxRect.contains(n, n2)) {
                    boolean bl = this.maxImageState == 2;
                    this.maxImageState = 32;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        if (this.maximized) {
                            this.folderListeners[i].restore(cTabFolderEvent);
                            continue;
                        }
                        this.folderListeners[i].maximize(cTabFolderEvent);
                    }
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n, n2)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i = 0; i < this.items.length; ++i) {
                        serializable = this.items[i].getBounds();
                        if (!serializable.contains(n, n2)) continue;
                        cTabItem = this.items[i];
                    }
                }
                if (cTabItem == null || !cTabItem.closeRect.contains(n, n2)) break;
                boolean bl = cTabItem.closeImageState == 2;
                cTabItem.closeImageState = 32;
                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                if (!bl) {
                    return;
                }
                serializable = new CTabFolderEvent(this);
                ((CTabFolderEvent)serializable).widget = this;
                ((CTabFolderEvent)serializable).time = event.time;
                ((CTabFolderEvent)serializable).item = cTabItem;
                ((CTabFolderEvent)serializable).doit = true;
                for (n5 = 0; n5 < this.folderListeners.length; ++n5) {
                    object = this.folderListeners[n5];
                    object.close((CTabFolderEvent)serializable);
                }
                for (n5 = 0; n5 < this.tabListeners.length; ++n5) {
                    object = this.tabListeners[n5];
                    object.itemClosed((CTabFolderEvent)serializable);
                }
                if (((CTabFolderEvent)serializable).doit) {
                    cTabItem.dispose();
                }
                if (!this.isDisposed() && cTabItem.isDisposed()) {
                    Display display = this.getDisplay();
                    object = display.getCursorLocation();
                    object = display.map(null, this, ((Point)object).x, ((Point)object).y);
                    CTabItem cTabItem2 = this.getItem((Point)object);
                    if (cTabItem2 != null) {
                        if (cTabItem2.closeRect.contains((Point)object)) {
                            if (cTabItem2.closeImageState != 2 && cTabItem2.closeImageState != 32) {
                                cTabItem2.closeImageState = 32;
                                this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                            }
                        } else if (cTabItem2.closeImageState != 0) {
                            cTabItem2.closeImageState = 0;
                            this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    void onPageTraversal(Event event) {
        int n = this.items.length;
        if (n == 0) {
            return;
        }
        int n2 = this.selectedIndex;
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3;
            int n4 = n3 = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                n2 = (this.selectedIndex + n3 + n) % n;
            } else {
                int[] nArray = new int[this.items.length];
                int n5 = 0;
                int n6 = -1;
                for (int i = 0; i < this.items.length; ++i) {
                    if (!this.items[i].showing) continue;
                    if (i == this.selectedIndex) {
                        n6 = n5;
                    }
                    nArray[n5++] = i;
                }
                if (n6 + n3 >= 0 && n6 + n3 < n5) {
                    n2 = nArray[n6 + n3];
                } else if (this.showChevron) {
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = this.chevronRect.x;
                    cTabFolderEvent.y = this.chevronRect.y;
                    cTabFolderEvent.width = this.chevronRect.width;
                    cTabFolderEvent.height = this.chevronRect.height;
                    cTabFolderEvent.doit = true;
                    for (int i = 0; i < this.folderListeners.length; ++i) {
                        this.folderListeners[i].showList(cTabFolderEvent);
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                }
            }
        }
        this.setSelection(n2, true);
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gC = event.gc;
        Font font2 = gC.getFont();
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        Point point = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, point.x, point.y);
        this.renderer.draw(-1, 24, rectangle, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.renderer.draw(-2, 24, rectangle, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (!this.single) {
            for (int i = 0; i < this.items.length; ++i) {
                Rectangle rectangle2 = this.items[i].getBounds();
                if (i == this.selectedIndex || !event.getBounds().intersects(rectangle2)) continue;
                this.renderer.draw(i, 0x18 | this.items[i].state, rectangle2, gC);
            }
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (this.selectedIndex != -1) {
            this.renderer.draw(this.selectedIndex, this.items[this.selectedIndex].state | 8 | 0x10, this.items[this.selectedIndex].getBounds(), gC);
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.renderer.draw(-5, this.maxImageState, this.maxRect, gC);
        this.renderer.draw(-6, this.minImageState, this.minRect, gC);
        this.renderer.draw(-7, this.chevronImageState, this.chevronRect, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
    }

    void onResize() {
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point point = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && point.y != this.oldSize.y) {
            this.redraw();
        } else {
            int n = Math.min(point.x, this.oldSize.x);
            Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
            if (point.x != this.oldSize.x) {
                n -= rectangle.width + rectangle.x - this.marginWidth + 2;
            }
            if (!this.simple) {
                n -= 5;
            }
            int n2 = Math.min(point.y, this.oldSize.y);
            if (point.y != this.oldSize.y) {
                n2 -= rectangle.height + rectangle.y - this.marginHeight;
            }
            int n3 = Math.max(point.x, this.oldSize.x);
            int n4 = Math.max(point.y, this.oldSize.y);
            this.redraw(0, n2, n3, n4 - n2, false);
            this.redraw(n, 0, n3 - n, n4, false);
        }
        this.oldSize = point;
    }

    void onTraverse(Event event) {
        if (this.ignoreTraverse) {
            return;
        }
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control control = this.getDisplay().getFocusControl();
                if (control != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event, false);
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.items.length > 0;
            }
        }
        this.ignoreTraverse = true;
        this.notifyListeners(31, event);
        this.ignoreTraverse = false;
        event.type = 0;
        if (this.isDisposed()) {
            return;
        }
        if (!event.doit) {
            return;
        }
        switch (event.detail) {
            case 128: {
                this.onMnemonic(event, true);
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point point = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        if (this.onBottom) {
            int n = rectangle.height + rectangle.y - this.marginHeight;
            this.redraw(0, point.y - n - 1, point.x, n + 1, false);
        } else {
            this.redraw(0, 0, point.x, -rectangle.y - this.marginHeight + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.folderListeners.length; ++i) {
            if (cTabFolder2Listener != this.folderListeners[i]) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, n);
        System.arraycopy(this.folderListeners, n + 1, cTabFolder2ListenerArray, n, this.folderListeners.length - n - 1);
        this.folderListeners = cTabFolder2ListenerArray;
    }

    public void removeCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.tabListeners.length; ++i) {
            if (cTabFolderListener != this.tabListeners[i]) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, n);
        System.arraycopy(this.tabListeners, n + 1, cTabFolderListenerArray, n, this.tabListeners.length - n - 1);
        this.tabListeners = cTabFolderListenerArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void reskin(int n) {
        super.reskin(n);
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].reskin(n);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.renderer.createAntialiasColors();
        this.redraw();
    }

    public void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] < 0 || nArray[n] > 100) {
                    SWT.error(5);
                }
                if (n <= 0 || nArray[n] >= nArray[n - 1]) continue;
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
            int n2;
            n = 0;
            for (n2 = 0; n2 < this.gradientColors.length && (n = this.gradientColors[n2] == null ? (colorArray[n2] == null ? 1 : 0) : (int)(this.gradientColors[n2].equals(colorArray[n2]) ? 1 : 0)) != 0; ++n2) {
            }
            if (n != 0) {
                for (n2 = 0; n2 < this.gradientPercents.length; ++n2) {
                    int n3 = n = this.gradientPercents[n2] == nArray[n2] ? 1 : 0;
                    if (n == 0) break;
                }
            }
            if (n != 0 && this.gradientVertical == bl) {
                return;
            }
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground(null);
        } else {
            this.gradientColors = new Color[colorArray.length];
            for (n = 0; n < colorArray.length; ++n) {
                this.gradientColors[n] = colorArray[n];
            }
            this.gradientPercents = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                this.gradientPercents[n] = nArray[n];
            }
            this.gradientVertical = bl;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.renderer.createAntialiasColors();
        this.redraw();
    }

    public void setBorderVisible(boolean bl) {
        this.checkWidget();
        if (this.borderVisible == bl) {
            return;
        }
        this.borderVisible = bl;
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds(GC gC) {
        int n;
        int n2;
        Point point;
        Point point2 = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n3 = rectangle.width + rectangle.x;
        int n4 = -rectangle.x;
        int n5 = rectangle.height + rectangle.y;
        int n6 = -rectangle.y;
        int n7 = this.maxRect.x;
        int n8 = this.maxRect.y;
        int n9 = this.maxRect.width;
        int n10 = this.maxRect.height;
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            point = this.renderer.computeSize(-5, 0, gC, -1, -1);
            this.maxRect.x = point2.x - n3 - point.x - 3;
            if (n3 > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? point2.y - n5 - this.tabHeight + (this.tabHeight - point.y) / 2 : n6 + (this.tabHeight - point.y) / 2;
            this.maxRect.width = point.x;
            this.maxRect.height = point.y;
        }
        if (n7 != this.maxRect.x || n9 != this.maxRect.width || n8 != this.maxRect.y || n10 != this.maxRect.height) {
            int n11 = Math.min(n7, this.maxRect.x);
            n2 = Math.max(n7 + n9, this.maxRect.x + this.maxRect.width);
            n = this.onBottom ? point2.y - n5 - this.tabHeight : n6 + 1;
            this.redraw(n11, n, n2 - n11, this.tabHeight, false);
        }
        n7 = this.minRect.x;
        n8 = this.minRect.y;
        n9 = this.minRect.width;
        n10 = this.minRect.height;
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            point = this.renderer.computeSize(-6, 0, gC, -1, -1);
            this.minRect.x = point2.x - n3 - this.maxRect.width - point.x - 3;
            if (n3 > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? point2.y - n5 - this.tabHeight + (this.tabHeight - point.y) / 2 : n6 + (this.tabHeight - point.y) / 2;
            this.minRect.width = point.x;
            this.minRect.height = point.y;
        }
        if (n7 != this.minRect.x || n9 != this.minRect.width || n8 != this.minRect.y || n10 != this.minRect.height) {
            int n12 = Math.min(n7, this.minRect.x);
            n2 = Math.max(n7 + n9, this.minRect.x + this.minRect.width);
            n = this.onBottom ? point2.y - n5 - this.tabHeight : n6 + 1;
            this.redraw(n12, n, n2 - n12, this.tabHeight, false);
        }
        n7 = this.topRightRect.x;
        n8 = this.topRightRect.y;
        n9 = this.topRightRect.width;
        n10 = this.topRightRect.height;
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    int n13 = point2.x - n3 - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || n3 <= 0 || this.showMax || this.showMin)) {
                        n13 -= 2;
                    }
                    if (this.single) {
                        if (this.items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = n4 + 3;
                            this.topRightRect.width = n13 - this.topRightRect.x;
                        } else {
                            CTabItem cTabItem = this.items[this.selectedIndex];
                            n = this.renderer.computeSize((int)-7, (int)0, (GC)gC, (int)-1, (int)-1).x;
                            if (cTabItem.x + cTabItem.width + 7 + n >= n13) break;
                            this.topRightRect.x = cTabItem.x + cTabItem.width + 7 + n;
                            this.topRightRect.width = n13 - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (this.items.length == 0) {
                            this.topRightRect.x = n4 + 3;
                        } else {
                            n2 = this.items.length - 1;
                            CTabItem cTabItem = this.items[n2];
                            this.topRightRect.x = cTabItem.x + cTabItem.width;
                        }
                        this.topRightRect.width = Math.max(0, n13 - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? point2.y - n5 - this.tabHeight : n6 + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point point3 = this.topRight.computeSize(-1, this.tabHeight, false);
                    n2 = point2.x - n3 - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || n3 <= 0 || this.showMax || this.showMin)) {
                        n2 -= 2;
                    }
                    this.topRightRect.x = n2 - point3.x;
                    this.topRightRect.width = point3.x;
                    this.topRightRect.y = this.onBottom ? point2.y - n5 - this.tabHeight : n6 + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        if (n7 != this.topRightRect.x || n9 != this.topRightRect.width || n8 != this.topRightRect.y || n10 != this.topRightRect.height) {
            int n14 = Math.min(n7, this.topRightRect.x);
            int n15 = Math.max(n7 + n9, this.topRightRect.x + this.topRightRect.width);
            int n16 = this.onBottom ? point2.y - n5 - this.tabHeight : n6 + 1;
            this.redraw(n14, n16, n15 - n14, this.tabHeight, false);
        }
        n7 = this.chevronRect.x;
        n8 = this.chevronRect.y;
        n9 = this.chevronRect.width;
        n10 = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        Point point4 = this.renderer.computeSize(-7, 0, gC, -1, -1);
        if (this.single) {
            if (this.selectedIndex == -1 || this.items.length > 1) {
                this.chevronRect.width = point4.x;
                this.chevronRect.height = point4.y;
                int n17 = this.chevronRect.y = this.onBottom ? point2.y - n5 - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : n6 + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = point2.x - n3 - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem cTabItem = this.items[this.selectedIndex];
                    int n18 = point2.x - n3 - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        n18 -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(cTabItem.x + cTabItem.width + 3, n18);
                }
                if (n3 > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = point4.x;
            this.chevronRect.height = point4.y;
            int n19 = 0;
            int n20 = -1;
            while (n19 < this.priority.length && this.items[this.priority[n19]].showing) {
                n20 = Math.max(n20, this.priority[n19++]);
            }
            if (n20 == -1) {
                n20 = this.firstIndex;
            }
            CTabItem cTabItem = this.items[n20];
            int n21 = cTabItem.x + cTabItem.width + 3;
            if (!this.simple && n20 == this.selectedIndex) {
                n21 -= this.renderer.curveIndent;
            }
            this.chevronRect.x = Math.min(n21, this.getRightItemEdge(gC));
            int n22 = this.chevronRect.y = this.onBottom ? point2.y - n5 - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : n6 + (this.tabHeight - this.chevronRect.height) / 2;
        }
        if (n7 != this.chevronRect.x || n9 != this.chevronRect.width || n8 != this.chevronRect.y || n10 != this.chevronRect.height) {
            int n23 = Math.min(n7, this.chevronRect.x);
            int n24 = Math.max(n7 + n9, this.chevronRect.x + this.chevronRect.width);
            int n25 = this.onBottom ? point2.y - n5 - this.tabHeight : n6 + 1;
            this.redraw(n23, n25, n24 - n23, this.tabHeight, false);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem cTabItem, boolean bl) {
        this.checkWidget();
    }

    public void setInsertMark(int n, boolean bl) {
        this.checkWidget();
        if (n < -1 || n >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation(GC gC) {
        boolean bl = false;
        if (this.items.length == 0) {
            return false;
        }
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n = -rectangle.x;
        int n2 = rectangle.height + rectangle.y;
        int n3 = -rectangle.y;
        Point point = this.getSize();
        int n4 = this.onBottom ? Math.max(n2, point.y - n2 - this.tabHeight) : n3;
        Point point2 = this.renderer.computeSize(-8, 0, gC, -1, -1);
        if (this.single) {
            int n5 = this.getDisplay().getBounds().width + 10;
            for (int i = 0; i < this.items.length; ++i) {
                CTabItem cTabItem = this.items[i];
                if (i == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int n6 = cTabItem.x;
                    int n7 = cTabItem.y;
                    cTabItem.x = n;
                    cTabItem.y = n4;
                    cTabItem.showing = true;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.x = n - this.renderer.computeTrim((int)i, (int)0, (int)0, (int)0, (int)0, (int)0).x;
                        int n8 = cTabItem.closeRect.y = this.onBottom ? point.y - n2 - this.tabHeight + (this.tabHeight - point2.y) / 2 : n3 + (this.tabHeight - point2.y) / 2;
                    }
                    if (cTabItem.x == n6 && cTabItem.y == n7) continue;
                    bl = true;
                    continue;
                }
                cTabItem.x = n5;
                cTabItem.showing = false;
            }
        } else {
            int n9;
            int n10 = this.getRightItemEdge(gC);
            int n11 = n10 - n;
            int n12 = 0;
            for (n9 = 0; n9 < this.priority.length; ++n9) {
                CTabItem cTabItem = this.items[this.priority[n9]];
                cTabItem.showing = n9 == 0 ? true : cTabItem.width > 0 && (n12 += cTabItem.width) <= n11;
            }
            n9 = -this.renderer.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).x;
            int n13 = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            for (int i = 0; i < this.items.length; ++i) {
                CTabItem cTabItem = this.items[i];
                if (!cTabItem.showing) {
                    if (cTabItem.x != n13) {
                        bl = true;
                    }
                    cTabItem.x = n13;
                    continue;
                }
                this.firstIndex = Math.min(this.firstIndex, i);
                if (cTabItem.x != n9 || cTabItem.y != n4) {
                    bl = true;
                }
                cTabItem.x = n9;
                cTabItem.y = n4;
                int n14 = 0;
                if (i == this.selectedIndex) {
                    n14 |= 2;
                }
                Rectangle rectangle2 = this.renderer.computeTrim(i, n14, 0, 0, 0, 0);
                cTabItem.closeRect.x = cTabItem.x + cTabItem.width - (rectangle2.width + rectangle2.x) - point2.x;
                cTabItem.closeRect.y = this.onBottom ? point.y - n2 - this.tabHeight + (this.tabHeight - point2.y) / 2 : n3 + (this.tabHeight - point2.y) / 2;
                n9 += cTabItem.width;
                if (this.simple || i != this.selectedIndex) continue;
                n9 -= this.renderer.curveIndent;
            }
        }
        return bl;
    }

    boolean setItemSize(GC gC) {
        int[] nArray;
        int n;
        int n2;
        boolean bl = false;
        if (this.isDisposed()) {
            return bl;
        }
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return bl;
        }
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n3 = rectangle.width + rectangle.x;
        int n4 = -rectangle.x;
        this.showChevron = false;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem cTabItem = this.items[this.selectedIndex];
                int n5 = this.renderer.computeSize((int)this.selectedIndex, (int)2, (GC)gC, (int)-1, (int)-1).x;
                n5 = Math.min(n5, this.getRightItemEdge(gC) - n4);
                if (cTabItem.height != this.tabHeight || cTabItem.width != n5) {
                    bl = true;
                    cTabItem.shortenedText = null;
                    cTabItem.shortenedTextWidth = 0;
                    cTabItem.height = this.tabHeight;
                    cTabItem.width = n5;
                    cTabItem.closeRect.height = 0;
                    cTabItem.closeRect.width = 0;
                    if (this.showClose || cTabItem.showClose) {
                        Point point2 = this.renderer.computeSize(-8, 2, gC, -1, -1);
                        cTabItem.closeRect.width = point2.x;
                        cTabItem.closeRect.height = point2.y;
                    }
                }
            }
            return bl;
        }
        if (this.items.length == 0) {
            return bl;
        }
        int n6 = point.x - n4 - n3 - 3;
        if (this.showMin) {
            n6 -= this.renderer.computeSize((int)-6, (int)0, (GC)gC, (int)-1, (int)-1).x;
        }
        if (this.showMax) {
            n6 -= this.renderer.computeSize((int)-5, (int)0, (GC)gC, (int)-1, (int)-1).x;
        }
        if (this.topRightAlignment == 131072 && this.topRight != null) {
            Point point3 = this.topRight.computeSize(-1, -1, false);
            n6 -= point3.x + 3;
        }
        n6 = Math.max(0, n6);
        int n7 = 0;
        int[] nArray2 = new int[this.items.length];
        for (n2 = 0; n2 < this.priority.length; ++n2) {
            int n8 = this.priority[n2];
            n = 0x1000000;
            if (n8 == this.selectedIndex) {
                n |= 2;
            }
            nArray2[n8] = this.renderer.computeSize((int)n8, (int)n, (GC)gC, (int)-1, (int)-1).x;
            if ((n7 += nArray2[n8]) > n6) break;
        }
        if (n7 > n6) {
            boolean bl2 = this.showChevron = this.items.length > 1;
            if (this.showChevron) {
                n6 -= this.renderer.computeSize((int)-7, (int)0, (GC)gC, (int)-1, (int)-1).x;
            }
            nArray = nArray2;
            int n9 = n2 = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (n6 < nArray[n2]) {
                nArray[n2] = Math.max(0, n6);
            }
        } else {
            int n10;
            n2 = 0;
            int[] nArray3 = new int[this.items.length];
            for (n = 0; n < this.items.length; ++n) {
                n10 = 0;
                if (n == this.selectedIndex) {
                    n10 |= 2;
                }
                nArray3[n] = this.renderer.computeSize((int)n, (int)n10, (GC)gC, (int)-1, (int)-1).x;
                n2 += nArray3[n];
            }
            if (n2 <= n6) {
                nArray = nArray3;
            } else {
                n = (n6 - n7) / this.items.length;
                while (true) {
                    n10 = 0;
                    int n11 = 0;
                    for (int i = 0; i < this.items.length; ++i) {
                        if (nArray3[i] > nArray2[i] + n) {
                            n11 += nArray2[i] + n;
                            ++n10;
                            continue;
                        }
                        n11 += nArray3[i];
                    }
                    if (n11 >= n6) {
                        --n;
                        break;
                    }
                    if (n10 == 0 || n6 - n11 < n10) break;
                    ++n;
                }
                nArray = new int[this.items.length];
                for (n10 = 0; n10 < this.items.length; ++n10) {
                    nArray[n10] = Math.min(nArray3[n10], nArray2[n10] + n);
                }
            }
        }
        for (n2 = 0; n2 < this.items.length; ++n2) {
            CTabItem cTabItem = this.items[n2];
            n = nArray[n2];
            if (cTabItem.height == this.tabHeight && cTabItem.width == n) continue;
            bl = true;
            cTabItem.shortenedText = null;
            cTabItem.shortenedTextWidth = 0;
            cTabItem.height = this.tabHeight;
            cTabItem.width = n;
            cTabItem.closeRect.height = 0;
            cTabItem.closeRect.width = 0;
            if (!this.showClose && !cTabItem.showClose || n2 != this.selectedIndex && !this.showUnselectedClose) continue;
            Point point4 = this.renderer.computeSize(-8, 0, gC, -1, -1);
            cTabItem.closeRect.width = point4.x;
            cTabItem.closeRect.height = point4.y;
        }
        return bl;
    }

    public void setMaximizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMax == bl) {
            return;
        }
        this.showMax = bl;
        this.updateItems();
        this.redraw();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        if (this.maximized == bl) {
            return;
        }
        if (bl && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = bl;
        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
    }

    public void setMinimizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMin == bl) {
            return;
        }
        this.showMin = bl;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        if (bl && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = bl;
        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
    }

    public void setMinimumCharacters(int n) {
        this.checkWidget();
        if (n < 0) {
            SWT.error(6);
        }
        if (this.minChars == n) {
            return;
        }
        this.minChars = n;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setMRUVisible(boolean bl) {
        this.checkWidget();
        if (this.mru == bl) {
            return;
        }
        this.mru = bl;
        if (!this.mru) {
            int n = this.firstIndex;
            int n2 = 0;
            int n3 = this.firstIndex;
            while (n3 < this.items.length) {
                this.priority[n2++] = n3++;
            }
            n3 = 0;
            while (n3 < n) {
                this.priority[n2++] = n3++;
            }
            if (this.updateItems()) {
                this.redrawTabs();
            }
        }
    }

    public void setRenderer(CTabFolderRenderer cTabFolderRenderer) {
        this.checkWidget();
        if (this.renderer == cTabFolderRenderer) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        if (cTabFolderRenderer == null) {
            cTabFolderRenderer = new CTabFolderRenderer(this);
        }
        this.renderer = cTabFolderRenderer;
        this.updateTabHeight(false);
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    public void setSelection(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n = this.indexOf(cTabItem);
        this.setSelection(n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        CTabItem cTabItem = this.items[n];
        if (this.selectedIndex == n) {
            this.showItem(cTabItem);
            return;
        }
        int n2 = this.selectedIndex;
        this.selectedIndex = n;
        if (n2 != -1) {
            this.items[n2].closeImageState = 8;
            this.items[n2].state &= 0xFFFFFFFD;
        }
        cTabItem.closeImageState = 0;
        cTabItem.showing = false;
        cTabItem.state |= 2;
        Control control = cTabItem.control;
        Control control2 = null;
        if (n2 != -1) {
            control2 = this.items[n2].control;
        }
        if (control != control2) {
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (control2 != null && !control2.isDisposed()) {
                control2.setVisible(false);
            }
        }
        this.showItem(cTabItem);
        this.redraw();
    }

    void setSelection(int n, boolean bl) {
        int n2 = this.selectedIndex;
        this.setSelection(n);
        if (bl && this.selectedIndex != n2 && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (this.selectionBackground.equals(color)) {
            return;
        }
        this.setSelectionHighlightGradientColor(null);
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray) {
        this.setSelectionBackground(colorArray, nArray, false);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        int n2;
        this.checkWidget();
        Color color = null;
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1 && nArray.length != colorArray.length - 2) {
                SWT.error(5);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 <= 0 || nArray[n2] >= nArray[n2 - 1]) continue;
                SWT.error(5);
            }
            if (nArray.length == colorArray.length - 2) {
                color = colorArray[colorArray.length - 1];
                n = colorArray.length - 1;
            } else {
                n = colorArray.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[n - 1]};
                n = colorArray.length;
                nArray = new int[]{};
            }
        } else {
            n = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colorArray != null && this.selectionGradientColors.length == n) {
                int n3;
                n2 = 0;
                for (n3 = 0; n3 < this.selectionGradientColors.length && (n2 = this.selectionGradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.selectionGradientColors[n3].equals(colorArray[n3]) ? 1 : 0)) != 0; ++n3) {
                }
                if (n2 != 0) {
                    for (n3 = 0; n3 < this.selectionGradientPercents.length; ++n3) {
                        int n4 = n2 = this.selectionGradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                    }
                }
                if (n2 != 0 && this.selectionGradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colorArray == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.selectionGradientColors[n2] = colorArray[n2];
            }
            this.selectionGradientPercents = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.selectionGradientPercents[n2] = nArray[n2];
            }
            this.selectionGradientVertical = bl;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(color);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color color) {
        this.renderer.setSelectionHighlightGradientColor(color);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        if (image == this.selectionBgImage) {
            return;
        }
        this.setSelectionHighlightGradientColor(null);
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.renderer.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground.equals(color)) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSimple(boolean bl) {
        this.checkWidget();
        if (this.simple != bl) {
            this.simple = bl;
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean bl) {
        this.checkWidget();
        if (this.single != bl) {
            this.single = bl;
            if (!bl) {
                for (int i = 0; i < this.items.length; ++i) {
                    if (i == this.selectedIndex || this.items[i].closeImageState != 0) continue;
                    this.items[i].closeImageState = 8;
                }
            }
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTabHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = n;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (n == 1024)) {
            this.onBottom = n == 1024;
            this.updateTabHeight(true);
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int n) {
        this.checkWidget();
        if (n != 131072 && n != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        this.topRight = control;
        this.topRightAlignment = n;
        if (this.updateItems()) {
            this.redraw();
        }
    }

    public void setUnselectedCloseVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedClose == bl) {
            return;
        }
        this.showUnselectedClose = bl;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedImage == bl) {
            return;
        }
        this.showUnselectedImage = bl;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem cTabItem) {
        int n;
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        if (cTabItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n = this.indexOf(cTabItem)) == -1) {
            SWT.error(5);
        }
        int n2 = -1;
        for (int i = 0; i < this.priority.length; ++i) {
            if (this.priority[i] != n) continue;
            n2 = i;
            break;
        }
        if (this.mru) {
            int[] nArray = new int[this.priority.length];
            System.arraycopy(this.priority, 0, nArray, 1, n2);
            System.arraycopy(this.priority, n2 + 1, nArray, n2 + 1, this.priority.length - n2 - 1);
            nArray[0] = n;
            this.priority = nArray;
        }
        if (cTabItem.isShowing()) {
            return;
        }
        this.updateItems(n);
        this.redrawTabs();
    }

    void showList(Rectangle rectangle) {
        Object object;
        int n;
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this.getShell(), this.getStyle() & 0x6000000);
        } else {
            MenuItem[] menuItemArray = this.showMenu.getItems();
            for (n = 0; n < menuItemArray.length; ++n) {
                menuItemArray[n].dispose();
            }
        }
        for (n = 0; n < this.items.length; ++n) {
            CTabItem cTabItem = this.items[n];
            if (cTabItem.showing) continue;
            object = new MenuItem(this.showMenu, 0);
            ((MenuItem)object).setText(cTabItem.getText());
            ((MenuItem)object).setImage(cTabItem.getImage());
            ((Widget)object).setData("CTabFolder_showList_Index", cTabItem);
            ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    int n = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                    CTabFolder.this.setSelection(n, true);
                }
            });
        }
        n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        object = this.getDisplay().map(this, null, n, n2);
        this.showMenu.setLocation(((Point)object).x, ((Point)object).y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int n, int n2) {
        String string = this.getToolTipText();
        String string2 = this._getToolTip(n, n2);
        if (string2 == null || !string2.equals(string)) {
            this.setToolTipText(string2);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int n) {
        int n2;
        GC gC = new GC(this);
        if (!this.single && !this.mru && n != -1) {
            int n3;
            n2 = n;
            if (this.priority[0] < n) {
                int n4;
                int n5;
                Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
                n3 = -rectangle.x;
                int n6 = this.getRightItemEdge(gC) - n3;
                int n7 = 0;
                int[] nArray = new int[this.items.length];
                for (n5 = this.priority[0]; n5 <= n; ++n5) {
                    n4 = 0x1000000;
                    if (n5 == this.selectedIndex) {
                        n4 |= 2;
                    }
                    nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                    if ((n7 += nArray[n5]) > n6) break;
                }
                if (n7 > n6) {
                    n7 = 0;
                    n5 = n;
                    while (n5 >= 0) {
                        n4 = 0x1000000;
                        if (n5 == this.selectedIndex) {
                            n4 |= 2;
                        }
                        if (nArray[n5] == 0) {
                            nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                        }
                        if ((n7 += nArray[n5]) <= n6) {
                            n2 = n5--;
                            continue;
                        }
                        break;
                    }
                } else {
                    n2 = this.priority[0];
                    for (n5 = n + 1; n5 < this.items.length; ++n5) {
                        n4 = 0x1000000;
                        if (n5 == this.selectedIndex) {
                            n4 |= 2;
                        }
                        nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                        if ((n7 += nArray[n5]) >= n6) break;
                    }
                    if (n7 < n6) {
                        n5 = this.priority[0] - 1;
                        while (n5 >= 0) {
                            n4 = 0x1000000;
                            if (n5 == this.selectedIndex) {
                                n4 |= 2;
                            }
                            if (nArray[n5] == 0) {
                                nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                            }
                            if ((n7 += nArray[n5]) <= n6) {
                                n2 = n5--;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (n2 != this.priority[0]) {
                int n8 = 0;
                n3 = n2;
                while (n3 < this.items.length) {
                    this.priority[n8++] = n3++;
                }
                n3 = 0;
                while (n3 < n2) {
                    this.priority[n8++] = n3++;
                }
            }
        }
        n2 = this.showChevron;
        boolean bl = this.setItemSize(gC);
        bl |= this.setItemLocation(gC);
        this.setButtonBounds(gC);
        if ((bl |= this.showChevron != n2) && this.getToolTipText() != null) {
            Point point = this.getDisplay().getCursorLocation();
            point = this.toControl(point);
            this._setToolTipText(point.x, point.y);
        }
        gC.dispose();
        return bl;
    }

    boolean updateTabHeight(boolean bl) {
        int n = this.tabHeight;
        GC gC = new GC(this);
        this.tabHeight = this.renderer.computeSize((int)-2, (int)0, (GC)gC, (int)-1, (int)-1).y;
        gC.dispose();
        if (!bl && this.tabHeight == n) {
            return false;
        }
        this.oldSize = null;
        this.notifyListeners(11, new Event());
        return true;
    }

    String _getToolTip(int n, int n2) {
        if (this.showMin && this.minRect.contains(n, n2)) {
            return this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
        }
        if (this.showMax && this.maxRect.contains(n, n2)) {
            return this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
        }
        if (this.showChevron && this.chevronRect.contains(n, n2)) {
            return SWT.getMessage("SWT_ShowList");
        }
        CTabItem cTabItem = this.getItem(new Point(n, n2));
        if (cTabItem == null) {
            return null;
        }
        if (!cTabItem.showing) {
            return null;
        }
        if ((this.showClose || cTabItem.showClose) && cTabItem.closeRect.contains(n, n2)) {
            return SWT.getMessage("SWT_Close");
        }
        return cTabItem.getToolTipText();
    }
}

