/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Menu");
    long modelHandle;
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    ImageList imageList;
    int poppedUpCount;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super((Widget)decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget(0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    boolean ableToSetLocation() {
        if (!OS.isX11() && !this.getShell().getVisible()) {
            return false;
        }
        return this.hasLocation;
    }

    public void _setVisible(boolean bl) {
        if (Menu.logger.level >= 7) {
            Logger.Builder builder = logger.build("_setVisible(boolean)");
            (Menu.logger.level < 8 ? builder : builder.add("visible: ").add(bl).add(", mapped: ").add(GTK.gtk_widget_get_mapped((long)this.handle))).log(7);
        }
        if (bl == GTK.gtk_widget_get_mapped((long)this.handle)) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                if ((this.parent._getShell().style & 0x4000) != 0 && !GTK.GTK4) {
                    GTK.gtk_menu_shell_set_take_focus((long)this.handle, (boolean)false);
                }
                if (GTK.GTK_VERSION < OS.VERSION(3, 22, 0)) {
                    long l = 0L;
                    long l2 = 0L;
                    if (this.hasLocation) {
                        l2 = this.y << 16 | this.x;
                        if (Menu.logger.level >= 9) {
                            logger.build("_setVisible(boolean)").add("data: ").add(l2).log(9);
                        }
                    }
                    this.hasLocation = false;
                    TrayItem trayItem = this.display.currentTrayItem;
                    if (trayItem != null && !trayItem.isDisposed()) {
                        l2 = trayItem.handle;
                        l = GTK.gtk_status_icon_position_menu_func();
                    } else {
                        l = OS._gtk_my_menu_position_func();
                    }
                    if (Menu.logger.level >= 9) {
                        logger.log(9, "_setVisible(boolean)", "Calling gtk_menu_popup with address " + l + " and time " + this.display.getLastEventTime());
                    }
                    GTK.gtk_menu_popup((long)this.handle, (long)0L, (long)0L, (long)l, (long)l2, (int)0, (int)this.display.getLastEventTime());
                    boolean bl2 = GTK.gtk_widget_get_mapped((long)this.handle);
                    if (Menu.logger.level >= 9) {
                        logger.build("_setVisible(boolean)").add("mapped: ").add(bl2).log(9);
                    }
                    if (!bl2 && "true".equals(System.getProperty("qftest.swt.testing"))) {
                        if (Menu.logger.level >= 5) {
                            logger.log(5, "_setVisible(boolean)", "Failed to map menu. Fake grab and try again.");
                        }
                        GTK.gtk_menu_popup_fake_xgrab((long)this.handle);
                        GTK.gtk_menu_popup((long)this.handle, (long)0L, (long)0L, (long)l, (long)l2, (int)0, (int)this.display.getLastEventTime());
                        bl2 = GTK.gtk_widget_get_mapped((long)this.handle);
                        if (Menu.logger.level >= 9) {
                            logger.build("_setVisible(boolean)").add("mapped after fake and retry: ").add(bl2).log(9);
                        }
                    }
                } else {
                    long l = 0L;
                    if (this.ableToSetLocation()) {
                        l = GDK.gdk_event_new((int)(GTK.GTK4 ? 5 : 4));
                        GdkEventButton gdkEventButton = new GdkEventButton();
                        gdkEventButton.type = GTK.GTK4 ? 5 : 4;
                        gdkEventButton.device = GDK.gdk_get_pointer((long)GDK.gdk_display_get_default());
                        gdkEventButton.time = this.display.getLastEventTime();
                        GdkRectangle gdkRectangle = new GdkRectangle();
                        if (OS.isX11()) {
                            gdkEventButton.window = GDK.gdk_display_get_default_group((long)GDK.gdk_display_get_default());
                            OS.g_object_ref(gdkEventButton.window);
                            OS.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                            int[] nArray = new int[1];
                            int[] nArray2 = new int[1];
                            if (GTK.GTK4) {
                                GDK.gdk_surface_get_origin((long)gdkEventButton.window, (int[])nArray2, (int[])nArray);
                            } else {
                                GDK.gdk_window_get_origin((long)gdkEventButton.window, (int[])nArray2, (int[])nArray);
                            }
                            gdkRectangle.x = this.x - nArray2[0];
                            gdkRectangle.y = this.y - nArray[0];
                        } else {
                            long l3;
                            if (GTK.GTK4) {
                                long l4 = GTK.gtk_native_get_surface((long)GTK.gtk_widget_get_native((long)this.getShell().topHandle()));
                                l3 = GTK.gtk_native_get_surface((long)l4);
                            } else {
                                l3 = GTK.gtk_widget_get_window((long)this.getShell().topHandle());
                            }
                            gdkEventButton.window = OS.g_object_ref(l3);
                            OS.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                            gdkRectangle.x = this.x + 1;
                            gdkRectangle.y = this.y + 1;
                        }
                        GTK.gtk_menu_popup_at_rect((long)this.handle, (long)gdkEventButton.window, (GdkRectangle)gdkRectangle, (int)1, (int)1, (long)l);
                        this.gdk_event_free(l);
                    } else {
                        l = GTK.gtk_get_current_event();
                        if (l == 0L) {
                            l = GDK.gdk_event_new((int)(GTK.GTK4 ? 5 : 4));
                            GdkEventButton gdkEventButton = new GdkEventButton();
                            int n = gdkEventButton.type = GTK.GTK4 ? 5 : 4;
                            if (OS.isX11()) {
                                gdkEventButton.window = OS.g_object_ref(GTK.gtk_widget_get_window((long)this.getShell().handle));
                            }
                            gdkEventButton.device = GDK.gdk_get_pointer((long)GDK.gdk_display_get_default());
                            gdkEventButton.time = this.display.getLastEventTime();
                            OS.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                        }
                        this.adjustParentWindowWayland(l);
                        this.verifyMenuPosition(this.getItemCount());
                        GTK.gtk_menu_popup_at_pointer((long)this.handle, (long)l);
                        if (GTK.GTK4) {
                            GDK.gdk_event_unref((long)l);
                        } else {
                            GDK.gdk_event_free((long)l);
                        }
                    }
                }
                this.poppedUpCount = this.getItemCount();
            } else {
                this.sendEvent(23);
            }
        } else if (GTK.GTK4) {
            GTK.gtk_popover_popdown((long)this.handle);
        } else {
            GTK.gtk_menu_popdown((long)this.handle);
        }
    }

    void addAccelerators(long l) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.addAccelerators(l);
        }
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)menuListener);
        this.addListener(23, (Listener)typedListener);
        this.addListener(22, (Listener)typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)helpListener);
        this.addListener(28, (Listener)typedListener);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if (GTK.GTK4) {
            this.modelHandle = OS.g_menu_new();
        }
        if ((this.style & 2) != 0) {
            this.handle = GTK.GTK4 ? GTK.gtk_popover_menu_bar_new_from_model((long)this.modelHandle) : GTK.gtk_menu_bar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l = this.parent.vboxHandle;
            GTK.gtk_container_add((long)l, (long)this.handle);
            this.gtk_box_set_child_packing(l, this.handle, false, true, 0, 0);
        } else {
            this.handle = GTK.GTK4 ? GTK.gtk_popover_menu_new_from_model((long)this.modelHandle) : GTK.gtk_menu_new();
            if (this.handle == 0L) {
                this.error(2);
            }
        }
    }

    @Override
    void createWidget(int n) {
        this.checkOrientation((Widget)this.parent);
        super.createWidget(n);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations decorations) {
        if (this.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].fixMenus(decorations);
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    public Rectangle getBounds() {
        long l;
        this.checkWidget();
        if (!GTK.gtk_widget_get_mapped((long)this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            l = this.gtk_widget_get_surface(this.handle);
            GDK.gdk_surface_get_origin((long)l, (int[])nArray, (int[])nArray2);
        } else {
            l = this.gtk_widget_get_window(this.handle);
            GDK.gdk_window_get_origin((long)l, (int[])nArray, (int[])nArray2);
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation((long)this.handle, (GtkAllocation)gtkAllocation);
        int n = nArray[0] + gtkAllocation.x;
        int n2 = nArray2[0] + gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        return new Rectangle(n, n2, n3, n4);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return GTK.gtk_widget_get_sensitive((long)this.handle);
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        long l = GTK.gtk_container_get_children((long)this.handle);
        if (l == 0L) {
            this.error(8);
        }
        int n2 = OS.g_list_length(l);
        if (0 > n || n >= n2) {
            this.error(6);
        }
        long l2 = OS.g_list_nth_data(l, n);
        OS.g_list_free(l);
        if (l2 == 0L) {
            this.error(8);
        }
        return (MenuItem)((Object)this.display.getWidget(l2));
    }

    public int getItemCount() {
        this.checkWidget();
        long l = GTK.gtk_container_get_children((long)this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        return Math.max(0, n);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        long l = GTK.gtk_container_get_children((long)this.handle);
        if (l == 0L) {
            return new MenuItem[0];
        }
        long l2 = l;
        int n = OS.g_list_length(l);
        MenuItem[] menuItemArray = new MenuItem[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l3 = OS.g_list_data(l);
            MenuItem menuItem = (MenuItem)((Object)this.display.getWidget(l3));
            if (menuItem != null) {
                menuItemArray[n2++] = menuItem;
            }
            l = OS.g_list_next(l);
        }
        OS.g_list_free(l2);
        if (n2 != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n2];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n2);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    @Override
    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                string = string + (menuItemArray[i] == null ? "null" : menuItemArray[i].getNameText()) + ", ";
            }
            string = string + (menuItemArray[n - 1] == null ? "null" : menuItemArray[n - 1].getNameText());
        }
        return string;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 8) != 0 && (menuArray = this.display.popups) != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != this) continue;
                return true;
            }
        }
        return GTK.gtk_widget_get_mapped((long)this.handle);
    }

    @Override
    long gtk_hide(long l) {
        if ((this.style & 8) != 0 && this.display.activeShell != null) {
            this.display.activeShell = this.getShell();
            if (this.display.activeShell.ignoreFocusOut) {
                this.display.activeShell.ignoreFocusIn = true;
            }
            this.display.activeShell.ignoreFocusOut = false;
        }
        this.sendEvent(23);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(false)) continue;
            }
        }
        return 0L;
    }

    @Override
    long gtk_show(long l) {
        if ((this.style & 8) != 0) {
            if (this.display.activeShell != null) {
                this.display.activeShell = this.getShell();
                this.display.activeShell.ignoreFocusOut = true;
            }
            return 0L;
        }
        this.sendEvent(22);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(true)) continue;
            }
        }
        return 0L;
    }

    @Override
    long gtk_show_help(long l, long l2) {
        if (this.sendHelpEvent(l2)) {
            GTK.gtk_menu_shell_deactivate((long)this.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_menu_popped_up(long l, long l2, long l3, long l4, long l5) {
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.memmove(gdkRectangle, l3, (long)GDK.GdkRectangle_sizeof());
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.memmove(gdkRectangle2, l2, (long)GDK.GdkRectangle_sizeof());
        boolean bl = l4 == 1L;
        boolean bl2 = l5 == 1L;
        System.out.println("SWT_MENU_LOCATION_DEBUGGING enabled, printing positioning info for " + l);
        if (!OS.isX11()) {
            System.out.println("Note: SWT is running on Wayland, coordinates will be parent-relative");
        }
        if (this.hasLocation) {
            System.out.println("hasLocation is true and set coordinates are Point {" + this.x + ", " + this.y + "}");
        } else {
            System.out.println("hasLocation is not set, this is most likely a right click menu");
        }
        if (bl) {
            System.out.println("Menu is inverted along the X-axis");
        }
        if (bl2) {
            System.out.println("Menu is inverted along the Y-axis");
        }
        System.out.println("Final menu position and size is Rectangle {" + gdkRectangle.x + ", " + gdkRectangle.y + ", " + gdkRectangle.width + ", " + gdkRectangle.height + "}");
        System.out.println("Flipped menu position and size is Rectangle {" + gdkRectangle2.x + ", " + gdkRectangle2.y + ", " + gdkRectangle2.width + ", " + gdkRectangle2.height + "}");
        System.out.println("");
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0) && OS.SWT_MENU_LOCATION_DEBUGGING) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[85], 0, this.display.getClosure(85), false);
        }
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] != menuItem) continue;
            return i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            if (menuItem == null || menuItem.isDisposed()) continue;
            menuItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, (SWTEventListener)menuListener);
        this.eventTable.unhook(22, (SWTEventListener)menuListener);
    }

    void removeAccelerators(long l) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.removeAccelerators(l);
        }
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, (SWTEventListener)helpListener);
    }

    @Override
    void reskinChildren(int n) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.reskin(n);
        }
        super.reskinChildren(n);
    }

    boolean sendHelpEvent(long l) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(l);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        GTK.gtk_widget_set_sensitive((long)this.handle, (boolean)bl);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setLocation(new Point(n, n2));
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(point));
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocationInPixels(point.x, point.y);
    }

    public void setOrientation(int n) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(n);
    }

    void _setOrientation(int n) {
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        this.setOrientation(false);
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction((long)this.handle, (int)n);
            }
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                menuItemArray[i].setOrientation(bl);
            }
        }
    }

    void adjustParentWindowWayland(long l) {
        if (!OS.isX11()) {
            long l2 = GDK.gdk_display_get_default();
            long l3 = GDK.gdk_get_pointer((long)l2);
            long l4 = GTK.GTK4 ? GDK.gdk_device_get_surface_at_position((long)l3, null, null) : GDK.gdk_device_get_window_at_position((long)l3, null, null);
            OS.g_object_ref(l4);
            int n = GDK.gdk_event_get_event_type((long)l);
            n = Control.fixGdkEventTypeValues(n);
            switch (n) {
                case 4: {
                    GdkEventButton gdkEventButton = new GdkEventButton();
                    OS.memmove(gdkEventButton, l, (long)GdkEventButton.sizeof);
                    gdkEventButton.window = l4;
                    OS.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                    break;
                }
                case 8: {
                    GdkEventKey gdkEventKey = new GdkEventKey();
                    OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
                    gdkEventKey.window = l4;
                    OS.memmove(l, gdkEventKey, (long)GdkEventKey.sizeof);
                }
            }
        }
    }

    void verifyMenuPosition(int n) {
        if (OS.isX11() && n != this.poppedUpCount && this.poppedUpCount != 0) {
            int[] nArray = new int[1];
            GTK.gtk_widget_show((long)this.handle);
            GTK.gtk_widget_get_preferred_height((long)this.handle, null, (int[])nArray);
            if (nArray[0] > 0 && !GTK.GTK4) {
                long l = GTK.gtk_widget_get_toplevel((long)this.handle);
                long l2 = GTK.gtk_widget_get_window((long)l);
                int n2 = GDK.gdk_window_get_width((long)l2);
                GDK.gdk_window_resize((long)l2, (int)n2, (int)nArray[0]);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (Menu.logger.level >= 7) {
            Logger.Builder builder = logger.build("setVisible(boolean)");
            (Menu.logger.level < 8 ? builder : builder.add("visible: ").add(bl)).log(7);
        }
        if (Menu.logger.level >= 9) {
            logger.dumpStack(9, "setVisible(boolean)", "");
        }
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

