/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.cpsuite;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.extensions.cpsuite.ClassesFinder;
import org.junit.extensions.cpsuite.ClassesFinderFactory;
import org.junit.extensions.cpsuite.ClasspathFinderFactory;
import org.junit.extensions.cpsuite.SuiteType;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class ClasspathSuite
extends Suite {
    private static final boolean DEFAULT_INCLUDE_JARS = false;
    private static final SuiteType[] DEFAULT_SUITE_TYPES = new SuiteType[]{SuiteType.TEST_CLASSES};
    private static final Class<?>[] DEFAULT_BASE_TYPES = new Class[]{Object.class};
    private static final Class<?>[] DEFAULT_EXCLUDED_BASES_TYPES = new Class[0];
    private static final String[] DEFAULT_CLASSNAME_FILTERS = new String[0];
    private static final String DEFAULT_CLASSPATH_PROPERTY = "java.class.path";
    private final Class<?> suiteClass;

    public ClasspathSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        this(suiteClass, builder, new ClasspathFinderFactory());
    }

    public ClasspathSuite(Class<?> suiteClass, RunnerBuilder builder, ClassesFinderFactory factory) throws InitializationError {
        super(builder, suiteClass, (Class[])ClasspathSuite.getSortedTestclasses(ClasspathSuite.createFinder(suiteClass, factory)));
        this.suiteClass = suiteClass;
    }

    private static ClassesFinder createFinder(Class<?> suiteClass, ClassesFinderFactory finderFactory) {
        return finderFactory.create(ClasspathSuite.getSearchInJars(suiteClass), ClasspathSuite.getClassnameFilters(suiteClass), ClasspathSuite.getSuiteTypes(suiteClass), ClasspathSuite.getBaseTypes(suiteClass), ClasspathSuite.getExcludedBaseTypes(suiteClass), ClasspathSuite.getClasspathProperty(suiteClass));
    }

    private static Class<?>[] getSortedTestclasses(ClassesFinder finder) {
        List<Class<?>> testclasses = finder.find();
        Collections.sort(testclasses, ClasspathSuite.getClassComparator());
        return testclasses.toArray(new Class[testclasses.size()]);
    }

    private static Comparator<Class<?>> getClassComparator() {
        return new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }

    private static String[] getClassnameFilters(Class<?> suiteClass) {
        ClassnameFilters filtersAnnotation = suiteClass.getAnnotation(ClassnameFilters.class);
        if (filtersAnnotation == null) {
            return DEFAULT_CLASSNAME_FILTERS;
        }
        return filtersAnnotation.value();
    }

    private static boolean getSearchInJars(Class<?> suiteClass) {
        IncludeJars includeJarsAnnotation = suiteClass.getAnnotation(IncludeJars.class);
        if (includeJarsAnnotation == null) {
            return false;
        }
        return includeJarsAnnotation.value();
    }

    private static SuiteType[] getSuiteTypes(Class<?> suiteClass) {
        SuiteTypes suiteTypesAnnotation = suiteClass.getAnnotation(SuiteTypes.class);
        if (suiteTypesAnnotation == null) {
            return DEFAULT_SUITE_TYPES;
        }
        return suiteTypesAnnotation.value();
    }

    private static Class<?>[] getBaseTypes(Class<?> suiteClass) {
        BaseTypeFilter baseTypeAnnotation = suiteClass.getAnnotation(BaseTypeFilter.class);
        if (baseTypeAnnotation == null) {
            return DEFAULT_BASE_TYPES;
        }
        return baseTypeAnnotation.value();
    }

    private static Class<?>[] getExcludedBaseTypes(Class<?> suiteClass) {
        ExcludeBaseTypeFilter excludeBaseTypeAnnotation = suiteClass.getAnnotation(ExcludeBaseTypeFilter.class);
        if (excludeBaseTypeAnnotation == null) {
            return DEFAULT_EXCLUDED_BASES_TYPES;
        }
        return excludeBaseTypeAnnotation.value();
    }

    private static String getClasspathProperty(Class<?> suiteClass) {
        ClasspathProperty cpPropertyAnnotation = suiteClass.getAnnotation(ClasspathProperty.class);
        if (cpPropertyAnnotation == null) {
            return DEFAULT_CLASSPATH_PROPERTY;
        }
        return cpPropertyAnnotation.value();
    }

    public void run(RunNotifier notifier) {
        try {
            this.runBeforeMethods();
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            return;
        }
        super.run(notifier);
    }

    private void runBeforeMethods() throws Exception {
        for (Method each : this.suiteClass.getMethods()) {
            if (!each.isAnnotationPresent(BeforeSuite.class) || !this.isPublicStaticVoid(each)) continue;
            each.invoke(null, new Object[0]);
        }
    }

    private boolean isPublicStaticVoid(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && (method.getModifiers() & 8) != 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BeforeSuite {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ClasspathProperty {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ExcludeBaseTypeFilter {
        public Class<?>[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface BaseTypeFilter {
        public Class<?>[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuiteTypes {
        public SuiteType[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface IncludeJars {
        public boolean value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ClassnameFilters {
        public String[] value();
    }
}

