/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.cpsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JavaStyleClassnameMatcher {
    private static final Pattern WILDCARDS = Pattern.compile("\\*{1,2}");
    private final Pattern pattern;

    JavaStyleClassnameMatcher(String pattern) {
        StringBuilder rx = new StringBuilder();
        rx.append("^");
        for (String part : JavaStyleClassnameMatcher.splitIncludingSeparator(pattern)) {
            if (part.equals("**")) {
                rx.append(".*");
                continue;
            }
            if (part.equals("*")) {
                rx.append("[^\\.]*");
                continue;
            }
            rx.append(Pattern.quote(part));
        }
        rx.append("$");
        this.pattern = Pattern.compile(rx.toString());
    }

    private static Collection<String> splitIncludingSeparator(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = WILDCARDS.matcher(input);
        int start = 0;
        while (matcher.find()) {
            if (matcher.start() > start) {
                result.add(input.substring(start, matcher.start()));
            }
            result.add(matcher.group());
            start = matcher.end() + 1;
        }
        if (start < input.length()) {
            result.add(input.substring(start));
        }
        return result;
    }

    boolean matches(String classname) {
        return this.pattern.matcher(classname).matches();
    }
}

