/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        boolean bl;
        long l;
        Display display;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l2 = OS.gtk_color_selection_dialog_new(byArray);
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if (this.parent != null) {
            l = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l2, l);
            long l3 = OS.gtk_window_get_icon_list(l);
            if (l3 != 0L) {
                OS.gtk_window_set_icon_list(l2, l3);
                OS.g_list_free(l3);
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            l = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(l, l2);
        }
        OS.gtk_window_set_modal(l2, true);
        GtkColorSelectionDialog gtkColorSelectionDialog = new GtkColorSelectionDialog();
        OS.memmove(gtkColorSelectionDialog, l2);
        GdkColor gdkColor = new GdkColor();
        if (this.rgb != null) {
            gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
        }
        OS.gtk_color_selection_set_has_palette(gtkColorSelectionDialog.colorsel, true);
        display.runDialogShownHooks(this, l2);
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l2)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l4 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l4 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l2, 0L);
        }
        int n2 = OS.gtk_dialog_run(l2);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l4);
        }
        if (OS.gtk_window_get_modal(l2)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            OS.gtk_color_selection_get_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
            int n3 = gdkColor.red >> 8 & 0xFF;
            int n4 = gdkColor.green >> 8 & 0xFF;
            int n5 = gdkColor.blue >> 8 & 0xFF;
            this.rgb = new RGB(n3, n4, n5);
        }
        this.rgb = (RGB)display.runDialogClosedHooks(this, bl ? this.rgb : null);
        if (this.rgb != null) {
            bl = true;
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l2);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

