/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static final AutoScaleMethod AUTO_SCALE_METHOD_SETTING;
    private static AutoScaleMethod autoScaleMethod;
    private static String autoScaleValue;
    private static final boolean USE_CAIRO_AUTOSCALE;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";
    private static final String SWT_AUTOSCALE_UPDATE_ON_RUNTIME = "swt.autoScale.updateOnRuntime";

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = 1.0f / DPIUtil.getScalingFactor(deviceZoom);
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static int[] autoScaleDown(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor(deviceZoom);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] / f);
        }
        return nArray2;
    }

    public static int[] autoScaleDown(Drawable drawable, int[] nArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return nArray;
        }
        return DPIUtil.autoScaleDown(nArray);
    }

    public static float[] autoScaleDown(float[] fArray) {
        return DPIUtil.scaleDown(fArray, deviceZoom);
    }

    public static float[] scaleDown(float[] fArray, int n) {
        if (n == 100 || fArray == null) {
            return fArray;
        }
        float f = DPIUtil.getScalingFactor(n);
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = fArray[i] / f;
        }
        return fArray2;
    }

    public static float[] autoScaleDown(Drawable drawable, float[] fArray) {
        return DPIUtil.scaleDown(drawable, fArray, deviceZoom);
    }

    public static float[] scaleDown(Drawable drawable, float[] fArray, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return fArray;
        }
        return DPIUtil.scaleDown(fArray, n);
    }

    public static int autoScaleDown(int n) {
        return DPIUtil.scaleDown(n, deviceZoom);
    }

    public static int scaleDown(int n, int n2) {
        if (n2 == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor(n2);
        return Math.round((float)n / f);
    }

    public static int autoScaleDown(Drawable drawable, int n) {
        return DPIUtil.scaleDown(drawable, n, deviceZoom);
    }

    public static int scaleDown(Drawable drawable, int n, int n2) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return n;
        }
        return DPIUtil.scaleDown(n, n2);
    }

    public static float autoScaleDown(float f) {
        return DPIUtil.scaleDown(f, deviceZoom);
    }

    public static float scaleDown(float f, int n) {
        if (n == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor(n);
        return f / f2;
    }

    public static float autoScaleDown(Drawable drawable, float f) {
        return DPIUtil.scaleDown(drawable, f, deviceZoom);
    }

    public static float scaleDown(Drawable drawable, float f, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return f;
        }
        return DPIUtil.scaleDown(f, n);
    }

    public static Point autoScaleDown(Point point) {
        return DPIUtil.scaleDown(point, deviceZoom);
    }

    public static Point scaleDown(Point point, int n) {
        if (n == 100 || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor(n);
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x / f);
        point2.y = Math.round((float)point.y / f);
        return point2;
    }

    public static Point autoScaleDown(Drawable drawable, Point point) {
        return DPIUtil.scaleDown(drawable, point, deviceZoom);
    }

    public static Point scaleDown(Drawable drawable, Point point, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.scaleDown(point, n);
    }

    public static Rectangle autoScaleDown(Rectangle rectangle) {
        return DPIUtil.scaleDown(rectangle, deviceZoom);
    }

    public static Rectangle scaleDown(Rectangle rectangle, int n) {
        if (n == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.scaleDown(new Point(rectangle.x, rectangle.y), n);
        Point point2 = DPIUtil.scaleDown(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), n);
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Rectangle autoScaleDown(Drawable drawable, Rectangle rectangle) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.scaleDown(rectangle, deviceZoom);
    }

    public static Rectangle scaleDown(Drawable drawable, Rectangle rectangle, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.scaleDown(rectangle, n);
    }

    public static ImageData scaleImageData(Device device, ImageData imageData, int n, int n2) {
        if (imageData == null || n == n2 || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = (float)n / (float)n2;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static ImageData scaleImageData(Device device, ElementAtZoom<ImageData> elementAtZoom, int n) {
        return DPIUtil.scaleImageData(device, elementAtZoom.element(), n, elementAtZoom.zoom());
    }

    private static ImageData autoScaleImageData(Device device, ImageData imageData, final float f) {
        boolean bl;
        final int n2 = imageData.width;
        final int n3 = imageData.height;
        int n4 = Math.round((float)n2 * f);
        int n5 = Math.round((float)n3 * f);
        boolean bl2 = bl = DPIUtil.isSmoothScalingEnabled() && imageData.getTransparencyType() != 2;
        if (bl) {
            final Image image = new Image(device, n -> imageData);
            ImageGcDrawer imageGcDrawer = new ImageGcDrawer(){

                public void drawOn(GC gC, int n, int n22) {
                    gC.setAntialias(1);
                    Image.drawScaled(gC, image, n2, n3, f);
                }

                public int getGcStyle() {
                    return 0x40000000;
                }
            };
            Image image2 = new Image(device, imageGcDrawer, n4, n5);
            ImageData imageData2 = image2.getImageData(100);
            image.dispose();
            image2.dispose();
            return imageData2;
        }
        return imageData.scaledTo(n4, n5);
    }

    public static boolean isSmoothScalingEnabled() {
        return autoScaleMethod == AutoScaleMethod.SMOOTH;
    }

    public static Rectangle scaleBounds(Rectangle rectangle, int n, int n2) {
        if (rectangle == null || n == n2) {
            return rectangle;
        }
        float f = (float)n / (float)n2;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x * f);
        rectangle2.y = Math.round((float)rectangle.y * f);
        rectangle2.width = Math.round((float)rectangle.width * f);
        rectangle2.height = Math.round((float)rectangle.height * f);
        return rectangle2;
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n) {
        if (deviceZoom == n || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = (float)deviceZoom / (float)n;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        return DPIUtil.autoScaleImageData(device, imageData, 100);
    }

    public static int[] autoScaleUp(int[] nArray) {
        return DPIUtil.scaleUp(nArray, deviceZoom);
    }

    public static int[] scaleUp(int[] nArray, int n) {
        if (n == 100 || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor(n);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] * f);
        }
        return nArray2;
    }

    public static int[] autoScaleUp(Drawable drawable, int[] nArray) {
        return DPIUtil.scaleUp(drawable, nArray, deviceZoom);
    }

    public static int[] scaleUp(Drawable drawable, int[] nArray, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return nArray;
        }
        return DPIUtil.scaleUp(nArray, n);
    }

    public static int autoScaleUp(int n) {
        return DPIUtil.scaleUp(n, deviceZoom);
    }

    public static int scaleUp(int n, int n2) {
        if (n2 == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor(n2);
        return Math.round((float)n * f);
    }

    public static int autoScaleUp(Drawable drawable, int n) {
        return DPIUtil.scaleUp(drawable, n, deviceZoom);
    }

    public static int scaleUp(Drawable drawable, int n, int n2) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return n;
        }
        return DPIUtil.scaleUp(n, n2);
    }

    public static float autoScaleUp(float f) {
        return DPIUtil.scaleUp(f, deviceZoom);
    }

    public static float scaleUp(float f, int n) {
        if (n == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor(n);
        return f * f2;
    }

    public static float autoScaleUp(Drawable drawable, float f) {
        return DPIUtil.scaleUp(drawable, f, deviceZoom);
    }

    public static float scaleUp(Drawable drawable, float f, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return f;
        }
        return DPIUtil.scaleUp(f, n);
    }

    public static Point autoScaleUp(Point point) {
        return DPIUtil.scaleUp(point, deviceZoom);
    }

    public static Point scaleUp(Point point, int n) {
        if (n == 100 || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor(n);
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x * f);
        point2.y = Math.round((float)point.y * f);
        return point2;
    }

    public static Point autoScaleUp(Drawable drawable, Point point) {
        return DPIUtil.scaleUp(drawable, point, deviceZoom);
    }

    public static Point scaleUp(Drawable drawable, Point point, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.scaleUp(point, n);
    }

    public static Rectangle autoScaleUp(Rectangle rectangle) {
        return DPIUtil.scaleUp(rectangle, deviceZoom);
    }

    public static Rectangle scaleUp(Rectangle rectangle, int n) {
        if (n == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.scaleUp(new Point(rectangle.x, rectangle.y), n);
        Point point2 = DPIUtil.scaleUp(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), n);
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Rectangle autoScaleUp(Drawable drawable, Rectangle rectangle) {
        return DPIUtil.scaleUp(drawable, rectangle, deviceZoom);
    }

    public static Rectangle scaleUp(Drawable drawable, Rectangle rectangle, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.scaleUp(rectangle, n);
    }

    private static float getScalingFactor(int n) {
        if (USE_CAIRO_AUTOSCALE) {
            return 1.0f;
        }
        if (n <= 0) {
            n = deviceZoom;
        }
        return (float)n / 100.0f;
    }

    public static int mapDPIToZoom(int n) {
        double d = (double)n * 100.0 / 96.0;
        int n2 = (int)Math.round(d);
        return n2;
    }

    public static int mapZoomToDPI(int n) {
        double d = (double)n / 100.0 * 96.0;
        int n2 = (int)Math.round(d);
        return n2;
    }

    public static ElementAtZoom<ImageData> validateAndGetImageDataAtZoom(ImageDataProvider imageDataProvider, int n2) {
        ElementAtZoom<ImageData> elementAtZoom;
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        if ((elementAtZoom = DPIUtil.getElementAtZoom(n -> imageDataProvider.getImageData(n.intValue()), n2)) == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(imageDataProvider) + "] returns null ImageData at 100% zoom.");
        }
        return elementAtZoom;
    }

    public static ElementAtZoom<String> validateAndGetImagePathAtZoom(ImageFileNameProvider imageFileNameProvider, int n2) {
        ElementAtZoom<String> elementAtZoom;
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        if ((elementAtZoom = DPIUtil.getElementAtZoom(n -> imageFileNameProvider.getImagePath(n.intValue()), n2)) == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(imageFileNameProvider) + "] returns null filename at 100% zoom.");
        }
        return elementAtZoom;
    }

    private static <T> ElementAtZoom<T> getElementAtZoom(Function<Integer, T> function, int n) {
        T t;
        T t2 = function.apply(n);
        if (t2 != null) {
            return new ElementAtZoom<T>(t2, n);
        }
        if (n > 100 && n <= 150 && (t = function.apply(150)) != null) {
            return new ElementAtZoom<T>(t, 150);
        }
        if (n > 100 && (t = function.apply(200)) != null) {
            return new ElementAtZoom<T>(t, 200);
        }
        if (n != 100 && (t = function.apply(100)) != null) {
            return new ElementAtZoom<T>(t, 100);
        }
        return null;
    }

    public static int getNativeDeviceZoom() {
        return nativeDeviceZoom;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int n) {
        boolean bl;
        int n2;
        nativeDeviceZoom = n;
        deviceZoom = n2 = DPIUtil.getZoomForAutoscaleProperty(n);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(n2));
        boolean bl2 = bl = SWT.getPlatform().equals("gtk") && n2 == 100;
        if (!bl && AUTO_SCALE_METHOD_SETTING == AutoScaleMethod.AUTO) {
            autoScaleMethod = DPIUtil.sholdUseSmoothScaling() ? AutoScaleMethod.SMOOTH : AutoScaleMethod.NEAREST;
        }
    }

    private static boolean sholdUseSmoothScaling() {
        return switch (SWT.getPlatform()) {
            case "gtk" -> {
                if (deviceZoom / 100 * 100 != deviceZoom) {
                    yield true;
                }
                yield false;
            }
            case "win32" -> DPIUtil.isMonitorSpecificScalingActive();
            default -> false;
        };
    }

    public static int getZoomForAutoscaleProperty(int n) {
        return DPIUtil.getZoomForAutoscaleProperty(n, autoScaleValue);
    }

    private static int getZoomForAutoscaleProperty(int n, String string) {
        int n2 = 0;
        if (string != null) {
            if ("false".equalsIgnoreCase(string)) {
                n2 = 100;
            } else if ("half".equalsIgnoreCase(string)) {
                n2 = (int)Math.rint((double)n / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(string)) {
                n2 = Math.round((float)n / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(string)) {
                n2 = n;
            } else {
                try {
                    int n3 = Integer.parseInt(string);
                    n2 = Math.max(Math.min(n3, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n2 == 0) {
            n2 = Math.max((n + 25) / 100 * 100, 100);
        }
        return n2;
    }

    public static void runWithAutoScaleValue(String string, Runnable runnable) {
        String string2 = autoScaleValue;
        autoScaleValue = string;
        deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        try {
            runnable.run();
        }
        finally {
            autoScaleValue = string2;
            deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        }
    }

    public static void setMonitorSpecificScaling(boolean bl) {
        System.setProperty(SWT_AUTOSCALE_UPDATE_ON_RUNTIME, Boolean.toString(bl));
    }

    public static boolean isMonitorSpecificScalingActive() {
        boolean bl = Boolean.getBoolean(SWT_AUTOSCALE_UPDATE_ON_RUNTIME);
        return bl;
    }

    public static void setAutoScaleForMonitorSpecificScaling() {
        boolean bl;
        boolean bl2 = bl = autoScaleValue == null;
        if (bl) {
            autoScaleValue = "quarter";
        } else if (!DPIUtil.isSupportedAutoScaleForMonitorSpecificScaling()) {
            throw new SWTError(20, "monitor-specific scaling is only implemented for auto-scale values \"quarter\", \"exact\", \"false\" or a concrete zoom value, but \"" + autoScaleValue + "\" has been specified");
        }
    }

    private static boolean isSupportedAutoScaleForMonitorSpecificScaling() {
        if (autoScaleValue == null) {
            return false;
        }
        switch (autoScaleValue.toLowerCase()) {
            case "false": 
            case "quarter": 
            case "exact": {
                return true;
            }
        }
        try {
            Integer.parseInt(autoScaleValue);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static {
        USE_CAIRO_AUTOSCALE = SWT.getPlatform().equals("gtk");
        autoScaleValue = System.getProperty(SWT_AUTOSCALE, "false");
        String string = System.getProperty(SWT_AUTOSCALE_METHOD);
        AUTO_SCALE_METHOD_SETTING = AutoScaleMethod.forString(string).orElse(AutoScaleMethod.AUTO);
        autoScaleMethod = AUTO_SCALE_METHOD_SETTING != AutoScaleMethod.AUTO ? AUTO_SCALE_METHOD_SETTING : AutoScaleMethod.NEAREST;
    }

    public record ElementAtZoom<T>(T element, int zoom) {
        public ElementAtZoom {
            if (t == null) {
                SWT.error(4);
            }
            if (n <= 0) {
                SWT.error(5);
            }
        }
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;


        public static Optional<AutoScaleMethod> forString(String string) {
            for (AutoScaleMethod autoScaleMethod : AutoScaleMethod.values()) {
                if (!autoScaleMethod.name().equalsIgnoreCase(string)) continue;
                return Optional.of(autoScaleMethod);
            }
            return Optional.empty();
        }
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        Device device;
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(Device device, ImageData imageData, int n) {
            this.device = device;
            this.imageData = imageData;
            this.currentZoom = n;
        }

        public ImageData getImageData(int n) {
            return DPIUtil.scaleImageData(this.device, this.imageData, n, this.currentZoom);
        }
    }
}

