/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    final ConcurrentLinkedQueue<RunnableLock> messages = new ConcurrentLinkedQueue();
    Thread syncThread;
    static final int GROW_SIZE = 4;
    static final int MESSAGE_LIMIT = 64;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Synchronizer");
    static final boolean IS_COCOA = "cocoa".equals(SWT.getPlatform());
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    public Synchronizer(Display display) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("Synchronizer(Display)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add((Object)this).add(", display: ").add((Object)display)).log(7);
        }
        this.display = display;
    }

    void moveAllEventsTo(Synchronizer synchronizer) {
        ArrayList arrayList = new ArrayList();
        synchronizer.messages.removeIf(arrayList::add);
        this.messages.removeIf(synchronizer.messages::add);
        synchronizer.messages.addAll(arrayList);
    }

    void addLast(RunnableLock runnableLock) {
        boolean bl = this.messages.isEmpty();
        this.messages.add(runnableLock);
        if (bl) {
            this.display.wakeThread();
        }
    }

    protected void internalAsyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("internalAsyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add((Object)runnable)).log(7);
        }
        if (runnable != null && "org.eclipse.ui.internal.UISynchronizer".equals(this.getClass().getName()) && runnable.getClass().getName().startsWith("de.qfs.")) {
            this.trueAsyncExec(runnable);
        } else {
            this.asyncExec(runnable);
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("asyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add((Object)runnable)).log(7);
        }
        this.trueAsyncExec(runnable);
    }

    void trueAsyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("trueAsyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add((Object)this).add(", runnable: ").add((Object)runnable)).log(7);
        }
        if (runnable == null && !IS_GTK && !IS_COCOA) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    boolean isMessagesEmpty() {
        return this.messages.isEmpty();
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages.clear();
        this.syncThread = null;
    }

    RunnableLock removeFirst() {
        return this.messages.poll();
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runAsyncMessages(boolean bl) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("runAsyncMessages(boolean)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add((Object)this).add(", all: ").add(bl)).log(7);
        }
        boolean bl2 = false;
        do {
            RunnableLock runnableLock;
            if ((runnableLock = this.removeFirst()) == null) {
                return bl2;
            }
            bl2 = true;
            RunnableLock runnableLock2 = runnableLock;
            synchronized (runnableLock2) {
                this.syncThread = runnableLock.thread;
                this.display.sendPreEvent(0);
                try {
                    runnableLock.run(this.display);
                }
                catch (Throwable throwable) {
                    runnableLock.throwable = throwable;
                    SWT.error(46, throwable);
                }
                finally {
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.sendPostEvent(0);
                    }
                    this.syncThread = null;
                    runnableLock.notifyAll();
                }
            }
        } while (bl);
        return bl2;
    }

    protected void internalSyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("internalSyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add((Object)runnable)).log(7);
        }
        if (runnable != null && "org.eclipse.ui.internal.UISynchronizer".equals(this.getClass().getName()) && runnable.getClass().getName().startsWith("de.qfs.")) {
            this.trueSyncExec(runnable);
        } else {
            this.syncExec(runnable);
        }
    }

    protected void syncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("syncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add((Object)runnable)).log(7);
        }
        this.trueSyncExec(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trueSyncExec(Runnable runnable) {
        Logger.Builder builder;
        if (Synchronizer.logger.level >= 7) {
            builder = logger.build("trueSyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add((Object)this).add(", runnable: ").add((Object)runnable)).log(7);
        }
        builder = null;
        Logger.Builder builder2 = Device.class;
        synchronized (Device.class) {
            if (this.display == null || this.display.isDisposed()) {
                SWT.error(45);
            }
            if (!this.display.isValidThread()) {
                if (runnable == null) {
                    this.display.wake();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                builder = new RunnableLock(runnable);
                builder.thread = Thread.currentThread();
                this.addLast((RunnableLock)builder);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (builder == null) {
                if (runnable != null) {
                    this.display.sendPreEvent(0);
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException runtimeException) {
                        this.display.getRuntimeExceptionHandler().accept(runtimeException);
                    }
                    catch (Error error) {
                        this.display.getErrorHandler().accept(error);
                    }
                    finally {
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.sendPostEvent(0);
                        }
                    }
                }
                return;
            }
            builder2 = builder;
            synchronized (builder2) {
                boolean bl = false;
                while (!builder.done()) {
                    try {
                        builder.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                if (builder.throwable != null) {
                    SWT.error(46, builder.throwable);
                }
            }
            return;
        }
    }
}

