/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.transform;

import de.qfs.apps.qftest.qagent.QAgent;
import de.qfs.apps.qftest.transform.SWTTransformer;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class InstanceTraceTransformer
implements Opcodes,
ClassFileTransformer {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.transform.InstanceTraceTransformer");
    private static String SYSTEM_OS_ARCH = System.getProperty("os.arch");
    private static final String[] preloadClasses;
    static boolean hasModules;
    private static Map<String, Class<? extends ClassVisitor>> specialAdapterMap;
    private static Map<String, Class<? extends ClassVisitor>> connectorLoaderAdapterMap;
    private static Map<String, Class<? extends ClassVisitor>> mainAdapterMap;
    private boolean isMain;
    private boolean isSlave;
    private static boolean retransform;
    private static boolean awtAppContextNotTransformed;
    private static boolean awtComponentNotTransformed;
    private static boolean awtEventQueueNotTransformed;
    private Set<String> instanceTraces;
    private Map<String, String[]> methodTraces;
    private String[] classesToLog;
    private boolean traceSWT;
    private Map<ClassLoader, SWTTransformer> swtTransformers = new HashMap<ClassLoader, SWTTransformer>();

    public InstanceTraceTransformer(String string, boolean bl) {
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 213).add("getClass().getClassLoader()", (Object)this.getClass().getClassLoader())).log();
        }
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 214).add("Logger.class.getClassLoader()", (Object)Logger.class.getClassLoader())).log();
        }
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 215).add("getClass().getProtectionDomain()", (Object)this.getClass().getProtectionDomain())).log();
        }
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 216).add("Logger.class.getProtectionDomain()", (Object)Logger.class.getProtectionDomain())).log();
        }
        this.isMain = "main".equals(string);
        this.isSlave = "slave".equals(string);
        retransform = bl;
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 221).add("isMain", this.isMain)).add("isSlave", this.isSlave)).add("retransform", retransform)).log();
        }
        this.instanceTraces = new HashSet<String>();
        this.methodTraces = new HashMap<String, String[]>();
        if (!this.isMain) {
            this.traceAwtInstances();
            this.traceFxInstances();
            this.traceSwtInstances();
            this.traceWinInstances();
            this.traceIOSInstances();
            this.traceBridgedBrowsers();
            this.traceLangMethods();
            this.traceAwtMethods();
            this.traceFxMethods();
            this.traceSwtMethods();
            this.traceWinMethods();
            this.traceIOSMethods();
            this.tracePdfMethods();
        }
        this.traceInstancesFromEnvironment();
        this.traceMethodsFromEnvironment();
        this.setClassesToLogFromEnvironment();
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 246).add("instanceTraces", this.instanceTraces)).log();
        }
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 247).add("methodTraces", this.methodTraces)).log();
        }
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstanceTraceTransformer(String,boolean)", 248).add("classesToLog", (Object)this.classesToLog)).log();
        }
    }

    protected void traceAwtInstances() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceAwtInstances()", 254).log();
        }
        this.instanceTraces.add("java/awt/EventDispatchThread");
        if (!hasModules) {
            String string = QAgent.Environment.getEnv((String)"QFTEST_INSTRUMENT_EVENT_QUEUE");
            String string2 = QAgent.Environment.getEnv((String)"QFTEST_INJECT_EVENT_QUEUE");
            if ("false".equalsIgnoreCase(string) || !"true".equalsIgnoreCase(string) && !"true".equalsIgnoreCase(string2)) {
                this.instanceTraces.add("java/awt/EventQueue");
            }
        }
        this.instanceTraces.add("java/awt/Toolkit");
    }

    protected void traceFxInstances() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceFxInstances()", 275).log();
        }
        if ("de.qfs.apps.qfwin.QFWin".equals(System.getProperty("sun.java.command"))) {
            if (InstanceTraceTransformer.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "traceFxInstances()", 278).add("Not tracing FX instances in Win client")).log();
            }
        } else {
            this.instanceTraces.add("com/sun/javafx/tk/Toolkit");
            this.instanceTraces.add("javafx/animation/Animation");
            this.instanceTraces.add("javafx/scene/Scene");
            if (!"false".equals(System.getProperty("qftest.web.fx.bridged"))) {
                this.instanceTraces.add("javafx/scene/web/WebView");
            }
        }
    }

    protected void traceSwtInstances() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceSwtInstances()", 292).log();
        }
        String string = QAgent.Environment.getEnv((String)"QFTEST_SWT_VIA_AGENT");
        this.traceSWT = "true".equalsIgnoreCase(string);
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "traceSwtInstances()", 296).add("traceSWT", this.traceSWT)).log();
        }
    }

    protected void traceWinInstances() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceWinInstances()", 302).log();
        }
        this.instanceTraces.add("de/qfs/apps/qfwin/QFWin");
    }

    protected void traceIOSInstances() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceIOSInstances()", 310).log();
        }
        this.instanceTraces.add("de/qfs/apps/qfios/QFIOS");
    }

    protected void traceBridgedBrowsers() {
        String string;
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceBridgedBrowsers()", 318).log();
        }
        if (InstanceTraceTransformer.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "traceBridgedBrowsers()", 320).add("Bridge Browser Properties")).add("qftest.web.jx.bridged", System.getProperty("qftest.web.jx.bridged"))).add("qftest.web.swt.bridged", System.getProperty("qftest.web.swt.bridged"))).add("qftest.web.fx.bridged", System.getProperty("qftest.web.fx.bridged"))).log();
        }
        if (!"false".equalsIgnoreCase(string = System.getProperty("qftest.web.jx.bridged"))) {
            this.instanceTraces.add("com/teamdev/jxbrowser/engine/EngineOptions$Builder");
            if (!"cdp".equalsIgnoreCase(string)) {
                this.instanceTraces.add("com/teamdev/jxbrowser/chromium/javafx/BrowserView");
                this.instanceTraces.add("com/teamdev/jxbrowser/chromium/swing/BrowserView");
                this.instanceTraces.add("com/teamdev/jxbrowser/view/javafx/BrowserView");
                this.instanceTraces.add("com/teamdev/jxbrowser/view/swing/BrowserView");
                this.instanceTraces.add("com/teamdev/jxbrowser/view/swt/BrowserView");
            }
        }
        if (System.getProperty("os.name").startsWith("Windows") && !"false".equals(System.getProperty("qftest.web.swt.bridged")) || "true".equals(System.getProperty("qftest.web.swt.bridged"))) {
            this.instanceTraces.add("org/eclipse/swt/browser/Browser");
        }
    }

    protected void traceInstancesFromEnvironment() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceInstancesFromEnvironment()", 347).log();
        }
        String string = QAgent.Environment.getEnv((String)"QFTEST_TRACE_INSTANCES");
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "traceInstancesFromEnvironment()", 350).add("ienv", string)).log();
        }
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                String string3 = string2.trim().replace('.', '/');
                if (InstanceTraceTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "traceInstancesFromEnvironment()", 355).add("inst", string3)).log();
                }
                this.instanceTraces.add(string3);
            }
        }
    }

    protected void traceLangMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceLangMethods()", 364).log();
        }
        this.methodTraces.put("java/lang/ProcessBuilder", new String[]{"start()Ljava/lang/Process;"});
    }

    protected void traceAwtMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceAwtMethods()", 372).log();
        }
        this.methodTraces.put("java/awt/EventDispatchThread", new String[]{"run()V"});
        this.methodTraces.put("java/awt/Desktop", new String[]{"browse(Ljava/net/URI;)V", "open(Ljava/io/File;)V"});
    }

    protected void traceFxMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceFxMethods()", 393).log();
        }
        if ("de.qfs.apps.qfwin.QFWin".equals(System.getProperty("sun.java.command"))) {
            if (InstanceTraceTransformer.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "traceFxMethods()", 396).add("Not tracing FX methods in Win client")).log();
            }
        } else {
            this.methodTraces.put("javafx/scene/control/Button", new String[]{"fire()V"});
            this.methodTraces.put("javafx/scene/control/CheckBox", new String[]{"fire()V"});
            this.methodTraces.put("javafx/scene/control/Hyperlink", new String[]{"fire()V"});
            this.methodTraces.put("javafx/scene/control/ToggleButton", new String[]{"fire()V"});
            this.methodTraces.put("javafx/scene/control/SplitMenuButton", new String[]{"fire()V"});
            this.methodTraces.put("javafx/concurrent/Service", new String[]{"cancel()Z", "reset()V", "restart()V", "start()V", "executeTask(Ljavafx/concurrent/Task;)V"});
            this.methodTraces.put("javafx/concurrent/Task", new String[]{"setState(Ljavafx/concurrent/Worker$State;)V"});
            this.methodTraces.put("com/sun/javafx/scene/control/skin/ComboBoxBaseSkin", new String[]{"focusLost()V"});
            this.methodTraces.put("com/sun/javafx/scene/control/skin/ComboBoxPopupControl", new String[]{"hide()V"});
            this.methodTraces.put("javafx/scene/control/skin/ComboBoxBaseSkin", new String[]{"focusLost()V"});
            this.methodTraces.put("javafx/scene/control/skin/ComboBoxPopupControl", new String[]{"hide()V"});
            this.methodTraces.put("javafx/application/HostServices", new String[]{"showDocument(Ljava/lang/String;)V"});
        }
    }

    protected void traceSwtMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceSwtMethods()", 436).log();
        }
        if (this.traceSWT) {
            this.methodTraces.put("org/eclipse/swt/program/Program", new String[]{"launch(Ljava/lang/String;)Z", "launch(Ljava/lang/String;Ljava/lang/String;)Z"});
            this.methodTraces.put("org/eclipse/ui/internal/browser/DefaultWebBrowser", new String[]{"openURL(Ljava/net/URL;)V"});
            this.methodTraces.put("org/eclipse/ui/internal/browser/SystemBrowserInstance", new String[]{"openURL(Ljava/net/URL;)V"});
        }
    }

    protected void traceWinMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceWinMethods()", 453).log();
        }
    }

    protected void traceIOSMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceIOSMethods()", 460).log();
        }
    }

    private void tracePdfMethods() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "tracePdfMethods()", 467).log();
        }
        String string = System.getProperty("sun.java.command");
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "tracePdfMethods()", 470).add("command", string)).log();
        }
        if (string == null || !string.contains("de.qfs.apps.qfpdf.PDFMain")) {
            return;
        }
        System.setProperty("de.qfs.pdfMethodsTraceEnabled", "true");
        this.methodTraces.put("org/apache/pdfbox/debugger/pagepane/PagePane$RenderWorker", new String[]{"doInBackground()Ljava/lang/Object;"});
        this.methodTraces.put("org/apache/pdfbox/rendering/PageDrawer", new String[]{"drawImage(Lorg/apache/pdfbox/pdmodel/graphics/image/PDImage;)V", "drawBufferedImage(Ljava/awt/image/BufferedImage;Ljava/awt/geom/AffineTransform;)V", "drawPage(Ljava/awt/Graphics;Lorg/apache/pdfbox/pdmodel/common/PDRectangle;)V", "drawBufferedImage(Ljava/awt/image/BufferedImage;Ljava/awt/geom/AffineTransform;)V", "showFontGlyph(Lorg/apache/pdfbox/util/Matrix;Lorg/apache/pdfbox/pdmodel/font/PDFont;ILjava/lang/String;Lorg/apache/pdfbox/util/Vector;)V", "drawGlyph2D(Lorg/apache/pdfbox/rendering/Glyph2D;Lorg/apache/pdfbox/pdmodel/font/PDFont;ILorg/apache/pdfbox/util/Vector;Ljava/awt/geom/AffineTransform;)V", "beginTextClip()V", "endTextClip()V", "beginText()V", "endText()V", "shadingFill(Lorg/apache/pdfbox/cos/COSName;)V", "appendRectangle(Ljava/awt/geom/Point2D;Ljava/awt/geom/Point2D;Ljava/awt/geom/Point2D;Ljava/awt/geom/Point2D;)V", "moveTo(FF)V", "lineTo(FF)V", "curveTo(FFFFFF)V", "endPath()V", "getStroke()Ljava/awt/BasicStroke;"});
        this.methodTraces.put("org/apache/pdfbox/rendering/PDFRenderer", new String[]{"createPageDrawer(Lorg/apache/pdfbox/rendering/PageDrawerParameters;)Lorg/apache/pdfbox/rendering/PageDrawer;", "renderPage(Lorg/apache/pdfbox/pdmodel/PDPage;Ljava/awt/Graphics2D;IIFF)V"});
        this.methodTraces.put("org/apache/pdfbox/contentstream/PDFStreamEngine", new String[]{"showText([B)V"});
        this.methodTraces.put("org/apache/pdfbox/contentstream/operator/text/BeginText", new String[]{"process(Lorg/apache/pdfbox/contentstream/operator/Operator;Ljava/util/List;)V"});
        this.methodTraces.put("org/apache/pdfbox/contentstream/operator/text/EndText", new String[]{"process(Lorg/apache/pdfbox/contentstream/operator/Operator;Ljava/util/List;)V"});
    }

    protected void traceMethodsFromEnvironment() {
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "traceMethodsFromEnvironment()", 529).log();
        }
        String string = QAgent.Environment.getEnv((String)"QFTEST_TRACE_METHODS");
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "traceMethodsFromEnvironment()", 532).add("menv", string)).log();
        }
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\|")) {
                String[] stringArray2 = string2.trim().split(":");
                if (InstanceTraceTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "traceMethodsFromEnvironment()", 537).add("split", (Object)stringArray2)).log();
                }
                if (stringArray2.length != 2) continue;
                String[] stringArray3 = stringArray2[1].trim().split(",");
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string3 = stringArray3[i].trim();
                    if (!string3.startsWith("RE=")) {
                        string3 = string3.replace('.', '/');
                    }
                    stringArray3[i] = string3;
                }
                this.methodTraces.put(stringArray2[0].trim().replace('.', '/'), stringArray3);
            }
        }
    }

    protected void setClassesToLogFromEnvironment() {
        String string;
        String string2;
        if (InstanceTraceTransformer.logger.level >= 7) {
            logger.lvlBuild(7, "setClassesToLogFromEnvironment()", 556).log();
        }
        if ((string2 = QAgent.Environment.getEnv((String)"QFTEST_RMI_REAPER_DAEMON")) == null || !"false".equalsIgnoreCase(string2)) {
            specialAdapterMap.put("sun/rmi/transport/ObjectTable", ObjectTableAdapter.class);
        }
        if ((string = QAgent.Environment.getEnv((String)"QFTEST_CLASSES_TO_LOG")) != null) {
            this.classesToLog = string.split(":");
            for (int i = 0; i < this.classesToLog.length; ++i) {
                this.classesToLog[i] = this.classesToLog[i].replace('.', '/');
            }
            if (InstanceTraceTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setClassesToLogFromEnvironment()", 569).add("classesToLog", (Object)this.classesToLog)).log();
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        byte[] byArray2;
        block32: {
            if (string == null) {
                return null;
            }
            if (string.startsWith("de/qfs/lib/log/")) {
                return null;
            }
            if (string.startsWith("com/teamdev/jxbrowser/") && InstanceTraceTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 601).add("className", string)).add("loader", (Object)classLoader)).log();
            }
            byArray2 = null;
            try {
                Object object;
                Object object2;
                if (this.classesToLog != null && InstanceTraceTransformer.logger.level >= 7) {
                    object2 = this.classesToLog;
                    int n = ((String[])object2).length;
                    for (int i = 0; i < n; ++i) {
                        object = object2[i];
                        if (!string.startsWith((String)object) || InstanceTraceTransformer.logger.level < 7) continue;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 610).addDetail("loader", (Object)classLoader)).addDetail("className", string)).addDetail("classBeingRedefined", clazz)).addDetail("protectionDomain", (Object)protectionDomain)).addDetail("classfileBuffer", (Object)byArray)).dumpStack();
                    }
                }
                if (this.traceSWT && string.startsWith("org/eclipse/swt") && !string.equals("org/eclipse/swt/internal/Platform") && !string.equals("org/eclipse/swt/internal/Library")) {
                    if (InstanceTraceTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 618).add("className", string)).log();
                    }
                    if (SYSTEM_OS_ARCH != null && !SYSTEM_OS_ARCH.contains("64")) {
                        System.err.println("Error: Cannot instrument class " + string + "\nTesting 32 bit SWT applications requires QF-Test version 7.1 or older");
                        this.traceSWT = false;
                    } else {
                        if (!this.swtTransformers.containsKey(classLoader)) {
                            object2 = SWTTransformer.createSWTTransformer(classLoader);
                            this.swtTransformers.put(classLoader, (SWTTransformer)object2);
                        }
                        if ((object2 = this.swtTransformers.get(classLoader)) != null) {
                            byte[] byArray3 = ((SWTTransformer)object2).transform(string, clazz, protectionDomain, byArray);
                            if (InstanceTraceTransformer.logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 632).add("transformed", (Object)byArray3)).log();
                            }
                            if (byArray3 != null) {
                                byArray = byArray3;
                                byArray2 = byArray3;
                            }
                        }
                    }
                }
                if (this.instanceTraces.contains(string) && !this.methodTraces.containsKey(string)) {
                    if (InstanceTraceTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 642).add("transforming constructor for ")).add(string)).add("loader", (Object)classLoader)).dumpStack();
                    }
                    if (InstanceTraceTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 643).add("loader", (Object)classLoader)).log();
                    }
                    try {
                        object2 = new ClassReader(byArray);
                        ClassWriter classWriter = new ClassWriter((ClassReader)object2, 2);
                        InstrumentConstructorAdapter instrumentConstructorAdapter = new InstrumentConstructorAdapter((ClassVisitor)classWriter);
                        object2.accept((ClassVisitor)instrumentConstructorAdapter, 0);
                        object = classWriter.toByteArray();
                        return object;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if ((object2 = this.methodTraces.get(string)) != null) {
                    if (InstanceTraceTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 659).add("Instrumenting method calls for ")).add(string)).add("loader", (Object)classLoader)).dumpStack();
                    }
                    try {
                        ClassReader classReader = new ClassReader(byArray);
                        ClassWriter classWriter = new ClassWriter(classReader, 2);
                        object = new InstrumentMethodEntryAdapter((ClassVisitor)classWriter, string, (String[])object2);
                        if (InstanceTraceTransformer.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 666).add("imea", object)).log();
                        }
                        classReader.accept((ClassVisitor)object, 0);
                        return classWriter.toByteArray();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                String string2 = null;
                Class<? extends ClassVisitor> clazz2 = specialAdapterMap.get(string);
                object = classLoader == null ? "null" : classLoader.getClass().getName();
                boolean bl = "de.qfs.apps.qftest.start.Connector$Loader".equals(object);
                if (clazz2 == null) {
                    if (this.isMain || this.isSlave && !bl) {
                        clazz2 = mainAdapterMap.get(string);
                    } else if (bl) {
                        clazz2 = connectorLoaderAdapterMap.get(string);
                    }
                }
                if (clazz2 != null) {
                    if (InstanceTraceTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 692).add("transforming ")).add(string)).add(" with ")).add(clazz2)).add("loader", (Object)classLoader)).dumpStack();
                    }
                    byte[] byArray4 = this.transformSpecial(byArray, clazz2, string2, string);
                    if (InstanceTraceTransformer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 694).add("classBeingRedefined", clazz)).log();
                    }
                    return byArray4;
                }
            }
            catch (Throwable throwable) {
                if (InstanceTraceTransformer.logger.level < 3) break block32;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "transform(ClassLoader,String,Class<?>,ProtectionDomain,byte[])", 707).add("ex", (Object)throwable)).log();
            }
        }
        return byArray2;
    }

    private byte[] transformSpecial(byte[] byArray, Class<? extends ClassVisitor> clazz, String string, String string2) {
        if (InstanceTraceTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "transformSpecial(byte[],Class<? extends ClassVisitor>,String,String)", 718).addDetail("classfileBuffer", (Object)byArray)).addDetail("adapterClass", clazz)).addDetail("clazz", string)).addDetail("className", string2)).log();
        }
        try {
            ClassReader classReader = new ClassReader(byArray);
            ClassWriter classWriter = new ClassWriter(classReader, 2);
            ClassVisitor classVisitor = string == null ? clazz.getConstructor(ClassVisitor.class).newInstance(classWriter) : clazz.getConstructor(ClassVisitor.class, String.class).newInstance(classWriter, string);
            if (InstanceTraceTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "transformSpecial(byte[],Class<? extends ClassVisitor>,String,String)", 731).add("adapter", (Object)classVisitor)).log();
            }
            classReader.accept(classVisitor, 0);
            byte[] byArray2 = classWriter.toByteArray();
            return byArray2;
        }
        catch (Throwable throwable) {
            if (InstanceTraceTransformer.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "transformSpecial(byte[],Class<? extends ClassVisitor>,String,String)", 746).add("ex", (Object)throwable)).log();
            }
            throwable.printStackTrace();
            return null;
        }
    }

    public void retransform(Instrumentation instrumentation) {
        if (InstanceTraceTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "retransform(Instrumentation)", 755).addDetail("inst", (Object)instrumentation)).log();
        }
        int n = 0;
        specialAdapterMap.put("com/sun/javafx/event/EventUtil", EventUtilAdapterRetransform.class);
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            try {
                String string = clazz.getName();
                String string2 = string.replace('.', '/');
                if ("java.awt.Component".equals(string)) {
                    awtComponentNotTransformed = true;
                    continue;
                }
                if ("sun.awt.AppContext".equals(string)) {
                    awtAppContextNotTransformed = true;
                    continue;
                }
                if (!this.instanceTraces.contains(string2) && !this.methodTraces.containsKey(string2) && !specialAdapterMap.containsKey(string2)) continue;
                if (instrumentation.isModifiableClass(clazz)) {
                    if (InstanceTraceTransformer.logger.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "retransform(Instrumentation)", 776).add("Retransform ")).add(string)).log();
                    }
                    instrumentation.retransformClasses(clazz);
                    continue;
                }
                if (InstanceTraceTransformer.logger.level < 5) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "retransform(Instrumentation)", 779).add("Skip ")).add(string)).log();
            }
            catch (Throwable throwable) {
                if (n >= 3) continue;
                if (InstanceTraceTransformer.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "retransform(Instrumentation)", 784).add("ex", (Object)throwable)).log();
                }
                ++n;
            }
        }
        retransform = false;
    }

    protected static void createParamArray(MethodVisitor methodVisitor, String string, boolean bl) {
        if (InstanceTraceTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createParamArray(MethodVisitor,String,boolean)", 807).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).addDetail("isStatic", bl)).log();
        }
        Type[] typeArray = Type.getArgumentTypes((String)string);
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createParamArray(MethodVisitor,String,boolean)", 810).add("types", (Object)typeArray)).log();
        }
        if (typeArray.length == 0) {
            methodVisitor.visitInsn(1);
        } else {
            methodVisitor.visitIntInsn(16, typeArray.length);
            methodVisitor.visitTypeInsn(189, "java/lang/Object");
            int n = bl ? 0 : 1;
            for (int i = 0; i < typeArray.length; ++i) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                if (InstanceTraceTransformer.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "createParamArray(MethodVisitor,String,boolean)", 821).add("sort", typeArray[i].getSort())).add("arg", n)).log();
                }
                switch (typeArray[i].getSort()) {
                    case 9: 
                    case 10: {
                        methodVisitor.visitVarInsn(25, n++);
                        break;
                    }
                    case 1: {
                        methodVisitor.visitVarInsn(21, n++);
                        methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                        break;
                    }
                    case 3: {
                        methodVisitor.visitVarInsn(21, n++);
                        methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                        break;
                    }
                    case 2: {
                        methodVisitor.visitVarInsn(21, n++);
                        methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                        break;
                    }
                    case 8: {
                        methodVisitor.visitVarInsn(24, n++);
                        ++n;
                        methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                        break;
                    }
                    case 6: {
                        methodVisitor.visitVarInsn(23, n++);
                        methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                        break;
                    }
                    case 5: {
                        methodVisitor.visitVarInsn(21, n++);
                        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                        break;
                    }
                    case 7: {
                        methodVisitor.visitVarInsn(22, n++);
                        ++n;
                        methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                    }
                }
                methodVisitor.visitInsn(83);
            }
        }
    }

    protected static void createReturn(MethodVisitor methodVisitor, String string) {
        int n;
        if (InstanceTraceTransformer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createReturn(MethodVisitor,String)", 879).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
        }
        Type type = Type.getReturnType((String)string);
        if (InstanceTraceTransformer.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createReturn(MethodVisitor,String)", 882).add("type", (Object)type)).log();
        }
        if ((n = type.getSort()) == 0) {
            methodVisitor.visitInsn(177);
            return;
        }
        if (n != 0) {
            if (InstanceTraceTransformer.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "createReturn(MethodVisitor,String)", 892).add("className", type.getClassName())).log();
            }
            switch (n) {
                case 1: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                    methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                    break;
                }
                case 2: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Character");
                    methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                    break;
                }
                case 3: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                    methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                    break;
                }
                case 4: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Short");
                    methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                    break;
                }
                case 5: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                    methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                    break;
                }
                case 6: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Float");
                    methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                    break;
                }
                case 7: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Long");
                    methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                    break;
                }
                case 8: {
                    methodVisitor.visitTypeInsn(192, "java/lang/Double");
                    methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                    break;
                }
                default: {
                    methodVisitor.visitTypeInsn(192, type.getClassName().replace('.', '/'));
                }
            }
            methodVisitor.visitInsn(type.getOpcode(172));
        }
    }

    static {
        for (String string : preloadClasses = new String[]{"org.objectweb.asm.ClassReader", "org.objectweb.asm.ClassVisitor", "org.objectweb.asm.ClassWriter", "org.objectweb.asm.FieldVisitor", "org.objectweb.asm.MethodVisitor", "org.objectweb.asm.Opcodes", "org.objectweb.asm.AnnotationVisitor", "org.objectweb.asm.AnnotationWriter", "org.objectweb.asm.MethodWriter", "org.objectweb.asm.FieldWriter", "org.objectweb.asm.ByteVector", "org.objectweb.asm.Attribute", "org.objectweb.asm.Context", "org.objectweb.asm.Label", "de.qfs.apps.qftest.transform.InstanceTraceTransformer$ConstructorAdapter", "de.qfs.lib.log.QFLogger", "de.qfs.lib.log.QFLoggerInterface"}) {
            try {
                Class<?> clazz = Class.forName(string);
                if (InstanceTraceTransformer.logger.level < 9) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "static", 93).add("cl", clazz)).add("cl.getProtectionDomain()", (Object)clazz.getProtectionDomain())).log();
            }
            catch (Throwable throwable) {
                if (InstanceTraceTransformer.logger.level < 1) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "static", 95).add("ex", (Object)throwable)).log();
            }
        }
        try {
            Class.forName("java.lang.Module");
            hasModules = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        specialAdapterMap = new HashMap<String, Class<? extends ClassVisitor>>();
        connectorLoaderAdapterMap = new HashMap<String, Class<? extends ClassVisitor>>();
        mainAdapterMap = new HashMap<String, Class<? extends ClassVisitor>>();
        specialAdapterMap.put("com/sun/javafx/event/EventUtil", EventUtilAdapter.class);
        specialAdapterMap.put("javafx/stage/FileChooser", FileChooserAdapter.class);
        specialAdapterMap.put("javafx/stage/DirectoryChooser", DirectoryChooserAdapter.class);
        specialAdapterMap.put("javafx/stage/PopupWindow", PopupWindowAdapter.class);
        specialAdapterMap.put("javafx/stage/Window", FXWindowAdapter.class);
        specialAdapterMap.put("java/awt/EventQueue", EventQueueAdapter.class);
        specialAdapterMap.put("java/awt/Component", ComponentAdapter.class);
        specialAdapterMap.put("sun/awt/AppContext", AppContextAdapter.class);
        specialAdapterMap.put("de/qfs/apps/qftest/client/awt/AWTAccessHelper9", AWTAccessAdapter.class);
        if (hasModules) {
            specialAdapterMap.put("de/qfs/lib/util/Reflector", ReflectorAdapter.class);
            specialAdapterMap.put("de/qfs/apps/qftest/shared/Util", UtilAdapter.class);
            connectorLoaderAdapterMap.put("org/python/core/PyJavaType", PyJavaTypeAdapter.class);
            connectorLoaderAdapterMap.put("org/codehaus/groovy/reflection/CachedClass", CachedClassAdapter.class);
            mainAdapterMap.put("org/python/core/PyJavaType", PyJavaTypeAdapter.class);
            mainAdapterMap.put("org/codehaus/groovy/reflection/CachedClass", CachedClassAdapter.class);
            mainAdapterMap.put("org/codehaus/groovy/reflection/ClassLoaderForClassArtifacts", CLFCAAdapter.class);
        }
    }

    public static class BundleLoaderAdapter
    extends InstrumentMethodEntryAdapter {
        public BundleLoaderAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "org/eclipse/osgi/internal/loader/BundleLoader", new String[]{"searchHooks(Ljava/lang/String;I)Ljava/lang/Object;"});
        }
    }

    public static class UtilAdapter
    extends ClassVisitor
    implements Opcodes {
        public UtilAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UtilAdapter.visitMethod(int,String,String,String,String[])", 3270).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ("openModule".equals(string) && "(Ljava/lang/Class;Ljava/lang/Object;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new OpenModuleAdapter(methodVisitor, false);
            }
            if ("openModule".equals(string) && "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new OpenModuleAdapter(methodVisitor, true);
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        class OpenModuleAdapter
        extends MethodVisitor {
            private boolean withPackage;

            public OpenModuleAdapter(MethodVisitor methodVisitor, boolean bl) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UtilAdapter.OpenModuleAdapter.OpenModuleAdapter(MethodVisitor,boolean)", 3305).addDetail("mv", (Object)methodVisitor)).addDetail("withPackage", bl)).log();
                }
                this.withPackage = bl;
            }

            public void visitInsn(int n) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "UtilAdapter.OpenModuleAdapter.visitInsn(int)", 3321).addDetail("opcode", n)).log();
                }
                if (n == 177) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 1);
                    if (this.withPackage) {
                        this.mv.visitVarInsn(25, 2);
                    }
                    this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/ModuleHelper", "openModule", "(Ljava/lang/Class;" + (this.withPackage ? "Ljava/lang/String;Ljava/lang/Class;" : "Ljava/lang/Object;") + ")V");
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "UtilAdapter.OpenModuleAdapter.visitInsn(int)", 3335).add("Instrumented Util.openModule")).log();
                    }
                }
                super.visitInsn(n);
            }
        }
    }

    public static class ReflectorAdapter
    extends ClassVisitor
    implements Opcodes {
        public ReflectorAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ReflectorAdapter.visitMethod(int,String,String,String,String[])", 3161).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ("openModule".equals(string) && "(Ljava/lang/Class;Ljava/lang/Object;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new OpenModuleAdapter(methodVisitor, false);
            }
            if ("openModule".equals(string) && "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new OpenModuleAdapter(methodVisitor, true);
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        class OpenModuleAdapter
        extends MethodVisitor {
            private boolean stringBased;

            public OpenModuleAdapter(MethodVisitor methodVisitor, boolean bl) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ReflectorAdapter.OpenModuleAdapter.OpenModuleAdapter(MethodVisitor,boolean)", 3196).addDetail("mv", (Object)methodVisitor)).addDetail("stringBased", bl)).log();
                }
                this.stringBased = bl;
            }

            public void visitInsn(int n) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ReflectorAdapter.OpenModuleAdapter.visitInsn(int)", 3212).addDetail("opcode", n)).log();
                }
                if (n == 177) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 1);
                    if (this.stringBased) {
                        this.mv.visitVarInsn(25, 2);
                        this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/ModuleHelper", "openModule", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V");
                    } else {
                        this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/ModuleHelper", "openModule", "(Ljava/lang/Class;Ljava/lang/Object;)V");
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "ReflectorAdapter.OpenModuleAdapter.visitInsn(int)", 3225).add("Instrumented Reflector.openModule")).log();
                    }
                }
                super.visitInsn(n);
            }
        }
    }

    public static class AWTAccessAdapter
    extends InstrumentMethodEntryAdapter {
        public AWTAccessAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "de/qfs/apps/qftest/client/awt/AWTAccessHelper9", new String[0]);
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "AWTAccessAdapter.visitMethod(int,String,String,String,String[])", 3008).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if (!retransform && (!awtComponentNotTransformed && "getAppContext".equals(string) && "(Ljava/awt/Component;)Ljava/lang/Object;".equals(string2) || !awtEventQueueNotTransformed && ("getAppContext".equals(string) && "(Ljava/awt/EventQueue;)Ljava/lang/Object;".equals(string2) || "getCurrentAppContext".equals(string) && "()Ljava/lang/Object;".equals(string2) || "getEventQueue".equals(string) && "(Ljava/lang/Object;)Ljava/awt/EventQueue;".equals(string2) || "isDispatchThread".equals(string) && "(Ljava/awt/EventQueue;)Z".equals(string2) || "autoShutdownNotifyThreadBusy".equals(string) && "(Ljava/lang/Thread;)V".equals(string2) || "autoShutdownNotifyThreadFree".equals(string) && "(Ljava/lang/Thread;)V".equals(string2)) || !awtAppContextNotTransformed && "getThreadGroupMap".equals(string) && "()Ljava/util/Map;".equals(string2))) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, "_dropped_" + string, string2, string3, stringArray);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "AWTAccessAdapter.visitMethod(int,String,String,String,String[])", 3024).add("mv", (Object)methodVisitor)).log();
                }
                return methodVisitor;
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        public void visitEnd() {
            MethodVisitor methodVisitor;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "AWTAccessAdapter.visitEnd()", 3038).log();
            }
            if (retransform) {
                super.visitEnd();
                return;
            }
            if (!awtComponentNotTransformed) {
                methodVisitor = this.cv.visitMethod(1, "getAppContext", "(Ljava/awt/Component;)Ljava/lang/Object;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(182, "java/awt/Component", "_qf_getAppContext", "()Ljava/lang/Object;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 2);
                methodVisitor.visitEnd();
            }
            if (!awtEventQueueNotTransformed) {
                methodVisitor = this.cv.visitMethod(1, "autoShutdownNotifyThreadBusy", "(Ljava/lang/Thread;)V", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(184, "java/awt/EventQueue", "_qf_autoShutdownNotifyThreadBusy", "(Ljava/lang/Thread;)V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(2, 2);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(1, "autoShutdownNotifyThreadFree", "(Ljava/lang/Thread;)V", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(184, "java/awt/EventQueue", "_qf_autoShutdownNotifyThreadFree", "(Ljava/lang/Thread;)V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(2, 2);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(1, "getAppContext", "(Ljava/awt/EventQueue;)Ljava/lang/Object;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(182, "java/awt/EventQueue", "_qf_getAppContext", "()Ljava/lang/Object;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 2);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(1, "getCurrentAppContext", "()Ljava/lang/Object;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, "java/awt/EventQueue", "_qf_getCurrentAppContext", "()Ljava/lang/Object;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(1, "getEventQueue", "(Ljava/lang/Object;)Ljava/awt/EventQueue;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(184, "java/awt/EventQueue", "_qf_getEventQueue", "(Ljava/lang/Object;)Ljava/awt/EventQueue;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 2);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(1, "isDispatchThread", "(Ljava/awt/EventQueue;)Z", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(182, "java/awt/EventQueue", "_qf_isDispatchThread", "()Z");
                methodVisitor.visitInsn(172);
                methodVisitor.visitMaxs(1, 2);
                methodVisitor.visitEnd();
            }
            if (!awtAppContextNotTransformed) {
                methodVisitor = this.cv.visitMethod(1, "getThreadGroupMap", "()Ljava/util/Map;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, "java/awt/EventQueue", "_qf_getThreadGroupMap", "()Ljava/util/Map;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
            }
            super.visitEnd();
        }
    }

    public static class CLFCAAdapter
    extends ClassVisitor
    implements Opcodes {
        public CLFCAAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "CLFCAAdapter.visitMethod(int,String,String,String,String[])", 2899).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ("<init>".equals(string) && "(Ljava/lang/Class;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new InitAdapter(methodVisitor, string2);
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        class InitAdapter
        extends ConstructorAdapter {
            public InitAdapter(MethodVisitor methodVisitor, String string) {
                super(methodVisitor, string);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "CLFCAAdapter.InitAdapter.InitAdapter(MethodVisitor,String)", 2927).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
                }
            }

            @Override
            public void visitInsn(int n) {
                if (n == 177) {
                    this.mv.visitVarInsn(25, 1);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/ModuleHelper", "openModule", "(Ljava/lang/Class;Ljava/lang/Object;)V");
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "CLFCAAdapter.InitAdapter.visitInsn(int)", 2950).add("Instrumented ClassLoaderForClassArtifacts constructor")).log();
                    }
                }
                this.mv.visitInsn(n);
            }

            public void visitMaxs(int n, int n2) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "CLFCAAdapter.InitAdapter.visitMaxs(int,int)", 2959).addDetail("maxStack", n)).addDetail("maxLocals", n2)).log();
                }
                super.visitMaxs(n, n2);
            }
        }
    }

    public static class CachedClassAdapter
    extends ClassVisitor
    implements Opcodes {
        public CachedClassAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "CachedClassAdapter.visitMethod(int,String,String,String,String[])", 2806).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ("<init>".equals(string) && "(Ljava/lang/Class;Lorg/codehaus/groovy/reflection/ClassInfo;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new InitAdapter(methodVisitor);
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        class InitAdapter
        extends MethodVisitor {
            public InitAdapter(MethodVisitor methodVisitor) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "CachedClassAdapter.InitAdapter.InitAdapter(MethodVisitor)", 2834).addDetail("mv", (Object)methodVisitor)).log();
                }
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "CachedClassAdapter.InitAdapter.visitCode()", 2844).log();
                }
                super.visitCode();
                this.mv.visitVarInsn(25, 1);
                this.mv.visitLdcInsn((Object)Type.getType((String)"Lorg/codehaus/groovy/reflection/CachedClass;"));
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/ModuleHelper", "openModule", "(Ljava/lang/Class;Ljava/lang/Object;)V");
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "CachedClassAdapter.InitAdapter.visitCode()", 2852).add("Instrumented CachedClass constructor")).log();
                }
            }
        }
    }

    public static class PyJavaTypeAdapter
    extends ClassVisitor
    implements Opcodes {
        public PyJavaTypeAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "PyJavaTypeAdapter.visitMethod(int,String,String,String,String[])", 2715).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ("init".equals(string) && "(Ljava/lang/Class;Ljava/util/Set;)V".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
                return new InitAdapter(methodVisitor);
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        class InitAdapter
        extends MethodVisitor {
            public InitAdapter(MethodVisitor methodVisitor) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "PyJavaTypeAdapter.InitAdapter.InitAdapter(MethodVisitor)", 2743).addDetail("mv", (Object)methodVisitor)).log();
                }
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "PyJavaTypeAdapter.InitAdapter.visitCode()", 2753).log();
                }
                super.visitCode();
                this.mv.visitVarInsn(25, 1);
                this.mv.visitLdcInsn((Object)Type.getType((String)"Lorg/python/core/PyJavaType;"));
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/ModuleHelper", "openModule", "(Ljava/lang/Class;Ljava/lang/Object;)V");
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "PyJavaTypeAdapter.InitAdapter.visitCode()", 2761).add("Instrumented PyJavaType.init")).log();
                }
            }
        }
    }

    public static class ObjectTableAdapter
    extends InstrumentMethodEntryAdapter {
        public ObjectTableAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "sun/rmi/transport/ObjectTable", new String[]{"incrementKeepAliveCount()V"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ObjectTableAdapter.createMethodAdapter(MethodVisitor,String,String,boolean)", 2612).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            return new MethodAdapter(methodVisitor, string, string2, bl);
        }

        class MethodAdapter
        extends InstrumentMethodEntryAdapter.MethodAdapter {
            protected String desc;
            protected boolean primed;

            public MethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
                super(methodVisitor, string, string2, bl);
                this.primed = false;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ObjectTableAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String,String,boolean)", 2649).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
                }
            }

            public void visitLdcInsn(Object object) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ObjectTableAdapter.MethodAdapter.visitLdcInsn(Object)", 2657).addDetail("value", object)).log();
                }
                if ("Reaper".equals(object)) {
                    this.primed = true;
                }
                super.visitLdcInsn(object);
            }

            @Override
            public void visitInsn(int n) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ObjectTableAdapter.MethodAdapter.visitInsn(int)", 2666).addDetail("opcode", n)).log();
                }
                if (this.primed && n == 3) {
                    n = 4;
                    this.primed = false;
                }
                super.visitInsn(n);
            }
        }
    }

    public static class AppContextAdapter
    extends InstrumentMethodEntryAdapter {
        public AppContextAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "sun/awt/AppContext", new String[0]);
        }

        public void visitEnd() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "AppContextAdapter.visitEnd()", 2563).log();
            }
            MethodVisitor methodVisitor = this.cv.visitMethod(9, "_qf_getThreadGroupMap", "()Ljava/util/Map;", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitFieldInsn(178, "sun/awt/AppContext", "threadGroup2appContext", "Ljava/util/Map;");
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(1, 0);
            methodVisitor.visitEnd();
            super.visitEnd();
        }
    }

    public static class ComponentAdapter
    extends ClassVisitor {
        public ComponentAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public void visitEnd() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ComponentAdapter.visitEnd()", 2517).log();
            }
            if (retransform) {
                awtComponentNotTransformed = true;
            } else {
                MethodVisitor methodVisitor = this.cv.visitMethod(1, "_qf_getAppContext", "()Ljava/lang/Object;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, "java/awt/Component", "appContext", "Lsun/awt/AppContext;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
            }
            super.visitEnd();
        }
    }

    public static class EventQueueAdapter
    extends InstrumentMethodEntryAdapter {
        private boolean fieldCreated;

        public EventQueueAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "java/awt/EventQueue", new String[]{"push(Ljava/awt/EventQueue;)V", "pop()V", "getNextEvent()Ljava/awt/AWTEvent;", "getNextEventPrivate()Ljava/awt/AWTEvent;", "getNextEvent(I)Ljava/awt/AWTEvent;", "postEventPrivate(Ljava/awt/AWTEvent;)V"});
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "EventQueueAdapter.visitMethod(int,String,String,String,String[])", 2344).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if (retransform) {
                awtEventQueueNotTransformed = true;
            } else {
                FieldVisitor fieldVisitor;
                if (!this.fieldCreated) {
                    this.fieldCreated = true;
                    fieldVisitor = this.cv.visitField(1, "_qf_eventQueue", "Lde/qfs/apps/qftest/instrument/EventDispatcher;", null, null);
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "EventQueueAdapter.visitMethod(int,String,String,String,String[])", 2355).add("fv", (Object)fieldVisitor)).log();
                    }
                    fieldVisitor.visitEnd();
                }
                if ("dispatchEventImpl".equals(string) && "(Ljava/awt/AWTEvent;Ljava/lang/Object;)V".equals(string2)) {
                    fieldVisitor = this.cv.visitMethod(n & 0xFFFFFFFD | 1, "_qf_" + string, string2, string3, stringArray);
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "EventQueueAdapter.visitMethod(int,String,String,String,String[])", 2363).add("mv", (Object)fieldVisitor)).log();
                    }
                    return fieldVisitor;
                }
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        public void visitEnd() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "EventQueueAdapter.visitEnd()", 2377).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "EventQueueAdapter.visitEnd()", 2379).add("retransform", retransform)).log();
            }
            if (!retransform) {
                MethodVisitor methodVisitor = this.cv.visitMethod(2, "dispatchEventImpl", "(Ljava/awt/AWTEvent;Ljava/lang/Object;)V", null, null);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "EventQueueAdapter.visitEnd()", 2386).add("mv", (Object)methodVisitor)).log();
                }
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, "java/awt/EventQueue", "_qf_eventQueue", "Lde/qfs/apps/qftest/instrument/EventDispatcher;");
                Label label = new Label();
                methodVisitor.visitJumpInsn(198, label);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, "java/awt/EventQueue", "_qf_eventQueue", "Lde/qfs/apps/qftest/instrument/EventDispatcher;");
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(185, "de/qfs/apps/qftest/instrument/EventDispatcher", "dispatchEvent", "(Ljava/awt/EventQueue;Ljava/awt/AWTEvent;Ljava/lang/Object;)V");
                Label label2 = new Label();
                methodVisitor.visitJumpInsn(167, label2);
                methodVisitor.visitLabel(label);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(183, "java/awt/EventQueue", "_qf_dispatchEventImpl", "(Ljava/awt/AWTEvent;Ljava/lang/Object;)V");
                methodVisitor.visitLabel(label2);
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(3, 3);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(9, "_qf_autoShutdownNotifyThreadBusy", "(Ljava/lang/Thread;)V", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, "sun/awt/AWTAutoShutdown", "getInstance", "()Lsun/awt/AWTAutoShutdown;");
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, "sun/awt/AWTAutoShutdown", "notifyThreadBusy", "(Ljava/lang/Thread;)V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(2, 1);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(9, "_qf_autoShutdownNotifyThreadFree", "(Ljava/lang/Thread;)V", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, "sun/awt/AWTAutoShutdown", "getInstance", "()Lsun/awt/AWTAutoShutdown;");
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, "sun/awt/AWTAutoShutdown", "notifyThreadFree", "(Ljava/lang/Thread;)V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(2, 1);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(1, "_qf_getAppContext", "()Ljava/lang/Object;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, "java/awt/EventQueue", "appContext", "Lsun/awt/AppContext;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(9, "_qf_getCurrentAppContext", "()Ljava/lang/Object;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, "sun/awt/AppContext", "getAppContext", "()Lsun/awt/AppContext;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(1, 0);
                methodVisitor.visitEnd();
                methodVisitor = this.cv.visitMethod(9, "_qf_getEventQueue", "(Ljava/lang/Object;)Ljava/awt/EventQueue;", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitTypeInsn(192, "sun/awt/AppContext");
                methodVisitor.visitFieldInsn(178, "sun/awt/AppContext", "EVENT_QUEUE_KEY", "Ljava/lang/Object;");
                methodVisitor.visitMethodInsn(182, "sun/awt/AppContext", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
                methodVisitor.visitVarInsn(58, 1);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, "java/awt/EventQueue");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(2, 2);
                methodVisitor.visitEnd();
                if (!awtAppContextNotTransformed) {
                    methodVisitor = this.cv.visitMethod(9, "_qf_getThreadGroupMap", "()Ljava/util/Map;", null, null);
                    methodVisitor.visitCode();
                    methodVisitor.visitMethodInsn(184, "sun/awt/AppContext", "_qf_getThreadGroupMap", "()Ljava/util/Map;");
                    methodVisitor.visitInsn(176);
                    methodVisitor.visitMaxs(1, 0);
                    methodVisitor.visitEnd();
                }
                methodVisitor = this.cv.visitMethod(1, "_qf_isDispatchThread", "()Z", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, "java/awt/EventQueue", "isDispatchThreadImpl", "()Z");
                methodVisitor.visitInsn(172);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
            }
            super.visitEnd();
        }
    }

    public static class UIDefaultsAdapter
    extends InstrumentMethodEntryAdapter {
        public UIDefaultsAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "javax/swing/UIDefaults", new String[]{"getUIClass(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/Class;"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UIDefaultsAdapter.createMethodAdapter(MethodVisitor,String,String,boolean)", 2218).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            return new MethodAdapter(methodVisitor, string, string2, bl);
        }

        class MethodAdapter
        extends InstrumentMethodEntryAdapter.MethodAdapter {
            protected String desc;

            public MethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
                super(methodVisitor, string, string2, bl);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UIDefaultsAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String,String,boolean)", 2250).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
                }
            }

            public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UIDefaultsAdapter.MethodAdapter.visitFrame(int,int,Object[],int,Object[])", 2258).addDetail("type", n)).addDetail("nLocal", n2)).addDetail("local", (Object)objectArray)).addDetail("nStack", n3)).addDetail("stack", (Object)objectArray2)).log();
                }
                if (n == 4 && objectArray2 != null && objectArray2.length > 0 && ("java/lang/ClassNotFoundException".equals(objectArray2[0]) || "java/lang/ClassCastException".equals(objectArray2[0]))) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "UIDefaultsAdapter.MethodAdapter.visitFrame(int,int,Object[],int,Object[])", 2266).add("Instrumenting")).log();
                    }
                    this.mv.visitVarInsn(58, 3);
                    this.mv.visitTypeInsn(187, "de/qfs/lib/log/Logger");
                    this.mv.visitInsn(89);
                    this.mv.visitLdcInsn((Object)"javax.swing.UIDefaults");
                    this.mv.visitMethodInsn(183, "de/qfs/lib/log/Logger", "<init>", "(Ljava/lang/String;)V");
                    this.mv.visitVarInsn(58, 2);
                    this.mv.visitVarInsn(25, 2);
                    this.mv.visitFieldInsn(180, "de/qfs/lib/log/Logger", "level", "I");
                    this.mv.visitInsn(4);
                    Label label = new Label();
                    this.mv.visitJumpInsn(161, label);
                    this.mv.visitVarInsn(25, 2);
                    this.mv.visitInsn(4);
                    this.mv.visitLdcInsn((Object)"getUIClass(String,ClassLoader)");
                    this.mv.visitVarInsn(25, 3);
                    this.mv.visitMethodInsn(182, "de/qfs/lib/log/Logger", "log", "(ILjava/lang/String;Ljava/lang/Throwable;)V");
                    this.mv.visitLabel(label);
                    this.mv.visitVarInsn(25, 3);
                }
                super.visitFrame(n, n2, objectArray, n3, objectArray2);
            }
        }
    }

    public static class FXWindowAdapter
    extends InstrumentMethodEntryAdapter {
        public FXWindowAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "javafx/stage/Window", new String[]{"isFocused()Z", "setFocused(Z)V", "requestFocus()V"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FXWindowAdapter.createMethodAdapter(MethodVisitor,String,String,boolean)", 2107).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            if ("isFocused".equals(this.method) && "()Z".equals(string2)) {
                return new MethodAdapter(methodVisitor, string2);
            }
            return super.createMethodAdapter(methodVisitor, string, string2, bl);
        }

        class MethodAdapter
        extends MethodVisitor {
            protected String desc;

            public MethodAdapter(MethodVisitor methodVisitor, String string) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FXWindowAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String)", 2142).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
                }
                this.desc = string;
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "FXWindowAdapter.MethodAdapter.visitCode()", 2153).log();
                }
                super.visitCode();
                this.mv.visitLdcInsn((Object)(FXWindowAdapter.this.clazz + "-" + FXWindowAdapter.this.method + "-" + FXWindowAdapter.this.descriptor));
                this.mv.visitVarInsn(25, 0);
                InstanceTraceTransformer.createParamArray(this.mv, this.desc, false);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                this.mv.visitVarInsn(58, 1);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                Label label = new Label();
                this.mv.visitJumpInsn(165, label);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitTypeInsn(192, "java/lang/Boolean");
                this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                this.mv.visitInsn(172);
                this.mv.visitLabel(label);
            }
        }
    }

    public static class PopupWindowAdapter
    extends InstrumentMethodEntryAdapter {
        public PopupWindowAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "javafx/stage/PopupWindow", new String[]{"isAutoHide()Z", "hide()V", "showImpl(Ljavafx/stage/Window;)V"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "PopupWindowAdapter.createMethodAdapter(MethodVisitor,String,String,boolean)", 1995).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            if ("isAutoHide".equals(this.method) && "()Z".equals(string2)) {
                return new MethodAdapter(methodVisitor, string2);
            }
            return super.createMethodAdapter(methodVisitor, string, string2, bl);
        }

        class MethodAdapter
        extends MethodVisitor {
            protected String desc;

            public MethodAdapter(MethodVisitor methodVisitor, String string) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "PopupWindowAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String)", 2030).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
                }
                this.desc = string;
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "PopupWindowAdapter.MethodAdapter.visitCode()", 2041).log();
                }
                super.visitCode();
                this.mv.visitLdcInsn((Object)(PopupWindowAdapter.this.clazz + "-" + PopupWindowAdapter.this.method + "-" + PopupWindowAdapter.this.descriptor));
                this.mv.visitVarInsn(25, 0);
                InstanceTraceTransformer.createParamArray(this.mv, this.desc, false);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                this.mv.visitVarInsn(58, 1);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                Label label = new Label();
                this.mv.visitJumpInsn(165, label);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitTypeInsn(192, "java/lang/Boolean");
                this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                this.mv.visitInsn(172);
                this.mv.visitLabel(label);
            }
        }
    }

    public static class DirectoryChooserAdapter
    extends InstrumentMethodEntryAdapter {
        public DirectoryChooserAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "javafx/stage/DirectoryChooser", new String[]{"showDialog(Ljavafx/stage/Window;)Ljava/io/File;"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DirectoryChooserAdapter.createMethodAdapter(MethodVisitor,String,String,boolean)", 1859).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            return new MethodAdapter(methodVisitor, string2);
        }

        class MethodAdapter
        extends MethodVisitor {
            protected String desc;

            public MethodAdapter(MethodVisitor methodVisitor, String string) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "DirectoryChooserAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String)", 1891).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
                }
                this.desc = string;
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "DirectoryChooserAdapter.MethodAdapter.visitCode()", 1902).log();
                }
                super.visitCode();
                this.mv.visitLdcInsn((Object)(DirectoryChooserAdapter.this.clazz + "-" + DirectoryChooserAdapter.this.method + "-" + DirectoryChooserAdapter.this.descriptor));
                this.mv.visitVarInsn(25, 0);
                InstanceTraceTransformer.createParamArray(this.mv, this.desc, false);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                this.mv.visitVarInsn(58, 2);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                Label label = new Label();
                this.mv.visitJumpInsn(165, label);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitTypeInsn(192, "java/io/File");
                this.mv.visitInsn(176);
                this.mv.visitLabel(label);
            }

            public void visitInsn(int n) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "DirectoryChooserAdapter.MethodAdapter.visitInsn(int)", 1936).addDetail("opcode", n)).log();
                }
                if (n == 176) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "DirectoryChooserAdapter.MethodAdapter.visitInsn(int)", 1939).add("Adding return call to InstanceTracer")).log();
                    }
                    this.mv.visitVarInsn(58, 2);
                    this.mv.visitLdcInsn((Object)(DirectoryChooserAdapter.this.clazz + "-" + DirectoryChooserAdapter.this.method + "-" + DirectoryChooserAdapter.this.descriptor));
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 2);
                    this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodReturned", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    this.mv.visitTypeInsn(192, "java/io/File");
                }
                this.mv.visitInsn(n);
            }
        }
    }

    public static class FileChooserAdapter
    extends InstrumentMethodEntryAdapter {
        public FileChooserAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "javafx/stage/FileChooser", new String[]{"showOpenDialog(Ljavafx/stage/Window;)Ljava/io/File;", "showOpenMultipleDialog(Ljavafx/stage/Window;)Ljava/util/List;", "showSaveDialog(Ljavafx/stage/Window;)Ljava/io/File;"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooserAdapter.createMethodAdapter(MethodVisitor,String,String,boolean)", 1715).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            return new MethodAdapter(methodVisitor, string2);
        }

        class MethodAdapter
        extends MethodVisitor {
            protected String desc;

            public MethodAdapter(MethodVisitor methodVisitor, String string) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooserAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String)", 1747).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
                }
                this.desc = string;
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "FileChooserAdapter.MethodAdapter.visitCode()", 1758).log();
                }
                super.visitCode();
                this.mv.visitLdcInsn((Object)(FileChooserAdapter.this.clazz + "-" + FileChooserAdapter.this.method + "-" + FileChooserAdapter.this.descriptor));
                this.mv.visitVarInsn(25, 0);
                InstanceTraceTransformer.createParamArray(this.mv, this.desc, false);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                this.mv.visitVarInsn(58, 2);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                Label label = new Label();
                this.mv.visitJumpInsn(165, label);
                this.mv.visitVarInsn(25, 2);
                if ("showOpenDialog".equals(FileChooserAdapter.this.method) || "showSaveDialog".equals(FileChooserAdapter.this.method)) {
                    this.mv.visitTypeInsn(192, "java/io/File");
                } else {
                    this.mv.visitTypeInsn(192, "java/util/List");
                }
                this.mv.visitInsn(176);
                this.mv.visitLabel(label);
            }

            public void visitInsn(int n) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "FileChooserAdapter.MethodAdapter.visitInsn(int)", 1797).addDetail("opcode", n)).log();
                }
                if (n == 176) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "FileChooserAdapter.MethodAdapter.visitInsn(int)", 1800).add("Adding return call to InstanceTracer")).log();
                    }
                    this.mv.visitVarInsn(58, 2);
                    this.mv.visitLdcInsn((Object)(FileChooserAdapter.this.clazz + "-" + FileChooserAdapter.this.method + "-" + FileChooserAdapter.this.descriptor));
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 2);
                    this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodReturned", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    if ("showOpenDialog".equals(FileChooserAdapter.this.method) || "showSaveDialog".equals(FileChooserAdapter.this.method)) {
                        this.mv.visitTypeInsn(192, "java/io/File");
                    } else {
                        this.mv.visitTypeInsn(192, "java/util/List");
                    }
                }
                this.mv.visitInsn(n);
            }
        }
    }

    public static class EventUtilAdapterRetransform
    extends InstrumentMethodEntryAdapter {
        public EventUtilAdapterRetransform(ClassVisitor classVisitor) {
            super(classVisitor, "com/sun/javafx/event/EventUtil", new String[]{"fireEventImpl(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;"});
        }

        @Override
        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "EventUtilAdapterRetransform.createMethodAdapter(MethodVisitor,String,String,boolean)", 1575).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
            }
            return new MethodAdapter(methodVisitor, string2);
        }

        class MethodAdapter
        extends MethodVisitor {
            protected String desc;
            protected Label l0;

            public MethodAdapter(MethodVisitor methodVisitor, String string) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "EventUtilAdapterRetransform.MethodAdapter.MethodAdapter(MethodVisitor,String)", 1609).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
                }
                this.desc = string;
                this.l0 = new Label();
            }

            public void visitCode() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "EventUtilAdapterRetransform.MethodAdapter.visitCode()", 1621).log();
                }
                super.visitCode();
                this.mv.visitLdcInsn((Object)"com/sun/javafx/event/EventUtil-fireEventImpl-(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;");
                this.mv.visitInsn(1);
                this.mv.visitInsn(6);
                this.mv.visitTypeInsn(189, "java/lang/Object");
                this.mv.visitInsn(89);
                this.mv.visitInsn(3);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitInsn(83);
                this.mv.visitInsn(89);
                this.mv.visitInsn(4);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitInsn(83);
                this.mv.visitInsn(89);
                this.mv.visitInsn(5);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitInsn(83);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                this.mv.visitVarInsn(58, 3);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.mv.visitJumpInsn(166, this.l0);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(185, "javafx/event/EventTarget", "buildEventDispatchChain", "(Ljavafx/event/EventDispatchChain;)Ljavafx/event/EventDispatchChain;");
                this.mv.visitVarInsn(58, 3);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitMethodInsn(185, "javafx/event/EventDispatchChain", "dispatchEvent", "(Ljavafx/event/Event;)Ljavafx/event/Event;");
                this.mv.visitInsn(176);
                this.mv.visitLabel(this.l0);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitTypeInsn(192, "javafx/event/Event");
                this.mv.visitInsn(176);
            }
        }
    }

    public static class EventUtilAdapter
    extends InstrumentMethodEntryAdapter {
        public EventUtilAdapter(ClassVisitor classVisitor) {
            super(classVisitor, "com/sun/javafx/event/EventUtil", new String[]{"fireEventImpl(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;"});
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "EventUtilAdapter.visitMethod(int,String,String,String,String[])", 1463).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ("fireEventImpl".equals(string) && "(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;".equals(string2)) {
                MethodVisitor methodVisitor = this.cv.visitMethod(n & 0xFFFFFFFD | 1, "_qf_fireEventImpl", string2, string3, stringArray);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "EventUtilAdapter.visitMethod(int,String,String,String,String[])", 1471).add("mv", (Object)methodVisitor)).log();
                }
                return methodVisitor;
            }
            return super.visitMethod(n, string, string2, string3, stringArray);
        }

        public void visitEnd() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "EventUtilAdapter.visitEnd()", 1484).log();
            }
            MethodVisitor methodVisitor = this.cv.visitMethod(10, "fireEventImpl", "(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;", null, null);
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "EventUtilAdapter.visitEnd()", 1491).add("mv", (Object)methodVisitor)).log();
            }
            methodVisitor.visitCode();
            methodVisitor.visitLdcInsn((Object)"com/sun/javafx/event/EventUtil-fireEventImpl-(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;");
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(6);
            methodVisitor.visitTypeInsn(189, "java/lang/Object");
            methodVisitor.visitInsn(89);
            methodVisitor.visitInsn(3);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitInsn(83);
            methodVisitor.visitInsn(89);
            methodVisitor.visitInsn(4);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitInsn(83);
            methodVisitor.visitInsn(89);
            methodVisitor.visitInsn(5);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitInsn(83);
            methodVisitor.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            methodVisitor.visitVarInsn(58, 3);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            Label label = new Label();
            methodVisitor.visitJumpInsn(166, label);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(184, "com/sun/javafx/event/EventUtil", "_qf_fireEventImpl", "(Ljavafx/event/EventDispatchChain;Ljavafx/event/EventTarget;Ljavafx/event/Event;)Ljavafx/event/Event;");
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(label);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitTypeInsn(192, "javafx/event/Event");
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            super.visitEnd();
        }
    }

    public static class InstrumentMethodEntryAdapter
    extends ClassVisitor
    implements Opcodes {
        protected String owner;
        protected boolean isInterface;
        protected String clazz;
        protected String[] methods;
        protected String method;
        protected String descriptor;
        protected boolean withConstructor;

        public InstrumentMethodEntryAdapter(ClassVisitor classVisitor, String string, String[] stringArray) {
            super(458752, classVisitor);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "InstrumentMethodEntryAdapter.InstrumentMethodEntryAdapter(ClassVisitor,String,String[])", 1170).addDetail("cv", (Object)classVisitor)).addDetail("clazz", string)).addDetail("methods", (Object)stringArray)).log();
            }
            this.clazz = string;
            this.methods = stringArray;
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.cv.visit(n, n2, string, string2, string3, stringArray);
            this.owner = string;
            this.isInterface = (n2 & 0x200) != 0;
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MethodVisitor methodVisitor;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "InstrumentMethodEntryAdapter.visitMethod(int,String,String,String,String[])", 1227).addDetail("access", n)).addDetail("name", string)).addDetail("desc", string2)).addDetail("signature", string3)).addDetail("exceptions", (Object)stringArray)).log();
            }
            if ((methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray)) != null && string.equals("<init>")) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentMethodEntryAdapter.visitMethod(int,String,String,String,String[])", 1233).add("Got a constructor, owner", this.owner)).add("desc", string2)).log();
                }
                methodVisitor = new ConstructorAdapter(methodVisitor, string2);
                return methodVisitor;
            }
            if (methodVisitor != null && string != null && string2 != null && !string.startsWith("<")) {
                for (String string4 : this.methods) {
                    String string5 = string + string2;
                    if (!string5.equals(string4) && (!string4.startsWith("RE=") || !string5.matches(string4.substring(3)))) continue;
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentMethodEntryAdapter.visitMethod(int,String,String,String,String[])", 1246).add("Got the method, owner", this.owner)).add("name", string)).add("desc", string2)).log();
                    }
                    this.method = string;
                    this.descriptor = string2;
                    methodVisitor = this.createMethodAdapter(methodVisitor, this.clazz, string2, (n & 8) != 0);
                    break;
                }
            }
            return methodVisitor;
        }

        public boolean handles(String string) {
            return this.clazz.equals(string);
        }

        protected MethodVisitor createMethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
            return new MethodAdapter(methodVisitor, string, string2, bl);
        }

        class MethodAdapter
        extends MethodVisitor {
            protected String clazz;
            protected String desc;
            protected boolean isStatic;

            public MethodAdapter(MethodVisitor methodVisitor, String string, String string2, boolean bl) {
                super(458752, methodVisitor);
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "InstrumentMethodEntryAdapter.MethodAdapter.MethodAdapter(MethodVisitor,String,String,boolean)", 1338).addDetail("mv", (Object)methodVisitor)).addDetail("clazz", string)).addDetail("desc", string2)).addDetail("isStatic", bl)).log();
                }
                this.clazz = string;
                this.desc = string2;
                this.isStatic = bl;
            }

            public void visitCode() {
                super.visitCode();
                this.mv.visitLdcInsn((Object)(this.clazz + "-" + InstrumentMethodEntryAdapter.this.method + "-" + InstrumentMethodEntryAdapter.this.descriptor));
                if (this.isStatic) {
                    this.mv.visitInsn(1);
                } else {
                    this.mv.visitVarInsn(25, 0);
                }
                InstanceTraceTransformer.createParamArray(this.mv, this.desc, this.isStatic);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodCalled", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                Label label = new Label();
                this.mv.visitJumpInsn(165, label);
                InstanceTraceTransformer.createReturn(this.mv, this.desc);
                this.mv.visitLabel(label);
                this.mv.visitInsn(87);
            }

            public void visitInsn(int n) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "InstrumentMethodEntryAdapter.MethodAdapter.visitInsn(int)", 1387).addDetail("opcode", n)).log();
                }
                if (n == 176) {
                    Type type = Type.getReturnType((String)this.desc);
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentMethodEntryAdapter.MethodAdapter.visitInsn(int)", 1391).add("type", (Object)type)).log();
                    }
                    if (type.getSort() == 10) {
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentMethodEntryAdapter.MethodAdapter.visitInsn(int)", 1394).add("Adding return call to InstanceTracer")).log();
                        }
                        this.mv.visitVarInsn(58, 1);
                        String string = this.clazz + "-" + InstrumentMethodEntryAdapter.this.method + "-" + this.desc;
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentMethodEntryAdapter.MethodAdapter.visitInsn(int)", 1397).add("mtd", string)).log();
                        }
                        this.mv.visitLdcInsn((Object)string);
                        if (this.isStatic) {
                            this.mv.visitInsn(1);
                        } else {
                            this.mv.visitVarInsn(25, 0);
                        }
                        this.mv.visitVarInsn(25, 1);
                        this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "methodReturned", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentMethodEntryAdapter.MethodAdapter.visitInsn(int)", 1410).add("return type", Type.getReturnType((String)this.desc).getInternalName())).log();
                        }
                        this.mv.visitTypeInsn(192, Type.getReturnType((String)this.desc).getInternalName());
                    }
                }
                this.mv.visitInsn(n);
            }
        }
    }

    public class InstrumentConstructorAdapter
    extends ClassVisitor
    implements Opcodes {
        private String owner;
        private boolean isInterface;

        public InstrumentConstructorAdapter(ClassVisitor classVisitor) {
            super(458752, classVisitor);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "InstrumentConstructorAdapter.InstrumentConstructorAdapter(ClassVisitor)", 1047).addDetail("cv", (Object)classVisitor)).log();
            }
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.cv.visit(n, n2, string, string2, string3, stringArray);
            this.owner = string;
            this.isInterface = (n2 & 0x200) != 0;
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
            if (methodVisitor != null && string.equals("<init>")) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "InstrumentConstructorAdapter.visitMethod(int,String,String,String,String[])", 1109).add("Got a constructor, owner", this.owner)).add("desc", string2)).log();
                }
                methodVisitor = new ConstructorAdapter(methodVisitor, string2);
            }
            return methodVisitor;
        }
    }

    static class ConstructorAdapter
    extends MethodVisitor {
        private String desc;

        public ConstructorAdapter(MethodVisitor methodVisitor, String string) {
            super(458752, methodVisitor);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ConstructorAdapter.ConstructorAdapter(MethodVisitor,String)", 961).addDetail("mv", (Object)methodVisitor)).addDetail("desc", string)).log();
            }
            this.desc = string;
        }

        public void visitInsn(int n) {
            if (n == 177) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ConstructorAdapter.visitInsn(int)", 992).add("Adding call to InstanceTracer")).log();
                }
                this.mv.visitVarInsn(25, 0);
                InstanceTraceTransformer.createParamArray(this.mv, this.desc, false);
                this.mv.visitMethodInsn(184, "de/qfs/apps/qftest/instrument/InstanceTracer", "instanceCreated", "(Ljava/lang/Object;[Ljava/lang/Object;)V");
            }
            this.mv.visitInsn(n);
        }

        public void XXXvisitMaxs(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ConstructorAdapter.XXXvisitMaxs(int,int)", 1012).addDetail("maxStack", n)).addDetail("maxLocals", n2)).log();
            }
            this.mv.visitMaxs(n + 4, n2);
        }
    }
}

