/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    long modelHandle;
    static final int TEXT_COLUMN = 0;

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (l == 0L) {
            this.error(14);
        }
        OS.gtk_list_store_append(this.modelHandle, l);
        OS.gtk_list_store_set(this.modelHandle, l, 0, byArray, -1L);
        OS.g_free(l);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > n || n > n2) {
            this.error(6);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (l == 0L) {
            this.error(14);
        }
        if (n == n2) {
            OS.gtk_list_store_append(this.modelHandle, l);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, l, n);
        }
        OS.gtk_list_store_set(this.modelHandle, l, 0, byArray, -1L);
        OS.g_free(l);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    void createHandle(int n) {
        long l;
        long l2;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = new long[]{OS.G_TYPE_STRING()};
        this.modelHandle = OS.gtk_list_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((l2 = OS.gtk_cell_renderer_text_new()) == 0L) {
            this.error(2);
        }
        if ((l = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_tree_view_column_pack_start(l, l2, true);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.text, 0);
        OS.gtk_tree_view_column_set_min_width(l, 0);
        OS.gtk_tree_view_insert_column(this.handle, l, n);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(l3, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.getShell().style & 0x4000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        OS.gtk_tree_selection_unselect_iter(l2, l);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n < 0 && n2 < 0) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n >= n3 && n2 >= n3) {
            return;
        }
        n = Math.min(n3 - 1, Math.max(0, n));
        n2 = Math.min(n3 - 1, Math.max(0, n2));
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            OS.gtk_tree_selection_unselect_iter(l2, l);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || n2 > n - 1) continue;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n2);
            OS.gtk_tree_selection_unselect_iter(l2, l);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void deselectAll() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = false;
        if (bl) {
            long[] lArray = new long[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    long l = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                        bl4 = true;
                    }
                    OS.gtk_tree_path_free(lArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl3 = super.dragDetect(n, n2, bl, false, blArray)) && bl4 && blArray != null) {
            blArray[0] = true;
        }
        return bl3;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getFocusIndex() {
        this.checkWidget();
        long[] lArray = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return -1;
        }
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[]{-1};
        if (l != 0L) {
            OS.memmove(nArray, l, 4L);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return nArray[0];
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long[] lArray = new long[1];
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        OS.gtk_tree_model_get(this.modelHandle, l, 0, lArray, -1L);
        OS.g_free(l);
        if (lArray[0] == 0L) {
            return null;
        }
        int n2 = OS.strlen(lArray[0]);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, lArray[0], (long)n2);
        OS.g_free(lArray[0]);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        if (n == 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, nArray2);
            return nArray2[0];
        }
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, l2);
        OS.gtk_tree_view_column_cell_set_cell_data(l, this.modelHandle, l2, false, false);
        int[] nArray = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, nArray3);
        OS.g_free(l2);
        return nArray3[0];
    }

    public String[] getItems() {
        this.checkWidget();
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long[] lArray = new long[1];
        String[] stringArray = new String[n];
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        for (int i = 0; i < n; ++i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            OS.gtk_tree_model_get(this.modelHandle, l, 0, lArray, -1L);
            if (lArray[0] == 0L) continue;
            int n2 = OS.strlen(lArray[0]);
            byte[] byArray = new byte[n2];
            OS.memmove(byArray, lArray[0], (long)n2);
            OS.g_free(lArray[0]);
            stringArray[i] = new String(Converter.mbcsToWcs(null, byArray));
        }
        OS.g_free(l);
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getItem(nArray[i]);
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(l);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.gtk_tree_selection_get_selected_rows(l, null);
        if (l2 != 0L) {
            int n = OS.g_list_length(l2);
            int[] nArray = new int[1];
            for (int i = 0; i < n; ++i) {
                long l3 = OS.g_list_nth_data(l2, i);
                long l4 = OS.gtk_tree_path_get_indices(l3);
                if (l4 != 0L) {
                    OS.memmove(nArray, l4, 4L);
                    for (int j = i; j < n; ++j) {
                        l3 = OS.g_list_nth_data(l2, j);
                        OS.gtk_tree_path_free(l3);
                    }
                    break;
                }
                OS.gtk_tree_path_free(l3);
            }
            OS.g_list_free(l2);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.gtk_tree_selection_get_selected_rows(l, null);
        if (l2 != 0L) {
            int n = OS.g_list_length(l2);
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l3 = OS.g_list_nth_data(l2, i);
                long l4 = OS.gtk_tree_path_get_indices(l3);
                if (l4 != 0L) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, l4, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                OS.gtk_tree_path_free(l3);
            }
            OS.g_list_free(l2);
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            return nArray3;
        }
        return new int[0];
    }

    public int getTopIndex() {
        this.checkWidget();
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return 0;
        }
        if (lArray[0] == 0L) {
            return 0;
        }
        long l = OS.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[1];
        if (l != 0L) {
            OS.memmove(nArray, l, 4L);
        }
        OS.gtk_tree_path_free(lArray[0]);
        return nArray[0];
    }

    long gtk_changed(long l) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        switch (OS.GDK_EVENT_TYPE(l2)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) != 0) break;
                this.gtk_expose_event(l, l2);
            }
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_button_press_event(long l, long l2) {
        long l3;
        long[] lArray;
        long l4 = super.gtk_button_press_event(l, l2);
        if (l4 != 0L) {
            return l4;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        int n = gdkEventButton.button;
        if (n == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(l3, lArray[0])) {
                l4 = 1L;
            }
            OS.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(lArray[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return l4;
    }

    long gtk_popup_menu(long l) {
        long l2 = super.gtk_popup_menu(l);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1L : l2;
    }

    long gtk_row_activated(long l, long l2, long l3) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] stringArray = this.getItems();
        for (int i = n; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(null, Integer.toString(n), true);
        long l2 = OS.gtk_tree_path_new_from_string(byArray);
        boolean bl = OS.gtk_tree_selection_path_is_selected(l, l2);
        OS.gtk_tree_path_free(l2);
        return bl;
    }

    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_remove(this.modelHandle, l);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n2; i >= n; --i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            OS.gtk_list_store_remove(this.modelHandle, l);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = this.getItemCount();
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        int n4 = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            int n5 = nArray2[i];
            if (n5 == n4) continue;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n5);
            OS.gtk_list_store_remove(this.modelHandle, l);
            n4 = n5;
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void removeAll() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        OS.gtk_tree_selection_select_iter(l2, l);
        if ((this.style & 4) != 0) {
            long l3 = OS.gtk_tree_model_get_path(this.modelHandle, l);
            OS.gtk_tree_view_set_cursor(this.handle, l3, 0L, false);
            OS.gtk_tree_path_free(l3);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            OS.gtk_tree_selection_select_iter(l2, l);
            if ((this.style & 4) == 0) continue;
            long l3 = OS.gtk_tree_model_get_path(this.modelHandle, l);
            OS.gtk_tree_view_set_cursor(this.handle, l3, 0L, false);
            OS.gtk_tree_path_free(l3);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (0 > n3 || n3 >= n2) continue;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n3);
            OS.gtk_tree_selection_select_iter(l2, l);
            if ((this.style & 4) == 0) continue;
            long l3 = OS.gtk_tree_model_get_path(this.modelHandle, l);
            OS.gtk_tree_view_set_cursor(this.handle, l3, 0L, false);
            OS.gtk_tree_path_free(l3);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
    }

    void selectFocusIndex(int n) {
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > n || n >= n2) {
            return;
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, l);
        long l3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
        OS.gtk_tree_selection_select_iter(l3, l);
        OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_path_free(l2);
        OS.g_free(l);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) == 0) {
            this.redraw(false);
        }
        return n5;
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        OS.gtk_list_store_set(this.modelHandle, l, 0, byArray, -1L);
        OS.g_free(l);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            this.error(5);
        }
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(14);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_list_store_append(this.modelHandle, l2);
            OS.gtk_list_store_set(this.modelHandle, l2, 0, byArray, -1L);
        }
        OS.g_free(l2);
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = true;
        block0: for (int i = 0; i < n; ++i) {
            int n2 = 0;
            String string = stringArray[i];
            if (string == null) continue;
            while ((n2 = this.indexOf(string, n2)) != -1) {
                if ((this.style & 2) != 0) {
                    if (bl) {
                        bl = false;
                        this.selectFocusIndex(n2);
                    } else {
                        this.select(n2);
                    }
                } else {
                    this.selectFocusIndex(n2);
                    continue block0;
                }
                ++n2;
            }
        }
        this.showSelection();
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, l);
        OS.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, l2, 0L, gdkRectangle);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle.x, gdkRectangle.y, nArray, nArray2);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        }
        OS.gtk_tree_path_free(l2);
        OS.g_free(l);
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n == -1) {
            return;
        }
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, l);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, l2, 0L, gdkRectangle2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        } else {
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        }
        if (nArray2[0] < gdkRectangle.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        } else {
            int n2 = Math.min(gdkRectangle.height, gdkRectangle2.height);
            if (nArray2[0] + n2 > gdkRectangle.y + gdkRectangle.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 1.0f, 0.0f);
                nArray2[0] = nArray2[0] + (gdkRectangle2.height - gdkRectangle.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
            }
        }
        OS.gtk_tree_path_free(l2);
        OS.g_free(l);
    }
}

