/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        boolean bl;
        GdkRGBA gdkRGBA;
        GdkColor gdkColor;
        long l;
        long l2;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        long l3 = 0L;
        l3 = GTK.GTK_VERSION >= OS.VERSION(3, 4, 0) ? GTK.gtk_color_chooser_dialog_new((byte[])byArray, (long)this.parent.topHandle()) : GTK.gtk_color_selection_dialog_new((byte[])byArray);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l4 = 0L;
        if (GTK.GTK_VERSION <= OS.VERSION(3, 4, 0)) {
            if (this.parent != null) {
                l2 = this.parent.topHandle();
                GTK.gtk_window_set_transient_for((long)l3, (long)l2);
                l = GTK.gtk_window_get_icon_list((long)l2);
                if (l != 0L) {
                    GTK.gtk_window_set_icon_list((long)l3, (long)l);
                    OS.g_list_free(l);
                }
            }
            l2 = GTK.gtk_window_get_group((long)0L);
            GTK.gtk_window_group_add_window((long)l2, (long)l3);
            GTK.gtk_window_set_modal((long)l3, (boolean)true);
            l4 = GTK.gtk_color_selection_dialog_get_color_selection((long)l3);
            if (this.rgb != null) {
                gdkColor = new GdkColor();
                gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
                gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
                gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
                GTK.gtk_color_selection_set_current_color((long)l4, (GdkColor)gdkColor);
            }
            GTK.gtk_color_selection_set_has_palette((long)l4, (boolean)true);
        } else {
            gdkRGBA = new GdkRGBA();
            if (this.rgb != null) {
                gdkRGBA.red = (double)this.rgb.red / 255.0;
                gdkRGBA.green = (double)this.rgb.green / 255.0;
                gdkRGBA.blue = (double)this.rgb.blue / 255.0;
                gdkRGBA.alpha = 1.0;
            }
            GTK.gtk_color_chooser_set_rgba((long)l3, (GdkRGBA)gdkRGBA);
        }
        display.runDialogShownHooks(this, l3);
        if (this.rgbs != null) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                int n = 9;
                long l5 = OS.g_malloc(GdkRGBA.sizeof * this.rgbs.length);
                gdkRGBA = new GdkRGBA();
                for (int i = 0; i < this.rgbs.length; ++i) {
                    RGB rGB = this.rgbs[i];
                    if (rGB == null) continue;
                    gdkRGBA.red = (double)rGB.red / 255.0;
                    gdkRGBA.green = (double)rGB.green / 255.0;
                    gdkRGBA.blue = (double)rGB.blue / 255.0;
                    OS.memmove(l5 + (long)(i * GdkRGBA.sizeof), gdkRGBA, (long)GdkRGBA.sizeof);
                }
                GTK.gtk_color_chooser_add_palette((long)l3, (int)0, (int)n, (int)this.rgbs.length, (long)l5);
                GTK.gtk_color_chooser_set_rgba((long)l3, (GdkRGBA)gdkRGBA);
                if (GTK.gtk_color_chooser_get_use_alpha((long)l3)) {
                    GTK.gtk_color_chooser_set_use_alpha((long)l3, (boolean)false);
                }
                OS.g_free(l5);
            } else {
                l2 = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
                for (int i = 0; i < this.rgbs.length; ++i) {
                    RGB rGB = this.rgbs[i];
                    if (rGB == null) continue;
                    gdkColor = new GdkColor();
                    gdkColor.red = (short)(rGB.red & 0xFF | (rGB.red & 0xFF) << 8);
                    gdkColor.green = (short)(rGB.green & 0xFF | (rGB.green & 0xFF) << 8);
                    gdkColor.blue = (short)(rGB.blue & 0xFF | (rGB.blue & 0xFF) << 8);
                    OS.memmove(l2 + (long)(i * GdkColor.sizeof), gdkColor, (long)GdkColor.sizeof);
                }
                l = GTK.gtk_color_selection_palette_to_string((long)l2, (int)this.rgbs.length);
                int n = C.strlen((long)l);
                byArray = new byte[n];
                C.memmove((byte[])byArray, (long)l, (long)n);
                String string = new String(Converter.mbcsToWcs((byte[])byArray));
                byArray = Converter.wcsToMbcs((String)string, (boolean)true);
                OS.g_free(l2);
                long l6 = GTK.gtk_settings_get_default();
                if (l6 != 0L) {
                    GTK.gtk_settings_set_string_property((long)l6, (byte[])GTK.gtk_color_palette, (byte[])byArray, (byte[])Converter.wcsToMbcs((String)"gtk_color_selection_palette_to_string", (boolean)true));
                }
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (GTK.gtk_window_get_modal((long)l3)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l3, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int n2 = GTK.gtk_dialog_run((long)l3);
        GDK.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l);
        }
        if (GTK.gtk_window_get_modal((long)l3)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (GTK.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                gdkRGBA = new GdkRGBA();
                GTK.gtk_color_chooser_get_rgba((long)l3, (GdkRGBA)gdkRGBA);
                n3 = (int)(gdkRGBA.red * 255.0);
                n4 = (int)(gdkRGBA.green * 255.0);
                n5 = (int)(gdkRGBA.blue * 255.0);
            } else {
                gdkColor = new GdkColor();
                GTK.gtk_color_selection_get_current_color((long)l4, (GdkColor)gdkColor);
                n3 = gdkColor.red >> 8 & 0xFF;
                n4 = gdkColor.green >> 8 & 0xFF;
                n5 = gdkColor.blue >> 8 & 0xFF;
                long l7 = GTK.gtk_settings_get_default();
                if (l7 != 0L) {
                    long[] lArray = new long[1];
                    OS.g_object_get(l7, GTK.gtk_color_palette, lArray, 0L);
                    if (lArray[0] != 0L) {
                        int n6 = C.strlen((long)lArray[0]);
                        byArray = new byte[n6];
                        C.memmove((byte[])byArray, (long)lArray[0], (long)n6);
                        OS.g_free(lArray[0]);
                        String[] stringArray = null;
                        if (n6 > 0) {
                            String string = new String(Converter.mbcsToWcs((byte[])byArray));
                            stringArray = ColorDialog.splitString(string, ':');
                            n6 = stringArray.length;
                        }
                        this.rgbs = new RGB[n6];
                        for (int i = 0; i < n6; ++i) {
                            String string = stringArray[i];
                            byArray = Converter.wcsToMbcs((String)string, (boolean)true);
                            GDK.gdk_color_parse((byte[])byArray, (GdkColor)gdkColor);
                            int n7 = gdkColor.red >> 8 & 0xFF;
                            int n8 = gdkColor.green >> 8 & 0xFF;
                            int n9 = gdkColor.blue >> 8 & 0xFF;
                            this.rgbs[i] = new RGB(n7, n8, n9);
                        }
                    }
                }
            }
            this.rgb = new RGB(n3, n4, n5);
        }
        this.rgb = (RGB)display.runDialogClosedHooks(this, bl ? this.rgb : null);
        if (this.rgb != null) {
            bl = true;
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy((long)l3);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

