/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    long menuHandle;
    long buttonBoxHandle;
    long cellBoxHandle;
    int lastEventTime;
    int visibleCount = 10;
    long imContext;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    int indexSelected;
    GdkRGBA background;
    public static final int LIMIT = 65535;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Text");

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n > this.items.length) {
            this.error(6);
        }
        String[] stringArray = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.items, n, stringArray, n + 1, this.items.length - n);
        this.items = stringArray;
        byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert((long)this.handle, (int)n, null, (byte[])byArray);
            }
        } else if (this.handle != 0L) {
            GTK.gtk_combo_box_text_insert_text((long)this.handle, (int)n, (byte[])byArray);
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK.gtk_container_forall((long)this.popupHandle, (long)this.display.setDirectionProc, (long)2L);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, (Listener)new TypedListener((SWTEventListener)segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)verifyListener);
        this.addListener(25, (Listener)typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits((int)n, (int)4, (int)64, (int)0, (int)0, (int)0, (int)0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int n = GTK.gtk_editable_get_position((long)this.entryHandle);
            GTK.gtk_editable_select_region((long)this.entryHandle, (int)n, (int)n);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0) {
            int n = GTK.gtk_combo_box_get_active((long)this.handle);
            if (n != -1) {
                long l = GTK.gtk_combo_box_get_model((long)this.handle);
                long[] lArray = new long[1];
                long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child((long)l, (long)l2, (long)0L, (int)n);
                GTK.gtk_tree_model_get((long)l, (long)l2, (int)0, (long[])lArray, (int)-1);
                OS.g_free(l2);
                if (lArray[0] != 0L && C.strlen((long)lArray[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(lArray[0]);
            }
        } else {
            GTK.gtk_entry_set_text((long)this.entryHandle, (byte[])new byte[1]);
        }
        GTK.gtk_combo_box_set_active((long)this.handle, (int)-1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
    }

    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0 || GTK.GTK3) {
            return this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_widget_realize((long)this.entryHandle);
        long l = GTK.gtk_entry_get_layout((long)this.entryHandle);
        OS.pango_layout_get_pixel_size(l, nArray, nArray2);
        int n3 = 2;
        int n4 = 2;
        Point point = this.getThickness(this.entryHandle);
        n3 += point.x;
        n4 += point.y;
        int[] nArray3 = new int[1];
        GTK.gtk_widget_style_get((long)this.entryHandle, (byte[])OS.interior_focus, (int[])nArray3, (long)0L);
        if (nArray3[0] == 0) {
            GTK.gtk_widget_style_get((long)this.entryHandle, (byte[])OS.focus_line_width, (int[])nArray3, (long)0L);
            n3 += nArray3[0];
            n4 += nArray3[0];
        }
        int n5 = nArray[0] + n3 * 2;
        int n6 = nArray2[0] + n4 * 2;
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.buttonHandle, gtkRequisition);
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        long l2 = GTK.gtk_bin_get_child((long)this.popupHandle);
        this.gtk_widget_get_preferred_size(l2, gtkRequisition2);
        n5 = Math.max(gtkRequisition2.width, n5) + gtkRequisition.width;
        n5 = n == -1 ? n5 : n;
        n6 = n2 == -1 ? n6 : n2;
        return new Point(n5, n6);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_copy_clipboard((long)this.entryHandle);
        }
    }

    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window((long)this.fixedHandle, (boolean)true);
        long l = GTK.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = GTK.gtk_combo_box_text_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.cellHandle = GTK.gtk_bin_get_child((long)this.handle);
            if (this.cellHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_combo_box_set_wrap_width((long)this.handle, (int)1);
        } else {
            this.handle = GTK.gtk_combo_box_text_new_with_entry();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.entryHandle = GTK.gtk_bin_get_child((long)this.handle);
            if (this.entryHandle == 0L) {
                this.error(2);
            }
            if (GTK.GTK3) {
                this.imContext = OS.imContextLast();
            }
        }
        this.popupHandle = this.findPopupHandle(l);
        GTK.gtk_container_add((long)this.fixedHandle, (long)this.handle);
        this.textRenderer = GTK.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0L) {
            this.error(2);
        }
        int n2 = 0;
        OS.g_object_set(this.textRenderer, OS.ypad, n2, 0L);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        GTK.gtk_cell_layout_clear((long)this.handle);
        this.display.setWarnings(bl);
        GTK.gtk_cell_layout_pack_start((long)this.handle, (long)this.textRenderer, (boolean)true);
        GTK.gtk_cell_layout_set_attributes((long)this.handle, (long)this.textRenderer, (byte[])OS.text, (int)0, (long)0L);
        this.menuHandle = this.findMenuHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
        }
        this.buttonHandle = this.findButtonHandle();
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
        }
        if (this.buttonBoxHandle != 0L) {
            OS.g_object_ref(this.buttonBoxHandle);
        }
        if (this.cellHandle != 0L) {
            this.cellBoxHandle = GTK.gtk_widget_get_parent((long)this.cellHandle);
        }
        if (this.cellBoxHandle != 0L) {
            OS.g_object_ref(this.cellBoxHandle);
        }
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            GTK.gtk_widget_set_receives_default((long)this.buttonHandle, (boolean)false);
        }
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_cut_clipboard((long)this.entryHandle);
        }
    }

    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handleRGBA;
    }

    void deregister() {
        long l;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0L) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    boolean filterKey(int n, long l) {
        int n2 = GDK.gdk_event_get_time((long)l);
        if (n2 != this.lastEventTime) {
            this.lastEventTime = n2;
            long l2 = this.imContext();
            if (l2 != 0L) {
                boolean bl = GTK.gtk_im_context_filter_keypress((long)l2, (long)l);
                if (Combo.logger.level >= 9) {
                    logger.build("filterKey(int,int)").add("ret: ").add(bl).log(9);
                }
                if (!bl && this.display.charOverrideHead > this.display.charOverrideTail) {
                    long l3 = this.display.charOverride[this.display.charOverrideTail++];
                    if (Combo.logger.level >= 9) {
                        logger.build("filterKey(int,int)").add("char override: ").addHex(l3).log(9);
                    }
                    char c = (char)(l3 >> 32 & 0xFFFFL);
                    byte[] byArray = Converter.wcsToMbcs((char[])new char[]{c}, (boolean)true);
                    long l4 = OS.g_malloc(byArray.length);
                    OS.memmove((long)l4, (byte[])byArray, (long)byArray.length);
                    this.gtk_commit(l2, l4);
                    OS.g_free(l4);
                    bl = true;
                }
                return bl;
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    long findPopupHandle(long l) {
        long l2 = 0L;
        long l3 = GTK.gtk_window_list_toplevels();
        long l4 = l;
        long l5 = OS.g_list_last(l3);
        while (l5 != 0L) {
            long l6 = OS.g_list_data(l5);
            boolean bl = false;
            l4 = l;
            while (l4 != 0L) {
                long l7 = OS.g_list_data(l4);
                if (l6 == l7) {
                    bl = true;
                    break;
                }
                l4 = OS.g_list_next(l4);
            }
            if (!bl) {
                l2 = l6;
                break;
            }
            l5 = OS.g_list_previous(l5);
        }
        OS.g_list_free(l);
        OS.g_list_free(l3);
        return l2;
    }

    long findButtonHandle() {
        long l;
        long l2;
        long l3 = 0L;
        long l4 = this.handle;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
            GTK.gtk_container_forall((long)this.handle, (long)this.display.allChildrenProc, (long)0L);
            if (this.display.allChildren != 0L) {
                l2 = this.display.allChildren;
                while (l2 != 0L) {
                    l = OS.g_list_data(l2);
                    if (l != 0L) {
                        l4 = l;
                        break;
                    }
                    l2 = OS.g_list_next(l2);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
            this.buttonBoxHandle = l4;
        }
        GTK.gtk_container_forall((long)l4, (long)this.display.allChildrenProc, (long)0L);
        if (this.display.allChildren != 0L) {
            l2 = this.display.allChildren;
            while (l2 != 0L) {
                l = OS.g_list_data(l2);
                if (GTK.GTK_IS_BUTTON((long)l)) {
                    l3 = l;
                    break;
                }
                l2 = OS.g_list_next(l2);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
        return l3;
    }

    long findMenuHandle() {
        if (this.popupHandle == 0L) {
            return 0L;
        }
        long l = 0L;
        GTK.gtk_container_forall((long)this.popupHandle, (long)this.display.allChildrenProc, (long)0L);
        if (this.display.allChildren != 0L) {
            long l2 = this.display.allChildren;
            while (l2 != 0L) {
                long l3 = OS.g_list_data(l2);
                if (OS.G_OBJECT_TYPE(l3) == GTK.GTK_TYPE_MENU()) {
                    l = l3;
                    break;
                }
                l2 = OS.g_list_next(l2);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
        return l;
    }

    void fixModal(long l, long l2) {
        if (this.popupHandle != 0L) {
            if (l != 0L) {
                GTK.gtk_window_group_add_window((long)l, (long)this.popupHandle);
            } else if (l2 != 0L) {
                GTK.gtk_window_group_remove_window((long)l2, (long)this.popupHandle);
            }
        }
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            GTK.gtk_im_context_filter_keypress((long)l, (long)this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    long focusHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0L && GTK.gtk_widget_has_focus((long)this.entryHandle);
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.getClosure(37), false);
        }
        this.hookEvents(new long[]{this.buttonHandle, this.entryHandle, this.menuHandle});
        long l = this.imContext();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.getClosure(9), false);
            int n = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.entryHandle);
        }
    }

    void hookEvents(long[] lArray) {
        int n = 772;
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            GTK.gtk_widget_add_events((long)l, (int)n);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(34), true);
            if (l != this.focusHandle()) {
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
            if (OS.G_OBJECT_TYPE(l) != GTK.GTK_TYPE_MENU()) continue;
            OS.g_signal_connect_closure(l, OS.selection_done, this.display.getClosure(68), true);
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return this.entryHandle != 0L ? GTK.GTK_ENTRY_IM_CONTEXT((long)this.entryHandle) : 0L;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (GTK.gtk_combo_box_get_active((long)this.handle) == n) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl && this.entryHandle != 0L) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = GTK.gtk_entry_get_layout((long)this.entryHandle);
            OS.pango_layout_xy_to_index(l, n * 1024, n2 * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            int n3 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.entryHandle, (int[])nArray3, (int[])nArray4);
            if (nArray3[0] <= n3 && n3 < nArray4[0] && super.dragDetect(n, n2, bl, bl2, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, bl2, blArray);
    }

    long enterExitHandle() {
        return this.fixedHandle;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getBaseGdkColor();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int n = GTK.gtk_editable_get_position((long)this.entryHandle);
        n = GTK.gtk_entry_text_index_to_layout_index((long)this.entryHandle, (int)n);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_entry_get_layout_offsets((long)this.entryHandle, (int[])nArray, (int[])nArray2);
        long l = GTK.gtk_entry_get_layout((long)this.entryHandle);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(l, n, pangoRectangle);
        int n2 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidthInPixels();
        int n3 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
        return new Point(n2, n3);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        long l = GTK.gtk_entry_get_text((long)this.entryHandle);
        return (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_editable_get_position((long)this.entryHandle));
    }

    GdkRGBA getContextBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    GdkColor getForegroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.items.length];
        System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0L && GTK.gtk_widget_get_visible((long)this.popupHandle);
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int n = 0;
            int n2 = GTK.gtk_combo_box_get_active((long)this.handle);
            if (n2 != -1) {
                n = this.getItem(n2).length();
            }
            return new Point(0, n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_get_selection_bounds((long)this.entryHandle, (int[])nArray, (int[])nArray2);
            long l = GTK.gtk_entry_get_text((long)this.entryHandle);
            nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
            nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return GTK.gtk_combo_box_get_active((long)this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long l = GTK.gtk_entry_get_text((long)this.entryHandle);
            if (l == 0L) {
                return "";
            }
            int n = C.strlen((long)l);
            byte[] byArray = new byte[n];
            C.memmove((byte[])byArray, (long)l, (long)n);
            return new String(Converter.mbcsToWcs((byte[])byArray));
        }
        int n = GTK.gtk_combo_box_get_active((long)this.handle);
        return n != -1 ? this.getItem(n) : "";
    }

    String getText(int n, int n2) {
        return this.getText().substring(n, n2 - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        this.checkWidget();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, gtkRequisition);
        if (GTK.GTK3) {
            return gtkRequisition.height;
        }
        return GTK.GTK_WIDGET_REQUISITION_HEIGHT((long)this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = this.entryHandle != 0L ? GTK.gtk_entry_get_max_length((long)this.entryHandle) : 0;
        return n == 0 ? LIMIT : n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    long gtk_button_press_event(long l, long l2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.type == 4 && gdkEventButton.button == 1) {
            return this.gtk_button_press_event(l, l2, false);
        }
        return super.gtk_button_press_event(l, l2);
    }

    long gtk_changed(long l) {
        if (l == this.handle) {
            int n;
            if (this.entryHandle == 0L) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0L;
                }
            }
            if ((n = GTK.gtk_combo_box_get_active((long)this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0L;
        }
        boolean bl = false;
        long l2 = GTK.gtk_get_current_event();
        if (l2 != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            GDK.gdk_event_free((long)l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (!GTK.gtk_editable_get_editable((long)this.entryHandle)) {
            return 0L;
        }
        int n = C.strlen((long)l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        C.memmove((byte[])byArray, (long)l2, (long)n);
        char[] cArray = Converter.mbcsToWcs((byte[])byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs((char[])cArray2, (boolean)true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position((long)this.entryHandle, (int)this.fixStart);
            GTK.gtk_editable_select_region((long)this.entryHandle, (int)this.fixStart, (int)this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long l4 = GTK.gtk_entry_get_text((long)this.entryHandle);
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text((long)this.entryHandle, (byte[])byArray, (int)byArray.length, (int[])nArray);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position((long)this.entryHandle, (int)nArray[0]);
        }
        return 0L;
    }

    long gtk_draw(long l, long l2) {
        long l3;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) && (this.style & 8) != 0 && this.parent != null && this.parent.fixClipHandle == 0L && (l3 = GTK.gtk_widget_get_parent((long)this.fixedHandle)) != 0L) {
            this.parent.fixClipHandle = l3;
            GTK.gtk_widget_queue_draw((long)l3);
            long[] lArray = new long[]{this.fixedHandle, this.handle, this.buttonBoxHandle, this.buttonHandle, this.cellBoxHandle, this.cellHandle};
            this.parent.fixClipHandleChildren = new long[lArray.length];
            System.arraycopy(lArray, 0, this.parent.fixClipHandleChildren, 0, lArray.length);
        }
        return super.gtk_draw(l, l2);
    }

    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 1) break;
                if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                    return 1L;
                }
                if ((this.style & 8) != 0 || l != this.buttonHandle) break;
                GTK.gtk_widget_grab_focus((long)this.entryHandle);
                break;
            }
            case 12: {
                if ((this.style & 8) != 0) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                if (gdkEventFocus.in != 0) {
                    if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                        GTK.gtk_widget_set_focus_on_click((long)this.handle, (boolean)false);
                        break;
                    }
                    GTK.gtk_combo_box_set_focus_on_click((long)this.handle, (boolean)false);
                    break;
                }
                if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                    GTK.gtk_widget_set_focus_on_click((long)this.handle, (boolean)true);
                    break;
                }
                GTK.gtk_combo_box_set_focus_on_click((long)this.handle, (boolean)true);
            }
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        int n;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        C.memmove((byte[])byArray, (long)l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs((byte[])byArray));
        int[] nArray = new int[1];
        C.memmove((int[])nArray, (long)l4, (long)4L);
        long l5 = GTK.gtk_entry_get_text((long)this.entryHandle);
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf8_offset_to_utf16_offset(l5, nArray[0]), n)) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.entryHandle, (int[])nArray2, (int[])nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection((long)this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs((String)string, (boolean)false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text((long)this.entryHandle, (byte[])byArray2, (int)byArray2.length, (int[])nArray);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            C.memmove((long)l4, (int[])nArray, (long)4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.gdkEventKey = 0L;
            this.fixIM();
            return l3;
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        if ((this.style & 8) == 0) {
            int n;
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            int n2 = n = GTK.gtk_combo_box_get_active((long)this.handle);
            int n3 = gdkEventKey.keyval;
            switch (n3) {
                case 65364: 
                case 65433: {
                    if (n == this.items.length - 1) break;
                    n2 = n + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (n == -1 || n == 0) break;
                    n2 = n - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    n2 = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    n2 = this.items.length - 1;
                }
            }
            if (n2 != n) {
                GTK.gtk_combo_box_set_active((long)this.handle, (int)n2);
                return 1L;
            }
        }
        return l3;
    }

    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction((long)l2, (int)2);
            GTK.gtk_container_forall((long)l2, (long)this.display.setDirectionProc, (long)2L);
        }
        return 0L;
    }

    long gtk_selection_done(long l) {
        int n = GTK.gtk_combo_box_get_active((long)this.handle);
        if (this.indexSelected == -1) {
            this.indexSelected = n;
        } else if (n != -1 && this.indexSelected == n) {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    long gtk_style_set(long l, long l2) {
        this.setButtonHandle(this.findButtonHandle());
        this.setMenuHandle(this.findMenuHandle());
        return super.gtk_style_set(l, l2);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            return -1;
        }
        for (int i = n; i < this.items.length; ++i) {
            if (!string.equals(this.items[i])) continue;
            return i;
        }
        return -1;
    }

    boolean isFocusHandle(long l) {
        if (this.buttonHandle != 0L && l == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0L && l == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(l);
    }

    long paintWindow() {
        long l = this.entryHandle != 0L ? this.entryHandle : this.handle;
        GTK.gtk_widget_realize((long)l);
        long l2 = this.gtk_widget_get_window(l);
        if ((this.style & 8) != 0) {
            return l2;
        }
        long l3 = GDK.gdk_window_get_children((long)l2);
        if (l3 != 0L) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                do {
                    l2 = OS.g_list_data(l3);
                } while ((l3 = OS.g_list_next(l3)) != 0L);
            } else {
                l2 = OS.g_list_data(l3);
            }
        }
        OS.g_list_free(l3);
        return l2;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_paste_clipboard((long)this.entryHandle);
        }
    }

    long parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        long l;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, (Widget)((Object)this));
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, (Widget)((Object)this));
        }
        if (this.popupHandle != 0L) {
            this.display.addWidget(this.popupHandle, (Widget)((Object)this));
        }
        if (this.menuHandle != 0L) {
            this.display.addWidget(this.menuHandle, (Widget)((Object)this));
        }
        if ((l = this.imContext()) != 0L) {
            this.display.addWidget(l, (Widget)((Object)this));
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
        }
        if (this.buttonHandle != 0L) {
            OS.g_object_unref(this.buttonHandle);
        }
        if (this.buttonBoxHandle != 0L) {
            OS.g_object_unref(this.buttonBoxHandle);
        }
        if (this.cellBoxHandle != 0L) {
            OS.g_object_unref(this.cellBoxHandle);
        }
        this.entryHandle = 0L;
        this.buttonHandle = 0L;
        this.menuHandle = 0L;
        this.buttonBoxHandle = 0L;
        this.cellBoxHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
        this.items = stringArray2;
        if (GTK.gtk_combo_box_get_active((long)this.handle) == n) {
            this.clearText();
        }
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove((long)this.handle, (int)n);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - (n2 - n + 1)];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n2 + 1, stringArray2, n, stringArray.length - n2 - 1);
        this.items = stringArray2;
        int n3 = GTK.gtk_combo_box_get_active((long)this.handle);
        if (n <= n3 && n3 <= n2) {
            this.clearText();
        }
        for (int i = n2; i >= n; --i) {
            if (this.handle == 0L) continue;
            GTK.gtk_combo_box_text_remove((long)this.handle, (int)i);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.items.length;
        this.items = new String[0];
        this.clearText();
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove_all((long)this.handle);
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (this.handle == 0L) continue;
                GTK.gtk_combo_box_text_remove((long)this.handle, (int)i);
            }
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, (SWTEventListener)modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, (SWTEventListener)segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, (SWTEventListener)selectionListener);
        this.eventTable.unhook(14, (SWTEventListener)selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, (SWTEventListener)verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        int n2 = GTK.gtk_combo_box_get_active((long)this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_combo_box_set_active((long)this.handle, (int)n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0 && n2 != n) {
            this.sendEvent(24);
        }
    }

    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        this.background = gdkRGBA;
        String string = "* {\n";
        String string2 = gdkRGBA != null ? this.display.gtk_rgba_to_css_string(gdkRGBA) : ((this.style & 8) != 0 ? this.display.gtk_rgba_to_css_string(this.display.COLOR_WIDGET_BACKGROUND_RGBA) : this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA));
        this.cssBackground = string = string + "background: " + string2 + ";}";
        String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        if (this.entryHandle == 0L || (this.style & 8) != 0) {
            this.gtk_css_provider_load_from_css(GTK.gtk_widget_get_style_context((long)this.buttonHandle), string3);
        } else if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.gtk_css_provider_load_from_css(GTK.gtk_widget_get_style_context((long)this.entryHandle), string3);
        } else {
            this.setBackgroundGradientGdkRGBA(GTK.gtk_widget_get_style_context((long)this.entryHandle), l2, gdkRGBA);
            super.setBackgroundGdkRGBA(GTK.gtk_widget_get_style_context((long)this.entryHandle), this.entryHandle, gdkRGBA);
        }
        OS.g_object_set(this.textRenderer, OS.background_rgba, gdkRGBA, 0L);
    }

    void setBackgroundGdkRGBA(GdkRGBA gdkRGBA) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        super.setBackgroundGdkRGBA(gdkRGBA);
        if (this.entryHandle != 0L) {
            this.setBackgroundGdkRGBA(this.entryHandle, gdkRGBA);
        }
        this.setBackgroundGdkRGBA(this.fixedHandle, gdkRGBA);
    }

    void setBackgroundGdkColor(GdkColor gdkColor) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(gdkColor);
        if (this.entryHandle != 0L) {
            GTK.gtk_widget_modify_base((long)this.entryHandle, (int)0, (GdkColor)gdkColor);
        }
        if (this.cellHandle != 0L) {
            OS.g_object_set(this.cellHandle, OS.background_gdk, gdkColor, 0L);
        }
        OS.g_object_set(this.textRenderer, OS.background_gdk, gdkColor, 0L);
        if (this.entryHandle != 0L) {
            this.setBackgroundGdkColor(this.entryHandle, gdkColor);
        }
        this.setBackgroundGdkColor(this.fixedHandle, gdkColor);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = n4;
        if (bl2) {
            n5 = Math.max(this.getTextHeightInPixels(), n4);
        }
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    void setButtonHandle(long l) {
        if (this.buttonHandle == l) {
            return;
        }
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
            OS.g_object_unref(this.buttonHandle);
        }
        this.buttonHandle = l;
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
            this.display.addWidget(this.buttonHandle, (Widget)((Object)this));
            this.hookEvents(new long[]{this.buttonHandle});
        }
    }

    void setMenuHandle(long l) {
        if (this.menuHandle == l) {
            return;
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
            OS.g_object_unref(this.menuHandle);
        }
        this.menuHandle = l;
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
            this.display.addWidget(this.menuHandle, (Widget)((Object)this));
            this.hookEvents(new long[]{this.menuHandle});
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (this.entryHandle != 0L) {
            this.setFontDescription(this.entryHandle, l);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, l, 0L);
        if ((this.style & 8) != 0) {
            int n = GTK.gtk_combo_box_get_active((long)this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_combo_box_set_active((long)this.handle, (int)-1);
            GTK.gtk_combo_box_set_active((long)this.handle, (int)n);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    void setForegroundGdkColor(GdkColor gdkColor) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setForegroundColor(this.handle, gdkColor, false);
        if (this.entryHandle != 0L) {
            this.setForegroundColor(this.entryHandle, gdkColor, false);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_gdk, gdkColor, 0L);
    }

    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (this.entryHandle != 0L) {
            this.setForegroundGdkRGBA(this.entryHandle, gdkRGBA);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_rgba, gdkRGBA, 0L);
        super.setForegroundGdkRGBA(gdkRGBA);
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            this.error(5);
        }
        this.items[n] = string;
        byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove((long)this.handle, (int)n);
            }
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert((long)this.handle, (int)n, null, (byte[])byArray);
            }
        } else {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove((long)this.handle, (int)n);
            }
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert_text((long)this.handle, (int)n, (byte[])byArray);
            }
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK.gtk_container_forall((long)this.popupHandle, (long)this.display.setDirectionProc, (long)2L);
        }
    }

    public void setItems(String ... stringArray) {
        int n;
        int n2;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] != null) continue;
            this.error(5);
        }
        n2 = this.items.length;
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.clearText();
        if (GTK.GTK3) {
            if (this.handle != 0L) {
                GTK.gtk_combo_box_text_remove_all((long)this.handle);
            }
        } else {
            for (n = n2 - 1; n >= 0; --n) {
                if (this.handle == 0L) continue;
                GTK.gtk_combo_box_text_remove((long)this.handle, (int)n);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
            if (GTK.GTK3) {
                if (this.handle != 0L) {
                    GTK.gtk_combo_box_text_insert((long)this.handle, (int)n, null, (byte[])byArray);
                }
            } else if (this.handle != 0L) {
                GTK.gtk_combo_box_text_insert_text((long)this.handle, (int)n, (byte[])byArray);
            }
            if ((this.style & 0x4000000) == 0 || this.popupHandle == 0L) continue;
            GTK.gtk_container_forall((long)this.popupHandle, (long)this.display.setDirectionProc, (long)2L);
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            GTK.gtk_combo_box_popup((long)this.handle);
        } else {
            GTK.gtk_combo_box_popdown((long)this.handle);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0L) {
                GTK.gtk_widget_set_direction((long)this.entryHandle, (int)n);
            }
            if (this.cellHandle != 0L) {
                GTK.gtk_widget_set_direction((long)this.cellHandle, (int)n);
            }
            if (!bl && this.popupHandle != 0L) {
                GTK.gtk_container_forall((long)this.popupHandle, (long)this.display.setDirectionProc, (long)n);
            }
        }
    }

    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            long l = GTK.gtk_entry_get_text((long)this.entryHandle);
            int n = (int)OS.g_utf16_offset_to_utf8_offset(l, point.x);
            int n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, point.y);
            GTK.gtk_editable_set_position((long)this.entryHandle, (int)n);
            GTK.gtk_editable_select_region((long)this.entryHandle, (int)n, (int)n2);
        }
    }

    public void setText(String string) {
        long l;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n == -1) {
                return;
            }
            this.select(n);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf16_strlen(l = GTK.gtk_entry_get_text((long)this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        GTK.gtk_entry_set_text((long)this.entryHandle, (byte[])byArray);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            GTK.gtk_entry_set_max_length((long)this.entryHandle, (int)n);
        }
    }

    void setToolTipText(Shell shell, String string) {
        if (this.entryHandle != 0L) {
            shell.setToolTipText(this.entryHandle, string);
        }
        if (this.buttonHandle != 0L) {
            shell.setToolTipText(this.buttonHandle, string);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                long l = this.imContext();
                if (l == 0L) break;
                long[] lArray = new long[1];
                GTK.gtk_im_context_get_preedit_string((long)l, (long[])lArray, null, null);
                if (lArray[0] == 0L) break;
                int n2 = C.strlen((long)lArray[0]);
                OS.g_free(lArray[0]);
                if (n2 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l = GTK.gtk_get_current_event();
        if (l != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            GDK.gdk_event_free((long)l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

