/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.Logger;
import java.io.IOException;
import java.io.OutputStream;

public class LogStream
extends OutputStream {
    private Logger logger;
    private int level;
    private String method;
    private byte[] buf = new byte[1023];
    private int size = 1023;
    private int pos = 0;
    private boolean wasCR;
    private boolean closed;

    public LogStream(int n, String string, String string2) {
        this.level = n;
        this.method = string2;
        this.logger = new Logger(string);
    }

    @Override
    public synchronized void close() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.log();
    }

    @Override
    public void write(int n) throws IOException {
        this.addByte((byte)n);
    }

    private synchronized void addByte(byte by) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (by == 10 && this.wasCR) {
            this.wasCR = false;
            return;
        }
        if (by == 10 || by == 13) {
            this.log();
            if (by == 13) {
                this.wasCR = true;
            }
        } else {
            if (this.pos == this.size - 1) {
                this.grow();
            }
            this.buf[this.pos++] = by;
        }
    }

    private synchronized void log() {
        if (this.pos > 0 && this.level >= this.logger.level) {
            this.logger.log(this.level, this.method, new String(this.buf, 0, this.pos));
        }
        this.pos = 0;
    }

    private synchronized void grow() {
        byte[] byArray = new byte[2 * this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.pos);
        this.buf = byArray;
    }
}

