/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.AbstractLogUser;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class TreeFilter
extends AbstractLogUser {
    protected Hashtable cache = new Hashtable();
    protected Hashtable levels = new Hashtable();
    private Hashtable methods = new Hashtable();
    protected int defaultLevel = 2;
    public static final char msep = '-';

    public TreeFilter() {
        super(1, null);
    }

    public TreeFilter(LogWriter logWriter) {
        super(0, logWriter);
    }

    public TreeFilter(int n, LogWriter logWriter) {
        super(n, logWriter);
    }

    public boolean filter(int n, String string, String string2, String string3) {
        return n <= this.getLevel(string, string2);
    }

    @Override
    protected boolean isUseful(LogEntry logEntry) {
        return logEntry.getLevel() <= this.getLevel(logEntry.getClazz(), logEntry.getMethod());
    }

    public int getDefault() {
        return this.defaultLevel;
    }

    public void setDefault(int n) {
        this.defaultLevel = n;
        this.cache = new Hashtable();
    }

    public int getLevel(String string, String string2) {
        Object v = null;
        if (string2 != null && (v = (Object)this.cache.get(string + '-' + string2)) != null) {
            return (Integer)v;
        }
        v = string2 == null ? (Object)this.levels.get(string) : (Object)this.levels.get(string + '-' + string2);
        if (v != null) {
            if (string2 != null) {
                this.cache.put(string + '-' + string2, v);
            }
            return (Integer)v;
        }
        if (string2 != null) {
            v = this.levels.get(string);
        }
        int n = v != null ? ((Integer)v).intValue() : this.getParentLevel(string);
        if (string2 != null) {
            this.cache.put(string + '-' + string2, new Integer(n));
        }
        if (this.methods.get(string + '-' + string2) == null) {
            this.methods.put(string + '-' + string2, "");
            this.methodAdded(string, string2);
        }
        return n;
    }

    public void setLevel(String string, String string2, int n, boolean bl) {
        Object v;
        String string3 = string;
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null) {
            v = this.levels.get(string + '-' + string2);
            this.levels.put(string + '-' + string2, new Integer(n));
            this.cache.put(string + '-' + string2, new Integer(n));
        } else {
            v = this.levels.get(string);
            this.levels.put(string, new Integer(n));
            if (bl) {
                this.removeChildren(string, n);
            }
            this.clearCache(string3);
        }
        if (v == null) {
            this.methodAdded(string3, string2);
        }
    }

    public void removeLevel(String string, String string2, boolean bl) {
        String string3 = string;
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null) {
            Object v = this.levels.get(string + '-' + string2);
            this.levels.remove(string + '-' + string2);
            this.cache.remove(string + '-' + string2);
        } else {
            Object v = this.levels.get(string);
            this.levels.remove(string);
            if (bl) {
                this.removeChildren(string, this.getParentLevel(string));
            }
            this.clearCache(string3);
        }
    }

    protected int getParentLevel(String string) {
        Object v;
        String string2 = string;
        int n = string2.lastIndexOf(36);
        while (n != -1) {
            v = this.levels.get(string2 = string2.substring(0, n));
            if (v != null) {
                return (Integer)v;
            }
            n = string2.lastIndexOf(36);
        }
        n = string2.lastIndexOf(46);
        while (n != -1) {
            v = this.levels.get(string2 = string2.substring(0, n));
            if (v != null) {
                return (Integer)v;
            }
            n = string2.lastIndexOf(46);
        }
        return this.defaultLevel;
    }

    protected void removeChildren(String string, int n) {
        Enumeration enumeration = this.levels.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            if (string2.indexOf(45) != -1) {
                this.levels.put(string2, new Integer(n));
                continue;
            }
            this.levels.remove(string2);
        }
    }

    protected void clearCache(String string) {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            this.cache.remove(string2);
        }
    }

    protected void methodAdded(String string, String string2) {
    }
}

