/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.TextOption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class ProguardMap {
    private static final QFLogger logger = new QFLogger("de.qfs.lib.log.ProguardMap");
    private static final File[] DEV_LIB_DIR = new File[]{new File("."), new File("lib"), new File("../lib"), new File(System.getenv("QFS"), "nprj/lib"), new File(System.getProperty("user.home"), "nprj/lib"), new File("H:\\nprj\\lib"), new File("C:\\qfs\\nprj\\lib")};
    private static final File[] DEV_MAP_DIR = new File[]{new File(System.getenv("QFS"), "nprj/release/maps"), new File(System.getProperty("user.home"), "nprj/release/maps"), new File("H:\\nprj\\release\\maps"), new File("C:\\qfs\\nprj\\release\\maps")};
    public static final String[] CLASSPATH = new String[]{"proguard.jar", "retrace.jar"};
    protected static final String RETRACE_CLASS = "proguard.retrace.ReTrace";
    protected static final Pattern TRACE_LINE_PATTERN = Pattern.compile(".*?\\bat\\s+");
    final File libDir;
    @NonNull
    File mapFile;

    public ProguardMap(File file) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "ProguardMap(File)", 109).addDetail("mapFile", file)).log();
        }
        this.mapFile = file;
        File file2 = ProguardMap.detectLibDir();
        this.libDir = file2 == null ? new File(".") : file2;
    }

    public static File detectLibDir() {
        if (ProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "detectLibDir()", 125).log();
        }
        for (File file : DEV_LIB_DIR) {
            if (ProguardMap.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectLibDir()", 127).add("Checking folder: ", file)).log();
            }
            if (!ProguardMap.checkLibs(file)) continue;
            if (ProguardMap.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectLibDir()", 129).add("Folder found: ", file)).log();
            }
            return file;
        }
        return null;
    }

    public boolean checkLibs() {
        if (ProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "checkLibs()", 143).log();
        }
        return ProguardMap.checkLibs(this.libDir);
    }

    protected static boolean checkLibs(File file) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "checkLibs(File)", 151).addDetail("libDir", file)).log();
        }
        for (String string : CLASSPATH) {
            if (new File(file, string).exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean isStackTrace(@NonNull String string) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isStackTrace(String)", 169).addDetail("candidate", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("candidate is marked @NonNull but is null");
        }
        Matcher matcher = TRACE_LINE_PATTERN.matcher(string);
        return matcher.find();
    }

    @NonNull
    public String retrace(@NonNull String string) {
        Process process;
        block9: {
            if (ProguardMap.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "retrace(String)", 183).addDetail("trace", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("trace is marked @NonNull but is null");
            }
            if (!this.checkLibs()) {
                return string;
            }
            process = null;
            try {
                process = Runtime.getRuntime().exec(new String[]{"java", "-cp", TextOption.join((String[])CLASSPATH, (String)File.pathSeparator), RETRACE_CLASS, this.mapFile.getAbsolutePath()}, null, this.libDir);
            }
            catch (IOException iOException) {
                if (ProguardMap.logger.level < 1) break block9;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "retrace(String)", 198).add("e", iOException)).log();
            }
        }
        if (process == null) {
            return string;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            ProguardMap.inheritIO(process.getErrorStream(), System.err);
            ProguardMap.inheritIO(process.getInputStream(), printStream);
            OutputStream outputStream = process.getOutputStream();
            outputStream.write(string.getBytes("UTF-8"));
            outputStream.close();
            process.waitFor();
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception exception) {
            if (ProguardMap.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "retrace(String)", 221).add("e", exception)).log();
            }
            return string;
        }
    }

    private static void inheritIO(final InputStream inputStream, final PrintStream printStream) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "inheritIO(InputStream,PrintStream)", 229).addDetail("src", inputStream)).addDetail("dest", printStream)).log();
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "inheritIO(InputStream,PrintStream).Runnable.run()", 232).log();
                }
                Scanner scanner = null;
                try {
                    scanner = new Scanner(inputStream);
                    while (scanner.hasNextLine()) {
                        printStream.println(scanner.nextLine());
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static String inputStreamToString(@NonNull InputStream inputStream) throws Exception {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "inputStreamToString(InputStream)", 252).addDetail("is", inputStream)).log();
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("is is marked @NonNull but is null");
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(inputStream);
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    @NonNull
    public static File getMapFileChooserStartDir(ProguardMap proguardMap) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getMapFileChooserStartDir(ProguardMap)", 270).addDetail("currentMap", proguardMap)).log();
        }
        File file = new File(new File(".").getAbsolutePath());
        if (proguardMap != null) {
            file = proguardMap.getMapFile().getParentFile();
        } else {
            for (File file2 : DEV_MAP_DIR) {
                if (!file2.exists()) continue;
                file = file2;
                break;
            }
        }
        return file;
    }

    public ProguardMap(File file, @NonNull File file2) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ProguardMap(File,File)", 70).addDetail("libDir", file)).addDetail("mapFile", file2)).log();
        }
        if (file2 == null) {
            throw new IllegalArgumentException("mapFile is marked @NonNull but is null");
        }
        this.libDir = file;
        this.mapFile = file2;
    }

    public boolean equals(Object object) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "equals(Object)", 71).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProguardMap)) {
            return false;
        }
        ProguardMap proguardMap = (ProguardMap)object;
        if (!proguardMap.canEqual(this)) {
            return false;
        }
        File file = this.getLibDir();
        File file2 = proguardMap.getLibDir();
        if (file == null ? file2 != null : !((Object)file).equals(file2)) {
            return false;
        }
        File file3 = this.getMapFile();
        File file4 = proguardMap.getMapFile();
        return !(file3 == null ? file4 != null : !((Object)file3).equals(file4));
    }

    protected boolean canEqual(Object object) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "canEqual(Object)", 71).addDetail("other", object)).log();
        }
        return object instanceof ProguardMap;
    }

    public int hashCode() {
        if (ProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "hashCode()", 71).log();
        }
        int n = 1;
        File file = this.getLibDir();
        n = n * 59 + (file == null ? 43 : ((Object)file).hashCode());
        File file2 = this.getMapFile();
        n = n * 59 + (file2 == null ? 43 : ((Object)file2).hashCode());
        return n;
    }

    public File getLibDir() {
        if (ProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "getLibDir()", 100).log();
        }
        return this.libDir;
    }

    @NonNull
    public File getMapFile() {
        if (ProguardMap.logger.level >= 7) {
            logger.lvlBuild(7, "getMapFile()", 101).log();
        }
        return this.mapFile;
    }

    public ProguardMap setMapFile(@NonNull File file) {
        if (ProguardMap.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMapFile(File)", 101).addDetail("mapFile", file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("mapFile is marked @NonNull but is null");
        }
        this.mapFile = file;
        return this;
    }
}

