/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = System.getProperty("file.separator");
    private static final int PATH_MAX = 1024;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.DirectoryDialog");

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        long l;
        long l2;
        Object object;
        Object object2;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l3 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l4 = 0L;
        l4 = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(byArray, l3, 2, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L) : OS.gtk_file_chooser_dialog_new(byArray, l3, 2, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0L);
        if (l4 == 0L) {
            this.error(2);
        }
        long l5 = OS.gtk_window_get_group(0L);
        OS.gtk_window_group_add_window(l5, l4);
        OS.gtk_window_set_modal(l4, true);
        long l6 = OS.gtk_window_get_icon_list(l3);
        if (l6 != 0L) {
            OS.gtk_window_set_icon_list(l4, l6);
            OS.g_list_free(l6);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            object2 = new StringBuffer();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                ((StringBuffer)object2).append(SEPARATOR);
            }
            ((StringBuffer)object2).append(this.filterPath);
            object = Converter.wcsToMbcs(null, ((StringBuffer)object2).toString(), true);
            if (OS.IsAIX) {
                byte[] byArray2 = new byte[1024];
                l2 = OS.realpath((byte[])object, byArray2);
                if (l2 != 0L) {
                    OS.gtk_file_chooser_set_current_folder(l4, l2);
                }
            } else {
                long l7 = OS.realpath((byte[])object, null);
                if (l7 != 0L) {
                    OS.gtk_file_chooser_set_current_folder(l4, l7);
                    OS.g_free(l7);
                }
            }
        }
        if (this.message.length() > 0) {
            object2 = Converter.wcsToMbcs(null, this.message, true);
            long l8 = 0L;
            if (OS.GTK3) {
                l8 = OS.gtk_box_new(0, 0);
                OS.gtk_box_set_homogeneous(l8, false);
            } else {
                l8 = OS.gtk_hbox_new(false, 0);
            }
            if (l8 == 0L) {
                this.error(2);
            }
            if ((l2 = OS.gtk_label_new((byte[])object2)) == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(l8, l2);
            OS.gtk_widget_show(l2);
            OS.gtk_label_set_line_wrap(l2, true);
            OS.gtk_label_set_justify(l2, 2);
            OS.gtk_file_chooser_set_extra_widget(l4, l8);
        }
        object2 = null;
        this._qfGetDisplay().runDialogShownHooks(this, l4);
        display.addIdleProc();
        object = null;
        if (OS.gtk_window_get_modal(l4)) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l4, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int n2 = OS.gtk_dialog_run(l4);
        OS.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l2);
        }
        if (OS.gtk_window_get_modal(l4)) {
            display.setModalDialog((Dialog)object);
        }
        if (n2 == -5 && (l = OS.gtk_file_chooser_get_filename(l4)) != 0L) {
            long l9 = OS.g_filename_to_utf8(l, -1L, null, null, null);
            if (l9 == 0L) {
                l9 = OS.g_filename_display_name(l);
            }
            if (l != l9) {
                OS.g_free(l);
            }
            if (l9 != 0L) {
                long[] lArray = new long[1];
                long l10 = OS.g_utf8_to_utf16(l9, -1L, null, lArray, null);
                OS.g_free(l9);
                if (l10 != 0L) {
                    int n3 = (int)lArray[0];
                    char[] cArray = new char[n3];
                    OS.memmove(cArray, l10, (long)(n3 * 2));
                    OS.g_free(l10);
                    this.filterPath = object2 = new String(cArray);
                }
            }
        }
        Object object3 = this._qfGetDisplay().runDialogClosedHooks(this, object2);
        if (DirectoryDialog.logger.level >= 9) {
            logger.build("openChooserDialog()").add("ret: ").add(object3).log(9);
        }
        if (object3 instanceof String || object3 == null) {
            object2 = (String)object3;
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l4);
        return object2;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

