/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Dialog");
    String message = "";
    long handle;

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n) {
        super(shell, MessageBox.checkStyle(shell, MessageBox.checkStyle(n)));
        this.checkSubclass();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        long l;
        long l2 = this.parent != null ? this.parent.topHandle() : 0L;
        int n = 2;
        if ((this.style & 0x38000) != 0) {
            n |= 1;
        }
        int n2 = 0;
        if ((this.style & 8) != 0) {
            n2 = 1;
        }
        if ((this.style & 4) != 0) {
            n2 = 2;
        }
        if ((this.style & 1) != 0) {
            n2 = 3;
        }
        byte[] byArray = Converter.wcsToMbcs(null, this.fixPercent(this.message), true);
        this.handle = OS.gtk_message_dialog_new(l2, n, n2, 0, byArray);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (l2 != 0L && (l = OS.gtk_window_get_icon_list(l2)) != 0L) {
            OS.gtk_window_set_icon_list(this.handle, l);
            OS.g_list_free(l);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.createButtons(display.getDismissalAlignment());
        byArray = Converter.wcsToMbcs(null, this.title, true);
        OS.gtk_window_set_title(this.handle, byArray);
        this._qfGetDisplay().runDialogShownHooks(this, this.handle);
        display.addIdleProc();
        Dialog dialog = null;
        long l3 = OS.gtk_window_get_group(0L);
        OS.gtk_window_group_add_window(l3, this.handle);
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n3 = 0;
        long l4 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l4 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, this.handle, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int n4 = OS.gtk_dialog_run(this.handle);
        OS.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, l4);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        display.removeIdleProc();
        Object object = this._qfGetDisplay().runDialogClosedHooks(this, new Integer(n4));
        if (MessageBox.logger.level >= 9) {
            logger.build("open()").add("ret: ").add(object).log(9);
        }
        if (object instanceof Integer) {
            n4 = (Integer)object;
        }
        OS.gtk_widget_destroy(this.handle);
        return n4;
    }

    private void createButtons(int n) {
        if (n == 16384) {
            if ((this.style & 0x20) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-ok", true), 32);
            }
            if ((this.style & 0x200) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Abort"), true), 512);
            }
            if ((this.style & 0x400) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true), 1024);
            }
            if ((this.style & 0x40) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-yes", true), 64);
            }
            if ((this.style & 0x80) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-no", true), 128);
            }
            if ((this.style & 0x800) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Ignore"), true), 2048);
            }
            if ((this.style & 0x100) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-cancel", true), 256);
            }
        } else {
            if ((this.style & 0x100) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-cancel", true), 256);
            }
            if ((this.style & 0x20) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-ok", true), 32);
            }
            if ((this.style & 0x80) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-no", true), 128);
            }
            if ((this.style & 0x40) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-yes", true), 64);
            }
            if ((this.style & 0x800) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Ignore"), true), 2048);
            }
            if ((this.style & 0x400) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true), 1024);
            }
            if ((this.style & 0x200) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Abort"), true), 512);
            }
        }
    }

    private static int checkStyle(int n) {
        int n2 = 4064;
        int n3 = n & n2;
        if (n3 == 32 || n3 == 256 || n3 == 288) {
            return n;
        }
        if (n3 == 64 || n3 == 128 || n3 == 192 || n3 == 448) {
            return n;
        }
        if (n3 == 1280 || n3 == 3584) {
            return n;
        }
        n = n & ~n2 | 0x20;
        return n;
    }

    char[] fixPercent(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[n * 2];
        while (n2 < n) {
            switch (cArray[n2]) {
                case '%': {
                    cArray2[n3++] = 37;
                }
            }
            cArray2[n3++] = cArray[n2++];
        }
        return cArray2;
    }
}

