/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    long labelHandle;
    long imageHandle;
    long buttonHandle;
    Table parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    boolean useFixedWidth;
    String toolTipText;

    public TableColumn(Table table, int n) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        this.createWidget(table.getColumnCount());
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        this.createWidget(n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        this.parent.createItem(this, n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        if (!OS.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        if (this.useFixedWidth) {
            return OS.gtk_tree_view_column_get_fixed_width(this.handle);
        }
        return OS.gtk_tree_view_column_get_width(this.handle);
    }

    long gtk_clicked(long l) {
        boolean bl = false;
        boolean bl2 = true;
        long l2 = OS.gtk_get_current_event();
        if (l2 != 0L) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
            OS.gdk_event_free(l2);
            switch (gdkEventButton.type) {
                case 7: {
                    int n = this.display.getDoubleClickTime();
                    int n2 = gdkEventButton.time;
                    int n3 = gdkEventButton.button;
                    if (this.lastButton == n3 && this.lastTime != 0 && Math.abs(this.lastTime - n2) <= n) {
                        bl = true;
                    }
                    this.lastTime = n2 == 0 ? 1 : n2;
                    this.lastButton = n3;
                    break;
                }
            }
        }
        if (bl2) {
            this.sendSelectionEvent(bl ? 14 : 13);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
        }
        return 0L;
    }

    long gtk_mnemonic_activate(long l, long l2) {
        return this.parent.gtk_mnemonic_activate(l, l2);
    }

    long gtk_size_allocate(long l, long l2) {
        this.useFixedWidth = false;
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.width;
        if (n != this.lastX) {
            this.lastX = n;
            this.sendEvent(10);
        }
        if (n2 != this.lastWidth) {
            this.lastWidth = n2;
            this.sendEvent(11);
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.buttonHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    public void pack() {
        this.checkWidget();
        int n = 0;
        if (this.buttonHandle != 0L) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.buttonHandle, gtkRequisition);
            n = gtkRequisition.width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            for (int i = 0; i < this.parent.items.length; ++i) {
                TableItem tableItem = this.parent.items[i];
                if (tableItem == null || !tableItem.cached) continue;
                n = Math.max(n, this.parent.calculateWidth(this.handle, tableItem.handle));
            }
        } else {
            long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter_first(this.parent.modelHandle, l)) {
                do {
                    n = Math.max(n, this.parent.calculateWidth(this.handle, l));
                } while (OS.gtk_tree_model_iter_next(this.parent.modelHandle, l));
            }
            OS.g_free(l);
        }
        this.setWidth(n);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.buttonHandle = 0L;
        this.handle = 0L;
        this.modelIndex = -1;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, n2 == 0, this.style);
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.labelHandle, l);
        this.setFontDescription(this.imageHandle, l);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.headerImageList;
            if (imageList == null) {
                imageList = this.parent.headerImageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            }
            long l = imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, l);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_resizable(this.handle, bl);
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_reorderable(this.handle, bl);
    }

    void setOrientation(boolean bl) {
        if (!((this.parent.style & 0x4000000) == 0 && bl || this.buttonHandle == 0L)) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.buttonHandle, n);
            OS.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, n);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.parent._getShell();
        this.setToolTipText(shell, string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.buttonHandle, string);
    }

    public void setWidth(int n) {
        long l;
        long l2;
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.lastWidth) {
            return;
        }
        if (n > 0) {
            this.useFixedWidth = true;
            OS.gtk_tree_view_column_set_fixed_width(this.handle, n);
        }
        if (n != 0) {
            OS.gtk_widget_realize(this.parent.handle);
        }
        OS.gtk_tree_view_column_set_visible(this.handle, n != 0);
        this.lastWidth = n;
        if (n != 0 && this.buttonHandle != 0L && (l2 = OS.gtk_widget_get_parent_window(this.buttonHandle)) != 0L && (l = OS.gdk_window_get_children(l2)) != 0L) {
            long l3 = l;
            long[] lArray = new long[1];
            while (l3 != 0L) {
                long l4 = OS.g_list_data(l3);
                OS.gdk_window_get_user_data(l4, lArray);
                if (lArray[0] == this.buttonHandle) {
                    OS.gdk_window_lower(l4);
                    break;
                }
                l3 = OS.g_list_next(l3);
            }
            OS.g_list_free(l);
        }
        this.sendEvent(11);
    }
}

