/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.QFLogger;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericLevelAwareLogBuilder<T extends GenericLevelAwareLogBuilder<T>> {
    private static final int DEFAULT_NUMBER_OF_ELEMENTS_TO_LOG_IN_ARRAY = 30;
    private static final int DEFAULT_NUMBER_OF_ELEMENTS_TO_LOG_IN_MAP = 50;
    private static final int AVERAGE_MESSAGE_SIZE = 200;
    protected final StringBuilder sb = new StringBuilder(200);
    protected final String method;
    protected int numberOfArrayElementsToLog = 30;
    protected int numberOfMapElementsToLog = 50;
    protected final QFLogger logger;
    protected final int level;
    protected final boolean useDetails;
    protected int lineNumber;
    protected Queue<LogEntry> triggeredLogEntries = null;
    protected final boolean noop;
    protected final boolean dump;

    protected GenericLevelAwareLogBuilder(QFLogger qFLogger, int n, String string, int n2, boolean bl, boolean bl2) {
        this.logger = qFLogger;
        this.level = n;
        this.method = string;
        this.lineNumber = n2;
        this.noop = bl;
        this.dump = bl2;
        this.useDetails = qFLogger.level >= n + 1;
    }

    public T setNumberOfArrayElementsToLog(int n) {
        this.numberOfArrayElementsToLog = n;
        return (T)this;
    }

    public T setNumberOfMapElementsToLog(int n) {
        this.numberOfMapElementsToLog = n;
        return (T)this;
    }

    public T add(boolean bl) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(bl);
        return (T)this;
    }

    public T add(byte by) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(by);
        return (T)this;
    }

    public T add(char c) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(c);
        return (T)this;
    }

    public T add(int n) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(n);
        return (T)this;
    }

    public T addHex(int n) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append("0x");
        this.sb.append(Integer.toHexString(n));
        return (T)this;
    }

    public T addHex(Integer n) {
        if (this.noop) {
            return (T)this;
        }
        if (n != null) {
            return this.addHex((int)n);
        }
        this.sb.append("null");
        return (T)this;
    }

    public T add(long l) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(l);
        return (T)this;
    }

    public T addHex(long l) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append("0x");
        this.sb.append(Long.toHexString(l));
        return (T)this;
    }

    public T addHex(Long l) {
        if (this.noop) {
            return (T)this;
        }
        if (l != null) {
            return this.addHex((long)l);
        }
        this.sb.append("null");
        return (T)this;
    }

    public T add(double d) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(d);
        return (T)this;
    }

    public T add(Object object) {
        if (this.noop) {
            return (T)this;
        }
        if (object == null) {
            this.sb.append(object);
        } else {
            try {
                if (object.getClass().isArray()) {
                    return this.addArray(object);
                }
                if (object instanceof Iterable) {
                    return this.addIterable((Iterable)object);
                }
                if (object instanceof Map) {
                    return this.addMap((Map)object);
                }
                if (object instanceof Throwable) {
                    return this.addThrowable((Throwable)object);
                }
                this.sb.append(object);
            }
            catch (Throwable throwable) {
                this.logger.log(3, this.method, throwable);
                this.sb.append("EXCEPTED");
            }
        }
        return (T)this;
    }

    public T add(String string) {
        if (this.noop) {
            return (T)this;
        }
        this.sb.append(string);
        return (T)this;
    }

    protected T addThrowable(Throwable throwable) {
        this.sb.append(throwable.getClass().getName() + ": " + throwable.getMessage());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = byteArrayOutputStream.toString();
        this.addTriggeredLogEntry(this.level + 1, this.formatMessage(string));
        return (T)this;
    }

    protected T addArray(Object object) {
        if (this.noop) {
            return (T)this;
        }
        assert (object != null);
        assert (object.getClass().isArray());
        int n = Array.getLength(object);
        int n2 = Math.max(0, n - this.numberOfArrayElementsToLog);
        this.sb.append("[");
        for (int i = 0; i < n - n2; ++i) {
            Object object2;
            if (i > 0) {
                this.sb.append(',');
            }
            this.add((object2 = Array.get(object, i)) == object ? "(this Array)" : object2);
        }
        if (n2 > 0) {
            this.sb.append(",... (").append(n2).append(" more)");
        }
        this.sb.append("]");
        return (T)this;
    }

    protected T addIterable(Iterable iterable) {
        if (this.noop) {
            return (T)this;
        }
        if (iterable == null) {
            this.sb.append(iterable);
        } else {
            this.sb.append("[");
            int n = 0;
            try {
                for (Object t : iterable) {
                    if (n > 0) {
                        this.sb.append(',');
                    }
                    if (++n > this.numberOfArrayElementsToLog) {
                        this.sb.append("...");
                        if (iterable instanceof Collection) {
                            int n2 = ((Collection)iterable).size();
                            int n3 = n2 - this.numberOfArrayElementsToLog;
                            this.sb.append(String.format(" (%d more)", n3));
                        }
                        break;
                    }
                    this.add((Object)(t == iterable ? "(this Iterable)" : t));
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.sb.append(" ConcurrentModification!");
            }
            this.sb.append("]");
        }
        return (T)this;
    }

    protected T addMap(Map map) {
        if (this.noop) {
            return (T)this;
        }
        if (map == null) {
            this.sb.append(map);
        } else {
            this.sb.append("{");
            try {
                int n = 0;
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    if (n > 0) {
                        this.sb.append(',');
                    }
                    if (++n > this.numberOfMapElementsToLog) {
                        this.sb.append("...");
                        int n2 = set.size();
                        int n3 = n2 - this.numberOfMapElementsToLog;
                        this.sb.append(String.format(" (%d more)", n3));
                        break;
                    }
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    this.add((Object)(k == map ? "(this Map)" : k));
                    this.sb.append("=");
                    this.add((Object)(v == map ? "(this Map)" : v));
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.sb.append(" ConcurrentModification!");
            }
            this.sb.append("}");
        }
        return (T)this;
    }

    public T addAll(Object object) {
        if (this.noop) {
            return (T)this;
        }
        int n = this.numberOfArrayElementsToLog;
        return ((GenericLevelAwareLogBuilder)((GenericLevelAwareLogBuilder)this.setNumberOfArrayElementsToLog(Integer.MAX_VALUE)).add(object)).setNumberOfArrayElementsToLog(n);
    }

    protected void addLabel(String string) {
        if (this.noop) {
            return;
        }
        if (this.sb.length() > 0) {
            this.sb.append(", ");
        }
        if (string == null) {
            this.sb.append(string);
        } else {
            this.sb.append(string.replaceAll("^\\s*,?\\s*|\\s*:?\\s*$", ""));
        }
        this.sb.append(": ");
    }

    public T add(String string, boolean bl) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(bl);
    }

    public T add(String string, byte by) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(by);
    }

    public T add(String string, char c) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(c);
    }

    public T add(String string, int n) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(n);
    }

    public T addHex(String string, int n) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.addHex(n);
    }

    public T addHex(String string, Integer n) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.addHex(n);
    }

    public T add(String string, long l) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(l);
    }

    public T addHex(String string, long l) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.addHex(l);
    }

    public T addHex(String string, Long l) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.addHex(l);
    }

    public T add(String string, double d) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(d);
    }

    public T add(String string, Object object) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(object);
    }

    public T add(String string, String string2) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.add(string2);
    }

    public T addAll(String string, Object object) {
        if (this.noop) {
            return (T)this;
        }
        this.addLabel(string);
        return this.addAll(object);
    }

    public T addDetail(boolean bl) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(bl);
        }
        return (T)this;
    }

    public T addDetail(byte by) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(by);
        }
        return (T)this;
    }

    public T addDetail(char c) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(c);
        }
        return (T)this;
    }

    public T addDetail(int n) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(n);
        }
        return (T)this;
    }

    public T addHexDetail(int n) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.addHex(n);
        }
        return (T)this;
    }

    public T addHexDetail(Integer n) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.addHex(n);
        }
        return (T)this;
    }

    public T addDetail(long l) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(l);
        }
        return (T)this;
    }

    public T addHexDetail(long l) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.addHex(l);
        }
        return (T)this;
    }

    public T addHexDetail(Long l) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.addHex(l);
        }
        return (T)this;
    }

    public T addDetail(double d) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(d);
        }
        return (T)this;
    }

    public T addDetail(Object object) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(object);
        }
        return (T)this;
    }

    public T addDetail(String string) {
        if (this.noop) {
            return (T)this;
        }
        if (this.useDetails) {
            this.add(string);
        }
        return (T)this;
    }

    protected void addDetailLabel(String string) {
        if (this.noop) {
            return;
        }
        if (this.useDetails) {
            this.addLabel(string);
        }
    }

    public T addDetail(String string, boolean bl) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(bl);
    }

    public T addDetail(String string, byte by) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(by);
    }

    public T addDetail(String string, char c) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(c);
    }

    public T addDetail(String string, int n) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(n);
    }

    public T addHexDetail(String string, int n) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addHexDetail(n);
    }

    public T addHexDetail(String string, Integer n) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addHexDetail(n);
    }

    public T addDetail(String string, long l) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(l);
    }

    public T addHexDetail(String string, long l) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addHexDetail(l);
    }

    public T addHexDetail(String string, Long l) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addHexDetail(l);
    }

    public T addDetail(String string, double d) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(d);
    }

    public T addDetail(String string, Object object) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(object);
    }

    public T addDetail(String string, String string2) {
        if (this.noop) {
            return (T)this;
        }
        this.addDetailLabel(string);
        return this.addDetail(string2);
    }

    public void log() {
        this.logAt(System.currentTimeMillis());
    }

    public void logAt(long l) {
        if (!this.noop) {
            if (this.dump) {
                this.dumpStack();
            } else {
                Log.log(this.level, l, this.logger.getOwnerName(), this.method, this.formatMessage(this.getMessage()));
            }
        }
        this.dispatchTriggeredLogEntries();
    }

    protected String formatMessage(String string) {
        return this.lineNumber > 0 ? "(#" + this.lineNumber + ")" + (string.length() > 0 ? " " + string : "") : string;
    }

    protected String getMessage() {
        return this.sb.toString();
    }

    public void dumpStack() {
        if (!this.noop) {
            this.logger.dumpStack(this.level, this.method, this.formatMessage(this.getMessage()));
        }
        this.dispatchTriggeredLogEntries();
    }

    protected void addTriggeredLogEntry(int n, String string) {
        if (this.triggeredLogEntries == null) {
            this.triggeredLogEntries = new ConcurrentLinkedQueue<LogEntry>();
        }
        this.triggeredLogEntries.add(new LogEntry(n, System.currentTimeMillis(), null, null, this.method, string));
    }

    protected void dispatchTriggeredLogEntries() {
        if (this.triggeredLogEntries == null) {
            return;
        }
        for (LogEntry logEntry : this.triggeredLogEntries) {
            Log.log(logEntry.getLevel(), logEntry.getTimestamp(), this.logger.getOwnerName(), logEntry.getMethod(), logEntry.getMessage());
        }
    }
}

