/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long groupHandle;
    int accelerator;
    int userId;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.createWidget(menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        int n3 = menu.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    void addAccelerator(long l) {
        this.updateAccelerator(l, true);
    }

    void addAccelerators(long l) {
        this.addAccelerator(l);
        if (this.menu != null) {
            this.menu.addAccelerators(l);
        }
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        boolean bl;
        long l;
        this.state |= 8;
        byte[] byArray = new byte[1];
        int n2 = 58;
        switch (this.style & n2) {
            case 2: {
                this.handle = OS.gtk_separator_menu_item_new();
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_menu_item_new(0L);
                if (this.groupHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                this.g_object_ref_sink(this.groupHandle);
                l = OS.gtk_radio_menu_item_get_group(this.groupHandle);
                this.handle = OS.gtk_radio_menu_item_new_with_label(l, byArray);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_menu_item_new_with_label(byArray);
                break;
            }
            default: {
                this.handle = OS.gtk_image_menu_item_new_with_label(byArray);
            }
        }
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 2) == 0) {
            l = OS.gtk_bin_get_child(this.handle);
            OS.gtk_accel_label_set_accel_widget(l, 0L);
        }
        if (!(bl = this.gtk_widget_get_sensitive(l = this.parent.handle))) {
            OS.gtk_widget_set_sensitive(l, true);
        }
        OS.gtk_menu_shell_insert(l, this.handle, n);
        if (!bl) {
            OS.gtk_widget_set_sensitive(l, false);
        }
        OS.gtk_widget_show(this.handle);
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    long getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return 0L;
        }
        Decorations decorations = menu.parent;
        if (decorations == null) {
            return 0L;
        }
        return decorations.menuBar == menu ? decorations.accelGroup : 0L;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.gtk_widget_get_mapped(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.gtk_widget_get_sensitive(this.handle);
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_check_menu_item_get_active(this.handle);
    }

    long gtk_activate(long l) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0L;
        }
        if (!this.isEnabled()) {
            return 0L;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    long gtk_select(long l) {
        this.parent.selectedItem = this;
        this.sendEvent(30);
        return 0L;
    }

    long gtk_show_help(long l, long l2) {
        boolean bl = this.hooks(28);
        if (bl) {
            this.postEvent(28);
        } else {
            bl = this.parent.sendHelpEvent(l2);
        }
        if (bl) {
            OS.gtk_menu_shell_deactivate(this.parent.handle);
            return 1L;
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
        OS.g_signal_connect_closure(this.handle, OS.select, this.display.closures[44], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.closures[46], false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        this.accelerator = 0;
        this.parent = null;
    }

    void removeAccelerator(long l) {
        this.updateAccelerator(l, false);
    }

    void removeAccelerators(long l) {
        this.removeAccelerator(l);
        if (this.menu != null) {
            this.menu.removeAccelerators(l);
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        this.accelerator = n;
        if (l != 0L) {
            this.addAccelerator(l);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (this.gtk_widget_get_sensitive(this.handle) == bl) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        OS.gtk_widget_set_sensitive(this.handle, bl);
        if (l != 0L) {
            this.addAccelerator(l);
        }
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.userId = n;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (!OS.GTK_IS_IMAGE_MENU_ITEM(this.handle)) {
            return;
        }
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            long l = imageList.getPixbuf(n);
            long l2 = OS.gtk_image_new_from_pixbuf(l);
            OS.gtk_image_menu_item_set_image(this.handle, l2);
            OS.gtk_widget_show(l2);
        } else {
            OS.gtk_image_menu_item_set_image(this.handle, 0L);
        }
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerators(l);
        }
        if (menu2 != null) {
            menu2.cascade = null;
            OS.g_object_ref(menu2.handle);
            if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                OS.gtk_menu_item_set_submenu(this.handle, 0L);
            } else {
                OS.gtk_menu_item_remove_submenu(this.handle);
            }
        }
        if ((this.menu = menu) != null) {
            menu.cascade = this;
            OS.gtk_menu_item_set_submenu(this.handle, menu.handle);
        }
        if (l != 0L) {
            this.addAccelerators(l);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.handle, n);
            OS.gtk_container_forall(this.handle, this.display.setDirectionProc, n);
            if (this.menu != null) {
                this.menu._setOrientation(this.parent.style & 0x6000000);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
        OS.gtk_check_menu_item_set_active(this.handle, bl);
        if ((this.style & 0x10) != 0) {
            OS.gtk_check_menu_item_set_active(this.groupHandle, !bl);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        String string2 = "";
        int n = string.indexOf(9);
        if (n != -1) {
            boolean bl = (this.parent.style & 0x4000000) != 0;
            string2 = (bl ? "" : "  ") + string.substring(n + 1, string.length()) + (bl ? "  " : "");
            string = string.substring(0, n);
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        long l = OS.gtk_bin_get_child(this.handle);
        if (l != 0L && OS.GTK_IS_LABEL(l)) {
            OS.gtk_label_set_text_with_mnemonic(l, byArray);
            if (!OS.GTK3 && OS.GTK_IS_ACCEL_LABEL(l)) {
                byArray = Converter.wcsToMbcs(null, string2, true);
                long l2 = OS.g_malloc(byArray.length);
                OS.memmove(l2, byArray, (long)byArray.length);
                long l3 = OS.GTK_ACCEL_LABEL_GET_ACCEL_STRING(l);
                OS.GTK_ACCEL_LABEL_SET_ACCEL_STRING(l, l2);
                if (l3 != 0L) {
                    OS.g_free(l3);
                }
            }
        }
    }

    void updateAccelerator(long l, boolean bl) {
        int n;
        int n2;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        int n3 = 0;
        if ((this.accelerator & 0x10000) != 0) {
            n3 |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            n3 |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            n3 |= 4;
        }
        if ((n2 = Display.untranslateKey(n = this.accelerator & 0x100FFFF)) != 0) {
            n = n2;
        } else {
            switch (n) {
                case 13: {
                    n = 65293;
                    break;
                }
                default: {
                    n = Display.wcsToMbcs((char)n);
                }
            }
        }
        if (n != 0) {
            if (bl) {
                OS.gtk_widget_add_accelerator(this.handle, OS.activate, l, n, n3, 1);
            } else {
                OS.gtk_widget_remove_accelerator(this.handle, l, n, n3);
            }
        }
    }

    boolean updateAcceleratorText(boolean bl) {
        if (this.accelerator != 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        if (bl) {
            int n3 = this.text.indexOf(9);
            if (n3 == -1) {
                return true;
            }
            int n4 = n3 + 1;
            int n5 = this.text.indexOf(43, n4);
            while (n5 != -1) {
                String string = this.text.substring(n4, n5);
                if (string.equals("Ctrl")) {
                    n |= 4;
                }
                if (string.equals("Shift")) {
                    n |= 1;
                }
                if (string.equals("Alt")) {
                    n |= 8;
                }
                n4 = n5 + 1;
                n5 = this.text.indexOf(43, n4);
            }
            block0 : switch (this.text.length() - n4) {
                case 1: {
                    n2 = this.text.charAt(n4);
                    n2 = Display.wcsToMbcs((char)n2);
                    break;
                }
                case 2: {
                    if (this.text.charAt(n4) != 'F') break;
                    switch (this.text.charAt(n4 + 1)) {
                        case '1': {
                            n2 = 65470;
                            break;
                        }
                        case '2': {
                            n2 = 65471;
                            break;
                        }
                        case '3': {
                            n2 = 65472;
                            break;
                        }
                        case '4': {
                            n2 = 65473;
                            break;
                        }
                        case '5': {
                            n2 = 65474;
                            break;
                        }
                        case '6': {
                            n2 = 65475;
                            break;
                        }
                        case '7': {
                            n2 = 65476;
                            break;
                        }
                        case '8': {
                            n2 = 65477;
                            break;
                        }
                        case '9': {
                            n2 = 65478;
                        }
                    }
                    break;
                }
                case 3: {
                    if (this.text.charAt(n4) != 'F' || this.text.charAt(n4 + 1) != '1') break;
                    switch (this.text.charAt(n4 + 2)) {
                        case '0': {
                            n2 = 65479;
                            break block0;
                        }
                        case '1': {
                            n2 = 65480;
                            break block0;
                        }
                        case '2': {
                            n2 = 65481;
                            break block0;
                        }
                        case '3': {
                            n2 = 65482;
                            break block0;
                        }
                        case '4': {
                            n2 = 65483;
                            break block0;
                        }
                        case '5': {
                            n2 = 65484;
                        }
                    }
                }
            }
        }
        if (n2 != 0) {
            long l = this.getAccelGroup();
            if (bl) {
                OS.gtk_widget_add_accelerator(this.handle, OS.activate, l, n2, n, 1);
            } else {
                OS.gtk_widget_remove_accelerator(this.handle, l, n2, n);
            }
        }
        return n2 != 0;
    }
}

