/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.FlushBuffer;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFilter;
import de.qfs.lib.log.LogQueue;
import de.qfs.lib.log.LogWriter;
import de.qfs.lib.log.StreamLogWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Vector;

public class Log {
    public static final int ERR = 1;
    public static final int ERRDETAIL = 2;
    public static final int WRN = 3;
    public static final int WRNDETAIL = 4;
    public static final int MSG = 5;
    public static final int MSGDETAIL = 6;
    public static final int MTD = 7;
    public static final int MTDDETAIL = 8;
    public static final int DBG = 9;
    public static final int DBGDETAIL = 10;
    private static boolean DEBUG = "true".equalsIgnoreCase(System.getenv("QFLIB_LOG_DEBUG"));
    public static final int DEFAULT_OUTPUT_LEVEL = 10;
    private static final Object classlock = new Object();
    private static int level = 10;
    public static final int DEFAULT_PRE_QUEUE_LEVEL = 10;
    private static int preQueueLevel = 10;
    public static final boolean DEFAULT_QUEUEING = true;
    public static final int DEFAULT_INITIAL_QUEUE_SIZE = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 3000;
    public static final boolean DEFAULT_INITIAL_DROP_ON_OVERFLOW = true;
    public static final boolean DEFAULT_DROP_ON_OVERFLOW = false;
    public static final int DEFAULT_FLUSH_BUFFER_SIZE = 0;
    private static FlushBuffer flushBuffer = null;
    public static final int DEFAULT_FLUSH_TRIGGER_LEVEL = 1;
    private static int flushTriggerLevel = 1;
    public static final int DEFAULT_POST_FLUSH_SIZE = 10;
    private static int postFlushSize = 10;
    private static int postFlushCount = 0;
    public static final int DEFAULT_MAXIMUM_MESSAGE_SIZE = 20000;
    private static int maxMessageSize = 20000;
    private static LogQueue queue = new LogQueue();
    private static boolean queueing = true;
    private static int targetQueueSize = 3000;
    private static boolean targetQueueDropOnOverflow = false;
    private static Vector filters = new Vector();
    private static LogFilter[] _filters = new LogFilter[0];
    private static LogWriter writer = new StreamLogWriter();
    private static Hashtable silenced = new Hashtable();
    private static LogThread logThread = new LogThread();
    private static boolean logThreadStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startLogThread() {
        LogThread logThread = Log.logThread;
        synchronized (logThread) {
            if (!logThreadStarted) {
                if (DEBUG) {
                    System.err.println("startLogThread - now: " + System.currentTimeMillis());
                    Thread.dumpStack();
                }
                logThreadStarted = true;
                Log.logThread.start();
            }
        }
    }

    public static void log(int n, long l, String string, String string2, String string3) {
        Thread thread = Thread.currentThread();
        if (silenced.containsKey(thread)) {
            return;
        }
        Log.log(n, l, string, string2, string3, thread.getName());
    }

    public static void log(int n, long l, String string, String string2, String string3, String string4) {
        boolean bl;
        Thread thread = Thread.currentThread();
        if (silenced.containsKey(thread)) {
            return;
        }
        if (maxMessageSize > 0 && string3 != null && string3.length() > maxMessageSize) {
            string3 = string3.substring(0, maxMessageSize);
        }
        boolean bl2 = bl = postFlushCount > 0;
        if (bl) {
            --postFlushCount;
        } else if (n > preQueueLevel) {
            if (flushBuffer != null) {
                flushBuffer.buffer(n, l, string, string2, string3);
            }
            return;
        }
        if (n <= flushTriggerLevel) {
            postFlushCount = postFlushSize;
            if (!bl && flushBuffer != null) {
                LogEntry[] logEntryArray = flushBuffer.flush();
                for (int i = 0; i < logEntryArray.length; ++i) {
                    if (queueing) {
                        queue.push(logEntryArray[i]);
                        continue;
                    }
                    Log.filter(logEntryArray[i]);
                }
            }
        }
        if (queueing) {
            queue.push(new LogEntry(n, l, string4, string, string2, string3));
        } else {
            Log.filter(new LogEntry(n, l, string4, string, string2, string3));
        }
    }

    public static void log(int n, String string, String string2, Throwable throwable) {
        long l = System.currentTimeMillis();
        boolean bl = throwable instanceof DumpStackException;
        String string3 = Log.getStackTrace(throwable);
        String string4 = throwable.getClass().getName() + ": " + throwable.getMessage();
        if (bl) {
            string4 = throwable.getMessage();
            int n2 = string3.indexOf(58);
            if (n2 > -1 && string3.length() >= n2 + 2) {
                string3 = string3.substring(n2 + 2);
            }
        }
        Log.log(n, l, string, string2, string4);
        Log.log(n + 1, l, string, string2, string3);
    }

    public static void log(int n, String string, String string2, Throwable throwable, String string3) {
        long l = System.currentTimeMillis();
        Log.log(n, l, string, string2, throwable.getClass().getName() + ": " + throwable.getMessage() + " - " + string3);
        String string4 = Log.getStackTrace(throwable);
        Log.log(n + 1, l, string, string2, string4);
    }

    public static LogWriter getLogWriter() {
        return writer;
    }

    public static void setLogWriter(LogWriter logWriter) {
        writer = logWriter;
    }

    public static void excludeThread() {
        Log.excludeThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excludeThread(Thread thread) {
        Hashtable hashtable = silenced;
        synchronized (hashtable) {
            if (silenced.containsKey(thread)) {
                silenced.put(thread, new Integer((Integer)silenced.get(thread) + 1));
            } else {
                silenced.put(thread, new Integer(1));
            }
        }
    }

    public static void includeThread() {
        Log.includeThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeThread(Thread thread) {
        Hashtable hashtable = silenced;
        synchronized (hashtable) {
            Integer n = (Integer)silenced.get(thread);
            if (n != null) {
                if (n == 1) {
                    silenced.remove(thread);
                } else {
                    silenced.put(thread, new Integer(n - 1));
                }
            }
        }
    }

    public static void addFilter(LogFilter logFilter) {
        filters.insertElementAt(logFilter, 0);
        _filters = new LogFilter[filters.size()];
        filters.copyInto(_filters);
    }

    public static void removeFilter(LogFilter logFilter) {
        if (filters.removeElement(logFilter)) {
            _filters = new LogFilter[filters.size()];
            filters.copyInto(_filters);
        }
    }

    public static int getOutputLevel() {
        return level;
    }

    public static void setOutputLevel(int n) {
        level = n;
    }

    public static int getPreQueueLevel() {
        return preQueueLevel;
    }

    public static void setPreQueueLevel(int n) {
        preQueueLevel = n;
    }

    public static int getMaxMessageSize() {
        return maxMessageSize;
    }

    public static void setMaxMessageSize(int n) {
        maxMessageSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFlushBufferSize() {
        Object object = classlock;
        synchronized (object) {
            return flushBuffer == null ? 0 : flushBuffer.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFlushBufferSize(int n) {
        Object object = classlock;
        synchronized (object) {
            if (n > 0) {
                if (flushBuffer == null) {
                    flushBuffer = new FlushBuffer(n);
                } else {
                    flushBuffer.resize(n);
                }
            } else {
                flushBuffer = null;
            }
        }
    }

    public static int getFlushTriggerLevel() {
        return flushTriggerLevel;
    }

    public static void setFlushTriggerLevel(int n) {
        flushTriggerLevel = n;
    }

    public static int getPostFlushSize() {
        return postFlushSize;
    }

    public static void setPostFlushSize(int n) {
        postFlushSize = n;
        if (postFlushCount > postFlushSize) {
            postFlushCount = postFlushSize;
        }
    }

    public static final boolean isQueueing() {
        return queueing;
    }

    public static final void setQueueing(boolean bl) {
        queue.setQueueing(bl);
        queueing = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQueueSize() {
        LogThread logThread = Log.logThread;
        synchronized (logThread) {
            if (Log.logThread.isRunning()) {
                return queue.getQueueSize();
            }
            return targetQueueSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQueueSize(int n) {
        LogThread logThread = Log.logThread;
        synchronized (logThread) {
            if (Log.logThread.isRunning()) {
                queue.setQueueSize(n);
            } else {
                targetQueueSize = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDropOnOverflow() {
        LogThread logThread = Log.logThread;
        synchronized (logThread) {
            if (Log.logThread.isRunning()) {
                return queue.isDropOnOverflow();
            }
            return targetQueueDropOnOverflow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDropOnOverflow(boolean bl) {
        LogThread logThread = Log.logThread;
        synchronized (logThread) {
            if (Log.logThread.isRunning()) {
                queue.setDropOnOverflow(bl);
            } else {
                targetQueueDropOnOverflow = bl;
            }
        }
    }

    private static void filter(final LogEntry logEntry) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block4: {
                    try {
                        boolean bl = false;
                        for (int i = 0; i < _filters.length; ++i) {
                            if (_filters[i].filter(logEntry)) continue;
                            bl = true;
                            break;
                        }
                        if (writer != null && !bl && logEntry.getLevel() <= level) {
                            writer.write(logEntry);
                        }
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block4;
                        System.err.println("Exception in LogThread");
                        exception.printStackTrace();
                        System.err.println(logEntry);
                    }
                }
                return null;
            }
        });
    }

    private static void filter(final LogEntry[] logEntryArray) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block5: {
                    LogEntry[] logEntryArray2 = logEntryArray;
                    try {
                        int n;
                        for (n = 0; n < _filters.length && logEntryArray2 != null && logEntryArray2.length > 0; ++n) {
                            logEntryArray2 = _filters[n].filter(logEntryArray2);
                        }
                        if (writer != null && logEntryArray2 != null) {
                            for (n = 0; n < logEntryArray2.length; ++n) {
                                if (logEntryArray2[n].getLevel() > level) continue;
                                writer.write(logEntryArray2[n]);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block5;
                        System.err.println("Exception in LogThread");
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    static {
        silenced.put(logThread, new Integer(1));
        long l = 500L;
        try {
            l = Long.parseLong(System.getenv("LOG_DELAY_LOG_THREAD"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l > 0L) {
            final long l2 = l;
            Thread thread = new Thread("delay log thread"){

                @Override
                public void run() {
                    try {
                        if (DEBUG) {
                            System.err.println("Log - now: " + System.currentTimeMillis());
                            System.err.println("Log - delay: " + l2);
                        }
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Log.startLogThread();
                }
            };
            thread.setDaemon(true);
            thread.start();
        } else {
            Log.startLogThread();
        }
    }

    public static class DumpStackException
    extends Exception {
        public DumpStackException(String string) {
            super(string);
        }

        @Override
        public Throwable fillInStackTrace() {
            Throwable throwable = super.fillInStackTrace();
            this.cleanStackTrace();
            return throwable;
        }

        private void cleanStackTrace() {
            try {
                StackTraceElement[] stackTraceElementArray = this.getStackTrace();
                int n = 0;
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    boolean bl;
                    String string = stackTraceElement.getMethodName();
                    boolean bl2 = bl = "dumpStack".equals(string) || "log".equals(string) || "logAt".equals(string);
                    if (!bl) break;
                    ++n;
                }
                if (n > 0) {
                    int n2 = stackTraceElementArray.length;
                    StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n2 - n];
                    System.arraycopy(stackTraceElementArray, n, stackTraceElementArray2, 0, n2 - n);
                    this.setStackTrace(stackTraceElementArray2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class LogThread
    extends Thread {
        private boolean running;

        public LogThread() {
            this.setPriority(1);
            this.setName("LogThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    LogEntry[] logEntryArray;
                    1 var2_1 = this;
                    synchronized (var2_1) {
                        LogThread.this.running = true;
                        logEntryArray = queueing ? queue.popAll() : new LogEntry[]{queue.pop()};
                        queue.entriesProcessed();
                        queue.setQueueSize(targetQueueSize);
                        queue.setDropOnOverflow(targetQueueDropOnOverflow);
                    }
                    Log.filter(logEntryArray);
                    while (true) {
                        if (queueing) {
                            Log.filter(queue.popAll());
                        } else {
                            Log.filter(queue.pop());
                        }
                        queue.entriesProcessed();
                    }
                }
            });
        }

        public final boolean isRunning() {
            return this.running;
        }
    }
}

