/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        Object[] objectArray;
        boolean bl;
        long l;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l2 = this.gtk_font_chooser_dialog_new(byArray);
        if (this.parent != null) {
            l = this.parent.topHandle();
            OS.gtk_window_set_transient_for(l2, l);
            long l3 = OS.gtk_window_get_icon_list(l);
            if (l3 != 0L) {
                OS.gtk_window_set_icon_list(l2, l3);
                OS.g_list_free(l3);
            }
        }
        l = OS.gtk_window_get_group(0L);
        OS.gtk_window_group_add_window(l, l2);
        OS.gtk_window_set_modal(l2, true);
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            long l4 = OS.pango_font_description_to_string(font.handle);
            int n = OS.strlen(l4);
            byte[] byArray2 = new byte[n + 1];
            OS.memmove(byArray2, l4, (long)n);
            font.dispose();
            OS.g_free(l4);
            this.gtk_font_chooser_set_font(l2, byArray2);
        }
        display.runDialogShownHooks(this, l2);
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l2)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l5 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l5 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l2, 0L);
        }
        int n2 = OS.gtk_dialog_run(l2);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l5);
        }
        if (OS.gtk_window_get_modal(l2)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            long l6 = this.gtk_font_chooser_get_font(l2);
            int n3 = OS.strlen(l6);
            byte[] byArray3 = new byte[n3 + 1];
            OS.memmove(byArray3, l6, (long)n3);
            OS.g_free(l6);
            long l7 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new(display, l7);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(l7);
        }
        if (bl) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.fontData;
            objectArray = objectArray2;
            objectArray2[1] = null;
        } else {
            objectArray = null;
        }
        Object[] objectArray3 = (Object[])display.runDialogClosedHooks(this, objectArray);
        if (objectArray3 != null) {
            this.fontData = (FontData)objectArray3[0];
            this.rgb = (RGB)objectArray3[1];
            bl = true;
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l2);
        if (!bl) {
            return null;
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl) {
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    long gtk_font_chooser_get_font(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            return OS.gtk_font_chooser_get_font(l);
        }
        return OS.gtk_font_selection_dialog_get_font_name(l);
    }

    long gtk_font_chooser_dialog_new(byte[] byArray) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            return OS.gtk_font_chooser_dialog_new(byArray, 0L);
        }
        return OS.gtk_font_selection_dialog_new(byArray);
    }

    void gtk_font_chooser_set_font(long l, byte[] byArray) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            OS.gtk_font_chooser_set_font(l, byArray);
        } else {
            OS.gtk_font_selection_dialog_set_font_name(l, byArray);
        }
    }
}

