/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;
    static final int GROW_SIZE = 4;
    static final int MESSAGE_LIMIT = 64;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Synchronizer");
    static final boolean IS_CARBON = "carbon".equals(SWT.getPlatform());
    static final boolean IS_COCOA = "cocoa".equals(SWT.getPlatform());
    static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    public Synchronizer(Display display) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("Synchronizer(Display)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add(this).add(", display: ").add(display)).log(7);
        }
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(RunnableLock runnableLock) {
        boolean bl = false;
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] runnableLockArray = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, runnableLockArray, 0, this.messageCount);
                this.messages = runnableLockArray;
            }
            this.messages[this.messageCount++] = runnableLock;
            bl = this.messageCount == 1;
        }
        if (bl) {
            this.display.wakeThread();
        }
    }

    protected void internalAsyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("internalAsyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add(runnable)).log(7);
        }
        if (runnable != null && "org.eclipse.ui.internal.UISynchronizer".equals(this.getClass().getName()) && runnable.getClass().getName().startsWith("de.qfs.")) {
            this.trueAsyncExec(runnable);
        } else {
            this.asyncExec(runnable);
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("asyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add(runnable)).log(7);
        }
        this.trueAsyncExec(runnable);
    }

    void trueAsyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("trueAsyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add(this).add(", runnable: ").add(runnable)).log(7);
        }
        if (!(runnable != null || IS_CARBON || IS_GTK || IS_COCOA)) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCount() {
        Object object = this.messageLock;
        synchronized (object) {
            return this.messageCount;
        }
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messageCount == 0) {
                return null;
            }
            RunnableLock runnableLock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0 && this.messages.length > 64) {
                this.messages = null;
            }
            return runnableLock;
        }
    }

    boolean runAsyncMessages() {
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runAsyncMessages(boolean bl) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("runAsyncMessages(boolean)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("this: ").add(this).add(", all: ").add(bl)).log(7);
        }
        boolean bl2 = false;
        do {
            block12: {
                RunnableLock runnableLock;
                if ((runnableLock = this.removeFirst()) == null) {
                    return bl2;
                }
                bl2 = true;
                RunnableLock runnableLock2 = runnableLock;
                synchronized (runnableLock2) {
                    block13: {
                        Object var7_7;
                        this.syncThread = runnableLock.thread;
                        this.display.sendPreEvent(null);
                        try {
                            try {
                                runnableLock.run();
                            }
                            catch (Throwable throwable) {
                                runnableLock.throwable = throwable;
                                SWT.error(46, throwable);
                                var7_7 = null;
                                if (this.display != null && !this.display.isDisposed()) {
                                    this.display.sendPostEvent(null);
                                }
                                this.syncThread = null;
                                runnableLock.notifyAll();
                                break block12;
                            }
                            var7_7 = null;
                            if (this.display == null) break block13;
                        }
                        catch (Throwable throwable) {
                            var7_7 = null;
                            if (this.display != null && !this.display.isDisposed()) {
                                this.display.sendPostEvent(null);
                            }
                            this.syncThread = null;
                            runnableLock.notifyAll();
                            throw throwable;
                        }
                        if (!this.display.isDisposed()) {
                            this.display.sendPostEvent(null);
                        }
                    }
                    this.syncThread = null;
                    runnableLock.notifyAll();
                }
            }
        } while (bl);
        return bl2;
    }

    protected void internalSyncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("internalSyncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add(runnable)).log(7);
        }
        if (runnable != null && "org.eclipse.ui.internal.UISynchronizer".equals(this.getClass().getName()) && runnable.getClass().getName().startsWith("de.qfs.")) {
            this.trueSyncExec(runnable);
        } else {
            this.syncExec(runnable);
        }
    }

    protected void syncExec(Runnable runnable) {
        if (Synchronizer.logger.level >= 7) {
            Logger.Builder builder = logger.build("syncExec(Runnable)");
            (Synchronizer.logger.level < 8 ? builder : builder.add("runnable: ").add(runnable)).log(7);
        }
        this.trueSyncExec(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trueSyncExec(Runnable runnable) {
        Object object;
        if (Synchronizer.logger.level >= 7) {
            object = logger.build("trueSyncExec(Runnable)");
            ((Logger.Builder)(Synchronizer.logger.level < 8 ? object : ((Logger.Builder)object).add("this: ").add(this).add(", runnable: ").add(runnable))).log(7);
        }
        object = null;
        Object object2 = Device.class;
        synchronized (Device.class) {
            if (this.display == null || this.display.isDisposed()) {
                SWT.error(45);
            }
            if (!this.display.isValidThread()) {
                if (runnable == null) {
                    this.display.wake();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                object = new RunnableLock(runnable);
                ((RunnableLock)object).thread = Thread.currentThread();
                this.addLast((RunnableLock)object);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (object == null) {
                if (runnable != null) {
                    this.display.sendPreEvent(null);
                    try {
                        runnable.run();
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (this.display != null && !this.display.isDisposed()) {
                            this.display.sendPostEvent(null);
                        }
                        throw throwable;
                    }
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.sendPostEvent(null);
                    }
                }
                return;
            }
            object2 = object;
            synchronized (object2) {
                boolean bl = false;
                while (!((RunnableLock)object).done()) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                if (bl) {
                    Compatibility.interrupt();
                }
                if (((RunnableLock)object).throwable != null) {
                    SWT.error(46, ((RunnableLock)object).throwable);
                }
            }
            return;
        }
    }
}

