/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle;

import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

public abstract class CommandLineUtility {
    final PrintStream out;
    final PrintStream err;
    final ProgressMonitor progressMonitor;

    CommandLineUtility() {
        this(System.out, System.err, true);
    }

    CommandLineUtility(OutputStream outputStream, OutputStream outputStream2, boolean bl) {
        if (outputStream == null || outputStream2 == null) {
            throw new NullPointerException();
        }
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream, bl);
        this.err = outputStream2 instanceof PrintStream ? (PrintStream)outputStream2 : new PrintStream(outputStream2, bl);
        this.progressMonitor = new ProgressMonitor(this.err);
        CommandLineUtility.configKeyManager();
    }

    private static void configKeyManager() {
        String string = "de.schlichtherle.key.passwd.swing.InvalidOpenKeyFeedback";
        System.setProperty(string, System.getProperty(string, "de.schlichtherle.key.passwd.swing.HurlingWindowFeedback"));
        string = "de.schlichtherle.key.passwd.swing.InvalidCreateKeyFeedback";
        System.setProperty(string, System.getProperty(string, "de.schlichtherle.key.passwd.swing.HurlingWindowFeedback"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int run(String[] stringArray) {
        int n;
        try {
            n = this.runWithException(stringArray) ? 0 : 1;
        }
        catch (Throwable throwable) {
            try {
                try {
                    File.umount();
                }
                finally {
                    this.progressMonitor.shutdown();
                }
                throw throwable;
            }
            catch (IllegalUsageException illegalUsageException) {
                this.err.println(illegalUsageException.getLocalizedMessage());
                return 1;
            }
            catch (IOException iOException) {
                this.err.println(iOException.getLocalizedMessage());
                return 1;
            }
        }
        try {
            File.umount();
        }
        finally {
            this.progressMonitor.shutdown();
        }
        return n;
    }

    public abstract boolean runWithException(String[] var1) throws IllegalUsageException, IOException;

    static class ProgressMonitor
    extends Thread {
        private final PrintStream err;
        private final Long[] args = new Long[2];
        private final ArchiveStatistics liveStats = File.getLiveArchiveStatistics();

        ProgressMonitor(PrintStream printStream) {
            this.err = printStream;
            this.setPriority(10);
            this.setDaemon(true);
        }

        public void start() {
            if (this.err == System.err || this.err == System.out) {
                super.start();
            }
        }

        public void run() {
            boolean bl = false;
            long l = 2000L;
            while (true) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                this.showProgress();
                l = 200L;
                bl = true;
            }
            if (bl) {
                this.showProgress();
                this.err.println();
            }
        }

        private void showProgress() {
            this.args[0] = new Long((this.liveStats.getUpdateTotalByteCountRead() + 1023L) / 1024L);
            this.args[1] = new Long((this.liveStats.getUpdateTotalByteCountWritten() + 1023L) / 1024L);
            this.err.print(MessageFormat.format("Top level archive I/O: {0} / {1} KB        \r", this.args));
            this.err.flush();
        }

        private void shutdown() {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static abstract class IllegalUsageException
    extends IllegalArgumentException {
        IllegalUsageException(String string) {
            super(string);
        }
    }
}

