/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryMetaData;
import de.schlichtherle.io.ArchiveFileSystemController;
import de.schlichtherle.io.Entry;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import java.io.CharConversionException;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;

final class ArchiveFileSystem
implements Entry {
    private static final String ROOT_DIRECTORY_NAME = "/";
    private final ArchiveFileSystemController controller;
    private final boolean readOnly;
    private Map master;
    private final ArchiveEntry root;
    private long touched;
    private final String[] split = new String[2];
    static final /* synthetic */ boolean $assertionsDisabled;

    ArchiveFileSystem(ArchiveFileSystemController archiveFileSystemController) throws IOException {
        this.controller = archiveFileSystemController;
        this.touched = 1L;
        this.master = new LinkedHashMap(64);
        this.root = this.createArchiveEntry(ROOT_DIRECTORY_NAME);
        this.root.setTime(System.currentTimeMillis());
        this.master.put(ROOT_DIRECTORY_NAME, this.root);
        this.readOnly = false;
        archiveFileSystemController.touch();
    }

    ArchiveFileSystem(ArchiveFileSystemController archiveFileSystemController, InputArchive inputArchive, long l, boolean bl) {
        ArchiveEntry archiveEntry;
        this.controller = archiveFileSystemController;
        int n = (int)((float)inputArchive.getNumArchiveEntries() / 0.75f) + 1;
        this.master = new LinkedHashMap(n);
        this.root = this.createArchiveEntry(ROOT_DIRECTORY_NAME);
        this.root.setTime(l);
        this.master.put(ROOT_DIRECTORY_NAME, this.root);
        Enumeration enumeration = inputArchive.getArchiveEntries();
        while (enumeration.hasMoreElements()) {
            archiveEntry = (ArchiveEntry)enumeration.nextElement();
            String string = archiveEntry.getName();
            if (ROOT_DIRECTORY_NAME.equals(string) || "./".equals(string)) continue;
            archiveEntry.setMetaData(new ArchiveEntryMetaData(archiveEntry));
            this.master.put(string, archiveEntry);
        }
        enumeration = inputArchive.getArchiveEntries();
        while (enumeration.hasMoreElements()) {
            archiveEntry = (ArchiveEntry)enumeration.nextElement();
            if (!ArchiveFileSystem.isLegalEntryName(archiveEntry.getName())) continue;
            this.fixParents(archiveEntry);
        }
        this.readOnly = bl;
        if (bl) {
            this.master = Collections.unmodifiableMap(this.master);
        }
        if (!$assertionsDisabled && this.touched != 0L) {
            throw new AssertionError();
        }
    }

    private static boolean isLegalEntryName(String string) {
        int n = string.length();
        if (n <= 0) {
            return false;
        }
        block0 : switch (string.charAt(0)) {
            case '/': {
                return false;
            }
            case '.': {
                if (n >= 2) {
                    switch (string.charAt(1)) {
                        case '.': {
                            if (n >= 3) {
                                if (string.charAt(2) != '/') break block0;
                                if (!$assertionsDisabled && !string.startsWith("../")) {
                                    throw new AssertionError();
                                }
                                return false;
                            }
                            if (!$assertionsDisabled && !"..".equals(string)) {
                                throw new AssertionError();
                            }
                            return false;
                        }
                        case '/': {
                            if (!$assertionsDisabled && !string.startsWith("./")) {
                                throw new AssertionError();
                            }
                            return false;
                        }
                    }
                    break;
                }
                if (!$assertionsDisabled && !".".equals(string)) {
                    throw new AssertionError();
                }
                return false;
            }
        }
        return true;
    }

    private void fixParents(ArchiveEntry archiveEntry) {
        String string = archiveEntry.getName();
        if (ArchiveFileSystem.isRoot(string) || string.charAt(0) == '/') {
            return;
        }
        if (!$assertionsDisabled && !ArchiveFileSystem.isLegalEntryName(string)) {
            throw new AssertionError();
        }
        String[] stringArray = this.split(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        ArchiveEntry archiveEntry2 = (ArchiveEntry)this.master.get(string2);
        if (archiveEntry2 == null) {
            archiveEntry2 = this.createArchiveEntry(string2);
            this.master.put(string2, archiveEntry2);
        }
        this.fixParents(archiveEntry2);
        archiveEntry2.getMetaData().children.add(string3);
    }

    private final String[] split(String string) {
        return ArchiveFileSystem.split(string, this.split);
    }

    static String[] split(String string, String[] stringArray) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray.length < 2) {
            throw new AssertionError();
        }
        int n = string.length();
        if (0 <= --n && string.charAt(n) == '/') {
            --n;
        }
        int n2 = string.lastIndexOf(47, n);
        ++n;
        if (n2 != -1) {
            stringArray[0] = string.substring(0, ++n2);
            stringArray[1] = string.substring(n2, n);
        } else {
            stringArray[0] = n > 0 ? ROOT_DIRECTORY_NAME : null;
            stringArray[1] = string.substring(0, n);
        }
        return stringArray;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isTouched() {
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return this.touched != 0L;
    }

    private void touch() throws IOException {
        if (this.isReadOnly()) {
            throw new ArchiveReadOnlyException();
        }
        if (this.touched == 0L) {
            this.controller.touch();
        }
        ++this.touched;
    }

    Enumeration getArchiveEntries() {
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return Collections.enumeration(this.master.values());
    }

    ArchiveEntry getRoot() {
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return this.root;
    }

    static final boolean isRoot(String string) {
        return "" == string;
    }

    ArchiveEntry get(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return (ArchiveEntry)this.master.get(string);
    }

    Delta link(String string, boolean bl) throws ArchiveFileSystemException {
        return this.link(string, bl, null);
    }

    Delta link(String string, boolean bl, ArchiveEntry archiveEntry) throws ArchiveFileSystemException {
        if (!$assertionsDisabled && !ArchiveFileSystem.isRoot(string) && string.charAt(0) == '/') {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        if (ArchiveFileSystem.isRoot(string)) {
            throw new ArchiveFileSystemException(string, "virtual root directory cannot get replaced");
        }
        return new LinkDelta(string, bl, archiveEntry);
    }

    private ArchiveEntry createArchiveEntry(String string, ArchiveEntry archiveEntry) throws CharConversionException {
        ArchiveEntry archiveEntry2 = this.controller.createArchiveEntry(string, archiveEntry);
        archiveEntry2.setMetaData(new ArchiveEntryMetaData(archiveEntry2));
        return archiveEntry2;
    }

    private ArchiveEntry createArchiveEntry(String string) {
        try {
            return this.createArchiveEntry(string, null);
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionError((Object)charConversionException);
        }
    }

    private void unlink(String string) throws IOException {
        if (ArchiveFileSystem.isRoot(string)) {
            throw new ArchiveFileSystemException(string, "virtual root directory cannot get unlinked");
        }
        try {
            ArchiveEntry archiveEntry = (ArchiveEntry)this.master.remove(string);
            if (archiveEntry == null) {
                throw new ArchiveFileSystemException(string, "entry does not exist");
            }
            if (archiveEntry == this.root || archiveEntry.isDirectory() && archiveEntry.getMetaData().children.size() != 0) {
                this.master.put(string, archiveEntry);
                throw new ArchiveFileSystemException(string, "directory is not empty");
            }
            String[] stringArray = this.split(string);
            String string2 = stringArray[0];
            ArchiveEntry archiveEntry2 = (ArchiveEntry)this.master.get(string2);
            if (!$assertionsDisabled && archiveEntry2 == null) {
                throw new AssertionError((Object)("The parent directory of \"" + string + "\" is missing - archive file system is corrupted!"));
            }
            boolean bl = archiveEntry2.getMetaData().children.remove(stringArray[1]);
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError((Object)("The parent directory of \"" + string + "\" does not contain this entry - archive file system is corrupted!"));
            }
            this.touch();
            if (archiveEntry2.getTime() != -1L) {
                archiveEntry2.setTime(System.currentTimeMillis());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ArchiveReadOnlyException();
        }
    }

    boolean exists(String string) {
        return this.get(string) != null || this.get(string + ROOT_DIRECTORY_NAME) != null;
    }

    boolean isFile(String string) {
        return this.get(string) != null;
    }

    boolean isDirectory(String string) {
        return this.get(string + ROOT_DIRECTORY_NAME) != null;
    }

    Icon getOpenIcon(String string) {
        if (!$assertionsDisabled && ArchiveFileSystem.isRoot(string)) {
            throw new AssertionError();
        }
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null) {
            archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        }
        return archiveEntry != null ? archiveEntry.getOpenIcon() : null;
    }

    Icon getClosedIcon(String string) {
        if (!$assertionsDisabled && ArchiveFileSystem.isRoot(string)) {
            throw new AssertionError();
        }
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null) {
            archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        }
        return archiveEntry != null ? archiveEntry.getClosedIcon() : null;
    }

    boolean canWrite(String string) {
        return !this.isReadOnly() && this.exists(string);
    }

    boolean setReadOnly(String string) {
        return this.isReadOnly() && this.exists(string);
    }

    long length(String string) {
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null || archiveEntry.isDirectory()) {
            return 0L;
        }
        long l = archiveEntry.getSize();
        return l != -1L ? l : 0L;
    }

    long lastModified(String string) {
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null) {
            archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        }
        if (archiveEntry != null) {
            long l = archiveEntry.getTime();
            return l >= 0L ? l : 0L;
        }
        return 0L;
    }

    boolean setLastModified(String string, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException(string + " (negative entry modification time)");
        }
        if (this.isReadOnly()) {
            return false;
        }
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null && (archiveEntry = this.get(string + ROOT_DIRECTORY_NAME)) == null) {
            return false;
        }
        this.touch();
        archiveEntry.setTime(l);
        return true;
    }

    String[] list(String string) {
        ArchiveEntry archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        if (archiveEntry != null) {
            return archiveEntry.getMetaData().list();
        }
        return null;
    }

    String[] list(String string, FilenameFilter filenameFilter, File file) {
        ArchiveEntry archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        if (archiveEntry != null) {
            if (filenameFilter != null) {
                return archiveEntry.getMetaData().list(filenameFilter, file);
            }
            return archiveEntry.getMetaData().list();
        }
        return null;
    }

    File[] listFiles(String string, FilenameFilter filenameFilter, File file, FileFactory fileFactory) {
        ArchiveEntry archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        if (archiveEntry != null) {
            return archiveEntry.getMetaData().listFiles(filenameFilter, file, fileFactory);
        }
        return null;
    }

    File[] listFiles(String string, FileFilter fileFilter, File file, FileFactory fileFactory) {
        ArchiveEntry archiveEntry = this.get(string + ROOT_DIRECTORY_NAME);
        if (archiveEntry != null) {
            return archiveEntry.getMetaData().listFiles(fileFilter, file, fileFactory);
        }
        return null;
    }

    void mkdir(String string, boolean bl) throws IOException {
        this.link(string + ROOT_DIRECTORY_NAME, bl).commit();
    }

    void delete(String string) throws IOException {
        if (!$assertionsDisabled && !ArchiveFileSystem.isRoot(string) && string.charAt(0) == '/') {
            throw new AssertionError();
        }
        if (this.get(string) != null) {
            this.unlink(string);
            return;
        }
        String string2 = string + ROOT_DIRECTORY_NAME;
        if (this.get(string2) != null) {
            this.unlink(string2);
            return;
        }
        throw new ArchiveFileSystemException(string, "archive entry does not exist");
    }

    static {
        $assertionsDisabled = !ArchiveFileSystem.class.desiredAssertionStatus();
    }

    static class ArchiveReadOnlyException
    extends ArchiveFileSystemException {
        private ArchiveReadOnlyException() {
            super("Archive file is read-only!");
        }
    }

    static class ArchiveFileSystemException
    extends IOException {
        private final String entryName;

        private ArchiveFileSystemException(String string) {
            super(string);
            this.entryName = null;
        }

        private ArchiveFileSystemException(String string, String string2) {
            super(string2);
            this.entryName = string;
        }

        public String getMessage() {
            return this.entryName != null ? this.entryName + " (" + super.getMessage() + ")" : super.getMessage();
        }
    }

    static interface Delta {
        public ArchiveEntry getEntry();

        public void commit() throws IOException;
    }

    private static abstract class AbstractDelta
    implements Delta {
        private AbstractDelta() {
        }

        static class Element {
            final String baseName;
            final ArchiveEntry entry;
            static final /* synthetic */ boolean $assertionsDisabled;

            Element(String string, ArchiveEntry archiveEntry) {
                this.baseName = string;
                if (!$assertionsDisabled && archiveEntry == null) {
                    throw new AssertionError();
                }
                this.entry = archiveEntry;
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystem == null ? (class$de$schlichtherle$io$ArchiveFileSystem = ArchiveFileSystem.class$("de.schlichtherle.io.ArchiveFileSystem")) : class$de$schlichtherle$io$ArchiveFileSystem).desiredAssertionStatus();
            }
        }
    }

    private final class LinkDelta
    extends AbstractDelta {
        final AbstractDelta.Element[] elements;
        static final /* synthetic */ boolean $assertionsDisabled;

        private LinkDelta(String string, boolean bl, ArchiveEntry archiveEntry) throws ArchiveFileSystemException {
            if (ArchiveFileSystem.this.isReadOnly()) {
                throw new ArchiveReadOnlyException();
            }
            try {
                this.elements = this.createElements(string, bl, archiveEntry, 1);
            }
            catch (CharConversionException charConversionException) {
                ArchiveFileSystemException archiveFileSystemException = new ArchiveFileSystemException(charConversionException.toString());
                archiveFileSystemException.initCause(charConversionException);
                throw archiveFileSystemException;
            }
        }

        private AbstractDelta.Element[] createElements(String string, boolean bl, ArchiveEntry archiveEntry, int n) throws ArchiveFileSystemException, CharConversionException {
            AbstractDelta.Element[] elementArray;
            String[] stringArray = ArchiveFileSystem.this.split(string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            ArchiveEntry archiveEntry2 = (ArchiveEntry)ArchiveFileSystem.this.master.get(string2);
            if (archiveEntry2 != null) {
                ArchiveEntry archiveEntry3 = (ArchiveEntry)ArchiveFileSystem.this.master.get(string);
                this.ensureMayBeReplaced(string, archiveEntry3);
                elementArray = new AbstractDelta.Element[n + 1];
                elementArray[0] = new AbstractDelta.Element(string2, archiveEntry2);
                ArchiveEntry archiveEntry4 = ArchiveFileSystem.this.createArchiveEntry(string, archiveEntry);
                elementArray[1] = new AbstractDelta.Element(string3, archiveEntry4);
            } else if (bl) {
                elementArray = this.createElements(string2, bl, null, n + 1);
                ArchiveEntry archiveEntry5 = ArchiveFileSystem.this.createArchiveEntry(string, archiveEntry);
                elementArray[elementArray.length - n] = new AbstractDelta.Element(string3, archiveEntry5);
            } else {
                throw new ArchiveFileSystemException(string, "missing parent directory");
            }
            return elementArray;
        }

        private void ensureMayBeReplaced(String string, ArchiveEntry archiveEntry) throws ArchiveFileSystemException {
            int n = string.length() - 1;
            if (string.charAt(n) == '/') {
                if (archiveEntry != null) {
                    throw new ArchiveFileSystemException(string, "directories cannot get replaced");
                }
                if (ArchiveFileSystem.this.master.get(string.substring(0, n)) != null) {
                    throw new ArchiveFileSystemException(string, "directories cannot replace files");
                }
            } else if (ArchiveFileSystem.this.master.get(string + ArchiveFileSystem.ROOT_DIRECTORY_NAME) != null) {
                throw new ArchiveFileSystemException(string, "files cannot replace directories");
            }
        }

        public void commit() throws IOException {
            if (!$assertionsDisabled && ArchiveFileSystem.this.controller.getFileSystem() != ArchiveFileSystem.this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.elements.length < 2) {
                throw new AssertionError();
            }
            ArchiveFileSystem.this.touch();
            long l = System.currentTimeMillis();
            int n = this.elements.length;
            ArchiveEntry archiveEntry = this.elements[0].entry;
            for (int i = 1; i < n; ++i) {
                AbstractDelta.Element element = this.elements[i];
                String string = element.baseName;
                ArchiveEntry archiveEntry2 = element.entry;
                if (archiveEntry.getMetaData().children.add(string) && archiveEntry.getTime() != -1L) {
                    archiveEntry.setTime(l);
                }
                ArchiveFileSystem.this.master.put(archiveEntry2.getName(), archiveEntry2);
                archiveEntry = archiveEntry2;
            }
            ArchiveEntry archiveEntry3 = this.elements[n - 1].entry;
            if (archiveEntry3.getTime() == -1L) {
                archiveEntry3.setTime(l);
            }
        }

        public ArchiveEntry getEntry() {
            if (!$assertionsDisabled && ArchiveFileSystem.this.controller.getFileSystem() != ArchiveFileSystem.this) {
                throw new AssertionError();
            }
            return this.elements[this.elements.length - 1].entry;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystem == null ? (class$de$schlichtherle$io$ArchiveFileSystem = ArchiveFileSystem.class$("de.schlichtherle.io.ArchiveFileSystem")) : class$de$schlichtherle$io$ArchiveFileSystem).desiredAssertionStatus();
        }
    }
}

