/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveControllers;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.Files;
import de.schlichtherle.io.Streams;
import de.schlichtherle.io.util.Paths;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

public class File
extends java.io.File {
    private static final long serialVersionUID = 3617072883686191745L;
    private static final Set roots;
    private static final String uncPrefix;
    private static boolean lenient;
    private static ArchiveDetector defaultDetector;
    private final java.io.File delegate;
    private final ArchiveDetector detector;
    private transient File innerArchive;
    private String innerEntryName;
    private File enclArchive;
    private String enclEntryName;
    private transient ArchiveController controller;
    static final /* synthetic */ boolean $assertionsDisabled;

    public File(java.io.File file) {
        this(file, defaultDetector);
    }

    public File(java.io.File file, ArchiveDetector archiveDetector) {
        super(file.getPath());
        if (file instanceof File) {
            File file2 = (File)file;
            this.delegate = file2.delegate;
            this.detector = file2.detector;
            this.enclArchive = file2.enclArchive;
            this.enclEntryName = file2.enclEntryName;
            this.innerArchive = file2.isArchive() ? this : file2.innerArchive;
            this.innerEntryName = file2.innerEntryName;
            this.controller = file2.controller;
        } else {
            this.delegate = file;
            this.detector = archiveDetector;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(String string) {
        this(string, defaultDetector);
    }

    public File(String string, ArchiveDetector archiveDetector) {
        super(string);
        this.delegate = new java.io.File(string);
        this.detector = archiveDetector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(String string, String string2) {
        this(string, string2, defaultDetector);
    }

    public File(String string, String string2, ArchiveDetector archiveDetector) {
        super(string, string2);
        this.delegate = new java.io.File(string, string2);
        this.detector = archiveDetector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(java.io.File file, String string) {
        this(file, string, null);
    }

    public File(java.io.File file, String string, ArchiveDetector archiveDetector) {
        super(file, string);
        this.delegate = new java.io.File(file, string);
        if (file instanceof File) {
            File file2 = (File)file;
            this.detector = archiveDetector != null ? archiveDetector : file2.detector;
            this.init(file2);
        } else {
            this.detector = archiveDetector != null ? archiveDetector : defaultDetector;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(URI uRI) {
        this(uRI, (ArchiveDetector)ArchiveDetector.ALL);
    }

    File(URI uRI, ArchiveDetector archiveDetector) {
        super(File.unjarFileURI(uRI));
        this.delegate = new java.io.File(super.getPath());
        this.detector = archiveDetector;
        this.init(uRI);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static final URI unjarFileURI(URI uRI) {
        try {
            String string = uRI.getScheme();
            String string2 = Paths.normalize(uRI.getSchemeSpecificPart(), '/');
            return File.unjarFileURI0(new URI(string, string2, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRI + ": Not a valid (possibly jared) file URI!");
        }
    }

    private static final URI unjarFileURI0(URI uRI) throws URISyntaxException {
        String string = uRI.getScheme();
        if ("jar".equalsIgnoreCase(string)) {
            String string2 = uRI.getRawSchemeSpecificPart();
            int n = string2.endsWith("!") ? string2.length() - 1 : string2.lastIndexOf("!/");
            if (n <= 0) {
                return File.unjarFileURI(new URI(string2));
            }
            URI uRI2 = new URI(string2.substring(0, n) + string2.substring(n + 1));
            String string3 = uRI2.getScheme();
            if ("jar".equalsIgnoreCase(string3)) {
                URI uRI3 = File.unjarFileURI0(uRI2);
                if (uRI3 != uRI2) {
                    return uRI3;
                }
            } else if ("file".equalsIgnoreCase(string3)) {
                return uRI2;
            }
        } else if ("file".equalsIgnoreCase(string)) {
            return uRI;
        }
        throw new URISyntaxException(uRI.toString(), "Not a valid (possibly jared) file URI!");
    }

    public File(java.io.File file, File file2, ArchiveDetector archiveDetector) {
        super(file.getPath());
        if (!$assertionsDisabled && !File.parameters(file, file2, archiveDetector)) {
            throw new AssertionError();
        }
        this.delegate = file;
        String string = file.getPath();
        if (file2 != null) {
            int n = file2.getPath().length();
            if (string.length() == n) {
                this.detector = file2.detector;
                this.innerArchive = this;
                this.innerEntryName = "";
                this.enclArchive = file2.enclArchive;
                this.enclEntryName = file2.enclEntryName;
                this.controller = ArchiveControllers.get(this);
            } else {
                this.detector = archiveDetector;
                this.innerArchive = this.enclArchive = file2;
                this.innerEntryName = this.enclEntryName = string.substring(n + 1).replace(separatorChar, '/');
            }
        } else {
            this.detector = archiveDetector;
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static final boolean parameters(java.io.File file, File file2, ArchiveDetector archiveDetector) throws AssertionError {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"delegate is null!");
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError((Object)"delegate must not be a de.schlichtherle.io.File!");
        }
        if (file2 != null) {
            if (!$assertionsDisabled && !file2.isArchive()) {
                throw new AssertionError((Object)"innerArchive must be an archive!");
            }
            if (!$assertionsDisabled && !Files.contains(file2.getPath(), file.getPath())) {
                throw new AssertionError((Object)"innerArchive must contain delegate!");
            }
        }
        if (!$assertionsDisabled && archiveDetector == null) {
            throw new AssertionError((Object)"detector is null!");
        }
        return true;
    }

    public File(File file, java.io.File file2, File file3) {
        super(file2.getPath());
        if (!$assertionsDisabled && !File.parameters(file, file2, file3)) {
            throw new AssertionError();
        }
        this.delegate = file2;
        this.detector = file.detector;
        this.enclArchive = file3;
        this.enclEntryName = file.enclEntryName;
        this.innerArchive = file.isArchive() ? this : file3;
        this.innerEntryName = file.innerEntryName;
        this.controller = file.controller;
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static boolean parameters(File file, java.io.File file2, File file3) throws AssertionError {
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError((Object)"delegate is null!");
        }
        if (!$assertionsDisabled && file2 instanceof File) {
            throw new AssertionError((Object)"delegate must not be a de.schlichtherle.io.File!");
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"template is null!");
        }
        String string = file2.getPath();
        java.io.File file4 = Files.normalize(file);
        String string2 = file4.getPath();
        String string3 = file4.getName();
        if (separatorChar != '/') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        if (!(".".equals(string3) || "..".equals(string3) || string2.startsWith("." + separator) || string2.startsWith(".." + separator))) {
            if (!$assertionsDisabled && !string.endsWith(string2)) {
                throw new AssertionError((Object)"delegate and template must identify the same directory!");
            }
            if (file3 != null) {
                if (!$assertionsDisabled && !file3.isArchive()) {
                    throw new AssertionError((Object)"enclArchive must be an archive file!");
                }
                if (!$assertionsDisabled && !file3.isParentOf(file2)) {
                    throw new AssertionError((Object)"enclArchive must be an ancestor of delegate!");
                }
            }
        }
        return true;
    }

    private void init(File file) {
        String string = super.getPath();
        if (!$assertionsDisabled && file != null && !string.startsWith(file.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(string)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.detector == null) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        this.init(file, this.detector, 0, string, stringBuffer, new String[2]);
        String string2 = this.enclEntryName = stringBuffer.length() > 0 ? stringBuffer.toString() : null;
        if (this.innerArchive == this) {
            this.innerEntryName = "";
            this.controller = ArchiveControllers.get(this);
        } else if (this.innerArchive == this.enclArchive) {
            this.innerEntryName = this.enclEntryName;
        }
    }

    private void init(File file, ArchiveDetector archiveDetector, int n, String string, StringBuffer stringBuffer, String[] stringArray) {
        if (string == null) {
            if (!$assertionsDisabled && this.enclArchive != null) {
                throw new AssertionError();
            }
            stringBuffer.setLength(0);
            return;
        }
        Paths.split(string, separatorChar, stringArray);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string3.length() != 0 && !".".equals(string3)) {
            if ("..".equals(string3)) {
                ++n;
            } else if (n > 0) {
                --n;
            } else {
                int n2;
                if (file != null) {
                    int n3;
                    n2 = string.length();
                    if (n2 == (n3 = file.getPath().length())) {
                        this.enclArchive = file.innerArchive;
                        if (!file.isArchive()) {
                            if (file.isEntry()) {
                                if (stringBuffer.length() > 0) {
                                    stringBuffer.insert(0, '/');
                                    stringBuffer.insert(0, file.enclEntryName);
                                } else {
                                    if (!$assertionsDisabled && this.enclArchive != file.enclArchive) {
                                        throw new AssertionError();
                                    }
                                    stringBuffer.append(file.enclEntryName);
                                }
                            } else {
                                if (!$assertionsDisabled && this.enclArchive != null) {
                                    throw new AssertionError();
                                }
                                stringBuffer.setLength(0);
                            }
                        } else if (stringBuffer.length() <= 0) {
                            if (!$assertionsDisabled && this.enclArchive != file) {
                                throw new AssertionError();
                            }
                            this.innerArchive = this;
                            this.enclArchive = file.enclArchive;
                            if (file.enclEntryName != null) {
                                stringBuffer.append(file.enclEntryName);
                            }
                        }
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (n2 < n3) {
                        archiveDetector = file.detector;
                        file = file.enclArchive;
                    }
                }
                int n4 = n2 = archiveDetector.getArchiveDriver(string) != null ? 1 : 0;
                if (stringBuffer.length() > 0) {
                    if (n2 != 0) {
                        this.enclArchive = archiveDetector.createFile(string);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    stringBuffer.insert(0, '/');
                    stringBuffer.insert(0, string3);
                } else {
                    if (n2 != 0) {
                        this.innerArchive = this;
                    }
                    stringBuffer.append(string3);
                }
            }
        }
        this.init(file, archiveDetector, n, string2, stringBuffer, stringArray);
    }

    private void init(URI uRI) {
        if (!$assertionsDisabled && uRI == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.detector == null) {
            throw new AssertionError();
        }
        this.init(uRI, 0, Paths.cutTrailingSeparators(uRI.getSchemeSpecificPart(), '/'), new String[2]);
        if (this.innerArchive == this) {
            this.controller = ArchiveControllers.get(this);
        }
    }

    private void init(URI uRI, int n, String string, String[] stringArray) {
        String string2 = uRI.getScheme();
        if (string == null || !"jar".equalsIgnoreCase(string2)) {
            if (!$assertionsDisabled && this.enclArchive != null) {
                throw new AssertionError();
            }
            this.enclEntryName = null;
            return;
        }
        Paths.split(string, '/', stringArray);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string4.length() != 0 && !".".equals(string4)) {
            if ("..".equals(string4)) {
                ++n;
            } else if (n > 0) {
                --n;
            } else {
                boolean bl;
                int n2 = string4.length() - 1;
                boolean bl2 = bl = string4.charAt(n2) == '!';
                if (this.enclEntryName != null) {
                    if (bl) {
                        this.enclArchive = this.detector.createFile(File.createURI(string2, string));
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                            this.innerEntryName = this.enclEntryName;
                        }
                        return;
                    }
                    this.enclEntryName = string4 + "/" + this.enclEntryName;
                } else if (bl) {
                    this.innerArchive = this;
                    this.innerEntryName = "";
                    int n3 = string3.indexOf(58);
                    if (!$assertionsDisabled && n3 < 0) {
                        throw new AssertionError();
                    }
                    string2 = string3.substring(0, n3);
                    if (!$assertionsDisabled && !string2.matches("[a-zA-Z]+")) {
                        throw new AssertionError();
                    }
                    if (n3 == string3.length() - 1) {
                        return;
                    }
                    uRI = File.createURI(string3.substring(0, n3), string3.substring(n3 + 1));
                    this.enclEntryName = string4.substring(0, n2);
                    string3 = uRI.getSchemeSpecificPart();
                } else {
                    this.enclEntryName = string4;
                }
            }
        }
        this.init(uRI, n, string3, stringArray);
    }

    private static URI createURI(String string, String string2) throws IllegalArgumentException {
        try {
            return new URI(string, string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(uRISyntaxException.toString());
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ("".equals(this.innerEntryName)) {
            if (!$assertionsDisabled && "" == this.innerEntryName) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.controller != null) {
                throw new AssertionError();
            }
            this.innerArchive = this;
            this.innerEntryName = "";
            this.controller = ArchiveControllers.get(this);
        }
        try {
            this.invariants();
        }
        catch (AssertionError assertionError) {
            throw (InvalidObjectException)new InvalidObjectException(((Throwable)((Object)assertionError)).toString()).initCause((Throwable)((Object)assertionError));
        }
    }

    private boolean invariants() {
        if (this.delegate == null) {
            throw new AssertionError();
        }
        if (this.delegate instanceof File) {
            throw new AssertionError();
        }
        if (!this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (this.detector == null) {
            throw new AssertionError();
        }
        if (this.innerArchive != null != (this.innerEntryName != null)) {
            throw new AssertionError();
        }
        if (this.enclArchive != null != (this.enclEntryName != null)) {
            throw new AssertionError();
        }
        if (this.enclArchive == this) {
            throw new AssertionError();
        }
        if (!((this.innerArchive == this && this.innerEntryName == "" && !this.innerEntryName.equals(this.enclEntryName) && this.controller != null) ^ (this.innerArchive == this.enclArchive && this.innerEntryName == this.enclEntryName && this.controller == null))) {
            throw new AssertionError();
        }
        if (this.enclArchive != null && (!Files.contains(this.enclArchive.getPath(), this.delegate.getParentFile().getPath()) || this.enclEntryName.length() <= 0 || separatorChar != '/' && this.enclEntryName.indexOf(separatorChar) != -1)) {
            throw new AssertionError();
        }
        return true;
    }

    public static final void umount() throws ArchiveException {
        ArchiveControllers.umount("", false, true, false, true, true);
    }

    public static final void umount(boolean bl) throws ArchiveException {
        ArchiveControllers.umount("", false, bl, false, bl, true);
    }

    public static final void umount(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        ArchiveControllers.umount("", bl, bl2, bl3, bl4, true);
    }

    public static final void umount(File file) throws ArchiveException {
        File.umount(file, false, true, false, true);
    }

    public static final void umount(File file, boolean bl) throws ArchiveException {
        File.umount(file, false, bl, false, bl);
    }

    public static final void umount(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        if (!file.isArchive()) {
            throw new IllegalArgumentException(file.getPath() + " (not an archive)");
        }
        if (file.getEnclArchive() != null) {
            throw new IllegalArgumentException(file.getPath() + " (not a top level archive)");
        }
        ArchiveControllers.umount(file.getCanOrAbsPath(), bl, bl2, bl3, bl4, true);
    }

    public static final void update() throws ArchiveException {
        ArchiveControllers.umount("", false, true, false, true, false);
    }

    public static final void update(boolean bl) throws ArchiveException {
        ArchiveControllers.umount("", false, bl, false, bl, false);
    }

    public static final void update(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        ArchiveControllers.umount("", bl, bl2, bl3, bl4, false);
    }

    public static final void update(File file) throws ArchiveException {
        File.update(file, false, true, false, true);
    }

    public static final void update(File file, boolean bl) throws ArchiveException {
        File.update(file, false, bl, false, bl);
    }

    public static final void update(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ArchiveException {
        if (!file.isArchive()) {
            throw new IllegalArgumentException(file.getPath() + " (not an archive)");
        }
        if (file.getEnclArchive() != null) {
            throw new IllegalArgumentException(file.getPath() + " (not a top level archive)");
        }
        ArchiveControllers.umount(file.getCanOrAbsPath(), bl, bl2, bl3, bl4, false);
    }

    public static final ArchiveStatistics getLiveArchiveStatistics() {
        return ArchiveControllers.getLiveArchiveStatistics();
    }

    public static final boolean isLenient() {
        return lenient;
    }

    public static final void setLenient(boolean bl) {
        lenient = bl;
    }

    public static final ArchiveDetector getDefaultArchiveDetector() {
        return defaultDetector;
    }

    public static final void setDefaultArchiveDetector(ArchiveDetector archiveDetector) {
        if (archiveDetector == null) {
            throw new NullPointerException();
        }
        defaultDetector = archiveDetector;
    }

    public java.io.File getParentFile() {
        java.io.File file = this.delegate.getParentFile();
        if (file == null) {
            return null;
        }
        if (!$assertionsDisabled && !super.getName().equals(this.delegate.getName())) {
            throw new AssertionError();
        }
        if (this.enclArchive != null && this.enclArchive.getPath().length() == file.getPath().length()) {
            if (!$assertionsDisabled && !this.enclArchive.getPath().equals(file.getPath())) {
                throw new AssertionError();
            }
            return this.enclArchive;
        }
        return this.detector.createFile(file, this.enclArchive);
    }

    public File getNonArchivedParentFile() {
        File file = this.enclArchive;
        return file != null ? file.getNonArchivedParentFile() : (File)this.getParentFile();
    }

    public java.io.File getAbsoluteFile() {
        File file = this.enclArchive;
        if (file != null) {
            file = (File)file.getAbsoluteFile();
        }
        return this.detector.createFile(this, this.delegate.getAbsoluteFile(), file);
    }

    public File getNormalizedAbsoluteFile() {
        File file = this.enclArchive;
        if (file != null) {
            file = file.getNormalizedAbsoluteFile();
        }
        return this.detector.createFile(this, Files.normalize(this.delegate.getAbsoluteFile()), file);
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize(this.getAbsolutePath(), separatorChar);
    }

    public File getNormalizedFile() {
        java.io.File file = Files.normalize(this);
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (file == this) {
            return this;
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.enclArchive != null && Files.normalize(this.enclArchive) != this.enclArchive) {
            throw new AssertionError();
        }
        return this.detector.createFile(this, file, this.enclArchive);
    }

    public String getNormalizedPath() {
        return Paths.normalize(this.getPath(), separatorChar);
    }

    public java.io.File getCanonicalFile() throws IOException {
        File file = this.enclArchive;
        if (file != null) {
            file = (File)file.getCanonicalFile();
        }
        return this.detector.createFile(this, this.delegate.getCanonicalFile(), file);
    }

    public final File getCanOrAbsFile() {
        File file = this.enclArchive;
        if (file != null) {
            file = file.getCanOrAbsFile();
        }
        return this.detector.createFile(this, Files.getCanOrAbsFile(this.delegate), file);
    }

    public String getCanOrAbsPath() {
        return this.getCanOrAbsFile().getPath();
    }

    public final boolean isArchive() {
        return this.innerArchive == this;
    }

    public final boolean isEntry() {
        return this.enclEntryName != null;
    }

    public final File getInnerArchive() {
        return this.innerArchive;
    }

    public final String getInnerEntryName() {
        return this.innerEntryName;
    }

    public final File getEnclArchive() {
        return this.enclArchive;
    }

    public final String getEnclEntryName() {
        return this.enclEntryName;
    }

    public final ArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public final java.io.File getDelegate() {
        return this.delegate;
    }

    final ArchiveController getArchiveController() {
        if (!$assertionsDisabled && this.controller != null != this.isArchive()) {
            throw new AssertionError();
        }
        return this.controller;
    }

    public boolean isParentOf(java.io.File file) {
        String string = Files.getCanOrAbsFile(this).getPath();
        String string2 = Files.getCanOrAbsFile(file).getParent();
        return string2 != null ? Files.contains(string, string2) : false;
    }

    public boolean contains(java.io.File file) {
        return Files.contains(this, file);
    }

    public static final boolean contains(java.io.File file, java.io.File file2) {
        return Files.contains(file, file2);
    }

    public boolean isFileSystemRoot() {
        File file = this.getCanOrAbsFile();
        return roots.contains(file) || File.isUNC(file.getPath());
    }

    public boolean isUNC() {
        return File.isUNC(this.getCanOrAbsFile().getPath());
    }

    protected static final boolean isUNC(String string) {
        return string.startsWith(uncPrefix) && string.indexOf(separatorChar, 2) > 2;
    }

    public int hashCode() {
        File file = this.enclArchive;
        if (file != null) {
            return 31 * file.hashCode() + this.enclEntryName.hashCode();
        }
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return super.equals(object);
    }

    public int compareTo(java.io.File file) {
        File file2;
        if (this == file) {
            return 0;
        }
        if (!(file instanceof File)) {
            return super.compareTo(file);
        }
        File file3 = (File)file;
        File file4 = this.enclArchive;
        if (file4 != null && (file2 = file3.enclArchive) != null) {
            int n = file4.compareTo(file2);
            if (n == 0) {
                n = this.enclEntryName.compareTo(file3.enclEntryName);
            }
            return n;
        }
        return super.compareTo(file);
    }

    public File getTopLevelArchive() {
        File file = this.enclArchive;
        return file != null ? file.getTopLevelArchive() : this.innerArchive;
    }

    public String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.delegate.getCanonicalPath();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getParent() {
        return this.delegate.getParent();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public URI toURI() {
        return this.delegate.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return this.delegate.toURL();
    }

    final void ensureNotVirtualRoot(String string) throws ArchiveController.ArchiveFileNotFoundException {
        if (this.isArchive() && (this.isDirectory() || this.exists() && !this.isFile())) {
            String string2 = "virtual root directory";
            if (string != null) {
                string2 = string + " " + string2;
            }
            ArchiveController archiveController = this.getArchiveController();
            archiveController.getClass();
            throw archiveController.new ArchiveController.ArchiveFileNotFoundException(string2);
        }
    }

    public boolean exists() {
        try {
            if (this.enclArchive != null) {
                return this.enclArchive.getArchiveController().exists(this.enclEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.exists();
    }

    public boolean isFile() {
        block3: {
            try {
                if (this.innerArchive != null) {
                    return this.innerArchive.getArchiveController().isFile(this.innerEntryName);
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                if (!this.isArchive() || !(rfsEntryFalsePositiveException.getCause() instanceof FileNotFoundException)) break block3;
                return false;
            }
        }
        return this.delegate.isFile();
    }

    public boolean isDirectory() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().isDirectory(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.isDirectory();
    }

    public Icon getOpenIcon() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().getOpenIcon(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return null;
    }

    public Icon getClosedIcon() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().getClosedIcon(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return null;
    }

    public boolean canRead() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().canRead(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.canRead();
    }

    public boolean canWrite() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().canWrite(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.canWrite();
    }

    public boolean setReadOnly() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().setReadOnly(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.setReadOnly();
    }

    public long length() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().length(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.length();
    }

    public long lastModified() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().lastModified(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.lastModified();
    }

    public boolean setLastModified(long l) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().setLastModified(this.innerEntryName, l);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.setLastModified(l);
    }

    public String[] list() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().list(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.list();
    }

    public String[] list(FilenameFilter filenameFilter) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().list(this.innerEntryName, filenameFilter, this);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.list(filenameFilter);
    }

    public java.io.File[] listFiles() {
        return this.listFiles((FilenameFilter)null, (FileFactory)this.detector);
    }

    public File[] listFiles(FileFactory fileFactory) {
        return this.listFiles((FilenameFilter)null, fileFactory);
    }

    public java.io.File[] listFiles(FilenameFilter filenameFilter) {
        return this.listFiles(filenameFilter, (FileFactory)this.detector);
    }

    public File[] listFiles(FilenameFilter filenameFilter, FileFactory fileFactory) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().listFiles(this.innerEntryName, filenameFilter, this, fileFactory);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return File.convert(this.delegate.listFiles(filenameFilter), fileFactory);
    }

    private static File[] convert(java.io.File[] fileArray, FileFactory fileFactory) {
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new File[fileArray.length];
        int n = fileArray.length;
        while (0 <= --n) {
            fileArray2[n] = fileFactory.createFile(fileArray[n]);
        }
        return fileArray2;
    }

    public final java.io.File[] listFiles(FileFilter fileFilter) {
        return this.listFiles(fileFilter, (FileFactory)this.detector);
    }

    public File[] listFiles(FileFilter fileFilter, FileFactory fileFactory) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().listFiles(this.innerEntryName, fileFilter, this, fileFactory);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegateListFiles(fileFilter, fileFactory);
    }

    private File[] delegateListFiles(FileFilter fileFilter, FileFactory fileFactory) {
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = this.delegate.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            File file = fileFactory.createFile((java.io.File)this, string);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    public boolean createNewFile() throws IOException {
        try {
            if (this.enclArchive != null) {
                return this.enclArchive.getArchiveController().createNewFile(this.enclEntryName, File.isLenient());
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return this.delegate.createNewFile();
    }

    public boolean mkdirs() {
        if (this.innerArchive == null) {
            return this.delegate.mkdirs();
        }
        File file = (File)this.getParentFile();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        return this.mkdir();
    }

    public boolean mkdir() {
        block3: {
            try {
                if (this.innerArchive != null) {
                    return this.innerArchive.getArchiveController().mkdir(this.innerEntryName, File.isLenient());
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                if ($assertionsDisabled || !this.isArchive()) break block3;
                throw new AssertionError();
            }
        }
        return this.delegate.mkdir();
    }

    public boolean delete() {
        block3: {
            try {
                if (this.innerArchive != null) {
                    return this.innerArchive.getArchiveController().delete(this.innerEntryName);
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                if (!this.isArchive() || this.delegate.isDirectory() || !(rfsEntryFalsePositiveException.getCause() instanceof FileNotFoundException)) break block3;
                return false;
            }
        }
        return this.delegate.delete();
    }

    public boolean deleteAll() {
        return Files.rm_r(this);
    }

    public void deleteOnExit() {
        if (this.innerArchive == null) {
            this.delegate.deleteOnExit();
            return;
        }
        if (this.isArchive()) {
            this.isDirectory();
        }
        ArchiveControllers.ShutdownHook.deleteOnExit.add(this);
    }

    public final boolean renameTo(java.io.File file) {
        return this.renameTo(file, this.detector);
    }

    public boolean renameTo(java.io.File file, ArchiveDetector archiveDetector) {
        if (!(this.innerArchive != null || file instanceof File && ((File)file).innerArchive != null)) {
            return this.delegate.renameTo(file);
        }
        return !file.exists() && Files.mv(this, file, archiveDetector);
    }

    public boolean copyFrom(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = this.detector.createFileOutputStream(this, false);
            try {
                File.cp(inputStream, fileOutputStream);
                return true;
            }
            catch (IOException iOException) {
                this.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean copyFrom(java.io.File file) {
        try {
            File.cp(file, this);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File file) {
        try {
            Files.cp_r(false, file, this, this.detector, this.detector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File file, ArchiveDetector archiveDetector) {
        try {
            Files.cp_r(false, file, this, archiveDetector, archiveDetector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        try {
            Files.cp_r(false, file, this, archiveDetector, archiveDetector2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyTo(OutputStream outputStream) {
        try {
            FileInputStream fileInputStream = this.detector.createFileInputStream(this);
            File.cp(fileInputStream, outputStream);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyTo(java.io.File file) {
        try {
            File.cp(this, file);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File file) {
        try {
            Files.cp_r(false, this, file, this.detector, this.detector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File file, ArchiveDetector archiveDetector) {
        try {
            Files.cp_r(false, this, file, archiveDetector, archiveDetector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        try {
            Files.cp_r(false, this, file, archiveDetector, archiveDetector2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyFrom(java.io.File file) {
        try {
            File.cp_p(file, this);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File file) {
        try {
            Files.cp_r(true, file, this, this.detector, this.detector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File file, ArchiveDetector archiveDetector) {
        try {
            Files.cp_r(true, file, this, archiveDetector, archiveDetector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        try {
            Files.cp_r(true, file, this, archiveDetector, archiveDetector2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyTo(java.io.File file) {
        try {
            File.cp_p(this, file);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File file) {
        try {
            Files.cp_r(true, this, file, this.detector, this.detector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File file, ArchiveDetector archiveDetector) {
        try {
            Files.cp_r(true, this, file, archiveDetector, archiveDetector);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File file, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) {
        try {
            Files.cp_r(true, this, file, archiveDetector, archiveDetector2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final void cp(InputStream inputStream, OutputStream outputStream) throws IOException {
        Files.cp(inputStream, outputStream);
    }

    public static final void cp(java.io.File file, java.io.File file2) throws IOException {
        Files.cp(false, file, file2);
    }

    public static final void cp_p(java.io.File file, java.io.File file2) throws IOException {
        Files.cp(true, file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean catFrom(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = this.detector.createFileOutputStream(this, false);
            try {
                try {
                    Streams.cat(inputStream, fileOutputStream);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                return true;
            }
            catch (IOException iOException) {
                this.delete();
                throw iOException;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean catTo(OutputStream outputStream) {
        try {
            FileInputStream fileInputStream = this.detector.createFileInputStream(this);
            try {
                Streams.cat(fileInputStream, outputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final void cat(InputStream inputStream, OutputStream outputStream) throws IOException {
        Streams.cat(inputStream, outputStream);
    }

    static {
        $assertionsDisabled = !File.class.desiredAssertionStatus();
        roots = new TreeSet<java.io.File>(Arrays.asList(File.listRoots()));
        uncPrefix = separator + separator;
        lenient = !Boolean.getBoolean("de.schlichtherle.io.strict");
        defaultDetector = ArchiveDetector.DEFAULT;
    }
}

