/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFileInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;

public class TarDriver
extends AbstractArchiveDriver {
    private static final long serialVersionUID = 6622746562629104174L;
    static final String TEMP_FILE_PREFIX = "tzp-tar";
    public static final String DEFAULT_CHARSET = "US-ASCII";

    public TarDriver() {
        this(DEFAULT_CHARSET, null, null);
    }

    public TarDriver(String string) {
        this(string, null, null);
    }

    public TarDriver(String string, Icon icon, Icon icon2) {
        super(string, icon, icon2);
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String string, ArchiveEntry archiveEntry) throws CharConversionException {
        TarEntry tarEntry;
        this.ensureEncodable(string);
        if (archiveEntry != null) {
            if (archiveEntry instanceof TarEntry) {
                tarEntry = new TarEntry((TarEntry)archiveEntry);
                tarEntry.setName(string);
            } else {
                tarEntry = new TarEntry(string);
                tarEntry.setTime(archiveEntry.getTime());
                tarEntry.setSize(archiveEntry.getSize());
            }
        } else {
            tarEntry = new TarEntry(string);
        }
        return tarEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputArchive createInputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        InputStream inputStream = this.createInputStream(archive, readOnlyFile);
        try {
            TarInputArchive tarInputArchive = this.createTarInputArchive(archive, inputStream);
            return tarInputArchive;
        }
        finally {
            inputStream.close();
        }
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        return new ReadOnlyFileInputStream(readOnlyFile);
    }

    protected TarInputArchive createTarInputArchive(Archive archive, InputStream inputStream) throws IOException {
        return new TarInputArchive(inputStream);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws IOException {
        return new MultiplexedOutputArchive(this.createTarOutputArchive(archive, outputStream, (TarInputArchive)inputArchive));
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream outputStream, TarInputArchive tarInputArchive) throws IOException {
        return new TarOutputArchive(outputStream);
    }
}

