/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip.raes;

import de.schlichtherle.crypto.io.raes.KeyManagerRaesParameters;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.io.archive.zip.JarDriver;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;

public abstract class AbstractZip32RaesDriver
extends JarDriver {
    private static final long serialVersionUID = 8191673749851616843L;
    private final long authenticationTrigger;

    protected AbstractZip32RaesDriver(Icon icon, Icon icon2, boolean bl, boolean bl2, int n, long l) {
        super(icon, icon2, bl, bl2, n);
        this.authenticationTrigger = l;
    }

    public final long getAuthenticationTrigger() {
        return this.authenticationTrigger;
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        RaesReadOnlyFile raesReadOnlyFile;
        try {
            raesReadOnlyFile = RaesReadOnlyFile.getInstance(readOnlyFile, this.getRaesParameters(archive));
        }
        catch (RaesKeyException raesKeyException) {
            throw new TransientIOException(raesKeyException);
        }
        if (readOnlyFile.length() <= this.getAuthenticationTrigger()) {
            raesReadOnlyFile.authenticate();
        }
        return super.createInputArchive(archive, raesReadOnlyFile);
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String string, ArchiveEntry archiveEntry) throws CharConversionException {
        Zip32Entry zip32Entry = (Zip32Entry)super.createArchiveEntry(archive, string, archiveEntry);
        if (zip32Entry.getMethod() != 8) {
            zip32Entry.setMethod(8);
            zip32Entry.setCompressedSize(-1L);
        }
        return zip32Entry;
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws IOException {
        RaesOutputStream raesOutputStream;
        try {
            raesOutputStream = RaesOutputStream.getInstance(outputStream, this.getRaesParameters(archive));
        }
        catch (RaesKeyException raesKeyException) {
            throw new TransientIOException(raesKeyException);
        }
        return super.createOutputArchive(archive, raesOutputStream, inputArchive);
    }

    public RaesParameters getRaesParameters(Archive archive) {
        return new KeyManagerRaesParameters(archive.getPath());
    }
}

