/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.File;
import de.schlichtherle.io.swing.tree.FileTreeCellRenderer;
import de.schlichtherle.io.swing.tree.FileTreeModel;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JFileTree
extends JTree {
    private static final String PROPERTY_DISPLAYING_SUFFIXES = "displayingSuffixes";
    private static final String PROPERTY_EDITING_SUFFIXES = "editingSuffixes";
    private static final String PROPERTY_DEFAULT_SUFFIX = "defaultSuffix";
    private final Controller controller = new Controller();
    private boolean displayingSuffixes = true;
    private boolean editingSuffixes = true;
    private String defaultSuffix;
    private java.io.File editedNode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JFileTree() {
        this(new FileTreeModel());
    }

    public JFileTree(java.io.File file) {
        this(new FileTreeModel(file));
    }

    public JFileTree(FileTreeModel fileTreeModel) {
        super(fileTreeModel);
        super.setCellRenderer(this.createTreeCellRenderer());
        super.addTreeExpansionListener(this.controller);
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        return new FileTreeCellRenderer(this);
    }

    public void setModel(TreeModel treeModel) {
        super.setModel((FileTreeModel)treeModel);
    }

    public void setEditable(boolean bl) {
        if (bl) {
            super.setEditable(true);
            this.getCellEditor().addCellEditorListener(this.controller);
        } else {
            TreeCellEditor treeCellEditor = this.getCellEditor();
            if (treeCellEditor != null) {
                treeCellEditor.removeCellEditorListener(this.controller);
            }
            super.setEditable(false);
        }
    }

    public boolean isDisplayingSuffixes() {
        return this.displayingSuffixes;
    }

    public void setDisplayingSuffixes(boolean bl) {
        boolean bl2 = this.displayingSuffixes;
        this.displayingSuffixes = bl;
        this.firePropertyChange(PROPERTY_DISPLAYING_SUFFIXES, bl2, bl);
    }

    public boolean isEditingSuffixes() {
        return this.editingSuffixes;
    }

    public void setEditingSuffixes(boolean bl) {
        boolean bl2 = this.editingSuffixes;
        this.editingSuffixes = bl;
        this.firePropertyChange(PROPERTY_EDITING_SUFFIXES, bl2, bl);
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(String string) {
        String string2 = this.defaultSuffix;
        if (string != null) {
            if ((string = string.trim()).length() <= 0) {
                string = null;
            } else if (string.charAt(0) != '.') {
                string = "." + string;
            }
        }
        this.defaultSuffix = string;
        this.firePropertyChange(PROPERTY_DEFAULT_SUFFIX, string2, string);
    }

    public java.io.File getEditedNode() {
        return this.editedNode;
    }

    public boolean isEditing() {
        return this.editedNode != null;
    }

    public void startEditingAtPath(TreePath treePath) {
        this.editedNode = (java.io.File)treePath.getLastPathComponent();
        super.startEditingAtPath(treePath);
    }

    public void cancelEditing() {
        this.editedNode = null;
        super.cancelEditing();
    }

    public boolean stopEditing() {
        boolean bl = super.stopEditing();
        if (bl) {
            this.editedNode = null;
        }
        return bl;
    }

    protected void onEditingStopped(ChangeEvent changeEvent) {
        Object object;
        TreeCellEditor treeCellEditor = (TreeCellEditor)changeEvent.getSource();
        String string = treeCellEditor.getCellEditorValue().toString().trim();
        java.io.File file = (java.io.File)this.getLeadSelectionPath().getLastPathComponent();
        java.io.File file2 = file.getParentFile();
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError();
        }
        if (!file.isDirectory()) {
            if (this.isDisplayingSuffixes() && this.isEditingSuffixes()) {
                String string2;
                object = this.getSuffix(string);
                if (object == null && (string2 = this.getDefaultSuffix()) != null) {
                    string = string + string2;
                }
            } else {
                object = this.getSuffix(file.getName());
                if (object != null) {
                    string = string + (String)object;
                }
            }
        }
        if (!this.renameTo(file, (java.io.File)(object = new File(file2, string)))) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private String getSuffix(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(n) : null;
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        java.io.File file = (java.io.File)object;
        java.io.File file2 = this.getEditedNode();
        if (file != file2 && !file.exists()) {
            return "?";
        }
        String string = file.getName();
        if (string.length() <= 0) {
            return file.getPath();
        }
        if (file.isDirectory() || this.isDisplayingSuffixes() && (!file.equals(file2) || this.isEditingSuffixes())) {
            return string;
        }
        int n2 = string.lastIndexOf(46);
        return n2 != -1 ? string.substring(0, n2) : string;
    }

    public void refresh() {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath((java.io.File)fileTreeModel.getRoot());
        if (treePath != null) {
            this.refresh(new TreePath[]{treePath});
        }
    }

    public void refresh(java.io.File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath != null) {
            this.refresh(new TreePath[]{treePath});
        }
    }

    public void refresh(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = this.getLeadSelectionPath();
        TreePath treePath2 = this.getAnchorSelectionPath();
        TreePath[] treePathArray2 = this.getSelectionPaths();
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            TreePath treePath3 = treePathArray[i];
            Enumeration<TreePath> enumeration = this.getExpandedDescendants(treePath3);
            fileTreeModel.refresh((java.io.File)treePath3.getLastPathComponent());
            this.setExpandedDescendants(enumeration);
        }
        this.setSelectionPaths(treePathArray2);
        this.setAnchorSelectionPath(treePath2);
        this.setLeadSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void setExpandedDescendants(Enumeration enumeration) {
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.setExpandedState((TreePath)enumeration.nextElement(), true);
        }
    }

    public boolean createNewFile(java.io.File file) throws IOException {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.createNewFile(file)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean mkdir(java.io.File file) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.mkdir(file)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean mkdirs(java.io.File file) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.mkdirs(file)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean copyFrom(File file, InputStream inputStream) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.copyFrom(file, inputStream)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean copyTo(File file, java.io.File file2) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file2);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.copyTo(file, file2)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean copyAllTo(File file, java.io.File file2) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file2);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.copyAllTo(file, file2)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean archiveCopyTo(File file, java.io.File file2) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file2);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.archiveCopyTo(file, file2)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean archiveCopyAllTo(File file, java.io.File file2) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file2);
        if (treePath == null) {
            return false;
        }
        if (!fileTreeModel.archiveCopyAllTo(file, file2)) {
            return false;
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    public boolean renameTo(java.io.File file, java.io.File file2) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file2);
        if (treePath == null) {
            return false;
        }
        TreePath treePath2 = fileTreeModel.createTreePath(file);
        Enumeration<TreePath> enumeration = treePath2 != null ? this.getExpandedDescendants(treePath2) : null;
        if (!fileTreeModel.renameTo(file, file2)) {
            return false;
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.setExpandedState(this.substPath(enumeration.nextElement(), treePath2, treePath), true);
            }
        }
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    private TreePath substPath(TreePath treePath, TreePath treePath2, TreePath treePath3) {
        java.io.File file = (java.io.File)treePath.getLastPathComponent();
        if (file.equals(treePath2.getLastPathComponent())) {
            return treePath3;
        }
        TreePath treePath4 = this.substPath(treePath.getParentPath(), treePath2, treePath3);
        return treePath4.pathByAddingChild(new File((java.io.File)treePath4.getLastPathComponent(), file.getName()));
    }

    public boolean delete(java.io.File file) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath == null) {
            return false;
        }
        this.scrollPathToVisible(treePath);
        int n = this.getRowForPath(treePath);
        if (!fileTreeModel.delete(file)) {
            return false;
        }
        this.setSelectionRow(n);
        return true;
    }

    public boolean deleteAll(File file) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath == null) {
            return false;
        }
        this.scrollPathToVisible(treePath);
        int n = this.getRowForPath(treePath);
        if (!fileTreeModel.deleteAll(file)) {
            return false;
        }
        this.setSelectionRow(n);
        return true;
    }

    public void setSelectionNode(java.io.File file) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath != null) {
            this.setSelectionPath(treePath);
        }
    }

    public void setSelectionNodes(java.io.File[] fileArray) {
        int n;
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        TreePath treePath = null;
        int n2 = fileArray.length;
        for (n = 0; n < n2; ++n) {
            treePath = fileTreeModel.createTreePath(fileArray[n]);
            if (treePath == null) continue;
            linkedList.add(treePath);
        }
        n = linkedList.size();
        if (n > 0) {
            TreePath[] treePathArray = new TreePath[n];
            linkedList.toArray(treePathArray);
            this.setSelectionPaths(treePathArray);
        }
    }

    public void scrollNodeToVisible(java.io.File file) {
        FileTreeModel fileTreeModel = (FileTreeModel)this.getModel();
        TreePath treePath = fileTreeModel.createTreePath(file);
        if (treePath != null) {
            this.scrollPathToVisible(treePath);
        }
    }

    static {
        $assertionsDisabled = !JFileTree.class.desiredAssertionStatus();
    }

    private class Controller
    implements TreeExpansionListener,
    CellEditorListener,
    Serializable {
        private Controller() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            ((FileTreeModel)JFileTree.this.getModel()).forget((java.io.File)treeExpansionEvent.getPath().getLastPathComponent());
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
            JFileTree.this.onEditingStopped(changeEvent);
        }
    }
}

