/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.util;

import java.io.IOException;
import java.io.OutputStream;

public class SynchronizedOutputStream
extends OutputStream {
    protected final Object lock;
    protected OutputStream out;

    public SynchronizedOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    public SynchronizedOutputStream(OutputStream outputStream, Object object) {
        this.out = outputStream;
        this.lock = object != null ? object : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(byArray, 0, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doFlush();
        }
    }

    protected void doFlush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        try {
            this.doFlush();
        }
        finally {
            this.out.close();
        }
    }
}

