/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.KeyManager;
import de.schlichtherle.key.KeyProvider;
import de.schlichtherle.key.UnknownKeyException;
import de.schlichtherle.util.ThreadLocalLong;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class AbstractKeyProvider
implements KeyProvider {
    private Object key;
    private final ThreadLocalLong invalidated = new ThreadLocalLong();

    public synchronized Object getKey() {
        return this.key;
    }

    public synchronized void setKey(Object object) {
        this.key = object;
    }

    public Object getCreateKey() throws UnknownKeyException {
        Object object = this.getCreateKeyImpl();
        if (object == null) {
            throw new UnknownKeyException();
        }
        return AbstractKeyProvider.clone(object);
    }

    protected Object getCreateKeyImpl() throws UnknownKeyException {
        return this.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getOpenKey() throws UnknownKeyException {
        try {
            Object object = this.getOpenKeyImpl();
            if (object == null) {
                throw new UnknownKeyException();
            }
            Object object2 = AbstractKeyProvider.clone(object);
            return object2;
        }
        finally {
            this.enforceSuspensionPenalty();
        }
    }

    protected Object getOpenKeyImpl() throws UnknownKeyException {
        return this.getKey();
    }

    public final void invalidOpenKey() {
        this.invalidated.setValue(System.currentTimeMillis());
        this.invalidOpenKeyImpl();
    }

    protected abstract void invalidOpenKeyImpl();

    public void reset() {
    }

    protected Object cloneKey() {
        Object object = this.getKey();
        if (object == null) {
            return null;
        }
        return AbstractKeyProvider.clone(object);
    }

    static Object clone(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(clazz.getComponentType(), n);
            System.arraycopy(object, 0, object2, 0, n);
            return object2;
        }
        try {
            return object.getClass().getMethod("clone", null).invoke(object, null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetKey() {
        Object object = this.getKey();
        if (object == null) {
            return;
        }
        this.setKey(null);
        Object object2 = object;
        synchronized (object2) {
            if (object instanceof byte[]) {
                Arrays.fill((byte[])object, (byte)0);
            } else if (object instanceof char[]) {
                Arrays.fill((char[])object, '\u0000');
            } else if (object instanceof short[]) {
                Arrays.fill((short[])object, (short)0);
            } else if (object instanceof int[]) {
                Arrays.fill((int[])object, 0);
            } else if (object instanceof long[]) {
                Arrays.fill((long[])object, 0L);
            } else if (object instanceof float[]) {
                Arrays.fill((float[])object, 0.0f);
            } else if (object instanceof double[]) {
                Arrays.fill((double[])object, 0.0);
            } else if (object instanceof boolean[]) {
                Arrays.fill((boolean[])object, false);
            } else if (object instanceof Object[]) {
                Arrays.fill((Object[])object, null);
            }
        }
    }

    private void enforceSuspensionPenalty() {
        long l;
        long l2 = this.invalidated.getValue();
        InterruptedException interruptedException = null;
        while ((l = System.currentTimeMillis() - l2) < 3000L) {
            try {
                Thread.sleep(3000L - l);
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
            }
        }
        if (interruptedException != null) {
            Thread.currentThread().interrupt();
        }
    }

    protected KeyProvider addToKeyManager(String string) throws NullPointerException, IllegalStateException {
        return KeyManager.mapKeyProvider(string, this);
    }

    protected KeyProvider removeFromKeyManager(String string) throws NullPointerException, IllegalStateException {
        return KeyManager.unmapKeyProvider(string);
    }
}

