/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.AesKeyProvider;
import de.schlichtherle.key.KeyManager;
import de.schlichtherle.key.KeyPromptingDisabledException;
import de.schlichtherle.key.KeyProvider;
import de.schlichtherle.key.PromptingAesKeyProvider;
import de.schlichtherle.key.PromptingKeyProvider;
import de.schlichtherle.key.PromptingKeyProviderUI;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;

public abstract class PromptingKeyManager
extends KeyManager {
    private static volatile boolean prompting = true;
    private final Map providerUITypes = new HashMap();

    public PromptingKeyManager() {
        this.mapKeyProviderType(KeyProvider.class, PromptingKeyProvider.class);
        this.mapKeyProviderType(AesKeyProvider.class, PromptingAesKeyProvider.class);
    }

    public static boolean isPrompting() {
        KeyManager keyManager = PromptingKeyManager.getInstance();
        return keyManager instanceof PromptingKeyManager && ((PromptingKeyManager)keyManager).isPromptingImpl();
    }

    protected boolean isPromptingImpl() {
        return prompting;
    }

    public static void setPrompting(boolean bl) {
        KeyManager keyManager = PromptingKeyManager.getInstance();
        if (keyManager instanceof PromptingKeyManager) {
            ((PromptingKeyManager)keyManager).setPromptingImpl(bl);
        }
    }

    protected void setPromptingImpl(boolean bl) {
        prompting = bl;
    }

    static void ensurePrompting() throws KeyPromptingDisabledException {
        KeyManager keyManager = PromptingKeyManager.getInstance();
        if (keyManager instanceof PromptingKeyManager) {
            ((PromptingKeyManager)keyManager).ensurePromptingImpl();
        }
    }

    protected void ensurePromptingImpl() throws KeyPromptingDisabledException {
        if (!this.isPromptingImpl()) {
            throw new KeyPromptingDisabledException();
        }
    }

    public static void resetCancelledPrompts() {
        PromptingKeyManager.forEachKeyProvider(new KeyManager.KeyProviderCommand(){

            public void run(String string, KeyProvider keyProvider) {
                if (keyProvider instanceof PromptingKeyProvider) {
                    ((PromptingKeyProvider)keyProvider).resetCancelledPrompt();
                }
            }
        });
    }

    protected final void register(String string, Class clazz) {
        this.mapPromptingKeyProviderUIType(string, clazz);
    }

    protected final synchronized void mapPromptingKeyProviderUIType(String string, Class clazz) {
        if (string == null) {
            throw new NullPointerException("uiClassID");
        }
        if (!PromptingKeyProviderUI.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " must be PromptingKeyProviderUI or a subclass!");
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(clazz.getName() + " (no public nullary constructor)");
            illegalArgumentException.initCause(noSuchMethodException);
            throw illegalArgumentException;
        }
        this.providerUITypes.put(string, clazz);
    }

    public KeyProvider getKeyProvider(String string, Class clazz) throws NullPointerException, ClassCastException, IllegalArgumentException {
        KeyProvider keyProvider = super.getKeyProvider(string, clazz);
        if (keyProvider instanceof PromptingKeyProvider) {
            PromptingKeyProvider promptingKeyProvider = (PromptingKeyProvider)keyProvider;
            promptingKeyProvider.setUI(this.getUI(promptingKeyProvider.getUIClassID()));
        }
        return keyProvider;
    }

    private synchronized PromptingKeyProviderUI getUI(String string) {
        PromptingKeyProviderUI promptingKeyProviderUI;
        Object v = this.providerUITypes.get(string);
        if (v instanceof Class) {
            try {
                promptingKeyProviderUI = (PromptingKeyProviderUI)((Class)v).newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new UndeclaredThrowableException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UndeclaredThrowableException(illegalAccessException);
            }
            this.providerUITypes.put(string, promptingKeyProviderUI);
        } else if (v != null) {
            promptingKeyProviderUI = (PromptingKeyProviderUI)v;
        } else {
            throw new IllegalArgumentException(string + " (unknown user interface for PromptingKeyProvider)");
        }
        return promptingKeyProviderUI;
    }
}

