/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.swing.FileComboBoxBrowser;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AuthenticationPanel
extends JPanel {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final de.schlichtherle.io.File BASE_DIR;
    private static SoftReference fileChooser;
    public static final int AUTH_PASSWD = 0;
    public static final int AUTH_KEY_FILE = 1;
    private final JComboBox keyFile = new JComboBox();
    private final JButton keyFileChooser = new JButton();
    private final EnhancedPanel keyFilePanel = new EnhancedPanel();
    private JTabbedPane tabs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuthenticationPanel() {
        this.initComponents();
        new FileComboBoxBrowser(this.keyFile).setDirectory(BASE_DIR);
        ((JTextField)this.keyFile.getEditor().getEditorComponent()).setColumns(30);
    }

    public void setPasswdPanel(JPanel jPanel) {
        if (jPanel == null) {
            throw new NullPointerException();
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String string = resources.getString("tab.passwd");
        if (string.equals(this.tabs.getTitleAt(0))) {
            this.tabs.removeTabAt(0);
        }
        this.tabs.insertTab(string, null, jPanel, null, 0);
        this.tabs.setSelectedIndex(0);
        this.revalidate();
    }

    Document getKeyFileDocument() {
        return ((JTextComponent)this.keyFile.getEditor().getEditorComponent()).getDocument();
    }

    public String getKeyFilePath() {
        return (String)this.keyFile.getSelectedItem();
    }

    private void setKeyFilePath(String string) {
        String string2 = (String)this.keyFile.getSelectedItem();
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        this.keyFile.setSelectedItem(string);
    }

    public int getAuthenticationMethod() {
        int n = this.tabs.getSelectedIndex();
        switch (n) {
            case 0: {
                if (!$assertionsDisabled && !resources.getString("tab.passwd").equals(this.tabs.getTitleAt(n))) {
                    throw new AssertionError();
                }
                break;
            }
            case 1: {
                if (!$assertionsDisabled && !resources.getString("tab.keyFile").equals(this.tabs.getTitleAt(n))) {
                    throw new AssertionError();
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported authentication method!");
            }
        }
        return n;
    }

    static JFileChooser getFileChooser() {
        JFileChooser jFileChooser;
        SoftReference softReference = fileChooser;
        JFileChooser jFileChooser2 = jFileChooser = softReference != null ? (JFileChooser)softReference.get() : null;
        if (jFileChooser == null) {
            jFileChooser = new CustomFileChooser();
            fileChooser = new SoftReference<JFileChooser>(jFileChooser);
        }
        return jFileChooser;
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        JLabel jLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyFilePanel.setLayout(new GridBagLayout());
        this.keyFilePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.keyFilePanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                AuthenticationPanel.this.keyFilePanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        jLabel.setDisplayedMnemonic(resources.getString("keyFile").charAt(0));
        jLabel.setLabelFor(this.keyFile);
        jLabel.setText(resources.getString("keyFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.keyFilePanel.add((Component)jLabel, gridBagConstraints);
        this.keyFile.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keyFilePanel.add((Component)this.keyFile, gridBagConstraints);
        this.keyFileChooser.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        this.keyFileChooser.setToolTipText(resources.getString("selectKeyFile.toolTip"));
        this.keyFileChooser.setName("keyFileChooser");
        this.keyFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuthenticationPanel.this.keyFileChooserActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.keyFilePanel.add((Component)this.keyFileChooser, gridBagConstraints);
        this.tabs.addTab(resources.getString("tab.keyFile"), this.keyFilePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabs, gridBagConstraints);
    }

    private void keyFileChooserActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = AuthenticationPanel.getFileChooser();
        if (jFileChooser.showOpenDialog(this) == 0) {
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(jFileChooser.getSelectedFile(), (ArchiveDetector)ArchiveDetector.NULL);
            String string = BASE_DIR.getCanOrAbsPath();
            String string2 = file.getCanOrAbsPath();
            if (string2.startsWith(string)) {
                if (!$assertionsDisabled && string2.charAt(string.length()) != de.schlichtherle.io.File.separatorChar) {
                    throw new AssertionError();
                }
                string2 = string2.substring(string.length() + 1);
            }
            this.setKeyFilePath(string2);
        }
    }

    private void keyFilePanelAncestorWindowShown(PanelEvent panelEvent) {
        final Window window = panelEvent.getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (AuthenticationPanel.this.keyFile.requestFocusInWindow()) {
                            ((JTextComponent)AuthenticationPanel.this.keyFile.getEditor().getEditorComponent()).selectAll();
                        }
                    }
                });
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    static /* synthetic */ de.schlichtherle.io.File access$400() {
        return BASE_DIR;
    }

    static {
        $assertionsDisabled = !AuthenticationPanel.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/key/passwd/swing/AuthenticationPanel".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        BASE_DIR = new de.schlichtherle.io.File(".", (ArchiveDetector)ArchiveDetector.NULL);
    }

    private static class CustomFileChooser
    extends JFileChooser {
        private static File lastCurrentDir = AuthenticationPanel.access$400();

        public CustomFileChooser() {
            super(lastCurrentDir);
            this.setDialogTitle(resources.getString("fileChooser.title"));
            this.setFileHidingEnabled(false);
        }

        public void setCurrentDirectory(File file) {
            super.setCurrentDirectory(file);
            lastCurrentDir = file;
        }

        public File getCurrentDirectory() {
            lastCurrentDir = super.getCurrentDirectory();
            return lastCurrentDir;
        }
    }
}

