/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.util.LEDataOutputStream;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class BasicZipOutputStream
extends FilterOutputStream {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final String charset;
    private final CRC32 crc = new CRC32();
    private final ZipDeflater def = new ZipDeflater();
    private final byte[] dbuf = new byte[65536];
    private final byte[] sbuf = new byte[1];
    private String comment = "";
    private short method = (short)8;
    private final Map entries = new LinkedHashMap();
    private long dataStart;
    private long cdOffset;
    private long cdLength;
    private boolean finished;
    private boolean closed;
    private ZipEntry entry;
    private boolean deflate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicZipOutputStream(OutputStream outputStream) throws NullPointerException {
        super(BasicZipOutputStream.toLEDataOutputStream(outputStream));
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.charset = DEFAULT_CHARSET;
    }

    public BasicZipOutputStream(OutputStream outputStream, String string) throws NullPointerException, UnsupportedEncodingException {
        super(BasicZipOutputStream.toLEDataOutputStream(outputStream));
        if (outputStream == null || string == null) {
            throw new NullPointerException();
        }
        "".getBytes(string);
        this.charset = string;
    }

    private static LEDataOutputStream toLEDataOutputStream(OutputStream outputStream) {
        return outputStream instanceof LEDataOutputStream ? (LEDataOutputStream)outputStream : new LEDataOutputStream(outputStream);
    }

    public String getEncoding() {
        return this.charset;
    }

    public int size() {
        return this.entries.size();
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public int getLevel() {
        return this.def.getLevel();
    }

    public void setLevel(int n) {
        this.def.setLevel(n);
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = (short)n;
    }

    public long length() {
        return ((LEDataOutputStream)this.out).size();
    }

    public boolean isBusy() {
        return this.entry != null;
    }

    public final void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.putNextEntry(zipEntry, true);
    }

    public void putNextEntry(ZipEntry zipEntry, boolean bl) throws IOException {
        this.closeEntry();
        String string = zipEntry.getName();
        long l = zipEntry.getNameLength(this.charset) + zipEntry.getExtraLength() + zipEntry.getCommentLength(this.charset);
        if (l > 65535L) {
            throw new ZipException(zipEntry.getName() + ": sum of name, extra fields and comment too long: " + l);
        }
        int n = zipEntry.getMethod();
        if (n == -1) {
            n = this.getMethod();
        }
        switch (n) {
            case 0: {
                BasicZipOutputStream.checkLocalFileHeaderData(zipEntry);
                this.deflate = false;
                break;
            }
            case 8: {
                if (!bl) {
                    BasicZipOutputStream.checkLocalFileHeaderData(zipEntry);
                }
                this.deflate = bl;
                break;
            }
            default: {
                throw new ZipException(zipEntry.getName() + ": unsupported compression method: " + n);
            }
        }
        if (zipEntry.getPlatform() == -1) {
            zipEntry.setPlatform((short)0);
        }
        if (zipEntry.getMethod() == -1) {
            zipEntry.setMethod(n);
        }
        if (zipEntry.getTime() == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        this.entry = zipEntry;
        this.writeLocalFileHeader();
        ZipEntry zipEntry2 = this.entries.put(string, zipEntry);
        if (!$assertionsDisabled && zipEntry2 != null) {
            throw new AssertionError();
        }
    }

    private static void checkLocalFileHeaderData(ZipEntry zipEntry) throws ZipException {
        if (zipEntry.getCrc() == -1L) {
            throw new ZipException("unknown CRC checksum");
        }
        if (zipEntry.getCompressedSize() == -1L) {
            throw new ZipException("unknown compressed size");
        }
        if (zipEntry.getSize() == -1L) {
            throw new ZipException("unknown size");
        }
    }

    private void writeLocalFileHeader() throws IOException {
        if (!$assertionsDisabled && this.entry == null) {
            throw new AssertionError();
        }
        ZipEntry zipEntry = this.entry;
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        long l = lEDataOutputStream.size();
        this.finished = false;
        lEDataOutputStream.writeInt(67324752);
        boolean bl = zipEntry.getCrc() == -1L || zipEntry.getCompressedSize() == -1L || zipEntry.getSize() == -1L;
        boolean bl2 = DEFAULT_CHARSET.equalsIgnoreCase(this.charset);
        int n = (bl ? 8 : 0) | (bl2 ? 2048 : 0);
        lEDataOutputStream.writeShort(bl ? 20 : 10);
        lEDataOutputStream.writeShort(n);
        lEDataOutputStream.writeShort(zipEntry.getMethod());
        lEDataOutputStream.writeInt((int)zipEntry.getDosTime());
        if (bl) {
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
        } else {
            lEDataOutputStream.writeInt((int)zipEntry.getCrc());
            lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
            lEDataOutputStream.writeInt((int)zipEntry.getSize());
        }
        byte[] byArray = zipEntry.getName().getBytes(this.charset);
        lEDataOutputStream.writeShort(byArray.length);
        byte[] byArray2 = zipEntry.getExtra();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        lEDataOutputStream.writeShort(byArray2.length);
        lEDataOutputStream.write(byArray);
        lEDataOutputStream.write(byArray2);
        zipEntry.setGeneral(n);
        zipEntry.offset = l;
        this.dataStart = lEDataOutputStream.size();
    }

    public void write(int n) throws IOException {
        byte[] byArray = this.sbuf;
        byArray[0] = (byte)n;
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry != null) {
            if (n2 == 0) {
                return;
            }
            if (this.deflate) {
                if (!$assertionsDisabled && this.def.finished()) {
                    throw new AssertionError();
                }
                this.def.setInput(byArray, n, n2);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
                this.crc.update(byArray, n, n2);
            } else {
                this.out.write(byArray, n, n2);
                if (this.entry.getMethod() != 8) {
                    this.crc.update(byArray, n, n2);
                }
            }
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    private final void deflate() throws IOException {
        int n = this.def.deflate(this.dbuf, 0, this.dbuf.length);
        if (n > 0) {
            this.out.write(this.dbuf, 0, n);
        }
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        switch (this.entry.getMethod()) {
            case 0: {
                long l = this.crc.getValue();
                if (l != this.entry.getCrc()) {
                    throw new ZipException(this.entry.getName() + ": bad entry CRC-32: " + Long.toHexString(this.entry.getCrc()) + " expected: " + Long.toHexString(l));
                }
                long l2 = ((LEDataOutputStream)this.out).size();
                if (this.entry.getSize() == l2 - this.dataStart) break;
                throw new ZipException(this.entry.getName() + ": bad entry size: " + this.entry.getSize() + " expected: " + (l2 - this.dataStart));
            }
            case 8: {
                if (!this.deflate) break;
                if (!$assertionsDisabled && this.def.finished()) {
                    throw new AssertionError();
                }
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
                this.entry.setCrc(this.crc.getValue());
                this.entry.setCompressedSize((long)this.def.getTotalOut() & 0xFFFFFFFFL);
                this.entry.setSize((long)this.def.getTotalIn() & 0xFFFFFFFFL);
                this.def.reset();
                break;
            }
            default: {
                throw new ZipException(this.entry.getName() + ": unsupported compression method: " + this.entry.getMethod());
            }
        }
        this.writeDataDescriptor();
        this.flush();
        this.crc.reset();
        this.entry = null;
    }

    private void writeDataDescriptor() throws IOException {
        ZipEntry zipEntry = this.entry;
        if (!$assertionsDisabled && zipEntry == null) {
            throw new AssertionError();
        }
        if (!zipEntry.getGeneralBit(3)) {
            return;
        }
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(134695760);
        lEDataOutputStream.writeInt((int)zipEntry.getCrc());
        lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
        lEDataOutputStream.writeInt((int)zipEntry.getSize());
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.closeEntry();
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        this.cdOffset = lEDataOutputStream.size();
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            this.writeCentralFileHeader((ZipEntry)iterator.next());
        }
        this.cdLength = lEDataOutputStream.size() - this.cdOffset;
        this.writeEndOfCentralDirectory();
    }

    private void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        if (!$assertionsDisabled && zipEntry == null) {
            throw new AssertionError();
        }
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(33639248);
        lEDataOutputStream.writeShort(zipEntry.getPlatform() << 8 | 0x3F);
        lEDataOutputStream.writeShort(zipEntry.getGeneralBit(3) ? 20 : 10);
        lEDataOutputStream.writeShort(zipEntry.getGeneral());
        lEDataOutputStream.writeShort(zipEntry.getMethod());
        lEDataOutputStream.writeInt((int)zipEntry.getDosTime());
        lEDataOutputStream.writeInt((int)zipEntry.getCrc());
        lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
        lEDataOutputStream.writeInt((int)zipEntry.getSize());
        byte[] byArray = zipEntry.getName().getBytes(this.charset);
        lEDataOutputStream.writeShort(byArray.length);
        byte[] byArray2 = zipEntry.getExtra();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        lEDataOutputStream.writeShort(byArray2.length);
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray3 = string.getBytes(this.charset);
        lEDataOutputStream.writeShort(byArray3.length);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt((int)zipEntry.offset);
        lEDataOutputStream.write(byArray);
        lEDataOutputStream.write(byArray2);
        lEDataOutputStream.write(byArray3);
    }

    private void writeEndOfCentralDirectory() throws IOException {
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(101010256);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(this.entries.size());
        lEDataOutputStream.writeShort(this.entries.size());
        lEDataOutputStream.writeInt((int)this.cdLength);
        lEDataOutputStream.writeInt((int)this.cdOffset);
        String string = this.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray = string.getBytes(this.charset);
        lEDataOutputStream.writeShort(byArray.length);
        lEDataOutputStream.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.finish();
        }
        finally {
            this.entries.clear();
            super.close();
        }
    }

    static {
        $assertionsDisabled = !BasicZipOutputStream.class.desiredAssertionStatus();
    }

    private static class ZipDeflater
    extends Deflater {
        private int level = -1;

        public ZipDeflater() {
            super(-1, true);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            super.setLevel(n);
            this.level = n;
        }
    }
}

