/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.android.items;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.android.AndroidHelper;
import de.qfs.apps.qftest.client.android.toolkit.AndroidComponent;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;

public class ListItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.android.items.ListItemResolver");
    protected AndroidHelper helper;
    protected String[] listClasses;
    protected String[] itemClasses;
    protected ListItemValueResolver itemValueResolver = new ListItemValueResolver();

    public ListItemResolver(AndroidHelper androidHelper) {
        this(androidHelper, new String[]{"List"}, new String[]{"Item:ListItem"});
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(AndroidHelper)", 79).addDetail("helper", (Object)androidHelper)).log();
        }
    }

    public ListItemResolver(AndroidHelper androidHelper, String string, String string2) {
        this(androidHelper, new String[]{string}, new String[]{string2});
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(AndroidHelper,String,String)", 94).addDetail("helper", (Object)androidHelper)).addDetail("listClass", string)).addDetail("itemClass", string2)).log();
        }
    }

    public ListItemResolver(AndroidHelper androidHelper, String[] stringArray, String[] stringArray2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemResolver(AndroidHelper,String[],String[])", 109).addDetail("helper", (Object)androidHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        this.helper = androidHelper;
        this.listClasses = stringArray;
        this.itemClasses = stringArray2;
    }

    public static ListItemResolver createAndRegister(AndroidHelper androidHelper) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(AndroidHelper)", 126).addDetail("helper", (Object)androidHelper)).log();
        }
        return ListItemResolver.createAndRegister(androidHelper, new String[]{"List"}, new String[]{"Item:ListItem"});
    }

    public static ListItemResolver createAndRegister(AndroidHelper androidHelper, String string, String string2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(AndroidHelper,String,String)", 143).addDetail("helper", (Object)androidHelper)).addDetail("listClass", string)).addDetail("itemClass", string2)).log();
        }
        return ListItemResolver.createAndRegister(androidHelper, new String[]{string}, new String[]{string2});
    }

    public static ListItemResolver createAndRegister(AndroidHelper androidHelper, String[] stringArray, String[] stringArray2) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(AndroidHelper,String[],String[])", 161).addDetail("helper", (Object)androidHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).log();
        }
        ListItemResolver listItemResolver = new ListItemResolver(androidHelper, stringArray, stringArray2);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)listItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, listItemResolver.getItemValueResolver());
        }
        for (String string : stringArray2) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)listItemResolver);
        }
        return listItemResolver;
    }

    public void unregister() {
        if (ListItemResolver.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 182).log();
        }
        for (String string : this.listClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, (ItemValueResolver)this.itemValueResolver);
        }
        for (String string : this.itemClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    public Object[] getParentAndItem(Object object) {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 210).addDetail("element", object)).log();
        }
        if (!(object instanceof AndroidComponent)) {
            if (ListItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getParentAndItem(Object)", 213).add("Not an AndroidComponent", object)).dumpStack();
            }
            return null;
        }
        if (this.helper.isMatchingClass(object, this.itemClasses)) {
            Object object2 = this.helper.getAncestorOfClass(object, this.listClasses);
            int n2 = this.getItemIndex((AndroidComponent)object2, (AndroidComponent)object);
            return new Object[]{object2, n2};
        }
        return null;
    }

    public Object getElement(Object object, Object object2) throws TestException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 238).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!this.a(object, object2)) {
            return null;
        }
        int n2 = (Integer)object2;
        AndroidComponent androidComponent = this.getItemComponent((AndroidComponent)object, n2);
        if (androidComponent != null) {
            return androidComponent;
        }
        RetryException.throwEither((TestException)((Object)new BadItemException("Cannot find component for item " + String.valueOf(object2))), (long)10L);
        return null;
    }

    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        SubItemIndex subItemIndex;
        int n2;
        int n3;
        block10: {
            AndroidComponent androidComponent;
            block9: {
                if (ListItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 271).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                if (!this.a(object, null)) {
                    return null;
                }
                androidComponent = (AndroidComponent)object;
                n3 = -1;
                n2 = this.getRowCount(androidComponent);
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 282).add("rows", n2)).log();
                }
                if (n2 == 0) {
                    return null;
                }
                subItemIndex = subItemIndexArray[0];
                if (subItemIndex.getType() != 1) break block9;
                n3 = subItemIndex.asNumber();
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 291).add("item", n3)).log();
                }
                if (n3 >= 0) break block10;
                n3 = n2 + n3;
                break block10;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!subItemIndex.matches(this.getResolvedName(androidComponent, i2))) continue;
                n3 = i2;
                break;
            }
        }
        if (n3 < 0 || n3 >= n2) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 304).add("item[0]", n3)).dumpStack();
            }
            throw new IndexNotFoundException(subItemIndex);
        }
        if (ListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 308).add("item", n3)).log();
        }
        return n3;
    }

    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 327).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        if (object2 == null) {
            return null;
        }
        if (!this.a(object, object2)) {
            return null;
        }
        AndroidComponent androidComponent = (AndroidComponent)object;
        int n3 = this.getRowCount(androidComponent);
        int n4 = (Integer)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        switch (n2) {
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n4);
                break;
            }
            case 1: {
                boolean bl;
                String string = this.getResolvedName(androidComponent, n4);
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 353).add("name", string)).log();
                }
                boolean bl2 = bl = string != null && string.length() > 0;
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 355).add("unique", bl)).log();
                }
                if (bl) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (i2 == n4) continue;
                        String string2 = this.getResolvedName(androidComponent, i2);
                        if (ListItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 360).add("iname", string2)).log();
                        }
                        if (!Misc.equalOrNull((Object)string, (Object)string2)) continue;
                        bl = false;
                        break;
                    }
                }
                subItemIndexArray[0] = bl ? new SubItemIndex(string, "\\#@&%") : new SubItemIndex(n4);
                break;
            }
            case 2: {
                subItemIndexArray[0] = new SubItemIndex(this.getResolvedName(androidComponent, n4), "\\#@&%");
            }
        }
        if (ListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 378).add("result", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    public boolean isCustomList(AndroidComponent androidComponent) {
        Object object;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isCustomList(AndroidComponent)", 390).addDetail("list", (Object)androidComponent)).log();
        }
        if (!androidComponent.isCollection()) {
            return false;
        }
        Object[] objectArray = this.helper.getElementsByClassName(androidComponent, this.itemClasses);
        if (objectArray.length != 0 && (object = objectArray[0]) instanceof AndroidComponent) {
            AndroidComponent androidComponent2 = (AndroidComponent)object;
            return !androidComponent2.isItem();
        }
        return false;
    }

    public int getRowCount(AndroidComponent androidComponent) {
        if (this.isCustomList(androidComponent)) {
            Object[] objectArray = this.helper.getElementsByClassName(androidComponent, this.itemClasses);
            return objectArray.length;
        }
        int n2 = androidComponent.getRows();
        if (n2 == -1) {
            AndroidComponent[] androidComponentArray;
            n2 = 0;
            for (AndroidComponent androidComponent2 : androidComponentArray = androidComponent.getChildren()) {
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getRowCount(AndroidComponent)", 425).add("child", (Object)androidComponent2)).log();
                }
                n2 = Math.max(n2, androidComponent2.getRow() + 1);
            }
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getRowCount(AndroidComponent)", 428).add("rows from children: ")).add(n2)).log();
            }
        }
        return n2;
    }

    public AndroidComponent getItemComponent(AndroidComponent androidComponent, int n2) {
        Object[] objectArray;
        block5: {
            if (this.isCustomList(androidComponent)) {
                objectArray = this.helper.getElementsByClassName(androidComponent, this.itemClasses);
                try {
                    return (AndroidComponent)objectArray[n2];
                }
                catch (Throwable throwable) {
                    if (ListItemResolver.a.level < 5) break block5;
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getItemComponent(AndroidComponent,int)", 452).add("Mapping index to android component failed!", (Object)throwable)).log();
                }
            }
        }
        objectArray = androidComponent.getChildren();
        for (AndroidComponent androidComponent2 : objectArray) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemComponent(AndroidComponent,int)", 458).add("child", (Object)androidComponent2)).log();
            }
            if (androidComponent2.getRow() != n2) continue;
            return androidComponent2;
        }
        return null;
    }

    public int getItemIndex(AndroidComponent androidComponent, AndroidComponent androidComponent2) {
        if (androidComponent2 == null) {
            return -1;
        }
        if (this.isCustomList(androidComponent)) {
            Object[] objectArray = this.helper.getElementsByClassName(androidComponent, this.itemClasses);
            int n2 = 0;
            for (Object object : objectArray) {
                if (androidComponent2.equals(object)) {
                    return n2;
                }
                ++n2;
            }
        }
        return androidComponent2.getRow();
    }

    public String getName(AndroidComponent androidComponent, int n2) {
        AndroidHelper androidHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getName(AndroidComponent,int)", 507).addDetail("list", (Object)androidComponent)).addDetail("item", n2)).log();
        }
        if ((androidHelper = (AndroidHelper)Engine.helperFor((Object)androidComponent)) == null) {
            return "";
        }
        String string = ResolverRegistry.instance().getItemName((Object)androidComponent, (Object)n2, null);
        if (ListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getName(AndroidComponent,int)", 515).add("Name from registry: ")).add(string)).log();
        }
        if (string == null) {
            AndroidComponent androidComponent2 = this.getItemComponent(androidComponent, n2);
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getName(AndroidComponent,int)", 519).add("cell", (Object)androidComponent2)).log();
            }
            if (androidComponent2 != null) {
                string = androidHelper.getFlatIdentifierText(androidComponent2);
                if (ListItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getName(AndroidComponent,int)", 522).add("Name from cell itself: ")).add(string)).log();
                }
                if (string == null) {
                    string = androidHelper.getFirstLabelText(androidComponent2);
                    if (ListItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getName(AndroidComponent,int)", 525).add("First label text from cell: ")).add(string)).log();
                    }
                    if (string == null) {
                        string = androidHelper.getFirstNonEmptyText(androidComponent2);
                        if (ListItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getName(AndroidComponent,int)", 528).add("First non-empty text from cell: ")).add(string)).log();
                        }
                    }
                    if (string != null) {
                        string = Util.getFlatIdentifierText((String)string);
                    }
                }
            }
        }
        return string;
    }

    public String getResolvedName(AndroidComponent androidComponent, int n2) {
        AndroidHelper androidHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedName(AndroidComponent,int)", 551).addDetail("list", (Object)androidComponent)).addDetail("item", n2)).log();
        }
        if ((androidHelper = (AndroidHelper)Engine.helperFor((Object)androidComponent)) == null) {
            return "";
        }
        String string = this.getName(androidComponent, n2);
        return ItemRegistry.instance().getItemName((Object)androidComponent, androidHelper.getClassNames(androidComponent), (Object)n2, string);
    }

    public String getValue(AndroidComponent androidComponent, int n2) {
        AndroidHelper androidHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getValue(AndroidComponent,int)", 573).addDetail("list", (Object)androidComponent)).addDetail("item", n2)).log();
        }
        if ((androidHelper = (AndroidHelper)Engine.helperFor((Object)androidComponent)) == null) {
            return "";
        }
        AndroidComponent androidComponent2 = this.getItemComponent(androidComponent, n2);
        if (androidComponent2 != null) {
            return Util.getCleanElementText((String)androidHelper.getWholeText(androidComponent2));
        }
        return null;
    }

    public String getResolvedValue(AndroidComponent androidComponent, int n2) {
        AndroidHelper androidHelper;
        if (ListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedValue(AndroidComponent,int)", 597).addDetail("list", (Object)androidComponent)).addDetail("item", n2)).log();
        }
        if ((androidHelper = (AndroidHelper)Engine.helperFor((Object)androidComponent)) == null) {
            return "";
        }
        String string = this.getValue(androidComponent, n2);
        return ItemRegistry.instance().resolveItemValue((Object)androidComponent, androidHelper.getClassNames(androidComponent), (Object)n2, string);
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    private boolean a(Object object, Object object2) throws BadItemException {
        if (!(object instanceof AndroidComponent)) {
            if (ListItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "checkItem(Object,Object)", 648).add("Not an AndroidComponent", object)).dumpStack();
            }
            return false;
        }
        if (!this.helper.isMatchingClass(object, this.listClasses)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "checkItem(Object,Object)", 652).add("Not a List", object)).dumpStack();
            }
            return false;
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (ListItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "checkItem(Object,Object)", 657).add("Internal error: Not an int", object2)).dumpStack();
            }
            throw new BadItemException("Not an int: " + String.valueOf(object2));
        }
        return true;
    }

    public class ListItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        public String getItemValue(Object object, Object object2) {
            if (ListItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListItemValueResolver.getItemValue(Object,Object)", 688).addDetail("element", object)).addDetail("item", object2)).log();
            }
            if (object2 == null) {
                return null;
            }
            try {
                if (!ListItemResolver.this.a(object, object2)) {
                    return null;
                }
            }
            catch (BadItemException badItemException) {
                if (ListItemResolver.a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "ListItemValueResolver.getItemValue(Object,Object)", 698).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
            return ListItemResolver.this.getValue((AndroidComponent)object, (Integer)object2);
        }
    }
}

