/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.android.toolkit;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;

public class AndroidClassesGenerated {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.android.toolkit.AndroidClassesGenerated");
    private static final String[] b = new String[]{"app", "appcompat", "camera", "cardview", "coordinatorlayout", "core", "drawerlayout", "emoji", "fragment", "gridlayout", "leanback", "media2", "mediarouter", "percentlayout", "recyclerview", "slice", "slidingpanelayout", "swiperefreshlayout", "view", "viewpager", "viewpager2", "wear"};

    public static String normalizeClassString(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "normalizeClassString(String)", 63).addDetail("clazz", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            if (AndroidClassesGenerated.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "normalizeClassString(String)", 66).add("Null or empty clazz!")).log();
            }
            return "";
        }
        int n2 = string.indexOf("<");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string.startsWith("android.support.v")) {
            string = string.substring("android.support.".length());
            CharSequence[] charSequenceArray = string.split("\\.");
            for (String string2 : b) {
                charSequenceArray[0] = "androidx." + string2;
                string = String.join((CharSequence)".", charSequenceArray);
                if (!AndroidClassesGenerated.isSystemClazz(string)) continue;
                return string;
            }
            charSequenceArray[0] = "androidx";
            string = String.join((CharSequence)".", charSequenceArray);
            return string;
        }
        return string;
    }

    public static String getParentClazz(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentClazz(String)", 97).addDetail("clazz", string)).log();
        }
        string = AndroidClassesGenerated.normalizeClassString(string);
        String string2 = "android.view.View";
        switch (string) {
            case "androidx.appcompat.widget.AppCompatToggleButton": {
                return "android.widget.ToggleButton";
            }
            case "android.view.View": {
                return "java.lang.Object";
            }
            case "android.widget.TextView": {
                return "android.view.View";
            }
            case "android.widget.Button": {
                return "android.widget.TextView";
            }
            case "android.widget.CompoundButton": {
                return "android.widget.Button";
            }
            case "android.widget.ToggleButton": {
                return "android.widget.CompoundButton";
            }
            case "androidx.emoji.widget.EmojiExtractTextLayout": {
                return "android.widget.LinearLayout";
            }
            case "android.view.ViewGroup": {
                return "android.view.View";
            }
            case "android.widget.LinearLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.leanback.widget.BaseCardView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.FrameLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.core.widget.ContentLoadingProgressBar": {
                return "android.widget.ProgressBar";
            }
            case "android.widget.ProgressBar": {
                return "android.view.View";
            }
            case "androidx.drawerlayout.widget.DrawerLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.appcompat.widget.AppCompatImageButton": {
                return "android.widget.ImageButton";
            }
            case "android.widget.ImageView": {
                return "android.view.View";
            }
            case "android.widget.ImageButton": {
                return "android.widget.ImageView";
            }
            case "androidx.emoji.widget.EmojiEditText": {
                return "android.widget.EditText";
            }
            case "android.widget.EditText": {
                return "android.widget.TextView";
            }
            case "androidx.appcompat.widget.SearchView": {
                return "androidx.appcompat.widget.LinearLayoutCompat";
            }
            case "androidx.appcompat.widget.LinearLayoutCompat": {
                return "android.view.ViewGroup";
            }
            case "androidx.leanback.widget.BaseGridView": {
                return "androidx.recyclerview.widget.RecyclerView";
            }
            case "androidx.recyclerview.widget.RecyclerView": {
                return "android.view.ViewGroup";
            }
            case "androidx.appcompat.widget.ActionMenuView": {
                return "androidx.appcompat.widget.LinearLayoutCompat";
            }
            case "androidx.viewpager.widget.PagerTitleStrip": {
                return "android.view.ViewGroup";
            }
            case "androidx.leanback.widget.ShadowOverlayContainer": {
                return "android.widget.FrameLayout";
            }
            case "androidx.media2.widget.VideoView": {
                return "android.view.ViewGroup";
            }
            case "androidx.appcompat.widget.AppCompatSpinner": {
                return "android.widget.Spinner";
            }
            case "android.widget.AdapterView": {
                return "android.view.ViewGroup";
            }
            case "android.widget.AbsSpinner": {
                return "android.widget.AdapterView";
            }
            case "android.widget.Spinner": {
                return "android.widget.AbsSpinner";
            }
            case "androidx.wear.widget.WearArcLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.viewpager2.widget.ViewPager2": {
                return "android.view.ViewGroup";
            }
            case "androidx.leanback.widget.SearchOrbView": {
                return "android.widget.FrameLayout";
            }
            case "androidx.slidingpanelayout.widget.SlidingPaneLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.wear.widget.drawer.WearableActionDrawerView": {
                return "androidx.wear.widget.drawer.WearableDrawerView";
            }
            case "androidx.wear.widget.drawer.WearableDrawerView": {
                return "android.widget.FrameLayout";
            }
            case "androidx.media2.widget.MediaControlView": {
                return "android.view.ViewGroup";
            }
            case "androidx.fragment.app.FragmentTabHost": {
                return "android.widget.TabHost";
            }
            case "android.widget.TabHost": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.ZoomButton": {
                return "android.widget.ImageButton";
            }
            case "androidx.coordinatorlayout.widget.CoordinatorLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.core.widget.NestedScrollView": {
                return "android.widget.FrameLayout";
            }
            case "androidx.leanback.widget.picker.PinPicker": {
                return "androidx.leanback.widget.picker.Picker";
            }
            case "androidx.leanback.widget.picker.Picker": {
                return "android.widget.FrameLayout";
            }
            case "androidx.appcompat.widget.AppCompatCheckedTextView": {
                return "android.widget.CheckedTextView";
            }
            case "android.widget.CheckedTextView": {
                return "android.widget.TextView";
            }
            case "androidx.mediarouter.app.MediaRouteButton": {
                return "android.view.View";
            }
            case "androidx.percentlayout.widget.PercentFrameLayout": {
                return "android.widget.FrameLayout";
            }
            case "androidx.viewpager.widget.PagerTabStrip": {
                return "androidx.viewpager.widget.PagerTitleStrip";
            }
            case "androidx.leanback.widget.GuidedActionEditText": {
                return "android.widget.EditText";
            }
            case "android.widget.Switch": {
                return "android.widget.CompoundButton";
            }
            case "androidx.appcompat.widget.AppCompatEditText": {
                return "android.widget.EditText";
            }
            case "androidx.emoji.widget.EmojiAppCompatEditText": {
                return "androidx.appcompat.widget.AppCompatEditText";
            }
            case "androidx.appcompat.widget.AppCompatImageView": {
                return "android.widget.ImageView";
            }
            case "androidx.leanback.widget.picker.DatePicker": {
                return "androidx.leanback.widget.picker.Picker";
            }
            case "androidx.fragment.app.FragmentContainerView": {
                return "android.widget.FrameLayout";
            }
            case "androidx.appcompat.widget.AppCompatButton": {
                return "android.widget.Button";
            }
            case "androidx.leanback.widget.HorizontalGridView": {
                return "androidx.leanback.widget.BaseGridView";
            }
            case "androidx.wear.widget.BoxInsetLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.leanback.widget.SearchBar": {
                return "android.widget.RelativeLayout";
            }
            case "android.widget.RelativeLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.leanback.widget.SearchEditText": {
                return "android.widget.EditText";
            }
            case "android.widget.AutoCompleteTextView": {
                return "android.widget.EditText";
            }
            case "android.widget.MultiAutoCompleteTextView": {
                return "android.widget.AutoCompleteTextView";
            }
            case "android.widget.Adapter": {
                return "android.widget.AdapterView";
            }
            case "androidx.camera.view.CameraView": {
                return "android.widget.FrameLayout";
            }
            case "androidx.leanback.widget.SpeechOrbView": {
                return "androidx.leanback.widget.SearchOrbView";
            }
            case "androidx.appcompat.widget.SwitchCompat": {
                return "android.widget.CompoundButton";
            }
            case "android.widget.ListView": {
                return "android.widget.AbsListView";
            }
            case "android.widget.AbsListView": {
                return "android.widget.AdapterView";
            }
            case "androidx.cardview.widget.CardView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.CheckBox": {
                return "android.widget.CompoundButton";
            }
            case "android.inputmethodservice.ExtractEditText": {
                return "android.widget.EditText";
            }
            case "androidx.appcompat.widget.AppCompatTextView": {
                return "android.widget.TextView";
            }
            case "androidx.leanback.widget.picker.TimePicker": {
                return "androidx.leanback.widget.picker.Picker";
            }
            case "androidx.appcompat.widget.AppCompatSeekBar": {
                return "android.widget.SeekBar";
            }
            case "android.widget.AbsSeekBar": {
                return "android.widget.ProgressBar";
            }
            case "android.widget.SeekBar": {
                return "android.widget.AbsSeekBar";
            }
            case "androidx.wear.widget.DismissibleFrameLayout": {
                return "android.widget.FrameLayout";
            }
            case "androidx.wear.widget.SwipeDismissFrameLayout": {
                return "androidx.wear.widget.DismissibleFrameLayout";
            }
            case "androidx.leanback.widget.TitleView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.Gallery": {
                return "android.widget.AbsSpinner";
            }
            case "androidx.leanback.widget.ListRowHoverCardView": {
                return "android.widget.LinearLayout";
            }
            case "androidx.wear.widget.WearableRecyclerView": {
                return "androidx.recyclerview.widget.RecyclerView";
            }
            case "androidx.percentlayout.widget.PercentRelativeLayout": {
                return "android.widget.RelativeLayout";
            }
            case "androidx.appcompat.widget.AppCompatCheckBox": {
                return "android.widget.CheckBox";
            }
            case "androidx.camera.view.PreviewView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.Chronometer": {
                return "android.widget.TextView";
            }
            case "androidx.swiperefreshlayout.widget.SwipeRefreshLayout": {
                return "android.view.ViewGroup";
            }
            case "androidx.emoji.widget.EmojiTextView": {
                return "android.widget.TextView";
            }
            case "androidx.emoji.widget.EmojiAppCompatButton": {
                return "androidx.appcompat.widget.AppCompatButton";
            }
            case "androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView": {
                return "android.widget.MultiAutoCompleteTextView";
            }
            case "androidx.leanback.tab.LeanbackTabLayout": {
                return "com.google.android.material.tabs.TabLayout";
            }
            case "android.widget.HorizontalScrollView": {
                return "android.widget.FrameLayout";
            }
            case "com.google.android.material.tabs.TabLayout": {
                return "android.widget.HorizontalScrollView";
            }
            case "androidx.leanback.widget.BrowseFrameLayout": {
                return "android.widget.FrameLayout";
            }
            case "androidx.wear.widget.WearCurvedTextView": {
                return "android.view.View";
            }
            case "androidx.viewpager.widget.ViewPager": {
                return "android.view.ViewGroup";
            }
            case "android.widget.ActionMenuView": {
                return "android.widget.LinearLayout";
            }
            case "androidx.appcompat.widget.Toolbar": {
                return "android.view.ViewGroup";
            }
            case "androidx.wear.widget.drawer.WearableDrawerLayout": {
                return "android.widget.FrameLayout";
            }
            case "androidx.emoji.widget.EmojiAppCompatTextView": {
                return "androidx.appcompat.widget.AppCompatTextView";
            }
            case "androidx.leanback.tab.LeanbackViewPager": {
                return "androidx.viewpager.widget.ViewPager";
            }
            case "androidx.leanback.widget.ListRowView": {
                return "android.widget.LinearLayout";
            }
            case "androidx.slice.widget.SliceView": {
                return "android.view.ViewGroup";
            }
            case "androidx.wear.widget.CircularProgressLayout": {
                return "android.widget.FrameLayout";
            }
            case "androidx.leanback.widget.VerticalGridView": {
                return "androidx.leanback.widget.BaseGridView";
            }
            case "android.widget.ZoomControls": {
                return "android.widget.LinearLayout";
            }
            case "androidx.appcompat.widget.AppCompatRadioButton": {
                return "android.widget.RadioButton";
            }
            case "android.widget.RadioButton": {
                return "android.widget.CompoundButton";
            }
            case "androidx.leanback.widget.ImageCardView": {
                return "androidx.leanback.widget.BaseCardView";
            }
            case "android.widget.VideoView": {
                return "android.view.SurfaceView";
            }
            case "android.view.SurfaceView": {
                return "android.view.View";
            }
            case "androidx.emoji.widget.EmojiButton": {
                return "android.widget.Button";
            }
            case "androidx.leanback.widget.RowHeaderView": {
                return "android.widget.TextView";
            }
            case "android.widget.DigitalClock": {
                return "android.widget.TextView";
            }
            case "androidx.appcompat.widget.AppCompatAutoCompleteTextView": {
                return "android.widget.AutoCompleteTextView";
            }
            case "androidx.appcompat.widget.AppCompatRatingBar": {
                return "android.widget.RatingBar";
            }
            case "android.widget.RatingBar": {
                return "android.widget.AbsSeekBar";
            }
            case "androidx.wear.widget.drawer.WearableNavigationDrawerView": {
                return "androidx.wear.widget.drawer.WearableDrawerView";
            }
            case "android.widget.DatePicker": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.MediaController": {
                return "android.widget.FrameLayout";
            }
            case "androidx.gridlayout.widget.GridLayout": {
                return "android.view.ViewGroup";
            }
            case "android.widget.TabWidget": {
                return "android.widget.LinearLayout";
            }
            case "android.widget.TextClock": {
                return "android.widget.TextView";
            }
            case "android.widget.ImageSwitcher": {
                return "android.widget.ViewSwitcher";
            }
            case "android.widget.ViewAnimator": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.ViewSwitcher": {
                return "android.widget.ViewAnimator";
            }
            case "android.widget.TableRow": {
                return "android.widget.LinearLayout";
            }
            case "android.widget.AnalogClock": {
                return "android.view.View";
            }
            case "android.widget.RadioGroup": {
                return "android.widget.LinearLayout";
            }
            case "android.widget.SearchView": {
                return "android.widget.LinearLayout";
            }
            case "android.widget.StackView": {
                return "android.widget.AdapterViewAnimator";
            }
            case "android.widget.AdapterViewAnimator": {
                return "android.widget.AdapterView";
            }
            case "android.opengl.GLSurfaceView": {
                return "android.view.SurfaceView";
            }
            case "android.widget.Space": {
                return "android.view.View";
            }
            case "android.widget.GridView": {
                return "android.widget.AbsListView";
            }
            case "android.widget.ExpandableListView": {
                return "android.widget.ListView";
            }
            case "android.view.ViewStub": {
                return "android.view.View";
            }
            case "android.gesture.GestureOverlayView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.QuickContactBadge": {
                return "android.widget.ImageView";
            }
            case "android.widget.TableLayout": {
                return "android.widget.LinearLayout";
            }
            case "android.widget.NumberPicker": {
                return "android.widget.LinearLayout";
            }
            case "android.widget.AdapterViewFlipper": {
                return "android.widget.AdapterViewAnimator";
            }
            case "android.widget.CalendarView": {
                return "android.widget.FrameLayout";
            }
            case "android.app.MediaRouteButton": {
                return "android.view.View";
            }
            case "android.widget.TextSwitcher": {
                return "android.widget.ViewSwitcher";
            }
            case "android.media.tv.TvView": {
                return "android.view.ViewGroup";
            }
            case "android.widget.TimePicker": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.SlidingDrawer": {
                return "android.view.ViewGroup";
            }
            case "android.widget.TwoLineListItem": {
                return "android.widget.RelativeLayout";
            }
            case "android.widget.AbsoluteLayout": {
                return "android.view.ViewGroup";
            }
            case "android.webkit.WebView": {
                return "android.widget.AbsoluteLayout";
            }
            case "android.view.TextureView": {
                return "android.view.View";
            }
            case "android.appwidget.AppWidgetHostView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.ViewFlipper": {
                return "android.widget.ViewAnimator";
            }
            case "android.widget.ScrollView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.Toolbar": {
                return "android.view.ViewGroup";
            }
            case "android.widget.DialerFilter": {
                return "android.widget.RelativeLayout";
            }
            case "android.inputmethodservice.KeyboardView": {
                return "android.view.View";
            }
            case "android.window.SplashScreenView": {
                return "android.widget.FrameLayout";
            }
            case "android.widget.inline.InlineContentView": {
                return "android.view.ViewGroup";
            }
            case "android.widget.GridLayout": {
                return "android.view.ViewGroup";
            }
            case "android.app.FragmentBreadCrumbs": {
                return "android.view.ViewGroup";
            }
            case "androidx.view.ViewPager": {
                return "android.view.ViewGroup";
            }
            case "androidx.appcompat.app.ActionBar$Tab": {
                return "java.lang.Object";
            }
            case "androidx.app.ActionBar$Tab": {
                return "java.lang.Object";
            }
            case "java.lang.Object": {
                return null;
            }
        }
        return string2;
    }

    public static boolean isInteresting(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isInteresting(String)", 446).addDetail("clazz", string)).log();
        }
        if ("androidx.appcompat.widget.AppCompatToggleButton".equals(string = AndroidClassesGenerated.normalizeClassString(string))) {
            return true;
        }
        if ("android.view.View".equals(string)) {
            return true;
        }
        if ("android.widget.TextView".equals(string)) {
            return true;
        }
        if ("android.widget.Button".equals(string)) {
            return true;
        }
        if ("android.widget.CompoundButton".equals(string)) {
            return true;
        }
        if ("android.widget.ToggleButton".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiExtractTextLayout".equals(string)) {
            return false;
        }
        if ("android.view.ViewGroup".equals(string)) {
            return false;
        }
        if ("android.widget.LinearLayout".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.BaseCardView".equals(string)) {
            return false;
        }
        if ("android.widget.FrameLayout".equals(string)) {
            return false;
        }
        if ("androidx.core.widget.ContentLoadingProgressBar".equals(string)) {
            return true;
        }
        if ("android.widget.ProgressBar".equals(string)) {
            return true;
        }
        if ("androidx.drawerlayout.widget.DrawerLayout".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatImageButton".equals(string)) {
            return true;
        }
        if ("android.widget.ImageView".equals(string)) {
            return true;
        }
        if ("android.widget.ImageButton".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiEditText".equals(string)) {
            return true;
        }
        if ("android.widget.EditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SearchView".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.LinearLayoutCompat".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.BaseGridView".equals(string)) {
            return false;
        }
        if ("androidx.recyclerview.widget.RecyclerView".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.ActionMenuView".equals(string)) {
            return false;
        }
        if ("androidx.viewpager.widget.PagerTitleStrip".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.ShadowOverlayContainer".equals(string)) {
            return false;
        }
        if ("androidx.media2.widget.VideoView".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatSpinner".equals(string)) {
            return false;
        }
        if ("android.widget.AdapterView".equals(string)) {
            return false;
        }
        if ("android.widget.AbsSpinner".equals(string)) {
            return false;
        }
        if ("android.widget.Spinner".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.WearArcLayout".equals(string)) {
            return false;
        }
        if ("androidx.viewpager2.widget.ViewPager2".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.SearchOrbView".equals(string)) {
            return true;
        }
        if ("androidx.slidingpanelayout.widget.SlidingPaneLayout".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.drawer.WearableActionDrawerView".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerView".equals(string)) {
            return false;
        }
        if ("androidx.media2.widget.MediaControlView".equals(string)) {
            return false;
        }
        if ("androidx.fragment.app.FragmentTabHost".equals(string)) {
            return true;
        }
        if ("android.widget.TabHost".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomButton".equals(string)) {
            return true;
        }
        if ("androidx.coordinatorlayout.widget.CoordinatorLayout".equals(string)) {
            return false;
        }
        if ("androidx.core.widget.NestedScrollView".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.picker.PinPicker".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.Picker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckedTextView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckedTextView".equals(string)) {
            return true;
        }
        if ("androidx.mediarouter.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentFrameLayout".equals(string)) {
            return false;
        }
        if ("androidx.viewpager.widget.PagerTabStrip".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.GuidedActionEditText".equals(string)) {
            return true;
        }
        if ("android.widget.Switch".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.DatePicker".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentContainerView".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatButton".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.HorizontalGridView".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.BoxInsetLayout".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.SearchBar".equals(string)) {
            return false;
        }
        if ("android.widget.RelativeLayout".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.SearchEditText".equals(string)) {
            return true;
        }
        if ("android.widget.AutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.MultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.Adapter".equals(string)) {
            return false;
        }
        if ("androidx.camera.view.CameraView".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.SpeechOrbView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SwitchCompat".equals(string)) {
            return true;
        }
        if ("android.widget.ListView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsListView".equals(string)) {
            return true;
        }
        if ("androidx.cardview.widget.CardView".equals(string)) {
            return false;
        }
        if ("android.widget.CheckBox".equals(string)) {
            return true;
        }
        if ("android.inputmethodservice.ExtractEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.TimePicker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSeekBar".equals(string)) {
            return true;
        }
        if ("android.widget.AbsSeekBar".equals(string)) {
            return true;
        }
        if ("android.widget.SeekBar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.DismissibleFrameLayout".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.SwipeDismissFrameLayout".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.TitleView".equals(string)) {
            return false;
        }
        if ("android.widget.Gallery".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowHoverCardView".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.WearableRecyclerView".equals(string)) {
            return false;
        }
        if ("androidx.percentlayout.widget.PercentRelativeLayout".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatCheckBox".equals(string)) {
            return true;
        }
        if ("androidx.camera.view.PreviewView".equals(string)) {
            return false;
        }
        if ("android.widget.Chronometer".equals(string)) {
            return true;
        }
        if ("androidx.swiperefreshlayout.widget.SwipeRefreshLayout".equals(string)) {
            return false;
        }
        if ("androidx.emoji.widget.EmojiTextView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatButton".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackTabLayout".equals(string)) {
            return false;
        }
        if ("android.widget.HorizontalScrollView".equals(string)) {
            return false;
        }
        if ("com.google.android.material.tabs.TabLayout".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.BrowseFrameLayout".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.WearCurvedTextView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.ViewPager".equals(string)) {
            return false;
        }
        if ("android.widget.ActionMenuView".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerLayout".equals(string)) {
            return false;
        }
        if ("androidx.emoji.widget.EmojiAppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackViewPager".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.ListRowView".equals(string)) {
            return true;
        }
        if ("androidx.slice.widget.SliceView".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.CircularProgressLayout".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.VerticalGridView".equals(string)) {
            return false;
        }
        if ("android.widget.ZoomControls".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatRadioButton".equals(string)) {
            return true;
        }
        if ("android.widget.RadioButton".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ImageCardView".equals(string)) {
            return false;
        }
        if ("android.widget.VideoView".equals(string)) {
            return true;
        }
        if ("android.view.SurfaceView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiButton".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.RowHeaderView".equals(string)) {
            return true;
        }
        if ("android.widget.DigitalClock".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRatingBar".equals(string)) {
            return true;
        }
        if ("android.widget.RatingBar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableNavigationDrawerView".equals(string)) {
            return false;
        }
        if ("android.widget.DatePicker".equals(string)) {
            return true;
        }
        if ("android.widget.MediaController".equals(string)) {
            return false;
        }
        if ("androidx.gridlayout.widget.GridLayout".equals(string)) {
            return false;
        }
        if ("android.widget.TabWidget".equals(string)) {
            return true;
        }
        if ("android.widget.TextClock".equals(string)) {
            return true;
        }
        if ("android.widget.ImageSwitcher".equals(string)) {
            return false;
        }
        if ("android.widget.ViewAnimator".equals(string)) {
            return false;
        }
        if ("android.widget.ViewSwitcher".equals(string)) {
            return false;
        }
        if ("android.widget.TableRow".equals(string)) {
            return false;
        }
        if ("android.widget.AnalogClock".equals(string)) {
            return true;
        }
        if ("android.widget.RadioGroup".equals(string)) {
            return true;
        }
        if ("android.widget.SearchView".equals(string)) {
            return false;
        }
        if ("android.widget.StackView".equals(string)) {
            return false;
        }
        if ("android.widget.AdapterViewAnimator".equals(string)) {
            return false;
        }
        if ("android.opengl.GLSurfaceView".equals(string)) {
            return true;
        }
        if ("android.widget.Space".equals(string)) {
            return false;
        }
        if ("android.widget.GridView".equals(string)) {
            return true;
        }
        if ("android.widget.ExpandableListView".equals(string)) {
            return true;
        }
        if ("android.view.ViewStub".equals(string)) {
            return false;
        }
        if ("android.gesture.GestureOverlayView".equals(string)) {
            return false;
        }
        if ("android.widget.QuickContactBadge".equals(string)) {
            return true;
        }
        if ("android.widget.TableLayout".equals(string)) {
            return true;
        }
        if ("android.widget.NumberPicker".equals(string)) {
            return false;
        }
        if ("android.widget.AdapterViewFlipper".equals(string)) {
            return false;
        }
        if ("android.widget.CalendarView".equals(string)) {
            return true;
        }
        if ("android.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("android.widget.TextSwitcher".equals(string)) {
            return false;
        }
        if ("android.media.tv.TvView".equals(string)) {
            return false;
        }
        if ("android.widget.TimePicker".equals(string)) {
            return true;
        }
        if ("android.widget.SlidingDrawer".equals(string)) {
            return false;
        }
        if ("android.widget.TwoLineListItem".equals(string)) {
            return false;
        }
        if ("android.widget.AbsoluteLayout".equals(string)) {
            return false;
        }
        if ("android.webkit.WebView".equals(string)) {
            return false;
        }
        if ("android.view.TextureView".equals(string)) {
            return true;
        }
        if ("android.appwidget.AppWidgetHostView".equals(string)) {
            return false;
        }
        if ("android.widget.ViewFlipper".equals(string)) {
            return false;
        }
        if ("android.widget.ScrollView".equals(string)) {
            return false;
        }
        if ("android.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("android.widget.DialerFilter".equals(string)) {
            return false;
        }
        if ("android.inputmethodservice.KeyboardView".equals(string)) {
            return true;
        }
        if ("android.window.SplashScreenView".equals(string)) {
            return false;
        }
        if ("android.widget.inline.InlineContentView".equals(string)) {
            return false;
        }
        if ("android.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.app.FragmentBreadCrumbs".equals(string)) {
            return false;
        }
        if ("androidx.view.ViewPager".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.app.ActionBar$Tab".equals(string)) {
            return true;
        }
        if ("androidx.app.ActionBar$Tab".equals(string)) {
            return true;
        }
        return true;
    }

    public static String getGenericClazzName(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getGenericClazzName(String)", 622).addDetail("clazz", string)).log();
        }
        if ("androidx.appcompat.widget.AppCompatToggleButton".equals(string = AndroidClassesGenerated.normalizeClassString(string))) {
            return "ToggleButton";
        }
        if ("android.view.View".equals(string)) {
            return "Panel";
        }
        if ("android.widget.TextView".equals(string)) {
            return "Label";
        }
        if ("android.widget.Button".equals(string)) {
            return "Button";
        }
        if ("android.widget.CompoundButton".equals(string)) {
            return "Button";
        }
        if ("android.widget.ToggleButton".equals(string)) {
            return "ToggleButton";
        }
        if ("androidx.emoji.widget.EmojiExtractTextLayout".equals(string)) {
            return "Panel";
        }
        if ("android.view.ViewGroup".equals(string)) {
            return "Panel";
        }
        if ("android.widget.LinearLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.BaseCardView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.FrameLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.core.widget.ContentLoadingProgressBar".equals(string)) {
            return "ProgressBar";
        }
        if ("android.widget.ProgressBar".equals(string)) {
            return "ProgressBar";
        }
        if ("androidx.drawerlayout.widget.DrawerLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatImageButton".equals(string)) {
            return "Button";
        }
        if ("android.widget.ImageView".equals(string)) {
            return "Icon";
        }
        if ("android.widget.ImageButton".equals(string)) {
            return "Button";
        }
        if ("androidx.emoji.widget.EmojiEditText".equals(string)) {
            return "TextField";
        }
        if ("android.widget.EditText".equals(string)) {
            return "TextField";
        }
        if ("androidx.appcompat.widget.SearchView".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.LinearLayoutCompat".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.BaseGridView".equals(string)) {
            return "Panel";
        }
        if ("androidx.recyclerview.widget.RecyclerView".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.ActionMenuView".equals(string)) {
            return "Panel";
        }
        if ("androidx.viewpager.widget.PagerTitleStrip".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.ShadowOverlayContainer".equals(string)) {
            return "Panel";
        }
        if ("androidx.media2.widget.VideoView".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatSpinner".equals(string)) {
            return "ComboBox";
        }
        if ("android.widget.AdapterView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.AbsSpinner".equals(string)) {
            return "Panel";
        }
        if ("android.widget.Spinner".equals(string)) {
            return "ComboBox";
        }
        if ("androidx.wear.widget.WearArcLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.viewpager2.widget.ViewPager2".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.SearchOrbView".equals(string)) {
            return "Panel";
        }
        if ("androidx.slidingpanelayout.widget.SlidingPaneLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.drawer.WearableActionDrawerView".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.drawer.WearableDrawerView".equals(string)) {
            return "Panel";
        }
        if ("androidx.media2.widget.MediaControlView".equals(string)) {
            return "Panel";
        }
        if ("androidx.fragment.app.FragmentTabHost".equals(string)) {
            return "TabPanel";
        }
        if ("android.widget.TabHost".equals(string)) {
            return "TabPanel";
        }
        if ("android.widget.ZoomButton".equals(string)) {
            return "Button";
        }
        if ("androidx.coordinatorlayout.widget.CoordinatorLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.core.widget.NestedScrollView".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.picker.PinPicker".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.picker.Picker".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatCheckedTextView".equals(string)) {
            return "CheckBox";
        }
        if ("android.widget.CheckedTextView".equals(string)) {
            return "CheckBox";
        }
        if ("androidx.mediarouter.app.MediaRouteButton".equals(string)) {
            return "Panel";
        }
        if ("androidx.percentlayout.widget.PercentFrameLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.viewpager.widget.PagerTabStrip".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.GuidedActionEditText".equals(string)) {
            return "TextField";
        }
        if ("android.widget.Switch".equals(string)) {
            return "ToggleButton";
        }
        if ("androidx.appcompat.widget.AppCompatEditText".equals(string)) {
            return "TextField";
        }
        if ("androidx.emoji.widget.EmojiAppCompatEditText".equals(string)) {
            return "TextField";
        }
        if ("androidx.appcompat.widget.AppCompatImageView".equals(string)) {
            return "Icon";
        }
        if ("androidx.leanback.widget.picker.DatePicker".equals(string)) {
            return "Panel";
        }
        if ("androidx.fragment.app.FragmentContainerView".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatButton".equals(string)) {
            return "Button";
        }
        if ("androidx.leanback.widget.HorizontalGridView".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.BoxInsetLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.SearchBar".equals(string)) {
            return "Panel";
        }
        if ("android.widget.RelativeLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.SearchEditText".equals(string)) {
            return "TextField";
        }
        if ("android.widget.AutoCompleteTextView".equals(string)) {
            return "TextField";
        }
        if ("android.widget.MultiAutoCompleteTextView".equals(string)) {
            return "TextField";
        }
        if ("android.widget.Adapter".equals(string)) {
            return "Panel";
        }
        if ("androidx.camera.view.CameraView".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.SpeechOrbView".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.SwitchCompat".equals(string)) {
            return "Button";
        }
        if ("android.widget.ListView".equals(string)) {
            return "List";
        }
        if ("android.widget.AbsListView".equals(string)) {
            return "Panel";
        }
        if ("androidx.cardview.widget.CardView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.CheckBox".equals(string)) {
            return "CheckBox";
        }
        if ("android.inputmethodservice.ExtractEditText".equals(string)) {
            return "TextField";
        }
        if ("androidx.appcompat.widget.AppCompatTextView".equals(string)) {
            return "Label";
        }
        if ("androidx.leanback.widget.picker.TimePicker".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatSeekBar".equals(string)) {
            return "Slider";
        }
        if ("android.widget.AbsSeekBar".equals(string)) {
            return "Slider";
        }
        if ("android.widget.SeekBar".equals(string)) {
            return "Slider";
        }
        if ("androidx.wear.widget.DismissibleFrameLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.SwipeDismissFrameLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.TitleView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.Gallery".equals(string)) {
            return "List:Gallery";
        }
        if ("androidx.leanback.widget.ListRowHoverCardView".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.WearableRecyclerView".equals(string)) {
            return "Panel";
        }
        if ("androidx.percentlayout.widget.PercentRelativeLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatCheckBox".equals(string)) {
            return "CheckBox";
        }
        if ("androidx.camera.view.PreviewView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.Chronometer".equals(string)) {
            return "Clock";
        }
        if ("androidx.swiperefreshlayout.widget.SwipeRefreshLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.emoji.widget.EmojiTextView".equals(string)) {
            return "Label";
        }
        if ("androidx.emoji.widget.EmojiAppCompatButton".equals(string)) {
            return "Button";
        }
        if ("androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView".equals(string)) {
            return "TextField";
        }
        if ("androidx.leanback.tab.LeanbackTabLayout".equals(string)) {
            return "Panel";
        }
        if ("android.widget.HorizontalScrollView".equals(string)) {
            return "Panel";
        }
        if ("com.google.android.material.tabs.TabLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.BrowseFrameLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.WearCurvedTextView".equals(string)) {
            return "Label";
        }
        if ("androidx.viewpager.widget.ViewPager".equals(string)) {
            return "Panel";
        }
        if ("android.widget.ActionMenuView".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.Toolbar".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.drawer.WearableDrawerLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.emoji.widget.EmojiAppCompatTextView".equals(string)) {
            return "Label";
        }
        if ("androidx.leanback.tab.LeanbackViewPager".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.ListRowView".equals(string)) {
            return "TableRow";
        }
        if ("androidx.slice.widget.SliceView".equals(string)) {
            return "Panel";
        }
        if ("androidx.wear.widget.CircularProgressLayout".equals(string)) {
            return "Panel";
        }
        if ("androidx.leanback.widget.VerticalGridView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.ZoomControls".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.widget.AppCompatRadioButton".equals(string)) {
            return "RadioButton";
        }
        if ("android.widget.RadioButton".equals(string)) {
            return "RadioButton";
        }
        if ("androidx.leanback.widget.ImageCardView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.VideoView".equals(string)) {
            return "Graphics";
        }
        if ("android.view.SurfaceView".equals(string)) {
            return "Graphics";
        }
        if ("androidx.emoji.widget.EmojiButton".equals(string)) {
            return "Button";
        }
        if ("androidx.leanback.widget.RowHeaderView".equals(string)) {
            return "Label";
        }
        if ("android.widget.DigitalClock".equals(string)) {
            return "Clock";
        }
        if ("androidx.appcompat.widget.AppCompatAutoCompleteTextView".equals(string)) {
            return "TextField";
        }
        if ("androidx.appcompat.widget.AppCompatRatingBar".equals(string)) {
            return "Slider";
        }
        if ("android.widget.RatingBar".equals(string)) {
            return "Slider";
        }
        if ("androidx.wear.widget.drawer.WearableNavigationDrawerView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.DatePicker".equals(string)) {
            return "Calendar";
        }
        if ("android.widget.MediaController".equals(string)) {
            return "Panel";
        }
        if ("androidx.gridlayout.widget.GridLayout".equals(string)) {
            return "Panel";
        }
        if ("android.widget.TabWidget".equals(string)) {
            return "TabPanel";
        }
        if ("android.widget.TextClock".equals(string)) {
            return "Clock";
        }
        if ("android.widget.ImageSwitcher".equals(string)) {
            return "Panel";
        }
        if ("android.widget.ViewAnimator".equals(string)) {
            return "Panel";
        }
        if ("android.widget.ViewSwitcher".equals(string)) {
            return "Panel";
        }
        if ("android.widget.TableRow".equals(string)) {
            return "TableRow";
        }
        if ("android.widget.AnalogClock".equals(string)) {
            return "Clock";
        }
        if ("android.widget.RadioGroup".equals(string)) {
            return "Panel";
        }
        if ("android.widget.SearchView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.StackView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.AdapterViewAnimator".equals(string)) {
            return "Panel";
        }
        if ("android.opengl.GLSurfaceView".equals(string)) {
            return "Graphics";
        }
        if ("android.widget.Space".equals(string)) {
            return "Spacer";
        }
        if ("android.widget.GridView".equals(string)) {
            return "Table";
        }
        if ("android.widget.ExpandableListView".equals(string)) {
            return "List";
        }
        if ("android.view.ViewStub".equals(string)) {
            return "Spacer";
        }
        if ("android.gesture.GestureOverlayView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.QuickContactBadge".equals(string)) {
            return "Icon";
        }
        if ("android.widget.TableLayout".equals(string)) {
            return "Table";
        }
        if ("android.widget.NumberPicker".equals(string)) {
            return "Panel";
        }
        if ("android.widget.AdapterViewFlipper".equals(string)) {
            return "Panel";
        }
        if ("android.widget.CalendarView".equals(string)) {
            return "Calendar";
        }
        if ("android.app.MediaRouteButton".equals(string)) {
            return "Panel";
        }
        if ("android.widget.TextSwitcher".equals(string)) {
            return "Panel";
        }
        if ("android.media.tv.TvView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.TimePicker".equals(string)) {
            return "Panel";
        }
        if ("android.widget.SlidingDrawer".equals(string)) {
            return "Panel";
        }
        if ("android.widget.TwoLineListItem".equals(string)) {
            return "Panel";
        }
        if ("android.widget.AbsoluteLayout".equals(string)) {
            return "Panel";
        }
        if ("android.webkit.WebView".equals(string)) {
            return "Window:InternalWindow|Window";
        }
        if ("android.view.TextureView".equals(string)) {
            return "Graphics";
        }
        if ("android.appwidget.AppWidgetHostView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.ViewFlipper".equals(string)) {
            return "Panel";
        }
        if ("android.widget.ScrollView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.Toolbar".equals(string)) {
            return "ToolBar";
        }
        if ("android.widget.DialerFilter".equals(string)) {
            return "Panel";
        }
        if ("android.inputmethodservice.KeyboardView".equals(string)) {
            return "Keyboard";
        }
        if ("android.window.SplashScreenView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.inline.InlineContentView".equals(string)) {
            return "Panel";
        }
        if ("android.widget.GridLayout".equals(string)) {
            return "Table";
        }
        if ("android.app.FragmentBreadCrumbs".equals(string)) {
            return "Panel";
        }
        if ("androidx.view.ViewPager".equals(string)) {
            return "Panel";
        }
        if ("androidx.appcompat.app.ActionBar$Tab".equals(string)) {
            return "TabItem";
        }
        if ("androidx.app.ActionBar$Tab".equals(string)) {
            return "TabItem";
        }
        return null;
    }

    public static boolean recordX(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "recordX(String)", 798).addDetail("clazz", string)).log();
        }
        if ("androidx.appcompat.widget.AppCompatToggleButton".equals(string = AndroidClassesGenerated.normalizeClassString(string))) {
            return false;
        }
        if ("android.view.View".equals(string)) {
            return true;
        }
        if ("android.widget.TextView".equals(string)) {
            return true;
        }
        if ("android.widget.Button".equals(string)) {
            return false;
        }
        if ("android.widget.CompoundButton".equals(string)) {
            return false;
        }
        if ("android.widget.ToggleButton".equals(string)) {
            return false;
        }
        if ("androidx.emoji.widget.EmojiExtractTextLayout".equals(string)) {
            return true;
        }
        if ("android.view.ViewGroup".equals(string)) {
            return true;
        }
        if ("android.widget.LinearLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BaseCardView".equals(string)) {
            return true;
        }
        if ("android.widget.FrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.core.widget.ContentLoadingProgressBar".equals(string)) {
            return true;
        }
        if ("android.widget.ProgressBar".equals(string)) {
            return true;
        }
        if ("androidx.drawerlayout.widget.DrawerLayout".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageButton".equals(string)) {
            return false;
        }
        if ("android.widget.ImageView".equals(string)) {
            return true;
        }
        if ("android.widget.ImageButton".equals(string)) {
            return false;
        }
        if ("androidx.emoji.widget.EmojiEditText".equals(string)) {
            return true;
        }
        if ("android.widget.EditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SearchView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.LinearLayoutCompat".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BaseGridView".equals(string)) {
            return true;
        }
        if ("androidx.recyclerview.widget.RecyclerView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.ActionMenuView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.PagerTitleStrip".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ShadowOverlayContainer".equals(string)) {
            return true;
        }
        if ("androidx.media2.widget.VideoView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSpinner".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsSpinner".equals(string)) {
            return true;
        }
        if ("android.widget.Spinner".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearArcLayout".equals(string)) {
            return true;
        }
        if ("androidx.viewpager2.widget.ViewPager2".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchOrbView".equals(string)) {
            return true;
        }
        if ("androidx.slidingpanelayout.widget.SlidingPaneLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableActionDrawerView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerView".equals(string)) {
            return true;
        }
        if ("androidx.media2.widget.MediaControlView".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentTabHost".equals(string)) {
            return true;
        }
        if ("android.widget.TabHost".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomButton".equals(string)) {
            return false;
        }
        if ("androidx.coordinatorlayout.widget.CoordinatorLayout".equals(string)) {
            return true;
        }
        if ("androidx.core.widget.NestedScrollView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.PinPicker".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.Picker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckedTextView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckedTextView".equals(string)) {
            return true;
        }
        if ("androidx.mediarouter.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.PagerTabStrip".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.GuidedActionEditText".equals(string)) {
            return true;
        }
        if ("android.widget.Switch".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.DatePicker".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentContainerView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatButton".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.HorizontalGridView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.BoxInsetLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchBar".equals(string)) {
            return true;
        }
        if ("android.widget.RelativeLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchEditText".equals(string)) {
            return true;
        }
        if ("android.widget.AutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.MultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.Adapter".equals(string)) {
            return true;
        }
        if ("androidx.camera.view.CameraView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SpeechOrbView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SwitchCompat".equals(string)) {
            return false;
        }
        if ("android.widget.ListView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsListView".equals(string)) {
            return true;
        }
        if ("androidx.cardview.widget.CardView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckBox".equals(string)) {
            return false;
        }
        if ("android.inputmethodservice.ExtractEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.TimePicker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSeekBar".equals(string)) {
            return true;
        }
        if ("android.widget.AbsSeekBar".equals(string)) {
            return true;
        }
        if ("android.widget.SeekBar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.DismissibleFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.SwipeDismissFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.TitleView".equals(string)) {
            return true;
        }
        if ("android.widget.Gallery".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowHoverCardView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearableRecyclerView".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentRelativeLayout".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckBox".equals(string)) {
            return false;
        }
        if ("androidx.camera.view.PreviewView".equals(string)) {
            return true;
        }
        if ("android.widget.Chronometer".equals(string)) {
            return true;
        }
        if ("androidx.swiperefreshlayout.widget.SwipeRefreshLayout".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiTextView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatButton".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackTabLayout".equals(string)) {
            return true;
        }
        if ("android.widget.HorizontalScrollView".equals(string)) {
            return true;
        }
        if ("com.google.android.material.tabs.TabLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BrowseFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearCurvedTextView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.ViewPager".equals(string)) {
            return true;
        }
        if ("android.widget.ActionMenuView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerLayout".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackViewPager".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowView".equals(string)) {
            return true;
        }
        if ("androidx.slice.widget.SliceView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.CircularProgressLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.VerticalGridView".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomControls".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRadioButton".equals(string)) {
            return false;
        }
        if ("android.widget.RadioButton".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.ImageCardView".equals(string)) {
            return true;
        }
        if ("android.widget.VideoView".equals(string)) {
            return true;
        }
        if ("android.view.SurfaceView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiButton".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.RowHeaderView".equals(string)) {
            return true;
        }
        if ("android.widget.DigitalClock".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRatingBar".equals(string)) {
            return true;
        }
        if ("android.widget.RatingBar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableNavigationDrawerView".equals(string)) {
            return true;
        }
        if ("android.widget.DatePicker".equals(string)) {
            return true;
        }
        if ("android.widget.MediaController".equals(string)) {
            return true;
        }
        if ("androidx.gridlayout.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.widget.TabWidget".equals(string)) {
            return true;
        }
        if ("android.widget.TextClock".equals(string)) {
            return true;
        }
        if ("android.widget.ImageSwitcher".equals(string)) {
            return true;
        }
        if ("android.widget.ViewAnimator".equals(string)) {
            return true;
        }
        if ("android.widget.ViewSwitcher".equals(string)) {
            return true;
        }
        if ("android.widget.TableRow".equals(string)) {
            return true;
        }
        if ("android.widget.AnalogClock".equals(string)) {
            return true;
        }
        if ("android.widget.RadioGroup".equals(string)) {
            return true;
        }
        if ("android.widget.SearchView".equals(string)) {
            return true;
        }
        if ("android.widget.StackView".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterViewAnimator".equals(string)) {
            return true;
        }
        if ("android.opengl.GLSurfaceView".equals(string)) {
            return true;
        }
        if ("android.widget.Space".equals(string)) {
            return true;
        }
        if ("android.widget.GridView".equals(string)) {
            return true;
        }
        if ("android.widget.ExpandableListView".equals(string)) {
            return true;
        }
        if ("android.view.ViewStub".equals(string)) {
            return true;
        }
        if ("android.gesture.GestureOverlayView".equals(string)) {
            return true;
        }
        if ("android.widget.QuickContactBadge".equals(string)) {
            return false;
        }
        if ("android.widget.TableLayout".equals(string)) {
            return true;
        }
        if ("android.widget.NumberPicker".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterViewFlipper".equals(string)) {
            return true;
        }
        if ("android.widget.CalendarView".equals(string)) {
            return true;
        }
        if ("android.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("android.widget.TextSwitcher".equals(string)) {
            return true;
        }
        if ("android.media.tv.TvView".equals(string)) {
            return true;
        }
        if ("android.widget.TimePicker".equals(string)) {
            return true;
        }
        if ("android.widget.SlidingDrawer".equals(string)) {
            return true;
        }
        if ("android.widget.TwoLineListItem".equals(string)) {
            return true;
        }
        if ("android.widget.AbsoluteLayout".equals(string)) {
            return true;
        }
        if ("android.webkit.WebView".equals(string)) {
            return true;
        }
        if ("android.view.TextureView".equals(string)) {
            return true;
        }
        if ("android.appwidget.AppWidgetHostView".equals(string)) {
            return true;
        }
        if ("android.widget.ViewFlipper".equals(string)) {
            return true;
        }
        if ("android.widget.ScrollView".equals(string)) {
            return true;
        }
        if ("android.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("android.widget.DialerFilter".equals(string)) {
            return true;
        }
        if ("android.inputmethodservice.KeyboardView".equals(string)) {
            return true;
        }
        if ("android.window.SplashScreenView".equals(string)) {
            return true;
        }
        if ("android.widget.inline.InlineContentView".equals(string)) {
            return true;
        }
        if ("android.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.app.FragmentBreadCrumbs".equals(string)) {
            return true;
        }
        if ("androidx.view.ViewPager".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.app.ActionBar$Tab".equals(string)) {
            return false;
        }
        return !"androidx.app.ActionBar$Tab".equals(string);
    }

    public static boolean recordY(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "recordY(String)", 974).addDetail("clazz", string)).log();
        }
        if ("androidx.appcompat.widget.AppCompatToggleButton".equals(string = AndroidClassesGenerated.normalizeClassString(string))) {
            return false;
        }
        if ("android.view.View".equals(string)) {
            return true;
        }
        if ("android.widget.TextView".equals(string)) {
            return true;
        }
        if ("android.widget.Button".equals(string)) {
            return false;
        }
        if ("android.widget.CompoundButton".equals(string)) {
            return false;
        }
        if ("android.widget.ToggleButton".equals(string)) {
            return false;
        }
        if ("androidx.emoji.widget.EmojiExtractTextLayout".equals(string)) {
            return true;
        }
        if ("android.view.ViewGroup".equals(string)) {
            return true;
        }
        if ("android.widget.LinearLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BaseCardView".equals(string)) {
            return true;
        }
        if ("android.widget.FrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.core.widget.ContentLoadingProgressBar".equals(string)) {
            return true;
        }
        if ("android.widget.ProgressBar".equals(string)) {
            return true;
        }
        if ("androidx.drawerlayout.widget.DrawerLayout".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageButton".equals(string)) {
            return false;
        }
        if ("android.widget.ImageView".equals(string)) {
            return true;
        }
        if ("android.widget.ImageButton".equals(string)) {
            return false;
        }
        if ("androidx.emoji.widget.EmojiEditText".equals(string)) {
            return true;
        }
        if ("android.widget.EditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SearchView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.LinearLayoutCompat".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BaseGridView".equals(string)) {
            return true;
        }
        if ("androidx.recyclerview.widget.RecyclerView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.ActionMenuView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.PagerTitleStrip".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ShadowOverlayContainer".equals(string)) {
            return true;
        }
        if ("androidx.media2.widget.VideoView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSpinner".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsSpinner".equals(string)) {
            return true;
        }
        if ("android.widget.Spinner".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearArcLayout".equals(string)) {
            return true;
        }
        if ("androidx.viewpager2.widget.ViewPager2".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchOrbView".equals(string)) {
            return true;
        }
        if ("androidx.slidingpanelayout.widget.SlidingPaneLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableActionDrawerView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerView".equals(string)) {
            return true;
        }
        if ("androidx.media2.widget.MediaControlView".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentTabHost".equals(string)) {
            return true;
        }
        if ("android.widget.TabHost".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomButton".equals(string)) {
            return false;
        }
        if ("androidx.coordinatorlayout.widget.CoordinatorLayout".equals(string)) {
            return true;
        }
        if ("androidx.core.widget.NestedScrollView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.PinPicker".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.Picker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckedTextView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckedTextView".equals(string)) {
            return true;
        }
        if ("androidx.mediarouter.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.PagerTabStrip".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.GuidedActionEditText".equals(string)) {
            return true;
        }
        if ("android.widget.Switch".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.DatePicker".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentContainerView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatButton".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.HorizontalGridView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.BoxInsetLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchBar".equals(string)) {
            return true;
        }
        if ("android.widget.RelativeLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchEditText".equals(string)) {
            return true;
        }
        if ("android.widget.AutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.MultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.Adapter".equals(string)) {
            return true;
        }
        if ("androidx.camera.view.CameraView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SpeechOrbView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SwitchCompat".equals(string)) {
            return false;
        }
        if ("android.widget.ListView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsListView".equals(string)) {
            return true;
        }
        if ("androidx.cardview.widget.CardView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckBox".equals(string)) {
            return false;
        }
        if ("android.inputmethodservice.ExtractEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.TimePicker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSeekBar".equals(string)) {
            return false;
        }
        if ("android.widget.AbsSeekBar".equals(string)) {
            return false;
        }
        if ("android.widget.SeekBar".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.DismissibleFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.SwipeDismissFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.TitleView".equals(string)) {
            return true;
        }
        if ("android.widget.Gallery".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowHoverCardView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearableRecyclerView".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentRelativeLayout".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckBox".equals(string)) {
            return false;
        }
        if ("androidx.camera.view.PreviewView".equals(string)) {
            return true;
        }
        if ("android.widget.Chronometer".equals(string)) {
            return true;
        }
        if ("androidx.swiperefreshlayout.widget.SwipeRefreshLayout".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiTextView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatButton".equals(string)) {
            return false;
        }
        if ("androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackTabLayout".equals(string)) {
            return true;
        }
        if ("android.widget.HorizontalScrollView".equals(string)) {
            return true;
        }
        if ("com.google.android.material.tabs.TabLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BrowseFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearCurvedTextView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.ViewPager".equals(string)) {
            return true;
        }
        if ("android.widget.ActionMenuView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerLayout".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackViewPager".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowView".equals(string)) {
            return true;
        }
        if ("androidx.slice.widget.SliceView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.CircularProgressLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.VerticalGridView".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomControls".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRadioButton".equals(string)) {
            return false;
        }
        if ("android.widget.RadioButton".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.ImageCardView".equals(string)) {
            return true;
        }
        if ("android.widget.VideoView".equals(string)) {
            return true;
        }
        if ("android.view.SurfaceView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiButton".equals(string)) {
            return false;
        }
        if ("androidx.leanback.widget.RowHeaderView".equals(string)) {
            return true;
        }
        if ("android.widget.DigitalClock".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRatingBar".equals(string)) {
            return false;
        }
        if ("android.widget.RatingBar".equals(string)) {
            return false;
        }
        if ("androidx.wear.widget.drawer.WearableNavigationDrawerView".equals(string)) {
            return true;
        }
        if ("android.widget.DatePicker".equals(string)) {
            return true;
        }
        if ("android.widget.MediaController".equals(string)) {
            return true;
        }
        if ("androidx.gridlayout.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.widget.TabWidget".equals(string)) {
            return true;
        }
        if ("android.widget.TextClock".equals(string)) {
            return true;
        }
        if ("android.widget.ImageSwitcher".equals(string)) {
            return true;
        }
        if ("android.widget.ViewAnimator".equals(string)) {
            return true;
        }
        if ("android.widget.ViewSwitcher".equals(string)) {
            return true;
        }
        if ("android.widget.TableRow".equals(string)) {
            return true;
        }
        if ("android.widget.AnalogClock".equals(string)) {
            return true;
        }
        if ("android.widget.RadioGroup".equals(string)) {
            return true;
        }
        if ("android.widget.SearchView".equals(string)) {
            return true;
        }
        if ("android.widget.StackView".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterViewAnimator".equals(string)) {
            return true;
        }
        if ("android.opengl.GLSurfaceView".equals(string)) {
            return true;
        }
        if ("android.widget.Space".equals(string)) {
            return true;
        }
        if ("android.widget.GridView".equals(string)) {
            return true;
        }
        if ("android.widget.ExpandableListView".equals(string)) {
            return true;
        }
        if ("android.view.ViewStub".equals(string)) {
            return true;
        }
        if ("android.gesture.GestureOverlayView".equals(string)) {
            return true;
        }
        if ("android.widget.QuickContactBadge".equals(string)) {
            return false;
        }
        if ("android.widget.TableLayout".equals(string)) {
            return true;
        }
        if ("android.widget.NumberPicker".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterViewFlipper".equals(string)) {
            return true;
        }
        if ("android.widget.CalendarView".equals(string)) {
            return true;
        }
        if ("android.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("android.widget.TextSwitcher".equals(string)) {
            return true;
        }
        if ("android.media.tv.TvView".equals(string)) {
            return true;
        }
        if ("android.widget.TimePicker".equals(string)) {
            return true;
        }
        if ("android.widget.SlidingDrawer".equals(string)) {
            return true;
        }
        if ("android.widget.TwoLineListItem".equals(string)) {
            return true;
        }
        if ("android.widget.AbsoluteLayout".equals(string)) {
            return true;
        }
        if ("android.webkit.WebView".equals(string)) {
            return true;
        }
        if ("android.view.TextureView".equals(string)) {
            return true;
        }
        if ("android.appwidget.AppWidgetHostView".equals(string)) {
            return true;
        }
        if ("android.widget.ViewFlipper".equals(string)) {
            return true;
        }
        if ("android.widget.ScrollView".equals(string)) {
            return true;
        }
        if ("android.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("android.widget.DialerFilter".equals(string)) {
            return true;
        }
        if ("android.inputmethodservice.KeyboardView".equals(string)) {
            return true;
        }
        if ("android.window.SplashScreenView".equals(string)) {
            return true;
        }
        if ("android.widget.inline.InlineContentView".equals(string)) {
            return true;
        }
        if ("android.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.app.FragmentBreadCrumbs".equals(string)) {
            return true;
        }
        if ("androidx.view.ViewPager".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.app.ActionBar$Tab".equals(string)) {
            return false;
        }
        return !"androidx.app.ActionBar$Tab".equals(string);
    }

    public static boolean isSystemClazz(String string) {
        if (AndroidClassesGenerated.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isSystemClazz(String)", 1150).addDetail("clazz", string)).log();
        }
        if ("androidx.appcompat.widget.AppCompatToggleButton".equals(string = AndroidClassesGenerated.normalizeClassString(string))) {
            return true;
        }
        if ("android.view.View".equals(string)) {
            return true;
        }
        if ("android.widget.TextView".equals(string)) {
            return true;
        }
        if ("android.widget.Button".equals(string)) {
            return true;
        }
        if ("android.widget.CompoundButton".equals(string)) {
            return true;
        }
        if ("android.widget.ToggleButton".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiExtractTextLayout".equals(string)) {
            return true;
        }
        if ("android.view.ViewGroup".equals(string)) {
            return true;
        }
        if ("android.widget.LinearLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BaseCardView".equals(string)) {
            return true;
        }
        if ("android.widget.FrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.core.widget.ContentLoadingProgressBar".equals(string)) {
            return true;
        }
        if ("android.widget.ProgressBar".equals(string)) {
            return true;
        }
        if ("androidx.drawerlayout.widget.DrawerLayout".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageButton".equals(string)) {
            return true;
        }
        if ("android.widget.ImageView".equals(string)) {
            return true;
        }
        if ("android.widget.ImageButton".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiEditText".equals(string)) {
            return true;
        }
        if ("android.widget.EditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SearchView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.LinearLayoutCompat".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BaseGridView".equals(string)) {
            return true;
        }
        if ("androidx.recyclerview.widget.RecyclerView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.ActionMenuView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.PagerTitleStrip".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ShadowOverlayContainer".equals(string)) {
            return true;
        }
        if ("androidx.media2.widget.VideoView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSpinner".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsSpinner".equals(string)) {
            return true;
        }
        if ("android.widget.Spinner".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearArcLayout".equals(string)) {
            return true;
        }
        if ("androidx.viewpager2.widget.ViewPager2".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchOrbView".equals(string)) {
            return true;
        }
        if ("androidx.slidingpanelayout.widget.SlidingPaneLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableActionDrawerView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerView".equals(string)) {
            return true;
        }
        if ("androidx.media2.widget.MediaControlView".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentTabHost".equals(string)) {
            return true;
        }
        if ("android.widget.TabHost".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomButton".equals(string)) {
            return true;
        }
        if ("androidx.coordinatorlayout.widget.CoordinatorLayout".equals(string)) {
            return true;
        }
        if ("androidx.core.widget.NestedScrollView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.PinPicker".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.Picker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckedTextView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckedTextView".equals(string)) {
            return true;
        }
        if ("androidx.mediarouter.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.PagerTabStrip".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.GuidedActionEditText".equals(string)) {
            return true;
        }
        if ("android.widget.Switch".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatImageView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.DatePicker".equals(string)) {
            return true;
        }
        if ("androidx.fragment.app.FragmentContainerView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatButton".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.HorizontalGridView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.BoxInsetLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchBar".equals(string)) {
            return true;
        }
        if ("android.widget.RelativeLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SearchEditText".equals(string)) {
            return true;
        }
        if ("android.widget.AutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.MultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("android.widget.Adapter".equals(string)) {
            return true;
        }
        if ("androidx.camera.view.CameraView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.SpeechOrbView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.SwitchCompat".equals(string)) {
            return true;
        }
        if ("android.widget.ListView".equals(string)) {
            return true;
        }
        if ("android.widget.AbsListView".equals(string)) {
            return true;
        }
        if ("androidx.cardview.widget.CardView".equals(string)) {
            return true;
        }
        if ("android.widget.CheckBox".equals(string)) {
            return true;
        }
        if ("android.inputmethodservice.ExtractEditText".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.picker.TimePicker".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatSeekBar".equals(string)) {
            return true;
        }
        if ("android.widget.AbsSeekBar".equals(string)) {
            return true;
        }
        if ("android.widget.SeekBar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.DismissibleFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.SwipeDismissFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.TitleView".equals(string)) {
            return true;
        }
        if ("android.widget.Gallery".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowHoverCardView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearableRecyclerView".equals(string)) {
            return true;
        }
        if ("androidx.percentlayout.widget.PercentRelativeLayout".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatCheckBox".equals(string)) {
            return true;
        }
        if ("androidx.camera.view.PreviewView".equals(string)) {
            return true;
        }
        if ("android.widget.Chronometer".equals(string)) {
            return true;
        }
        if ("androidx.swiperefreshlayout.widget.SwipeRefreshLayout".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiTextView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatButton".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackTabLayout".equals(string)) {
            return true;
        }
        if ("android.widget.HorizontalScrollView".equals(string)) {
            return true;
        }
        if ("com.google.android.material.tabs.TabLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.BrowseFrameLayout".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.WearCurvedTextView".equals(string)) {
            return true;
        }
        if ("androidx.viewpager.widget.ViewPager".equals(string)) {
            return true;
        }
        if ("android.widget.ActionMenuView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableDrawerLayout".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiAppCompatTextView".equals(string)) {
            return true;
        }
        if ("androidx.leanback.tab.LeanbackViewPager".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ListRowView".equals(string)) {
            return true;
        }
        if ("androidx.slice.widget.SliceView".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.CircularProgressLayout".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.VerticalGridView".equals(string)) {
            return true;
        }
        if ("android.widget.ZoomControls".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRadioButton".equals(string)) {
            return true;
        }
        if ("android.widget.RadioButton".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.ImageCardView".equals(string)) {
            return true;
        }
        if ("android.widget.VideoView".equals(string)) {
            return true;
        }
        if ("android.view.SurfaceView".equals(string)) {
            return true;
        }
        if ("androidx.emoji.widget.EmojiButton".equals(string)) {
            return true;
        }
        if ("androidx.leanback.widget.RowHeaderView".equals(string)) {
            return true;
        }
        if ("android.widget.DigitalClock".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatAutoCompleteTextView".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.widget.AppCompatRatingBar".equals(string)) {
            return true;
        }
        if ("android.widget.RatingBar".equals(string)) {
            return true;
        }
        if ("androidx.wear.widget.drawer.WearableNavigationDrawerView".equals(string)) {
            return true;
        }
        if ("android.widget.DatePicker".equals(string)) {
            return true;
        }
        if ("android.widget.MediaController".equals(string)) {
            return true;
        }
        if ("androidx.gridlayout.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.widget.TabWidget".equals(string)) {
            return true;
        }
        if ("android.widget.TextClock".equals(string)) {
            return true;
        }
        if ("android.widget.ImageSwitcher".equals(string)) {
            return true;
        }
        if ("android.widget.ViewAnimator".equals(string)) {
            return true;
        }
        if ("android.widget.ViewSwitcher".equals(string)) {
            return true;
        }
        if ("android.widget.TableRow".equals(string)) {
            return true;
        }
        if ("android.widget.AnalogClock".equals(string)) {
            return true;
        }
        if ("android.widget.RadioGroup".equals(string)) {
            return true;
        }
        if ("android.widget.SearchView".equals(string)) {
            return true;
        }
        if ("android.widget.StackView".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterViewAnimator".equals(string)) {
            return true;
        }
        if ("android.opengl.GLSurfaceView".equals(string)) {
            return true;
        }
        if ("android.widget.Space".equals(string)) {
            return true;
        }
        if ("android.widget.GridView".equals(string)) {
            return true;
        }
        if ("android.widget.ExpandableListView".equals(string)) {
            return true;
        }
        if ("android.view.ViewStub".equals(string)) {
            return true;
        }
        if ("android.gesture.GestureOverlayView".equals(string)) {
            return true;
        }
        if ("android.widget.QuickContactBadge".equals(string)) {
            return true;
        }
        if ("android.widget.TableLayout".equals(string)) {
            return true;
        }
        if ("android.widget.NumberPicker".equals(string)) {
            return true;
        }
        if ("android.widget.AdapterViewFlipper".equals(string)) {
            return true;
        }
        if ("android.widget.CalendarView".equals(string)) {
            return true;
        }
        if ("android.app.MediaRouteButton".equals(string)) {
            return true;
        }
        if ("android.widget.TextSwitcher".equals(string)) {
            return true;
        }
        if ("android.media.tv.TvView".equals(string)) {
            return true;
        }
        if ("android.widget.TimePicker".equals(string)) {
            return true;
        }
        if ("android.widget.SlidingDrawer".equals(string)) {
            return true;
        }
        if ("android.widget.TwoLineListItem".equals(string)) {
            return true;
        }
        if ("android.widget.AbsoluteLayout".equals(string)) {
            return true;
        }
        if ("android.webkit.WebView".equals(string)) {
            return true;
        }
        if ("android.view.TextureView".equals(string)) {
            return true;
        }
        if ("android.appwidget.AppWidgetHostView".equals(string)) {
            return true;
        }
        if ("android.widget.ViewFlipper".equals(string)) {
            return true;
        }
        if ("android.widget.ScrollView".equals(string)) {
            return true;
        }
        if ("android.widget.Toolbar".equals(string)) {
            return true;
        }
        if ("android.widget.DialerFilter".equals(string)) {
            return true;
        }
        if ("android.inputmethodservice.KeyboardView".equals(string)) {
            return true;
        }
        if ("android.window.SplashScreenView".equals(string)) {
            return true;
        }
        if ("android.widget.inline.InlineContentView".equals(string)) {
            return true;
        }
        if ("android.widget.GridLayout".equals(string)) {
            return true;
        }
        if ("android.app.FragmentBreadCrumbs".equals(string)) {
            return true;
        }
        if ("androidx.view.ViewPager".equals(string)) {
            return true;
        }
        if ("androidx.appcompat.app.ActionBar$Tab".equals(string)) {
            return true;
        }
        return "androidx.app.ActionBar$Tab".equals(string);
    }
}

