/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.LogLevels;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Logger {
    public int level;
    public static final int DEFAULT_LOG_LEVEL = 4;
    private String owner;
    private static final char[] nibbles = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static LogLevels levels = new LogLevels();
    private static ThreadLocal localBOS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new ByteArrayOutputStream(1000);
        }
    };
    private static ThreadLocal localPW = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new PrintWriter((ByteArrayOutputStream)localBOS.get());
        }
    };
    private static Boolean is14;
    private static Method getStackTrace;
    private static Method getClassName;
    private static final Class[] noArgsArray;

    public Logger(String string) {
        this.owner = string;
        this.setLevel(Logger.getLogLevel(this));
    }

    public Logger(Object object) {
        this(object.getClass().getName());
    }

    public Logger(Class clazz) {
        this(clazz.getName());
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public static void setDefaultLogLevel(int n) {
        if (levels != null) {
            levels.setDefaultLogLevel(n);
        }
    }

    public static void setLogLevel(String string, int n) {
        if (levels != null) {
            levels.setLogLevel(string, n);
        }
    }

    public static void removeLogLevel(String string) {
        if (levels != null) {
            levels.removeLogLevel(string);
        }
    }

    public static int getLogLevel(Logger logger) {
        if (levels != null) {
            return levels.getLogLevel(logger);
        }
        return 4;
    }

    public static void setLogLevels(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("log-")) continue;
            try {
                int n = Integer.parseInt((String)hashtable.get(string));
                if (string.equals("log-default")) {
                    Logger.setDefaultLogLevel(n);
                    continue;
                }
                Logger.setLogLevel(string.substring(4), n);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public static void setLogLevels(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!string.startsWith("log-")) continue;
            try {
                int n = Integer.parseInt(resourceBundle.getString(string));
                if (string.equals("log-default")) {
                    Logger.setDefaultLogLevel(n);
                    continue;
                }
                Logger.setLogLevel(string.substring(4), n);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static void addLogLevelListener(LogLevelListener logLevelListener) {
        levels.addLogLevelListener(logLevelListener);
    }

    public static void removeLogLevelListener(LogLevelListener logLevelListener) {
        levels.removeLogLevelListener(logLevelListener);
    }

    public static Object[] getLogLevels() {
        return levels.getLogLevels();
    }

    public static void setLogLevel(LogLevelListener logLevelListener, String string, int n) {
        levels.setLogLevel(logLevelListener, string, n);
    }

    public static void removeLogLevel(LogLevelListener logLevelListener, String string) {
        levels.removeLogLevel(logLevelListener, string);
    }

    public void log(int n, String string, String string2) {
        Log.log(n, System.currentTimeMillis(), this.owner, string, string2);
    }

    public void log(String string, Throwable throwable) {
        Log.log(1, this.owner, string, throwable);
    }

    public void log(String string, Throwable throwable, String string2) {
        Log.log(1, this.owner, string, throwable, string2);
    }

    public void log(int n, String string, Throwable throwable) {
        Log.log(n, this.owner, string, throwable);
    }

    public void log(int n, String string, Throwable throwable, String string2) {
        Log.log(n, this.owner, string, throwable, string2);
    }

    public void dumpStack(int n, String string, String string2) {
        try {
            throw new Exception(string2);
        }
        catch (Exception exception) {
            this.log(n, string, exception);
            return;
        }
    }

    public Builder build(String string) {
        return new Builder(string);
    }

    public final void err(String string, String string2) {
        if (this.level >= 1) {
            Log.log(1, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void err(String string, Throwable throwable) {
        if (this.level >= 1) {
            Log.log(1, this.owner, string, throwable);
        }
    }

    public final void err(String string, Throwable throwable, String string2) {
        if (this.level >= 1) {
            Log.log(1, this.owner, string, throwable, string2);
        }
    }

    public final void wrn(String string, String string2) {
        if (this.level >= 3) {
            Log.log(3, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void wrn(String string, Throwable throwable) {
        if (this.level >= 3) {
            Log.log(3, this.owner, string, throwable);
        }
    }

    public final void wrn(String string, Throwable throwable, String string2) {
        if (this.level >= 3) {
            Log.log(3, this.owner, string, throwable, string2);
        }
    }

    public final void msg(String string, String string2) {
        if (this.level >= 5) {
            Log.log(5, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void msg(String string, Throwable throwable) {
        if (this.level >= 5) {
            Log.log(5, this.owner, string, throwable);
        }
    }

    public final void msg(String string, Throwable throwable, String string2) {
        if (this.level >= 5) {
            Log.log(5, this.owner, string, throwable, string2);
        }
    }

    public final void mtd(String string, String string2) {
        if (this.level >= 7) {
            Log.log(7, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void mtd(String string, Throwable throwable) {
        if (this.level >= 7) {
            Log.log(7, this.owner, string, throwable);
        }
    }

    public final void mtd(String string, Throwable throwable, String string2) {
        if (this.level >= 7) {
            Log.log(7, this.owner, string, throwable, string2);
        }
    }

    public final void dbg(String string, String string2) {
        if (this.level >= 9) {
            Log.log(9, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void dbg(String string, Throwable throwable) {
        if (this.level >= 9) {
            Log.log(9, this.owner, string, throwable);
        }
    }

    public final void dbg(String string, Throwable throwable, String string2) {
        if (this.level >= 9) {
            Log.log(9, this.owner, string, throwable, string2);
        }
    }

    public String getOwnerName() {
        return this.owner;
    }

    static {
        noArgsArray = new Class[0];
    }

    public class Builder {
        private StringBuffer sb;
        private String method;

        public Builder(String string) {
            this.method = string;
            this.sb = new StringBuffer();
        }

        public final Builder add(boolean bl) {
            this.sb.append(bl);
            return this;
        }

        public final Builder add(byte by) {
            this.sb.append(by);
            return this;
        }

        public final Builder add(char c) {
            this.sb.append(c);
            return this;
        }

        public final Builder add(int n) {
            this.sb.append(n);
            return this;
        }

        public final Builder addHex(int n) {
            this.sb.append("0x");
            this.sb.append(Integer.toHexString(n));
            return this;
        }

        public final Builder addHex(Integer n) {
            if (n != null) {
                return this.addHex((int)n);
            }
            this.sb.append("null");
            return this;
        }

        public final Builder add(long l) {
            this.sb.append(l);
            return this;
        }

        public final Builder addHex(long l) {
            this.sb.append("0x");
            this.sb.append(Long.toHexString(l));
            return this;
        }

        public final Builder addHex(Long l) {
            if (l != null) {
                return this.addHex((long)l);
            }
            this.sb.append("null");
            return this;
        }

        public final Builder add(double d) {
            this.sb.append(d);
            return this;
        }

        public Builder add(Object object) {
            try {
                this.sb.append(object);
            }
            catch (Throwable throwable) {
                Log.log(3, Logger.this.owner, this.method, throwable);
                this.sb.append("EXCEPTED");
            }
            return this;
        }

        public final Builder add(String string) {
            this.sb.append(string);
            return this;
        }

        public final Builder addAll(Object object) {
            if (object instanceof Object[]) {
                return this.addAll((Object[])object);
            }
            if (object instanceof int[]) {
                return this.addAll((int[])object);
            }
            if (object instanceof long[]) {
                return this.addAll((long[])object);
            }
            this.sb.append(object);
            return this;
        }

        public final Builder addAll(Object[] objectArray) {
            if (objectArray == null) {
                this.sb.append(objectArray);
            } else {
                this.sb.append("[");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        this.sb.append(',');
                    }
                    this.addAll(objectArray[i]);
                }
                this.sb.append("]");
            }
            return this;
        }

        public final Builder addAll(int[] nArray) {
            if (nArray == null) {
                this.sb.append(nArray);
            } else {
                this.sb.append("[");
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        this.sb.append(',');
                    }
                    this.sb.append(nArray[i]);
                }
                this.sb.append("]");
            }
            return this;
        }

        public final Builder addAll(long[] lArray) {
            if (lArray == null) {
                this.sb.append(lArray);
            } else {
                this.sb.append("[");
                for (int i = 0; i < lArray.length; ++i) {
                    if (i > 0) {
                        this.sb.append(',');
                    }
                    this.sb.append(lArray[i]);
                }
                this.sb.append("]");
            }
            return this;
        }

        public void log(int n) {
            Logger.this.log(n, this.method, this.sb.toString());
        }

        public void dumpStack(int n) {
            Logger.this.dumpStack(n, this.method, this.sb.toString());
        }
    }
}

