/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFilePicker;
import org.eclipse.swt.internal.mozilla.nsIFilePicker_1_8;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class FilePicker {
    XPCOMObject supports;
    XPCOMObject filePicker;
    int refCount = 0;
    short mode;
    long parentHandle;
    String[] files;
    String[] masks;
    String defaultFilename;
    String directory;
    String title;
    static final String SEPARATOR = System.getProperty("file.separator");

    FilePicker() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public long method0(long[] lArray) {
                return FilePicker.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return FilePicker.this.AddRef();
            }

            public long method2(long[] lArray) {
                return FilePicker.this.Release();
            }
        };
        this.filePicker = new XPCOMObject(new int[]{2, 0, 0, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}){

            public long method0(long[] lArray) {
                return FilePicker.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return FilePicker.this.AddRef();
            }

            public long method2(long[] lArray) {
                return FilePicker.this.Release();
            }

            public long method3(long[] lArray) {
                return FilePicker.this.Init(lArray[0], lArray[1], (short)lArray[2]);
            }

            public long method4(long[] lArray) {
                return FilePicker.this.AppendFilters((int)lArray[0]);
            }

            public long method5(long[] lArray) {
                return FilePicker.this.AppendFilter(lArray[0], lArray[1]);
            }

            public long method6(long[] lArray) {
                return FilePicker.this.GetDefaultString(lArray[0]);
            }

            public long method7(long[] lArray) {
                return FilePicker.this.SetDefaultString(lArray[0]);
            }

            public long method8(long[] lArray) {
                return FilePicker.this.GetDefaultExtension(lArray[0]);
            }

            public long method9(long[] lArray) {
                return FilePicker.this.SetDefaultExtension(lArray[0]);
            }

            public long method10(long[] lArray) {
                return FilePicker.this.GetFilterIndex(lArray[0]);
            }

            public long method11(long[] lArray) {
                return FilePicker.this.SetFilterIndex((int)lArray[0]);
            }

            public long method12(long[] lArray) {
                return FilePicker.this.GetDisplayDirectory(lArray[0]);
            }

            public long method13(long[] lArray) {
                return FilePicker.this.SetDisplayDirectory(lArray[0]);
            }

            public long method14(long[] lArray) {
                return FilePicker.this.GetFile(lArray[0]);
            }

            public long method15(long[] lArray) {
                return FilePicker.this.GetFileURL(lArray[0]);
            }

            public long method16(long[] lArray) {
                return FilePicker.this.GetFiles(lArray[0]);
            }

            public long method17(long[] lArray) {
                return FilePicker.this.Show(lArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.filePicker != null) {
            this.filePicker.dispose();
            this.filePicker = null;
        }
    }

    long getAddress() {
        return this.filePicker.getAddress();
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(l2, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFilePicker.NS_IFILEPICKER_IID)) {
            XPCOM.memmove(l2, new long[]{this.filePicker.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFilePicker_1_8.NS_IFILEPICKER_IID)) {
            XPCOM.memmove(l2, new long[]{this.filePicker.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFilePicker_1_8.NS_IFILEPICKER_10_IID)) {
            XPCOM.memmove(l2, new long[]{this.filePicker.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(l2, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser(long l) {
        if (l == 0L) {
            return null;
        }
        return Mozilla.getBrowser(l);
    }

    String parseAString(long l) {
        return null;
    }

    int Init(long l, long l2, short s) {
        this.parentHandle = l;
        this.mode = s;
        this.title = this.parseAString(l2);
        return 0;
    }

    int Show(long l) {
        int n;
        if (this.mode == 2) {
            int n2 = this.showDirectoryPicker();
            XPCOM.memmove(l, new short[]{(short)n2}, 2L);
            return 0;
        }
        int n3 = n = this.mode == 1 ? 8192 : 4096;
        if (this.mode == 3) {
            n |= 2;
        }
        Browser browser = this.getBrowser(this.parentHandle);
        Shell shell = null;
        shell = browser != null ? browser.getShell() : new Shell();
        FileDialog fileDialog = new FileDialog(shell, n);
        if (this.title != null) {
            fileDialog.setText(this.title);
        }
        if (this.directory != null) {
            fileDialog.setFilterPath(this.directory);
        }
        if (this.masks != null) {
            fileDialog.setFilterExtensions(this.masks);
        }
        if (this.defaultFilename != null) {
            fileDialog.setFileName(this.defaultFilename);
        }
        String string = fileDialog.open();
        this.files = fileDialog.getFileNames();
        this.directory = fileDialog.getFilterPath();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        boolean bl = string == null;
        XPCOM.memmove(l, new short[]{(short)(bl ? 1 : 0)}, 2L);
        return 0;
    }

    int showDirectoryPicker() {
        Browser browser = this.getBrowser(this.parentHandle);
        Shell shell = null;
        shell = browser != null ? browser.getShell() : new Shell();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 0);
        if (this.title != null) {
            directoryDialog.setText(this.title);
        }
        if (this.directory != null) {
            directoryDialog.setFilterPath(this.directory);
        }
        this.directory = directoryDialog.open();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        this.files = null;
        return this.directory == null ? 1 : 0;
    }

    int GetFiles(long l) {
        return -2147467263;
    }

    int GetFileURL(long l) {
        return -2147467263;
    }

    int GetFile(long l) {
        String string = "";
        if (this.directory != null) {
            string = string + this.directory + SEPARATOR;
        }
        if (this.files != null && this.files.length > 0) {
            string = string + this.files[0];
        }
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        long[] lArray = new long[1];
        int n = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, lArray);
        nsEmbedString2.dispose();
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(l, lArray, (long)C.PTR_SIZEOF);
        return 0;
    }

    int SetDisplayDirectory(long l) {
        if (l == 0L) {
            return 0;
        }
        nsILocalFile nsILocalFile2 = new nsILocalFile(l);
        long l2 = XPCOM.nsEmbedString_new();
        int n = nsILocalFile2.GetPath(l2);
        if (n != 0) {
            Mozilla.error(n);
        }
        int n2 = XPCOM.nsEmbedString_Length(l2);
        long l3 = XPCOM.nsEmbedString_get(l2);
        char[] cArray = new char[n2];
        XPCOM.memmove(cArray, l3, (long)(n2 * 2));
        XPCOM.nsEmbedString_delete(l2);
        this.directory = new String(cArray);
        return 0;
    }

    int GetDisplayDirectory(long l) {
        String string = this.directory != null ? this.directory : "";
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        long[] lArray = new long[1];
        int n = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, lArray);
        nsEmbedString2.dispose();
        if (n != 0) {
            Mozilla.error(n);
        }
        if (lArray[0] == 0L) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(l, lArray, (long)C.PTR_SIZEOF);
        return 0;
    }

    int SetFilterIndex(int n) {
        return -2147467263;
    }

    int GetFilterIndex(long l) {
        return -2147467263;
    }

    int SetDefaultExtension(long l) {
        return -2147467263;
    }

    int GetDefaultExtension(long l) {
        return -2147467263;
    }

    int SetDefaultString(long l) {
        this.defaultFilename = this.parseAString(l);
        return 0;
    }

    int GetDefaultString(long l) {
        return -2147467263;
    }

    int AppendFilter(long l, long l2) {
        return -2147467263;
    }

    int AppendFilters(int n) {
        String[] stringArray = null;
        switch (n) {
            case 1: 
            case 64: {
                this.masks = null;
                break;
            }
            case 2: {
                stringArray = new String[]{"*.htm;*.html"};
                break;
            }
            case 8: {
                stringArray = new String[]{"*.gif;*.jpeg;*.jpg;*.png"};
                break;
            }
            case 4: {
                stringArray = new String[]{"*.txt"};
                break;
            }
            case 16: {
                stringArray = new String[]{"*.xml"};
                break;
            }
            case 32: {
                stringArray = new String[]{"*.xul"};
            }
        }
        if (this.masks == null) {
            this.masks = stringArray;
        } else if (stringArray != null) {
            String[] stringArray2 = new String[this.masks.length + stringArray.length];
            System.arraycopy(this.masks, 0, stringArray2, 0, this.masks.length);
            System.arraycopy(stringArray, 0, stringArray2, this.masks.length, stringArray.length);
            this.masks = stringArray2;
        }
        return 0;
    }
}

