/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.system.Kernel32;

public class LastError {
    public static final int NO_ERROR = 0;
    public static final int ERROR_SUCCESS = 0;
    private static final String FUNCTION_GET_LAST_ERROR = "GetLastError";
    private static final String FUNCTION_SET_LAST_ERROR = "SetLastError";
    private static final int FORMAT_MESSAGE_IGNORE_INSERTS = 512;
    private static final int FORMAT_MESSAGE_FROM_SYSTEM = 4096;
    private static final int FORMAT_MESSAGE_ARGUMENT_ARRAY = 8192;

    public static int getValue() {
        Function getLastError = Kernel32.getInstance().getFunction(FUNCTION_GET_LAST_ERROR);
        Int32 errorCode = new Int32();
        getLastError.invoke(errorCode);
        return (int)errorCode.getValue();
    }

    public static int getValue(boolean clear) {
        int result = LastError.getValue();
        if (clear) {
            LastError.clearLastErrorCode();
        }
        return result;
    }

    public static void clearLastErrorCode() {
        LastError.setValue(0);
    }

    public static void setValue(int value) {
        Function setLastError = Kernel32.getInstance().getFunction(FUNCTION_SET_LAST_ERROR);
        Int32 errorCode = new Int32(value);
        setLastError.invoke(null, errorCode);
    }

    public static String getMessage() {
        return LastError.getMessage(LastError.getValue());
    }

    public static String getMessage(boolean clearStatus) {
        int lastError = LastError.getValue(clearStatus);
        return LastError.getMessage(lastError);
    }

    public static String getMessage(long errorCode) {
        FunctionName FUNCTION_FORMAT_MESSAGE = new FunctionName("FormatMessage");
        Function formatMessage = Kernel32.getInstance().getFunction(FUNCTION_FORMAT_MESSAGE.toString());
        UInt32 dwFlags = new UInt32(12800L);
        Pointer.Void NULL = new Pointer.Void();
        Str buffer = new Str("", 255);
        UInt32 result = new UInt32();
        UInt32 errCode = new UInt32(errorCode);
        formatMessage.invoke((Parameter)result, new Parameter[]{dwFlags, NULL, errCode, new UInt32(0L), new Pointer(buffer), new UInt32(buffer.getMaxLength()), NULL});
        return buffer.getValue().trim();
    }
}

