/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.dde.DdeClientEventHandler;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeFunctions;
import com.jniwrapper.win32.dde.DdeItem;
import com.jniwrapper.win32.dde.DdeResponse;
import com.jniwrapper.win32.dde.DdeServiceEventHandler;
import com.jniwrapper.win32.ui.User32;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

class DdeCallback
extends Callback {
    private static final Logger _log = Logger.getInstance(class$com$jniwrapper$win32$dde$DdeCallback == null ? (class$com$jniwrapper$win32$dde$DdeCallback = DdeCallback.class$("com.jniwrapper.win32.dde.DdeCallback")) : class$com$jniwrapper$win32$dde$DdeCallback);
    private static final FunctionName FUNCTION_QUERYSTRING = new FunctionName("DdeQueryString");
    private static final int XTYPF_NOBLOCK = 2;
    private static final int XCLASS_BOOL = 4096;
    private static final int XCLASS_DATA = 8192;
    private static final int XCLASS_FLAGS = 16384;
    private static final int XCLASS_NOTIFICATION = 32768;
    public static final int XTYP_ERROR = 32770;
    public static final int XTYP_ADVDATA = 16400;
    public static final int XTYP_ADVREQ = 8226;
    public static final int XTYP_ADVSTART = 4144;
    public static final int XTYP_ADVSTOP = 32832;
    public static final int XTYP_EXECUTE = 16464;
    public static final int XTYP_CONNECT = 4194;
    public static final int XTYP_CONNECT_CONFIRM = 32882;
    public static final int XTYP_XACT_COMPLETE = 32896;
    public static final int XTYP_POKE = 16528;
    public static final int XTYP_REGISTER = 32930;
    public static final int XTYP_REQUEST = 8368;
    public static final int XTYP_DISCONNECT = 32962;
    public static final int XTYP_UNREGISTER = 32978;
    public static final int XTYP_WILDCONNECT = 8418;
    private UInt _type = new UInt();
    private UInt _fmt = new UInt();
    private Handle _conv = new Handle();
    private Handle _sz1 = new Handle();
    private Handle _sz2 = new Handle();
    private Handle _data = new Handle();
    private Handle _data1 = new Handle();
    private Handle _data2 = new Handle();
    private Handle _result = new Handle();
    private Map _clientHandlers = new Hashtable();
    private Map _serverHandlers = new Hashtable();
    private Map _convToServer = new Hashtable();
    private long _idInst;
    static /* synthetic */ Class class$com$jniwrapper$win32$dde$DdeCallback;

    public DdeCallback() {
        this.init(new Parameter[]{this._type, this._fmt, this._conv, this._sz1, this._sz2, this._data, this._data1, this._data2}, this._result);
    }

    public void setIdInst(long idInst) {
        this._idInst = idInst;
    }

    public void callback() {
        try {
            switch ((int)this._type.getValue()) {
                case 32770: {
                    this.processError();
                    break;
                }
                case 16400: {
                    this.processAdvData();
                    break;
                }
                case 8226: {
                    this.processAdvReq();
                    break;
                }
                case 4144: {
                    this.processAdvStart();
                    break;
                }
                case 32832: {
                    this.processAdvStop();
                    break;
                }
                case 16464: {
                    this.processExecute();
                    break;
                }
                case 4194: {
                    this.processConnect();
                    break;
                }
                case 32882: {
                    String service = this.queryString(this._idInst, this._sz2);
                    this._convToServer.put(this._conv, service);
                    break;
                }
                case 32896: {
                    this.processActComplete();
                    break;
                }
                case 16528: {
                    this.processPoke();
                    break;
                }
                case 32930: {
                    this.processRegister();
                    break;
                }
                case 8368: {
                    this.processRequest();
                    break;
                }
                case 32962: {
                    this.processDisconnect();
                    break;
                }
                case 32978: {
                    this.processUnregister();
                    break;
                }
            }
        }
        catch (Exception e2) {
            _log.error("", e2);
        }
    }

    private void processError() {
        DdeClientEventHandler clientEventHandler = this.getClientHandler(this._conv);
        if (clientEventHandler != null) {
            clientEventHandler.error((int)this._data1.getValue());
        }
    }

    private void processAdvData() throws DdeException {
        DdeClientEventHandler clientEventHandler = this.getClientHandler(this._conv);
        DdeResponse response = DdeResponse.NOTPROCESSED;
        if (clientEventHandler != null) {
            String item = this.queryString(this._idInst, this._sz2);
            byte[] data = this._data.getValue() != 0L ? DdeFunctions.getData(this._data) : null;
            response = clientEventHandler.itemChanged(new DdeItem(item, this._fmt.getValue()), data);
            if (response == null) {
                response = DdeResponse.NOTPROCESSED;
            }
        }
        this._result.setValue(response.getValue());
    }

    private void processAdvReq() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        byte[] data = null;
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            String item = this.queryString(this._idInst, this._sz2);
            data = serviceEventHandler.adviseRequest(topic, new DdeItem(item, this._fmt.getValue()));
        }
        Handle hData = data != null ? DdeFunctions.createDataHandle(this._idInst, data, 0, this._fmt.getValue(), this._sz2) : new Handle();
        this._result.setValue(hData.getValue());
    }

    private void processAdvStart() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        boolean result = true;
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            String item = this.queryString(this._idInst, this._sz2);
            result = serviceEventHandler.adviseStart(topic, new DdeItem(item, this._fmt.getValue()));
        }
        if (result) {
            this._result.setValue(1L);
        } else {
            this._result.setValue(0L);
        }
    }

    private void processAdvStop() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            String item = this.queryString(this._idInst, this._sz2);
            serviceEventHandler.adviseStop(topic, new DdeItem(item, 0L));
        }
    }

    private void processExecute() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        DdeResponse response = DdeResponse.NOTPROCESSED;
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            byte[] data = DdeFunctions.getData(this._data);
            StringCharacterIterator commandIterator = new StringCharacterIterator(new String(data));
            StringBuffer command = new StringBuffer();
            do {
                if (commandIterator.current() == '\u0000') continue;
                command.append(commandIterator.current());
            } while (commandIterator.next() != '\uffff');
            response = serviceEventHandler.execute(topic, command.toString());
            if (response == null) {
                response = DdeResponse.NOTPROCESSED;
            }
        }
        this._result.setValue(response.getValue());
    }

    private void processConnect() throws DdeException {
        String service = this.queryString(this._idInst, this._sz2);
        DdeServiceEventHandler serviceEventHandler = (DdeServiceEventHandler)this._serverHandlers.get(service);
        boolean result = true;
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            boolean sameApplication = false;
            if (this._data2.getValue() == 1L) {
                sameApplication = true;
            }
            result = serviceEventHandler.beforeConnect(topic, sameApplication);
        }
        if (result) {
            this._result.setValue(1L);
        } else {
            this._result.setValue(0L);
        }
    }

    private void processActComplete() throws DdeException {
        DdeClientEventHandler clientEventHandler = this.getClientHandler(this._conv);
        if (clientEventHandler != null) {
            byte[] data = this._data.getValue() == 0L ? null : (this._data.getValue() == 1L ? new byte[]{} : DdeFunctions.getData(this._data));
            String item = this.queryString(this._idInst, this._sz2);
            clientEventHandler.asyncActionComplete(new DdeItem(item, this._fmt.getValue()), data, this._data1.getValue());
        }
    }

    private void processPoke() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        DdeResponse response = DdeResponse.NOTPROCESSED;
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            String item = this.queryString(this._idInst, this._sz2);
            byte[] data = DdeFunctions.getData(this._data);
            response = serviceEventHandler.pokeData(topic, new DdeItem(item, this._fmt.getValue()), data);
            if (response == null) {
                response = DdeResponse.NOTPROCESSED;
            }
        }
        this._result.setValue(response.getValue());
    }

    private void processRegister() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        String service = this.queryString(this._idInst, this._sz1);
        String instanceName = this.queryString(this._idInst, this._sz2);
        Collection values = this._serverHandlers.values();
        Iterator i2 = values.iterator();
        while (i2.hasNext()) {
            serviceEventHandler = (DdeServiceEventHandler)i2.next();
            serviceEventHandler.serviceRegister(service, instanceName);
        }
        values = this._clientHandlers.values();
        Iterator i3 = values.iterator();
        while (i3.hasNext()) {
            DdeClientEventHandler clientEventHandler = (DdeClientEventHandler)i3.next();
            clientEventHandler.serviceRegister(service, instanceName);
        }
    }

    private void processRequest() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        byte[] data = null;
        if (serviceEventHandler != null) {
            String topic = this.queryString(this._idInst, this._sz1);
            String item = this.queryString(this._idInst, this._sz2);
            data = serviceEventHandler.requestData(topic, new DdeItem(item, this._fmt.getValue()));
        }
        Handle hData = data != null ? DdeFunctions.createDataHandle(this._idInst, data, 0, this._fmt.getValue(), this._sz2) : new Handle();
        this._result.setValue(hData.getValue());
    }

    private void processDisconnect() {
        DdeClientEventHandler clientEventHandler;
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        if (serviceEventHandler != null) {
            boolean sameApplication = false;
            if (this._data2.getValue() == 1L) {
                sameApplication = true;
            }
            serviceEventHandler.disconnect(sameApplication);
        }
        if ((clientEventHandler = this.getClientHandler(this._conv)) != null) {
            boolean sameApplication = false;
            if (this._data2.getValue() == 1L) {
                sameApplication = true;
            }
            clientEventHandler.disconnect(sameApplication);
        }
    }

    private void processUnregister() throws DdeException {
        DdeServiceEventHandler serviceEventHandler = this.getServiceHandler(this._conv);
        String service = this.queryString(this._idInst, this._sz1);
        String instanceName = this.queryString(this._idInst, this._sz2);
        Collection values = this._serverHandlers.values();
        Iterator i2 = values.iterator();
        while (i2.hasNext()) {
            serviceEventHandler = (DdeServiceEventHandler)i2.next();
            serviceEventHandler.serviceUnregister(service, instanceName);
        }
        values = this._clientHandlers.values();
        Iterator i3 = values.iterator();
        while (i3.hasNext()) {
            DdeClientEventHandler clientEventHandler = (DdeClientEventHandler)i3.next();
            clientEventHandler.serviceUnregister(service, instanceName);
        }
    }

    private String queryString(long idInst, Handle handle) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_QUERYSTRING.toString());
        UInt32 result = new UInt32();
        Str str = new Str(255);
        function.invoke((Parameter)result, new Parameter[]{new UInt32(idInst), handle, new Pointer(str), new UInt32(255L), new Int(DdeFunctions.getCodePage())});
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return str.getValue();
    }

    public void addClientEventHandler(Handle conv, DdeClientEventHandler eventHandler) {
        this._clientHandlers.put(conv, eventHandler);
    }

    public void removeClientEventHandler(Handle conv) {
        this._clientHandlers.remove(conv);
    }

    public void addServerEventHandler(String server, DdeServiceEventHandler eventHandler) {
        this._serverHandlers.put(server, eventHandler);
    }

    public void removeServerEventHandler(String server) {
        this._serverHandlers.remove(server);
    }

    private DdeClientEventHandler getClientHandler(Handle conv) {
        Object res = this._clientHandlers.get(conv);
        if (res != null) {
            return (DdeClientEventHandler)res;
        }
        return null;
    }

    private DdeServiceEventHandler getServiceHandler(Handle conv) {
        String server = (String)this._convToServer.get(conv);
        if (server == null) {
            return null;
        }
        return (DdeServiceEventHandler)this._serverHandlers.get(server);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

