/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.dde.DdeCallback;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeFunctions;
import com.jniwrapper.win32.dde.DdeServiceEventHandler;
import com.jniwrapper.win32.system.EventObject;
import com.jniwrapper.win32.ui.User32;

class DdeServiceHelper {
    private static final String FUNCTION_NAMESERVICE = "DdeNameService";
    private static final String FUNCTION_POSTADVISE = "DdePostAdvise";
    private static final long DNS_REGISTER = 1L;
    private static final long DNS_UNREGISTER = 2L;
    private String _name;
    private boolean _registered;
    private long _idInst;
    private DdeCallback _callback;

    public DdeServiceHelper(String name) {
        this._name = name;
    }

    public void createCallback() {
        this._callback = new DdeCallback();
    }

    public void register(String eventName) throws DdeException {
        if (!this._registered) {
            EventObject notifyEvent;
            this._idInst = DdeFunctions.ddeInitialize(this._callback);
            this._callback.setIdInst(this._idInst);
            Handle name = DdeFunctions.createStringHandle(this._idInst, this._name);
            this.ddeNameService(this._idInst, name, 1L);
            this._registered = true;
            if (eventName != null && !(notifyEvent = new EventObject(eventName)).isNull()) {
                notifyEvent.notifyEvent();
                notifyEvent.close();
            }
            DdeFunctions.freeStringHandle(this._idInst, name);
        }
    }

    private void ddeNameService(long idInst, Handle service, long flag) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_NAMESERVICE);
        Handle result = new Handle();
        function.invoke(result, new UInt32(idInst), service, new UInt(0L), new UInt(flag));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public boolean isRegistered() {
        return this._registered;
    }

    public void unregister() throws DdeException {
        if (this._registered) {
            Handle name = DdeFunctions.createStringHandle(this._idInst, this._name);
            this.ddeNameService(this._idInst, name, 2L);
            DdeFunctions.freeStringHandle(this._idInst, name);
            DdeFunctions.ddeUninitialize(this._idInst);
            this._registered = false;
        }
    }

    public void setEventHandler(DdeServiceEventHandler eventHandler) {
        this._callback.addServerEventHandler(this._name, eventHandler);
    }

    public void removeEventHandler() {
        this._callback.removeServerEventHandler(this._name);
    }

    public String getName() {
        return this._name;
    }

    public void postAdvise(String topic, String item) throws DdeException {
        this.ddePostAdvise(this._idInst, topic, item);
    }

    private void ddePostAdvise(long idInst, String topic, String item) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_POSTADVISE);
        IntBool result = new IntBool();
        Handle hTopic = DdeFunctions.createStringHandle(idInst, topic);
        Handle hItem = DdeFunctions.createStringHandle(idInst, item);
        function.invoke(result, new UInt32(idInst), hTopic, hItem);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }
}

