/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Pointer;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.ui.User32;
import java.util.HashMap;
import java.util.Map;

public class Cursor
extends GdiObject {
    private static final String FUNCTION_GET_CURSOR_POS = "GetCursorPos";
    private static final String FUNCTION_SET_CURSOR_POS = "SetCursorPos";
    private static final String FUNCTION_SetCursor = "SetCursor";
    private static final String FUNCTION_LoadCursor = "LoadCursorW";
    static final Map _cursors = new HashMap();

    public Cursor() {
        _cursors.put(new Integer(0), CursorKind.IDC_ARROW);
        _cursors.put(new Integer(2), CursorKind.IDC_IBEAM);
        _cursors.put(new Integer(12), CursorKind.IDC_HAND);
        _cursors.put(new Integer(13), CursorKind.IDC_SIZEALL);
        _cursors.put(new Integer(3), CursorKind.IDC_WAIT);
        _cursors.put(new Integer(11), CursorKind.IDC_SIZEWE);
        _cursors.put(new Integer(8), CursorKind.IDC_SIZENS);
        _cursors.put(new Integer(7), CursorKind.IDC_SIZENESW);
        _cursors.put(new Integer(6), CursorKind.IDC_SIZENWSE);
        _cursors.put(new Integer(5), CursorKind.IDC_SIZENWSE);
        _cursors.put(new Integer(4), CursorKind.IDC_SIZENESW);
        _cursors.put(new Integer(10), CursorKind.IDC_SIZEWE);
        _cursors.put(new Integer(1), CursorKind.IDC_CROSS);
    }

    public Cursor(long value) {
        super(value);
        _cursors.put(new Integer(0), CursorKind.IDC_ARROW);
        _cursors.put(new Integer(2), CursorKind.IDC_IBEAM);
        _cursors.put(new Integer(12), CursorKind.IDC_HAND);
        _cursors.put(new Integer(13), CursorKind.IDC_SIZEALL);
        _cursors.put(new Integer(3), CursorKind.IDC_WAIT);
        _cursors.put(new Integer(11), CursorKind.IDC_SIZEWE);
        _cursors.put(new Integer(8), CursorKind.IDC_SIZENS);
        _cursors.put(new Integer(7), CursorKind.IDC_SIZENESW);
        _cursors.put(new Integer(6), CursorKind.IDC_SIZENWSE);
        _cursors.put(new Integer(5), CursorKind.IDC_SIZENWSE);
        _cursors.put(new Integer(4), CursorKind.IDC_SIZENESW);
        _cursors.put(new Integer(10), CursorKind.IDC_SIZEWE);
        _cursors.put(new Integer(1), CursorKind.IDC_CROSS);
    }

    public Cursor(java.awt.Cursor cursor) {
        _cursors.put(new Integer(0), CursorKind.IDC_ARROW);
        _cursors.put(new Integer(2), CursorKind.IDC_IBEAM);
        _cursors.put(new Integer(12), CursorKind.IDC_HAND);
        _cursors.put(new Integer(13), CursorKind.IDC_SIZEALL);
        _cursors.put(new Integer(3), CursorKind.IDC_WAIT);
        _cursors.put(new Integer(11), CursorKind.IDC_SIZEWE);
        _cursors.put(new Integer(8), CursorKind.IDC_SIZENS);
        _cursors.put(new Integer(7), CursorKind.IDC_SIZENESW);
        _cursors.put(new Integer(6), CursorKind.IDC_SIZENWSE);
        _cursors.put(new Integer(5), CursorKind.IDC_SIZENWSE);
        _cursors.put(new Integer(4), CursorKind.IDC_SIZENESW);
        _cursors.put(new Integer(10), CursorKind.IDC_SIZEWE);
        _cursors.put(new Integer(1), CursorKind.IDC_CROSS);
        this.setCursor(cursor);
    }

    public static Point getCursorPosition() {
        Point result = new Point();
        Function function = User32.getInstance().getFunction(FUNCTION_GET_CURSOR_POS);
        function.invoke(null, new Pointer(result));
        return result;
    }

    public static boolean setCursorPosition(int x2, int y2) {
        Int result = new Int();
        Int xInt = new Int(x2);
        Int yInt = new Int(y2);
        Function function = User32.getInstance().getFunction(FUNCTION_SET_CURSOR_POS);
        function.invoke(result, xInt, yInt);
        return result.getValue() != 0L;
    }

    protected void loadCursor(CursorKind cursor) {
        Function loadCursor = User32.getInstance().getFunction(FUNCTION_LoadCursor);
        Handle current = new Handle();
        loadCursor.invoke(this, current, new Pointer.Void(cursor.getValue()));
    }

    public void setCursor(java.awt.Cursor cursor) {
        String name;
        Function setCursor = User32.getInstance().getFunction(FUNCTION_SetCursor);
        int type = cursor.getType();
        CursorKind cursorKind = (CursorKind)_cursors.get(new Integer(type));
        if (cursorKind != null) {
            this.loadCursor(cursorKind);
            setCursor.invoke(null, this);
        } else if (type == -1 && "Invalid32x32".equals(name = cursor.getName())) {
            this.loadCursor(CursorKind.IDC_NO);
            setCursor.invoke(null, this);
        }
    }

    public static class CursorPositionCode
    extends EnumItem {
        public static final CursorPositionCode ERROR = new CursorPositionCode(-2);
        public static final CursorPositionCode TRANSPARENT = new CursorPositionCode(-1);
        public static final CursorPositionCode NOWHERE = new CursorPositionCode(0);
        public static final CursorPositionCode CLIENT = new CursorPositionCode(1);
        public static final CursorPositionCode CAPTION = new CursorPositionCode(2);
        public static final CursorPositionCode SYSMENU = new CursorPositionCode(3);
        public static final CursorPositionCode GROWBOX;
        public static final CursorPositionCode SIZE;
        public static final CursorPositionCode MENU;
        public static final CursorPositionCode HSCROLL;
        public static final CursorPositionCode VSCROLL;
        public static final CursorPositionCode MINBUTTON;
        public static final CursorPositionCode MAXBUTTON;
        public static final CursorPositionCode LEFT;
        public static final CursorPositionCode RIGHT;
        public static final CursorPositionCode TOP;
        public static final CursorPositionCode TOPLEFT;
        public static final CursorPositionCode TOPRIGHT;
        public static final CursorPositionCode BOTTOM;
        public static final CursorPositionCode BOTTOMLEFT;
        public static final CursorPositionCode BOTTOMRIGHT;
        public static final CursorPositionCode BORDER;
        public static final CursorPositionCode REDUCE;
        public static final CursorPositionCode ZOOM;
        public static final CursorPositionCode SIZEFIRST;
        public static final CursorPositionCode SIZELAST;
        public static final CursorPositionCode OBJECT;
        public static final CursorPositionCode CLOSE;
        public static final CursorPositionCode HELP;

        private CursorPositionCode(int value) {
            super(value);
        }

        static {
            SIZE = GROWBOX = new CursorPositionCode(4);
            MENU = new CursorPositionCode(5);
            HSCROLL = new CursorPositionCode(6);
            VSCROLL = new CursorPositionCode(7);
            MINBUTTON = new CursorPositionCode(8);
            MAXBUTTON = new CursorPositionCode(9);
            LEFT = new CursorPositionCode(10);
            RIGHT = new CursorPositionCode(11);
            TOP = new CursorPositionCode(12);
            TOPLEFT = new CursorPositionCode(13);
            TOPRIGHT = new CursorPositionCode(14);
            BOTTOM = new CursorPositionCode(15);
            BOTTOMLEFT = new CursorPositionCode(16);
            BOTTOMRIGHT = new CursorPositionCode(17);
            BORDER = new CursorPositionCode(18);
            REDUCE = MINBUTTON;
            ZOOM = MAXBUTTON;
            SIZEFIRST = LEFT;
            SIZELAST = BOTTOMRIGHT;
            OBJECT = new CursorPositionCode(19);
            CLOSE = new CursorPositionCode(20);
            HELP = new CursorPositionCode(21);
        }
    }

    public static class CursorKind
    extends EnumItem {
        public static CursorKind IDC_ARROW = new CursorKind(32512, "IDC_ARROW");
        public static CursorKind IDC_IBEAM = new CursorKind(32513, "IDC_IBEAM");
        public static CursorKind IDC_WAIT = new CursorKind(32514, "IDC_WAIT");
        public static CursorKind IDC_CROSS = new CursorKind(32515, "IDC_CROSS");
        public static CursorKind IDC_UPARROW = new CursorKind(32516, "IDC_UPARROW");
        public static CursorKind IDC_SIZE = new CursorKind(32640, "IDC_SIZE");
        public static CursorKind IDC_ICON = new CursorKind(32641, "IDC_ICON");
        public static CursorKind IDC_SIZENWSE = new CursorKind(32642, "IDC_SIZENWSE");
        public static CursorKind IDC_SIZENESW = new CursorKind(32643, "IDC_SIZENESW");
        public static CursorKind IDC_SIZEWE = new CursorKind(32644, "IDC_SIZEWE");
        public static CursorKind IDC_SIZENS = new CursorKind(32645, "IDC_SIZENS");
        public static CursorKind IDC_SIZEALL = new CursorKind(32646, "IDC_SIZEALL");
        public static CursorKind IDC_NO = new CursorKind(32648, "IDC_NO");
        public static CursorKind IDC_HAND = new CursorKind(32649, "IDC_HAND");
        public static CursorKind IDC_APPSTARTING = new CursorKind(32650, "IDC_APPSTARTING");
        public static CursorKind IDC_HELP = new CursorKind(32651, "IDC_HELP");
        private String _name;

        private CursorKind(int value, String name) {
            super(value);
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

